/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.filter;

import com.jxdinfo.hussar.core.filter.PatternMatcher;

public class HussarPathMatcher
implements PatternMatcher {
    private static final HussarPathMatcher INSTANCE = new HussarPathMatcher();

    public static HussarPathMatcher getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean matches(String pattern, String source) {
        String newSource = source;
        String newPattern = pattern;
        if (newPattern == null || newSource == null) {
            return false;
        }
        newPattern = newPattern.trim();
        newSource = newSource.trim();
        if (newPattern.endsWith("*")) {
            int length = newPattern.length() - 1;
            if (newSource.length() >= length && newPattern.substring(0, length).equals(newSource.substring(0, length))) {
                return true;
            }
        } else if (newPattern.startsWith("*")) {
            int length = newPattern.length() - 1;
            if (newSource.length() >= length && newSource.endsWith(newPattern.substring(1))) {
                return true;
            }
        } else if (newPattern.contains("*")) {
            int start = newPattern.indexOf("*");
            int end = newPattern.lastIndexOf("*");
            if (newSource.startsWith(newPattern.substring(0, start)) && newSource.endsWith(newPattern.substring(end + 1))) {
                return true;
            }
        } else if (newPattern.equals(newSource)) {
            return true;
        }
        return false;
    }
}

