/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.config;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import com.baomidou.dynamic.datasource.provider.YmlDynamicDataSourceProvider;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.jxdinfo.hussar.common.annotion.DynamicDS;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.config.DataSourceCondition;
import com.jxdinfo.hussar.core.intercept.DynamicDataSourceInterceptor;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.JdkRegexpMethodPointcut;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@DependsOn(value={"springContextHolder"})
public class DynamicDataSourceConfig {
    @Resource
    private DynamicDataSourceProperties properties;
    @Resource
    private GlobalProperties globalProperties;

    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={DataSourceCondition.class})
    public DynamicDataSourceProvider dynamicDataSourceProvider() {
        Map datasourceMap = this.properties.getDatasource();
        return new YmlDynamicDataSourceProvider(datasourceMap);
    }

    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={DataSourceCondition.class})
    public DataSource dataSource(DynamicDataSourceProvider dynamicDataSourceProvider) {
        DynamicRoutingDataSource dataSource = new DynamicRoutingDataSource();
        dataSource.setPrimary(this.properties.getPrimary());
        if (this.globalProperties.isTenantOpen()) {
            dataSource.setStrict(Boolean.valueOf(true));
        } else {
            dataSource.setStrict(this.properties.getStrict());
        }
        dataSource.setStrategy(this.properties.getStrategy());
        dataSource.setProvider(dynamicDataSourceProvider);
        dataSource.setP6spy(this.properties.getP6spy());
        dataSource.setSeata(this.properties.getSeata());
        return dataSource;
    }

    @Bean
    @Conditional(value={DataSourceCondition.class})
    public DefaultPointcutAdvisor defaultPointcutAdvisor() {
        List<String> patterns = this.globalProperties.getTenantPatterns();
        List<String> exPatterns = this.globalProperties.getTenantExcludePatterns();
        JdkRegexpMethodPointcut pointcut = new JdkRegexpMethodPointcut();
        if (patterns.size() > 0) {
            pointcut.setPatterns(patterns.toArray(new String[0]));
        }
        if (exPatterns.size() > 0) {
            pointcut.setExcludedPatterns(exPatterns.toArray(new String[0]));
        }
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)new DynamicDataSourceInterceptor());
        return advisor;
    }

    @Bean
    @Conditional(value={DataSourceCondition.class})
    public DefaultPointcutAdvisor defaultPointcutAdvisorWithAnnotation() {
        AnnotationMatchingPointcut pointcut = new AnnotationMatchingPointcut(null, DynamicDS.class);
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)new DynamicDataSourceInterceptor());
        return advisor;
    }
}

