/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.aop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.exception.ApiException;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.exception.CancelException;
import com.jxdinfo.hussar.common.exception.DataSourceException;
import com.jxdinfo.hussar.common.exception.DormancyException;
import com.jxdinfo.hussar.common.exception.HussarCredentialsException;
import com.jxdinfo.hussar.common.exception.HussarDisabledAccountException;
import com.jxdinfo.hussar.common.exception.HussarLockedAccountException;
import com.jxdinfo.hussar.common.exception.HussarUndeclaredThrowableException;
import com.jxdinfo.hussar.common.exception.InvalidKaptchaException;
import com.jxdinfo.hussar.common.exception.IsRepeatAuthenticateException;
import com.jxdinfo.hussar.common.exception.LoginGetParamException;
import com.jxdinfo.hussar.common.exception.LoginIpRefuseException;
import com.jxdinfo.hussar.common.exception.LoginSessionException;
import com.jxdinfo.hussar.common.exception.LoginTimeRefuseException;
import com.jxdinfo.hussar.common.exception.TemporaryException;
import com.jxdinfo.hussar.common.exception.TenantException;
import com.jxdinfo.hussar.common.exception.TenantLoginException;
import com.jxdinfo.hussar.common.exception.TotpKeyException;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.log.HussarLogManager;
import com.jxdinfo.hussar.core.log.factory.LogTaskFactory;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.support.exception.NoLicenseException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.core.util.UnauthorizedMailUtil;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.CredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.ModelAndView;

@ControllerAdvice
@RestControllerAdvice
@Order(value=-1)
@DependsOn(value={"springContextHolder"})
public class GlobalExceptionHandler {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static GlobalProperties globalProperties = (GlobalProperties)SpringContextHolder.getBean(GlobalProperties.class);

    private void writeBussinessLog(String userName, String msg) {
        ShiroUser user;
        try {
            user = ShiroKit.getUser();
        }
        catch (HussarUndeclaredThrowableException e) {
            user = null;
        }
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("sessionId", (String)((Object)ShiroKit.getSession().getId()));
        info.put("ip", HttpKit.getIp());
        info.put("port", HttpKit.getPort());
        info.put("host", HttpKit.getHost());
        info.put("localIp", HttpKit.getLocalIp());
        info.put("localPort", HttpKit.getLocalPort());
        info.put("localHost", HttpKit.getLocalHost());
        if (StringUtils.isNotEmpty((CharSequence)userName)) {
            HussarLogManager.me().executeLog(LogTaskFactory.loginLog(user, userName, msg, "07", info));
        }
    }

    @ExceptionHandler(value={NoLicenseException.class})
    @ResponseStatus(value=HttpStatus.LOCKED)
    @ResponseBody
    public ErrorTip noLic(NoLicenseException e, HttpServletRequest request) {
        HttpKit.getRequest().setAttribute("tip", (Object)e.getMessage());
        return new ErrorTip(e.getCode().intValue(), e.getMessage());
    }

    @ExceptionHandler(value={HussarException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ErrorTip internalServerError(HussarException e, HttpServletRequest request) {
        HussarLogManager.me().executeLog(LogTaskFactory.exceptionLog(ShiroKit.getUser(), (Exception)e, this.logInfo(e, request)));
        HttpKit.getRequest().setAttribute("tip", (Object)e.getMessage());
        this.log.error("\u4e1a\u52a1\u5f02\u5e38:", (Throwable)e);
        return new ErrorTip(e.getCode().intValue(), e.getMessage());
    }

    @ExceptionHandler(value={AuthenticationException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public String unAuth(AuthenticationException e) {
        this.log.error("\u7528\u6237\u672a\u767b\u5f55\uff1a", (Throwable)e);
        return "/login.html";
    }

    @ExceptionHandler(value={HussarDisabledAccountException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public JSONObject accountFrozen(HussarDisabledAccountException e, Model model) {
        this.writeBussinessLog(e.getUserName(), e.getMessage());
        JSONObject json = new JSONObject();
        json.put("result", (Object)e.getMessage());
        json.put("code", (Object)"loginFail");
        json.put("msg", (Object)e.getMsgSign());
        return json;
    }

    @ExceptionHandler(value={LockedAccountException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public JSONObject accountLocked(LockedAccountException e, Model model) {
        JSONObject json = new JSONObject();
        json.put("result", (Object)"\u8d26\u53f7\u88ab\u9501\u5b9a");
        json.put("code", (Object)"loginFail");
        return json;
    }

    @ExceptionHandler(value={HussarLockedAccountException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public JSONObject accountLocked(HussarLockedAccountException e, Model model) {
        this.writeBussinessLog(e.getUserName(), e.getMessage());
        JSONObject json = new JSONObject();
        json.put("result", (Object)e.getMessage());
        json.put("msg", (Object)e.getMsgSign());
        json.put("count", (Object)e.getCount());
        return json;
    }

    @ExceptionHandler(value={CredentialsException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public JSONObject credentials(CredentialsException e, Model model) {
        JSONObject json = new JSONObject();
        if (ToolUtil.isEmpty((Object)e.getMessage())) {
            json.put("result", (Object)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
            json.put("code", (Object)"loginFail");
            json.put("msg", (Object)"userOrPWDError");
        } else {
            json.put("result", (Object)("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff0c" + e.getMessage()));
            json.put("code", (Object)"loginFail");
        }
        return json;
    }

    @ExceptionHandler(value={HussarCredentialsException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public JSONObject credentials(HussarCredentialsException e, Model model) {
        this.writeBussinessLog(e.getUserName(), e.getMessage());
        JSONObject json = new JSONObject();
        json.put("result", (Object)e.getMessage());
        json.put("code", (Object)"loginFail");
        json.put("msg", (Object)e.getMsgSign());
        json.put("count", (Object)e.getCount());
        return json;
    }

    @ExceptionHandler(value={InvalidKaptchaException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public JSONObject credentials(InvalidKaptchaException e, Model model) {
        this.writeBussinessLog(e.getUserName(), e.getMessage());
        JSONObject json = new JSONObject();
        json.put("result", (Object)e.getMessage());
        json.put("msg", (Object)e.getMsgSign());
        return json;
    }

    @ExceptionHandler(value={TotpKeyException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public JSONObject credentials(TotpKeyException e, Model model) {
        this.writeBussinessLog(e.getUserName(), e.getMessage());
        JSONObject json = new JSONObject();
        json.put("result", (Object)e.getMessage());
        json.put("msg", (Object)e.getMsgSign());
        return json;
    }

    @ExceptionHandler(value={LoginSessionException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public JSONObject credentials(LoginSessionException e, Model model) {
        this.writeBussinessLog(e.getUserName(), e.getMessage());
        JSONObject json = new JSONObject();
        json.put("result", (Object)e.getMessage());
        return json;
    }

    @ExceptionHandler(value={LoginGetParamException.class})
    @ResponseStatus(value=HttpStatus.METHOD_NOT_ALLOWED)
    @ResponseBody
    public JSONObject loginGetparam(LoginGetParamException e, Model model) {
        this.writeBussinessLog(e.getUserName(), e.getMessage());
        JSONObject json = new JSONObject();
        json.put("result", (Object)e.getMessage());
        return json;
    }

    @ExceptionHandler(value={DormancyException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public JSONObject credentials(DormancyException e, Model model) {
        this.writeBussinessLog(e.getUserName(), e.getMessage());
        JSONObject json = new JSONObject();
        json.put("result", (Object)e.getMessage());
        json.put("msg", (Object)e.getMsgSign());
        return json;
    }

    @ExceptionHandler(value={CancelException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public JSONObject credentials(CancelException e) {
        this.writeBussinessLog(e.getUserName(), e.getMessage());
        JSONObject json = new JSONObject();
        json.put("result", (Object)e.getMessage());
        json.put("msg", (Object)e.getMsgSign());
        return json;
    }

    @ExceptionHandler(value={TemporaryException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public JSONObject credentials(TemporaryException e, Model model) {
        this.writeBussinessLog(e.getUserName(), e.getMessage());
        JSONObject json = new JSONObject();
        json.put("result", (Object)e.getMessage());
        json.put("msg", (Object)e.getMsgSign());
        return json;
    }

    @ExceptionHandler(value={LoginIpRefuseException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public JSONObject credentials(LoginIpRefuseException e) {
        this.writeBussinessLog(e.getUserName(), e.getMessage());
        JSONObject json = new JSONObject();
        json.put("result", (Object)e.getMessage());
        json.put("msg", (Object)e.getMsgSign());
        return json;
    }

    @ExceptionHandler(value={LoginTimeRefuseException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public JSONObject credentials(LoginTimeRefuseException e) {
        this.writeBussinessLog(e.getUserName(), e.getMessage());
        JSONObject json = new JSONObject();
        json.put("result", (Object)e.getMessage());
        json.put("msg", (Object)e.getMsgSign());
        return json;
    }

    @ExceptionHandler(value={UndeclaredThrowableException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public ErrorTip credentials(UndeclaredThrowableException e) {
        HttpKit.getRequest().setAttribute("tip", (Object)"\u6743\u9650\u5f02\u5e38");
        this.log.error("\u6743\u9650\u5f02\u5e38!", (Throwable)e);
        return new ErrorTip(BizExceptionEnum.NO_PERMITION.getCode().intValue(), BizExceptionEnum.NO_PERMITION.getMessage());
    }

    @ExceptionHandler(value={HussarUndeclaredThrowableException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public Object accountFrozen(HussarUndeclaredThrowableException e, Model model) {
        HttpServletRequest httpServletRequest = WebUtils.toHttp((ServletRequest)HttpKit.getRequest());
        if (httpServletRequest.getHeader("x-requested-with") != null && ("AxiosHttpRequest".equalsIgnoreCase(httpServletRequest.getHeader("x-requested-with")) || "XMLHttpRequest".equalsIgnoreCase(httpServletRequest.getHeader("x-requested-with")))) {
            JSONObject json = new JSONObject();
            json.put("msg", (Object)BizExceptionEnum.USER_NULL.getMessage());
            json.put("code", (Object)BizExceptionEnum.USER_NULL.getCode());
            json.put("result", (Object)"UNAUTHENTICATED");
            return json;
        }
        ModelAndView mav = new ModelAndView();
        mav.setViewName("/login.html");
        return mav;
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public Object notFount(RuntimeException e) {
        ShiroUser user;
        try {
            user = ShiroKit.getUser();
        }
        catch (HussarUndeclaredThrowableException e2) {
            user = null;
        }
        if (null != user) {
            HussarLogManager.me().executeLog(LogTaskFactory.exceptionLog(user, e, this.logInfo(null, null)));
            HttpKit.getRequest().setAttribute("tip", (Object)"\u670d\u52a1\u5668\u672a\u77e5\u8fd0\u884c\u65f6\u5f02\u5e38");
            this.log.error("\u8fd0\u884c\u65f6\u5f02\u5e38:", (Throwable)e);
            HttpServletRequest httpServletRequest = WebUtils.toHttp((ServletRequest)HttpKit.getRequest());
            if (httpServletRequest.getHeader("x-requested-with") != null && ("AxiosHttpRequest".equalsIgnoreCase(httpServletRequest.getHeader("x-requested-with")) || "XMLHttpRequest".equalsIgnoreCase(httpServletRequest.getHeader("x-requested-with")))) {
                JSONObject json = new JSONObject();
                json.put("msg", (Object)BizExceptionEnum.SERVER_ERROR.getMessage());
                json.put("code", (Object)BizExceptionEnum.SERVER_ERROR.getCode());
                json.put("result", (Object)"UNKNOWNEXCEPTION");
                return json;
            }
            ModelAndView mav = new ModelAndView();
            mav.setViewName("/500.html");
            return mav;
        }
        JSONObject json = new JSONObject();
        json.put("msg", (Object)BizExceptionEnum.USER_NULL.getMessage());
        json.put("code", (Object)BizExceptionEnum.USER_NULL.getCode());
        json.put("result", (Object)"UNAUTHENTICATED");
        return json;
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public Object credentials(UnauthorizedException e) {
        ShiroUser user = ShiroKit.getUser();
        String userName = "";
        if (user != null) {
            userName = user.getAccount();
        }
        this.writeBussinessLog(userName, "\u8d8a\u6743\u8bbf\u95ee!" + e);
        HttpServletRequest httpServletRequest = WebUtils.toHttp((ServletRequest)HttpKit.getRequest());
        if (globalProperties.isExceptionAlert() && ToolUtil.isNotEmpty((Object)globalProperties.getExceptionAlertEmail())) {
            UnauthorizedMailUtil.sendMail(e, httpServletRequest);
        }
        if (httpServletRequest.getHeader("x-requested-with") != null && ("AxiosHttpRequest".equalsIgnoreCase(httpServletRequest.getHeader("x-requested-with")) || "XMLHttpRequest".equalsIgnoreCase(httpServletRequest.getHeader("x-requested-with")))) {
            JSONObject json = new JSONObject();
            json.put("msg", (Object)BizExceptionEnum.USER_NULL.getMessage());
            json.put("code", (Object)BizExceptionEnum.USER_NULL.getCode());
            json.put("result", (Object)"NOPERMISSION");
            return json;
        }
        ModelAndView mav = new ModelAndView();
        mav.setViewName("/403.html");
        return mav;
    }

    @ExceptionHandler(value={IsRepeatAuthenticateException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public Object isRepeat(IsRepeatAuthenticateException e) {
        JSONObject json = new JSONObject();
        json.put("msg", (Object)BizExceptionEnum.USER_NULL.getMessage());
        json.put("code", (Object)BizExceptionEnum.USER_NULL.getCode());
        json.put("result", (Object)"NOTREPEATAUTHENTICATE");
        return json;
    }

    @ExceptionHandler(value={UnauthenticatedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public Object unLogin(UnauthenticatedException e) {
        HttpServletRequest httpServletRequest = WebUtils.toHttp((ServletRequest)HttpKit.getRequest());
        if (httpServletRequest.getHeader("x-requested-with") != null && ("AxiosHttpRequest".equalsIgnoreCase(httpServletRequest.getHeader("x-requested-with")) || "XMLHttpRequest".equalsIgnoreCase(httpServletRequest.getHeader("x-requested-with")))) {
            JSONObject json = new JSONObject();
            json.put("msg", (Object)BizExceptionEnum.SESSION_TIMEOUT.getMessage());
            json.put("code", (Object)BizExceptionEnum.SESSION_TIMEOUT.getCode());
            json.put("result", (Object)"UNAUTHENTICATED");
            return json;
        }
        ModelAndView mav = new ModelAndView();
        mav.setViewName("/login.html");
        return mav;
    }

    @ExceptionHandler(value={ApiException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public Object apiException(RuntimeException e) {
        HussarLogManager.me().executeLog(LogTaskFactory.exceptionLog(ShiroKit.getUser(), e, this.logInfo(null, null)));
        HttpKit.getRequest().setAttribute("tip", (Object)"\u670d\u52a1\u5668\u672a\u77e5\u8fd0\u884c\u65f6\u5f02\u5e38");
        this.log.error("\u8fd0\u884c\u65f6\u5f02\u5e38: REPLAY", (Throwable)e);
        HttpServletRequest httpServletRequest = WebUtils.toHttp((ServletRequest)HttpKit.getRequest());
        if (httpServletRequest.getHeader("x-requested-with") != null && ("AxiosHttpRequest".equalsIgnoreCase(httpServletRequest.getHeader("x-requested-with")) || "XMLHttpRequest".equalsIgnoreCase(httpServletRequest.getHeader("x-requested-with")))) {
            JSONObject json = new JSONObject();
            json.put("msg", (Object)BizExceptionEnum.NO_PERMITION.getMessage());
            json.put("code", (Object)BizExceptionEnum.NO_PERMITION.getCode());
            json.put("result", (Object)"REPLAY");
            return json;
        }
        ModelAndView mav = new ModelAndView();
        mav.setViewName("/500.html");
        return mav;
    }

    private Map<String, String> logInfo(@Nullable HussarException e, @Nullable HttpServletRequest request) {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("ip", HttpKit.getIp());
        info.put("port", HttpKit.getPort());
        info.put("host", HttpKit.getHost());
        info.put("localIp", HttpKit.getLocalIp());
        info.put("localPort", HttpKit.getLocalPort());
        info.put("localHost", HttpKit.getLocalHost());
        info.put("sessionId", HttpKit.getSeesionId());
        if (ToolUtil.isNotEmpty((Object)e)) {
            info.put("className", e.getStackTrace()[0].getClassName());
            info.put("methodName", e.getStackTrace()[0].getMethodName());
            info.put("lineNumber", ToolUtil.toStr((Object)e.getStackTrace()[0].getLineNumber()));
        }
        if (ToolUtil.isNotEmpty((Object)request)) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            Enumeration a = request.getParameterNames();
            String param = "";
            String val = "";
            while (a.hasMoreElements()) {
                param = (String)a.nextElement();
                val = request.getParameter(param);
                paramMap.put(param, val);
            }
            info.put("params", JSON.toJSONString(paramMap));
        }
        return info;
    }

    @ExceptionHandler(value={DataSourceException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public JSONObject credentials(DataSourceException e, Model model) {
        this.writeBussinessLog(e.getUserName(), e.getMessage());
        JSONObject json = new JSONObject();
        json.put("result", (Object)e.getMessage());
        return json;
    }

    @ExceptionHandler(value={TenantException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public JSONObject credentials(TenantException e, Model model) {
        this.writeBussinessLog(e.getUserName(), e.getMessage());
        JSONObject json = new JSONObject();
        json.put("result", (Object)e.getMessage());
        return json;
    }

    @ExceptionHandler(value={TenantLoginException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public JSONObject credentials(TenantLoginException e, Model model) {
        this.writeBussinessLog(e.getUserName(), e.getMessage());
        JSONObject json = new JSONObject();
        json.put("result", (Object)e.getMessage());
        json.put("code", (Object)"loginFail");
        json.put("msg", (Object)e.getMsgSign());
        return json;
    }
}

