/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.aop;

import com.jxdinfo.hussar.common.annotion.DataScope;
import com.jxdinfo.hussar.common.entity.BaseEntity;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.factory.IShiro;
import com.jxdinfo.hussar.core.shiro.factory.ShiroFactroy;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DataScopeAop {
    @Pointcut(value="@annotation(com.jxdinfo.hussar.common.annotion.DataScope)")
    public void dataScopePointCut() {
    }

    @Before(value="dataScopePointCut()")
    public void doBefore(JoinPoint point) {
        this.handleDataScope(point);
    }

    private void handleDataScope(JoinPoint joinPoint) {
        DataScope dataScope = this.getAnnotationLog(joinPoint);
        if (dataScope == null) {
            return;
        }
        ShiroUser shiroUser = ShiroKit.getUser();
        if (ToolUtil.isNotEmpty((Object)shiroUser) && !shiroUser.isSuperAdmin()) {
            this.dataScopeFilter(joinPoint, shiroUser, dataScope.deptAlias(), dataScope.userAlias(), dataScope.levelAlias());
        }
    }

    private void dataScopeFilter(JoinPoint joinPoint, ShiroUser user, String deptAlias, String userAlias, String levelAlias) {
        Object[] params;
        StringBuilder sqlString = new StringBuilder();
        IShiro shiro = ShiroFactroy.me();
        BigDecimal level = user.getSecurityLevel();
        if (level != null && ToolUtil.isNotEmpty((Object)levelAlias)) {
            int highLevel = level.intValue();
            if (highLevel == 0) {
                sqlString.append(ToolUtil.format((String)" {} = '{}' ", (Object[])new Object[]{levelAlias, highLevel}));
            } else {
                int lowLevel = 0;
                sqlString.append(ToolUtil.format((String)" {} BETWEEN '{}' AND '{}' ", (Object[])new Object[]{levelAlias, lowLevel, highLevel}));
            }
            sqlString.append(" AND ");
        }
        Map<String, Object> map = shiro.getDataScopeInfo(user);
        String dataScope = map.get("data_scope_type").toString();
        Set list = (Set)map.get("data_scope_list");
        String orgIds = "";
        if (ToolUtil.isNotEmpty((Object)list)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String orgId : list) {
                stringBuilder.append("'").append(orgId).append("',");
            }
            orgIds = stringBuilder.toString().substring(0, stringBuilder.lastIndexOf(","));
        }
        if ("1".equals(dataScope)) {
            sqlString.append("1 = 1");
        } else if ("4".equals(dataScope)) {
            if (ToolUtil.isNotEmpty((Object)userAlias)) {
                sqlString.append(ToolUtil.format((String)" {} = '{}' ", (Object[])new Object[]{userAlias, user.getId()}));
                if (ToolUtil.isNotEmpty((Object)orgIds) && ToolUtil.isNotEmpty((Object)deptAlias)) {
                    sqlString.append(ToolUtil.format((String)"OR {} in ({})", (Object[])new Object[]{deptAlias, orgIds}));
                }
            } else {
                sqlString.append(" 1 = 0 ");
            }
        } else if (ToolUtil.isNotEmpty((Object)deptAlias) && ToolUtil.isNotEmpty((Object)orgIds)) {
            sqlString.append(ToolUtil.format((String)" {} IN ( {} ) ", (Object[])new Object[]{deptAlias, orgIds}));
        } else {
            sqlString.append(" 1 = 0 ");
        }
        if (ToolUtil.isNotEmpty((Object)sqlString.toString()) && ToolUtil.isNotEmpty((Object)(params = joinPoint.getArgs()))) {
            for (Object obj : params) {
                if (!(obj instanceof BaseEntity)) continue;
                BaseEntity baseEntity = (BaseEntity)obj;
                baseEntity.setDataScopeSql("(" + sqlString + ")");
            }
        }
    }

    private DataScope getAnnotationLog(JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        if (method != null) {
            return method.getAnnotation(DataScope.class);
        }
        return null;
    }
}

