/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config.web;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.support.http.StatViewServlet;
import com.alibaba.druid.support.http.WebStatFilter;
import com.alibaba.druid.support.spring.stat.BeanTypeAutoProxyCreator;
import com.alibaba.druid.support.spring.stat.DruidStatInterceptor;
import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.google.code.kaptcha.util.Config;
import com.jxdinfo.hussar.common.firewall.cors.CorsProperties;
import com.jxdinfo.hussar.common.firewall.csrf.CsrfFilter;
import com.jxdinfo.hussar.common.firewall.xss.XssFilter;
import com.jxdinfo.hussar.config.cas.ShiroCasConfiguration;
import com.jxdinfo.hussar.config.properties.ConnectionPoolProperties;
import com.jxdinfo.hussar.config.properties.HussarProperties;
import com.jxdinfo.hussar.core.listener.ConfigListener;
import com.jxdinfo.hussar.isc.conf.ShiroIscConfiguration;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import java.io.IOException;
import java.util.EventListener;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.JdkRegexpMethodPointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.web.context.request.RequestContextListener;

@Configuration
public class WebConfig {
    @Autowired
    private HussarProperties hussarProperties;
    @Autowired
    private CorsProperties corsProperties;
    @Autowired
    ConnectionPoolProperties connectionPoolProperties;
    @Autowired
    AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Autowired
    private ShiroIscConfiguration iscConf;
    @Autowired
    private ShiroCasConfiguration casConf;

    @Bean
    public ServletRegistrationBean<StatViewServlet> druidServletRegistration() {
        ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)new StatViewServlet(), new String[0]);
        registration.addUrlMappings(new String[]{"/druid/*"});
        if (this.connectionPoolProperties.isInUse()) {
            registration.setEnabled(true);
        } else {
            registration.setEnabled(false);
        }
        if (this.connectionPoolProperties.isNeedLogin()) {
            registration.addInitParameter("loginUsername", this.connectionPoolProperties.getLoginUsername());
            registration.addInitParameter("loginPassword", this.connectionPoolProperties.getLoginPassword());
        }
        return registration;
    }

    @Bean
    public FilterRegistrationBean<WebStatFilter> druidStatFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)new WebStatFilter(), new ServletRegistrationBean[0]);
        filterRegistrationBean.addUrlPatterns(new String[]{"/*"});
        filterRegistrationBean.addInitParameter("exclusions", "/logout,/login,/static/*,*.js,*.gif,*.jpg,*.png,*.css,*.ico,/druid,/druid/*,/frontLogin/*,/speedcode/publish/*");
        filterRegistrationBean.addInitParameter("principalSessionName", "username");
        return filterRegistrationBean;
    }

    @Bean
    public DruidStatInterceptor druidStatInterceptor() {
        return new DruidStatInterceptor();
    }

    @Bean
    public JdkRegexpMethodPointcut druidStatPointcut() {
        JdkRegexpMethodPointcut druidStatPointcut = new JdkRegexpMethodPointcut();
        String patterns = "com.jxdinfo.hussar.*.service.*";
        druidStatPointcut.setPatterns(new String[]{patterns});
        return druidStatPointcut;
    }

    @Bean
    public BeanTypeAutoProxyCreator beanTypeAutoProxyCreator() {
        BeanTypeAutoProxyCreator beanTypeAutoProxyCreator = new BeanTypeAutoProxyCreator();
        beanTypeAutoProxyCreator.setTargetBeanType(DruidDataSource.class);
        beanTypeAutoProxyCreator.setInterceptorNames(new String[]{"druidStatInterceptor"});
        return beanTypeAutoProxyCreator;
    }

    @Bean
    public Advisor druidStatAdvisor() {
        return new DefaultPointcutAdvisor((Pointcut)this.druidStatPointcut(), (Advice)this.druidStatInterceptor());
    }

    @Bean
    public FilterRegistrationBean<XssFilter> xssFilterRegistration() {
        XssFilter xssFilter = new XssFilter();
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)xssFilter, new ServletRegistrationBean[0]);
        registration.addUrlPatterns(new String[]{"/*"});
        xssFilter.setXssLevel(this.hussarProperties.getFirewallXssLevel());
        List xssList = this.hussarProperties.getXssWhitelist();
        StringBuffer exclusions = new StringBuffer("/logout,/static/*,*.js,*.gif,*.jpg,*.png,*.css,*.ico");
        StringBuffer pathChecks = new StringBuffer("*/sqlnet.log,*/sqlnet.trc,*/status.cgi,*.cgi,*.dll,*.exe,*.sh,*.bat*,/servlet/viewsource.jsp,/cgi-bin/htgrep/*,*.asp,*.aspx,*php,*php5,*php4,*php3,*php2,*php1,*.swp");
        if (xssList != null && xssList.size() > 0) {
            for (String string : xssList) {
                exclusions.append(",");
                exclusions.append(string);
            }
        }
        registration.addInitParameter("exclusions", exclusions.toString());
        List xssBlackList = this.hussarProperties.getXssBlacklist();
        if (xssBlackList != null && xssBlackList.size() > 0) {
            for (String string : xssBlackList) {
                pathChecks.append(",");
                pathChecks.append(string);
            }
        }
        registration.addInitParameter("pathChecks", pathChecks.toString());
        return registration;
    }

    @Bean
    public FilterRegistrationBean<CsrfFilter> csrfFilterRegistration() {
        String[] allowedOrigins;
        CsrfFilter csrfFilter = new CsrfFilter(this.abstractOTPCredentialsMatcher);
        csrfFilter.setCsrfcheck(this.hussarProperties.isCheckCsrfOpen());
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)csrfFilter, new ServletRegistrationBean[0]);
        registration.addUrlPatterns(new String[]{"/*"});
        StringBuffer exclusions = new StringBuffer("/logout,/static/*,/monitor,*.js,*.gif,*.jpg,*.png,*.css,*.ico");
        List csrfList = this.hussarProperties.getCsrfWhitelist();
        if (csrfList != null && csrfList.size() > 0) {
            for (String string : csrfList) {
                exclusions.append(",");
                exclusions.append(string);
            }
        }
        StringBuffer referExclusions = new StringBuffer();
        List referList = this.hussarProperties.getReferWhitelist();
        if (this.iscConf.isActive()) {
            String iscServerUrl = this.iscConf.getServerUrlPrefix();
            referExclusions.append(",");
            referExclusions.append(iscServerUrl);
        }
        if (this.casConf.isActive()) {
            String casServerUrl = this.casConf.getServerUrlPrefix();
            referExclusions.append(",");
            referExclusions.append(casServerUrl);
        }
        if (referList != null && referList.size() > 0) {
            for (String string : referList) {
                referExclusions.append(",");
                referExclusions.append(string);
            }
        }
        for (String string : allowedOrigins = this.corsProperties.getAllowedOrigins()) {
            referExclusions.append(",");
            referExclusions.append(string);
        }
        csrfFilter.setRefererWhitelist(referExclusions.toString());
        registration.addInitParameter("exclusions", exclusions.toString());
        return registration;
    }

    @Bean
    public ServletListenerRegistrationBean<RequestContextListener> requestContextListenerRegistration() {
        return new ServletListenerRegistrationBean((EventListener)new RequestContextListener());
    }

    @Bean
    public ServletListenerRegistrationBean<ConfigListener> configListenerRegistration() {
        return new ServletListenerRegistrationBean((EventListener)new ConfigListener());
    }

    @Bean
    public DefaultKaptcha kaptcha() throws IOException {
        PropertiesFactoryBean propertiesFactoryBean = new PropertiesFactoryBean();
        propertiesFactoryBean.setLocation((Resource)new ClassPathResource("/kaptcha.properties"));
        propertiesFactoryBean.afterPropertiesSet();
        Config config = new Config(propertiesFactoryBean.getObject());
        DefaultKaptcha defaultKaptcha = new DefaultKaptcha();
        defaultKaptcha.setConfig(config);
        return defaultKaptcha;
    }
}

