/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config.web;

import org.apache.catalina.Context;
import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@ConditionalOnClass(name={"org.apache.catalina.connector.Connector"})
public class TomcatWebServerFactoryConfig {
    @Autowired
    ServerProperties serverProperties;

    @Bean
    @Profile(value={"produce"})
    public TomcatServletWebServerFactory servletContainer() {
        TomcatServletWebServerFactory tomcat = new TomcatServletWebServerFactory(){

            protected void postProcessContext(Context context) {
                String portheader;
                String[] portheaders;
                SecurityConstraint securityConstraint = new SecurityConstraint();
                securityConstraint.setUserConstraint("CONFIDENTIAL");
                SecurityCollection collection = new SecurityCollection();
                collection.addPattern("/*");
                if (TomcatWebServerFactoryConfig.this.serverProperties != null && (portheaders = (portheader = TomcatWebServerFactoryConfig.this.serverProperties.getTomcat().getPortHeader()).split(",")).length > 0) {
                    for (String string : portheaders) {
                        collection.addMethod(string.trim());
                    }
                }
                securityConstraint.addCollection(collection);
                context.addConstraint(securityConstraint);
            }
        };
        tomcat.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> connector.setAllowTrace(true)});
        return tomcat;
    }
}

