/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config.properties;

import com.jxdinfo.hussar.bsp.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.bsp.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.core.config.HussarConfig;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="hussar")
@Primary
public class HussarProperties
extends HussarConfig {
    private ISysBaseConfigService iSysBaseConfigService = null;
    private static final String OPEN = "0";
    private static final String CLOSE = "1";
    public static final String PREFIX = "hussar";
    private SimpleCookie shiroCookie;
    private String packaged;

    public String getPackaged() {
        return this.packaged;
    }

    public void setPackaged(String packaged) {
        this.packaged = packaged;
    }

    public SimpleCookie getShiroCookie() {
        return this.shiroCookie;
    }

    public void setShiroCookie(SimpleCookie shiroCookie) {
        this.shiroCookie = shiroCookie;
    }

    public void setSessionInvalidateTime(Integer sessionInvalidateTime) {
        if (sessionInvalidateTime > 1800 || sessionInvalidateTime < 0) {
            throw new RuntimeException("\u4f1a\u8bdd\u8d85\u65f6\u65f6\u95f4\u4e0d\u5728\u6709\u6548\u65f6\u95f4\u533a\u95f4\uff0c\u6709\u6548\u65f6\u95f4\u533a\u95f4\u4e3a0 ~ 1800\u79d2");
        }
        super.setSessionInvalidateTime(sessionInvalidateTime);
    }

    public Boolean getLoginUpperOpen() {
        Boolean loginUpperOpen = this.getBooleanBaseConfig("login_upper_open", super.getLoginUpperOpen());
        super.setLoginUpperOpen(loginUpperOpen);
        return loginUpperOpen;
    }

    public Boolean getKaptchaOpen() {
        Boolean kaptchaOpen = this.getBooleanBaseConfig("kaptcha_open", super.getKaptchaOpen());
        super.setKaptchaOpen(kaptchaOpen);
        return kaptchaOpen;
    }

    public Boolean getTotpOpen() {
        Boolean totpOpen = this.getBooleanBaseConfig("totp_open", super.getTotpOpen());
        super.setTotpOpen(totpOpen);
        return totpOpen;
    }

    public int getTotpOffsetMin() {
        String offsetMinStr = this.getStringBaseConfig("totp_offset_min", String.valueOf(super.getTotpOffsetMin()));
        int offsetMin = Integer.valueOf(offsetMinStr);
        super.setTotpOffsetMin(offsetMin);
        return offsetMin;
    }

    private SysBaseConfig getBaseConfigByKey(String key) {
        if (ToolUtil.isEmpty((Object)this.iSysBaseConfigService)) {
            this.iSysBaseConfigService = (ISysBaseConfigService)SpringContextHolder.getBean(ISysBaseConfigService.class);
        }
        return this.iSysBaseConfigService.getSysBaseConfig(key);
    }

    private Boolean getBooleanBaseConfig(String key, Boolean prop) {
        SysBaseConfig baseConfig = this.getBaseConfigByKey(key);
        if (ToolUtil.isNotEmpty((Object)((Object)baseConfig)) && ToolUtil.isNotEmpty((Object)baseConfig.getConfigValue())) {
            prop = OPEN.equals(baseConfig.getConfigValue());
        }
        return prop;
    }

    private String getStringBaseConfig(String key, String prop) {
        SysBaseConfig baseConfig = this.getBaseConfigByKey(key);
        if (ToolUtil.isNotEmpty((Object)((Object)baseConfig)) && ToolUtil.isNotEmpty((Object)baseConfig.getConfigValue())) {
            prop = baseConfig.getConfigValue();
        }
        return prop;
    }
}

