/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config.front.config;

import com.jxdinfo.hussar.config.cas.ShiroCasConfiguration;
import com.jxdinfo.hussar.config.front.config.CasCallbackFilter;
import com.jxdinfo.hussar.config.front.config.FrontKickoutSessionFilter;
import com.jxdinfo.hussar.config.front.config.FrontSessionManager;
import com.jxdinfo.hussar.config.front.config.IscCallbackFilter;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.config.properties.HussarProperties;
import com.jxdinfo.hussar.config.properties.JwtProperties;
import com.jxdinfo.hussar.config.properties.RestProperties;
import com.jxdinfo.hussar.config.properties.ShiroProperties;
import com.jxdinfo.hussar.core.intercept.HussarUserFilter;
import com.jxdinfo.hussar.core.shiro.HussarSessionListener;
import com.jxdinfo.hussar.core.shiro.ShiroDbRealm;
import com.jxdinfo.hussar.core.shiro.ShiroPac4jRealm;
import com.jxdinfo.hussar.core.shiro.interceptor.HussarAuthorizationAttributeSourceAdvisor;
import com.jxdinfo.hussar.isc.conf.ShiroIscConfiguration;
import com.jxdinfo.hussar.isc.listener.IscSingleSignOutHttpSessionListener;
import io.buji.pac4j.filter.LogoutFilter;
import io.buji.pac4j.filter.SecurityFilter;
import io.buji.pac4j.subject.Pac4jSubjectFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.ehcache.EhCacheManager;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.mgt.RememberMeManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SubjectFactory;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.SessionListener;
import org.apache.shiro.session.mgt.ExecutorServiceSessionValidationScheduler;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.session.mgt.SessionValidationScheduler;
import org.apache.shiro.session.mgt.ValidatingSessionManager;
import org.apache.shiro.session.mgt.eis.MemorySessionDAO;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.spring.LifecycleBeanPostProcessor;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.CookieRememberMeManager;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.apache.shiro.web.session.mgt.ServletContainerSessionManager;
import org.crazycake.shiro.IRedisManager;
import org.crazycake.shiro.RedisCacheManager;
import org.crazycake.shiro.RedisSessionDAO;
import org.pac4j.core.config.Config;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.MethodInvokingFactoryBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.cache.ehcache.EhCacheManagerFactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.filter.DelegatingFilterProxy;

@Configuration
public class ShiroConfig {
    @Value(value="${spring.profiles.active}")
    private String active;
    @Autowired
    private ShiroProperties shiroProperties;
    @Autowired
    private JwtProperties jwtProperties;
    @Autowired
    private RestProperties restProperties;
    @Autowired
    private CredentialsMatcher credentialsMatcher;
    @Autowired
    private ShiroIscConfiguration iscConf;
    @Autowired
    private HussarProperties hussarProperties;
    @Autowired
    private GlobalProperties globalProperties;
    @Autowired
    private ShiroCasConfiguration casConf;
    int kilo = 1000;

    @Bean
    public DefaultWebSecurityManager securityManager(CookieRememberMeManager rememberMeManager, CacheManager cacheShiroManager, SessionManager sessionManager, Realm realm, Pac4jSubjectFactory subjectFactory) {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setRealm(realm);
        if (this.iscConf.isActive() || this.casConf.isActive()) {
            securityManager.setSubjectFactory((SubjectFactory)subjectFactory);
        } else {
            securityManager.setRememberMeManager((RememberMeManager)rememberMeManager);
        }
        securityManager.setSessionManager(sessionManager);
        securityManager.setCacheManager(cacheShiroManager);
        return securityManager;
    }

    @Bean
    @ConditionalOnProperty(prefix="hussar", name={"spring-session-open"}, havingValue="true", matchIfMissing=false)
    public ServletContainerSessionManager servletContainerSessionManager() {
        return new ServletContainerSessionManager();
    }

    @Bean
    @ConditionalOnProperty(prefix="hussar", name={"spring-session-open"}, havingValue="false", matchIfMissing=true)
    public DefaultWebSessionManager defaultWebSessionManager(CacheManager cacheShiroManager, Collection<SessionListener> listeners, SessionDAO sessionDAO) {
        FrontSessionManager sessionManager = new FrontSessionManager();
        sessionManager.setSessionValidationScheduler(this.sessionValidationScheduler(sessionManager));
        sessionManager.setSessionValidationInterval(this.hussarProperties.getSessionValidationInterval() * this.kilo);
        sessionManager.setGlobalSessionTimeout(this.hussarProperties.getSessionInvalidateTime() * this.kilo);
        sessionManager.setDeleteInvalidSessions(true);
        sessionManager.setSessionValidationSchedulerEnabled(true);
        sessionManager.setSessionIdUrlRewritingEnabled(false);
        sessionManager.setSessionListeners(listeners);
        sessionManager.setCacheManager(cacheShiroManager);
        sessionManager.setSessionDAO(sessionDAO);
        sessionManager.setSessionIdCookieEnabled(true);
        SimpleCookie cookie = new SimpleCookie(this.globalProperties.getTitle() + "_hussarShiroCookie");
        if (this.casConf.isActive()) {
            cookie.setHttpOnly(false);
        } else if (this.iscConf.isActive()) {
            cookie.setHttpOnly(false);
        } else {
            cookie.setHttpOnly(true);
        }
        SimpleCookie shiroCookie = this.hussarProperties.getShiroCookie();
        if (shiroCookie != null) {
            cookie.setComment(shiroCookie.getComment());
            cookie.setDomain(shiroCookie.getDomain());
            cookie.setMaxAge(shiroCookie.getMaxAge());
            cookie.setPath(shiroCookie.getPath());
            cookie.setSameSite(shiroCookie.getSameSite());
            cookie.setValue(shiroCookie.getValue());
            cookie.setVersion(shiroCookie.getVersion());
            String name = shiroCookie.getName();
            if (name != null && name.endsWith("_hussarShiroCookie")) {
                cookie.setName(name);
            }
            cookie.setSecure(shiroCookie.isSecure());
        }
        sessionManager.setSessionIdCookie((Cookie)cookie);
        return sessionManager;
    }

    @Bean
    @ConditionalOnProperty(prefix="hussar", name={"stand-alone"}, havingValue="false", matchIfMissing=false)
    public SessionDAO redisSessionDAO(IRedisManager redisManager) {
        RedisSessionDAO sessionDAO = null;
        sessionDAO = new RedisSessionDAO();
        sessionDAO.setRedisManager(redisManager);
        return sessionDAO;
    }

    @Bean
    @ConditionalOnProperty(prefix="hussar", name={"stand-alone"}, havingValue="true", matchIfMissing=true)
    public SessionDAO sessionDAO() {
        MemorySessionDAO sessionDAO = null;
        if (this.hussarProperties.isStandAlone()) {
            sessionDAO = new MemorySessionDAO();
        }
        return sessionDAO;
    }

    @Bean
    public SessionValidationScheduler sessionValidationScheduler(FrontSessionManager sessionManager) {
        ExecutorServiceSessionValidationScheduler svs = new ExecutorServiceSessionValidationScheduler();
        svs.setInterval((long)(this.hussarProperties.getSessionValidationInterval() * this.kilo));
        svs.setSessionManager((ValidatingSessionManager)sessionManager);
        svs.enableSessionValidation();
        return svs;
    }

    @Bean
    @ConditionalOnProperty(prefix="hussar", name={"stand-alone"}, havingValue="false", matchIfMissing=false)
    public CacheManager redisCacheShiroManager(IRedisManager redisManager) {
        RedisCacheManager cacheManager = new RedisCacheManager();
        cacheManager.setRedisManager(redisManager);
        return cacheManager;
    }

    @Bean
    @ConditionalOnProperty(prefix="hussar", name={"stand-alone"}, havingValue="true", matchIfMissing=true)
    public CacheManager ehCacheShiroManager(EhCacheManagerFactoryBean ehcache) {
        EhCacheManager ehCacheManager = new EhCacheManager();
        ehCacheManager.setCacheManager(ehcache.getObject());
        return ehCacheManager;
    }

    @Bean
    public Collection<SessionListener> getSessionListener() {
        ArrayList<SessionListener> listeners = new ArrayList<SessionListener>();
        listeners.add(new HussarSessionListener());
        if (this.iscConf.isActive()) {
            listeners.add(new IscSingleSignOutHttpSessionListener());
        }
        return listeners;
    }

    @Bean
    public CookieRememberMeManager rememberMeManager(SimpleCookie rememberMeCookie) {
        CookieRememberMeManager manager = new CookieRememberMeManager();
        manager.setCipherKey(Base64.decode((String)"SHVzc2FyVjgAAAAAAAAAA="));
        manager.setCookie((Cookie)rememberMeCookie);
        return manager;
    }

    @Bean
    public CredentialsMatcher credentialsMatcher() {
        return this.credentialsMatcher;
    }

    @Bean
    public SimpleCookie rememberMeCookie() {
        SimpleCookie simpleCookie = new SimpleCookie(this.globalProperties.getTitle() + "_rememberMe");
        simpleCookie.setComment("\u767b\u5f55\u72b6\u6001\u5df2\u88ab\u8bb0\u5f55");
        simpleCookie.setHttpOnly(true);
        int time = this.hussarProperties.getRemebermeDays() * 24 * 60 * 60;
        simpleCookie.setMaxAge(time);
        return simpleCookie;
    }

    @Bean(value={"shiroFilter"})
    public ShiroFilterFactoryBean shiroFilter(DefaultWebSecurityManager securityManager, DefaultWebSessionManager sessionManager, SessionDAO sessionDAO, Config config) {
        ShiroFilterFactoryBean shiroFilter = new ShiroFilterFactoryBean();
        shiroFilter.setSecurityManager((SecurityManager)securityManager);
        String loginUrl = this.shiroProperties.getLoginUrl();
        if (StringUtils.isEmpty((CharSequence)loginUrl)) {
            loginUrl = "/login";
        }
        shiroFilter.setLoginUrl(loginUrl);
        String successUrl = this.shiroProperties.getSuccessUrl();
        if (StringUtils.isEmpty((CharSequence)successUrl)) {
            successUrl = "/";
        }
        shiroFilter.setSuccessUrl(successUrl);
        shiroFilter.setUnauthorizedUrl("/frontMsg/unauthorized");
        HashMap<String, Object> filters = new HashMap<String, Object>();
        if (this.iscConf.isActive()) {
            SecurityFilter securityFilter = new SecurityFilter();
            securityFilter.setConfig(config);
            securityFilter.setClients(this.iscConf.getClientName());
            filters.put("securityFilter", securityFilter);
            IscCallbackFilter callbackFilter = new IscCallbackFilter();
            callbackFilter.setHussarProperties(this.hussarProperties);
            callbackFilter.setIscConf(this.iscConf);
            callbackFilter.setConfig(config);
            callbackFilter.setDefaultUrl(this.iscConf.getLocalUrl());
            filters.put("callbackFilter", callbackFilter);
            LogoutFilter logoutFilter = new LogoutFilter();
            logoutFilter.setConfig(config);
            logoutFilter.setCentralLogout(Boolean.valueOf(true));
            logoutFilter.setLocalLogout(Boolean.valueOf(true));
            logoutFilter.setDefaultUrl(this.iscConf.getLocalUrl() + "/callback?client_name=" + this.iscConf.getClientName());
            filters.put("logoutFilter", logoutFilter);
        } else if (this.casConf.isActive()) {
            SecurityFilter securityFilter = new SecurityFilter();
            securityFilter.setConfig(config);
            securityFilter.setClients(this.casConf.getClientName());
            filters.put("securityFilter", securityFilter);
            CasCallbackFilter callbackFilter = new CasCallbackFilter();
            callbackFilter.setHussarProperties(this.hussarProperties);
            callbackFilter.setCasConf(this.casConf);
            callbackFilter.setConfig(config);
            callbackFilter.setDefaultUrl(this.casConf.getLocalUrl());
            filters.put("callbackFilter", callbackFilter);
            LogoutFilter logoutFilter = new LogoutFilter();
            logoutFilter.setConfig(config);
            logoutFilter.setCentralLogout(Boolean.valueOf(true));
            logoutFilter.setLocalLogout(Boolean.valueOf(true));
            logoutFilter.setDefaultUrl(this.casConf.getServerLogoutUrl() + "?service=" + this.casConf.getLocalUrl());
            filters.put("logoutFilter", logoutFilter);
        } else {
            filters.put("user", (Object)new HussarUserFilter());
            filters.put("kickout", (Object)this.kickoutSessionFilter(sessionManager, sessionDAO));
        }
        shiroFilter.setFilters(filters);
        if (this.iscConf.isActive() || this.casConf.isActive()) {
            this.loadShiroFilterChain(shiroFilter, true);
        } else {
            this.loadShiroFilterChain(shiroFilter, false);
        }
        return shiroFilter;
    }

    @Bean
    public MethodInvokingFactoryBean methodInvokingFactoryBean(DefaultWebSecurityManager securityManager) {
        MethodInvokingFactoryBean bean = new MethodInvokingFactoryBean();
        bean.setStaticMethod("org.apache.shiro.SecurityUtils.setSecurityManager");
        bean.setArguments(new Object[]{securityManager});
        return bean;
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.profiles", name={"active"}, havingValue="produce", matchIfMissing=false)
    public static LifecycleBeanPostProcessor lifecycleBeanPostProcessor() {
        return new LifecycleBeanPostProcessor();
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.profiles", name={"active"}, havingValue="produce", matchIfMissing=false)
    public DefaultAdvisorAutoProxyCreator advisorAutoProxyCreator() {
        DefaultAdvisorAutoProxyCreator advisorAutoProxyCreator = new DefaultAdvisorAutoProxyCreator();
        advisorAutoProxyCreator.setProxyTargetClass(true);
        return advisorAutoProxyCreator;
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.profiles", name={"active"}, havingValue="produce", matchIfMissing=false)
    public HussarAuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor(DefaultWebSecurityManager securityManager) {
        HussarAuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor = new HussarAuthorizationAttributeSourceAdvisor();
        authorizationAttributeSourceAdvisor.setSecurityManager((SecurityManager)securityManager);
        return authorizationAttributeSourceAdvisor;
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.profiles", name={"active"}, havingValue="test", matchIfMissing=false)
    public static LifecycleBeanPostProcessor lifecycleBeanPostProcessorTest() {
        return new LifecycleBeanPostProcessor();
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.profiles", name={"active"}, havingValue="test", matchIfMissing=false)
    public DefaultAdvisorAutoProxyCreator advisorAutoProxyCreatorTest() {
        DefaultAdvisorAutoProxyCreator advisorAutoProxyCreator = new DefaultAdvisorAutoProxyCreator();
        advisorAutoProxyCreator.setProxyTargetClass(true);
        return advisorAutoProxyCreator;
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.profiles", name={"active"}, havingValue="test", matchIfMissing=false)
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisorTest(DefaultWebSecurityManager securityManager) {
        AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor = new AuthorizationAttributeSourceAdvisor();
        authorizationAttributeSourceAdvisor.setSecurityManager((SecurityManager)securityManager);
        return authorizationAttributeSourceAdvisor;
    }

    public FrontKickoutSessionFilter kickoutSessionFilter(DefaultWebSessionManager sessionManager, SessionDAO sessionDAO) {
        FrontKickoutSessionFilter kickoutSessionFilter = new FrontKickoutSessionFilter();
        kickoutSessionFilter.setSessionManager((SessionManager)sessionManager);
        kickoutSessionFilter.setKickoutUrl("/login?kickout=true");
        kickoutSessionFilter.setMaxSession(this.globalProperties.getSystemMaxSession());
        kickoutSessionFilter.setSessionDAO(sessionDAO);
        return kickoutSessionFilter;
    }

    @Bean
    public FilterRegistrationBean<DelegatingFilterProxy> filterRegistrationBean() {
        FilterRegistrationBean filterRegistration = new FilterRegistrationBean();
        filterRegistration.setFilter((Filter)new DelegatingFilterProxy("shiroFilter"));
        filterRegistration.addInitParameter("targetFilterLifecycle", "true");
        filterRegistration.setEnabled(true);
        filterRegistration.addUrlPatterns(new String[]{"/*"});
        filterRegistration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.FORWARD});
        return filterRegistration;
    }

    @Bean
    public Pac4jSubjectFactory subjectFactory() {
        return new Pac4jSubjectFactory();
    }

    @Bean
    public Realm realm(@Qualifier(value="credentialsMatcher") CredentialsMatcher matcher) {
        if (this.iscConf.isActive()) {
            ShiroPac4jRealm realm = new ShiroPac4jRealm();
            realm.setClientName(this.iscConf.getClientName());
            realm.setCachingEnabled(false);
            realm.setAuthenticationCachingEnabled(false);
            realm.setAuthorizationCachingEnabled(false);
            return realm;
        }
        if (this.casConf.isActive()) {
            ShiroPac4jRealm shiroPac4jRealm = new ShiroPac4jRealm();
            shiroPac4jRealm.setClientName(this.casConf.getClientName());
            shiroPac4jRealm.setCachingEnabled(false);
            shiroPac4jRealm.setAuthenticationCachingEnabled(false);
            shiroPac4jRealm.setAuthorizationCachingEnabled(false);
            return shiroPac4jRealm;
        }
        ShiroDbRealm shiroDbRealm = new ShiroDbRealm();
        shiroDbRealm.setCredentialsMatcher(matcher);
        return shiroDbRealm;
    }

    private void loadShiroFilterChain(ShiroFilterFactoryBean shiroFilterFactoryBean, Boolean isCas) {
        LinkedHashMap<String, String> filterChainDefinitionMap = new LinkedHashMap<String, String>();
        if ("dev".equals(this.active)) {
            if (isCas.booleanValue()) {
                filterChainDefinitionMap.put("/static/**", "anon");
                filterChainDefinitionMap.put("/callback", "callbackFilter");
                filterChainDefinitionMap.put("/logout", "logoutFilter");
                filterChainDefinitionMap.put("/", "securityFilter");
                filterChainDefinitionMap.put("/casFrontLogin/login", "securityFilter");
                filterChainDefinitionMap.put("/frontLogin/login", "securityFilter");
                filterChainDefinitionMap.put("/frontLogin/validateLogin", "securityFilter");
            }
            filterChainDefinitionMap.put("/**", "anon");
        } else {
            filterChainDefinitionMap.put(this.jwtProperties.getAuthPath(), "anon");
            for (String urlPatterns : this.restProperties.getUrlPattern()) {
                filterChainDefinitionMap.put(urlPatterns, "anon");
            }
            List<String> securityWhitelist = this.shiroProperties.getSecurityWhitelist();
            if (securityWhitelist != null) {
                for (String string : securityWhitelist) {
                    if (filterChainDefinitionMap.containsKey(string)) continue;
                    filterChainDefinitionMap.put(string, "anon");
                }
            }
            if (isCas.booleanValue()) {
                filterChainDefinitionMap.put("/static/**", "anon");
                filterChainDefinitionMap.put("/casonline/check", "anon");
                filterChainDefinitionMap.put("/callback", "callbackFilter");
                filterChainDefinitionMap.put("/frontMenu/getMenu", "anon");
                filterChainDefinitionMap.put("/websocket", "anon");
                filterChainDefinitionMap.put("/frontLogin/validateLogin", "securityFilter");
                filterChainDefinitionMap.put("/frontLogin/validateLogout", "anon");
                filterChainDefinitionMap.put("/frontLogin/isCasActive", "anon");
                filterChainDefinitionMap.put("/casFrontLogin/addShiroCookie", "anon");
                filterChainDefinitionMap.put("/casFrontLogin/getRedirectUrl", "anon");
                filterChainDefinitionMap.put("/casFrontLogin/logout", "anon");
                filterChainDefinitionMap.put("/", "securityFilter");
                filterChainDefinitionMap.put("/**", "securityFilter");
            } else {
                filterChainDefinitionMap.put("/static/**", "anon");
                filterChainDefinitionMap.put("/login", "anon");
                filterChainDefinitionMap.put("/druid/*", "anon");
                filterChainDefinitionMap.put("/frontLogin/login", "anon");
                filterChainDefinitionMap.put("/frontLogin/getTotpKapcha", "anon");
                filterChainDefinitionMap.put("/frontLogin/getTenantCodeByDomain", "anon");
                filterChainDefinitionMap.put("/frontLogin/validateLogin", "anon");
                filterChainDefinitionMap.put("/frontLogin/validateLogout", "anon");
                filterChainDefinitionMap.put("/frontLogin/isCasActive", "anon");
                filterChainDefinitionMap.put("/vue/baseData/getBaseData", "anon");
                filterChainDefinitionMap.put("/frontLogin/getLoginViewInfo", "anon");
                filterChainDefinitionMap.put("/homePage/getHomePageInfo", "anon");
                filterChainDefinitionMap.put("/sysBaseConfigFront/showPicture", "anon");
                filterChainDefinitionMap.put("/getBackPwd/**", "anon");
                filterChainDefinitionMap.put("/getBackPwdFront/**", "anon");
                filterChainDefinitionMap.put("/global/sessionError", "anon");
                filterChainDefinitionMap.put("/kaptcha", "anon");
                filterChainDefinitionMap.put("/security", "anon");
                filterChainDefinitionMap.put("/resource/checkResource", "anon");
                filterChainDefinitionMap.put("/resourceFront/checkResource", "anon");
                filterChainDefinitionMap.put("/exception/repeat", "anon");
                filterChainDefinitionMap.put("/user/reChecking", "anon");
                filterChainDefinitionMap.put("/userFront/reChecking", "anon");
                filterChainDefinitionMap.put("/license/check", "anon");
                filterChainDefinitionMap.put("/casonline/check", "anon");
                filterChainDefinitionMap.put("/error", "anon");
                filterChainDefinitionMap.put("/**", "kickout");
            }
        }
        shiroFilterFactoryBean.setFilterChainDefinitionMap(filterChainDefinitionMap);
    }
}

