/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config.front.config;

import com.jxdinfo.hussar.config.properties.HussarProperties;
import com.jxdinfo.hussar.isc.conf.ShiroIscConfiguration;
import io.buji.pac4j.context.ShiroSessionStore;
import io.buji.pac4j.engine.ShiroCallbackLogic;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.CallbackLogic;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.http.adapter.J2ENopHttpActionAdapter;
import org.pac4j.core.util.CommonHelper;

public class IscCallbackFilter
implements Filter {
    private CallbackLogic<Object, J2EContext> callbackLogic = new ShiroCallbackLogic();
    private Config config;
    private String defaultUrl;
    private Boolean saveInSession;
    private Boolean multiProfile;
    private String defaultClient;
    private HttpActionAdapter<Object, J2EContext> httpActionAdapter;
    private HussarProperties hussarProperties;
    private ShiroIscConfiguration iscConf;

    public void setHussarProperties(HussarProperties hussarProperties) {
        this.hussarProperties = hussarProperties;
    }

    public void setIscConf(ShiroIscConfiguration iscConf) {
        this.iscConf = iscConf;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpActionAdapter<Object, J2EContext> adapter;
        CommonHelper.assertNotNull((String)"callbackLogic", this.callbackLogic);
        CommonHelper.assertNotNull((String)"config", (Object)this.config);
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        SessionStore sessionStore = this.config.getSessionStore();
        J2EContext context = new J2EContext(request, response, (SessionStore)(sessionStore != null ? sessionStore : ShiroSessionStore.INSTANCE));
        HttpActionAdapter<Object, J2EContext> httpActionAdapter = adapter = this.httpActionAdapter != null ? this.httpActionAdapter : J2ENopHttpActionAdapter.INSTANCE;
        if (this.hussarProperties.getUseSeparation().booleanValue()) {
            try {
                this.callbackLogic.perform((WebContext)context, this.config, adapter, this.defaultUrl, this.saveInSession, this.multiProfile, Boolean.valueOf(false), this.defaultClient);
            }
            catch (TechnicalException e) {
                HttpAction action = this.redirectToFrontUrl(context, this.iscConf.getFrontUrl());
                adapter.adapt(action.getCode(), (WebContext)context);
            }
        } else {
            this.callbackLogic.perform((WebContext)context, this.config, adapter, this.defaultUrl, this.saveInSession, this.multiProfile, Boolean.valueOf(false), this.defaultClient);
        }
    }

    private HttpAction redirectToFrontUrl(J2EContext context, String defaultUrl) {
        return HttpAction.redirect((WebContext)context, (String)defaultUrl);
    }

    public void destroy() {
    }

    public CallbackLogic<Object, J2EContext> getCallbackLogic() {
        return this.callbackLogic;
    }

    public void setCallbackLogic(CallbackLogic<Object, J2EContext> callbackLogic) {
        this.callbackLogic = callbackLogic;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public String getDefaultUrl() {
        return this.defaultUrl;
    }

    public void setDefaultUrl(String defaultUrl) {
        this.defaultUrl = defaultUrl;
    }

    public Boolean getMultiProfile() {
        return this.multiProfile;
    }

    public void setMultiProfile(Boolean multiProfile) {
        this.multiProfile = multiProfile;
    }

    public Boolean getSaveInSession() {
        return this.saveInSession;
    }

    public void setSaveInSession(Boolean saveInSession) {
        this.saveInSession = saveInSession;
    }

    public String getDefaultClient() {
        return this.defaultClient;
    }

    public void setDefaultClient(String defaultClient) {
        this.defaultClient = defaultClient;
    }

    public HttpActionAdapter<Object, J2EContext> getHttpActionAdapter() {
        return this.httpActionAdapter;
    }

    public void setHttpActionAdapter(HttpActionAdapter<Object, J2EContext> httpActionAdapter) {
        this.httpActionAdapter = httpActionAdapter;
    }
}

