/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config.front.config;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bsp.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.bsp.constant.Constants;
import com.jxdinfo.hussar.bsp.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysOnline;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysOnlineHistService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.bsp.theme.service.IThemeService;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.LoginSessionException;
import com.jxdinfo.hussar.common.exception.LoginTimeRefuseException;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.config.front.common.response.ResultCode;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.sessionlimit.SessionLimit;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.SessionException;
import org.apache.shiro.session.mgt.DefaultSessionKey;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@DependsOn(value={"springContextHolder"})
@Component
public class FrontKickoutSessionFilter
extends AccessControlFilter {
    private static Logger logger = LoggerFactory.getLogger(FrontKickoutSessionFilter.class);
    private String kickoutUrl = "/login?kickout=true";
    public static final String SYSTEM_MAX_SESSION = "maxSession";
    public static final String KICKOUT = "kickout";
    public static final String LOGIN_NEW_SESSIONID = "loginNewSessionId";
    public static final String LOGIN_NEW_IP = "loginNewIp";
    public static final String CAUSE = "cause";
    private static final String ERROR_TIPS = "tips";
    public static final String MSG_SYSTEM_MAX_SESSION = "\u8d85\u8fc7\u7cfb\u7edf\u6700\u5927\u4f1a\u8bdd\u6570\u9650\u5236\uff01";
    public static final String MSG_KICKOUT = "\u60a8\u5df2\u7ecf\u5728\u522b\u5904\u767b\u5f55\uff01";
    private SessionManager sessionManager;
    private SessionDAO sessionDAO;
    private Long maxSession = 1000000L;

    public SessionDAO getSessionDAO() {
        return this.sessionDAO;
    }

    public void setSessionDAO(SessionDAO sessionDAO) {
        this.sessionDAO = sessionDAO;
    }

    public Long getMaxSession() {
        return this.maxSession;
    }

    public void setMaxSession(Long maxSession) {
        this.maxSession = maxSession;
    }

    public void setKickoutUrl(String kickoutUrl) {
        this.kickoutUrl = kickoutUrl;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        GlobalProperties globalProperties;
        HttpServletRequest httpServletRequest = WebUtils.toHttp((ServletRequest)request);
        HttpServletResponse httpServletResponse = WebUtils.toHttp((ServletResponse)response);
        String requestUri = httpServletRequest.getRequestURI();
        String ua = this.getUsreAgent(httpServletRequest);
        String ip = this.getIP(httpServletRequest);
        logger.debug(String.format("URL:%s | IP: %s | USER-AGENT: %s", requestUri, ip, ua));
        String tips = httpServletRequest.getParameter(ERROR_TIPS);
        if (tips != null) {
            httpServletRequest.setAttribute(ERROR_TIPS, (Object)tips);
        } else {
            httpServletRequest.setAttribute(ERROR_TIPS, (Object)"");
        }
        Subject subject = this.getSubject(request, response);
        Boolean isRemembered = subject.isRemembered();
        Session session = subject.getSession();
        ShiroUser shiroUser = ShiroKit.getUser();
        if (ToolUtil.isEmpty((Object)shiroUser)) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("code", ResultCode.UN_AUTHORIZED.getCode());
            resultMap.put("msg", ResultCode.UN_AUTHORIZED.getMessage());
            this.out(response, resultMap);
        }
        if ((globalProperties = (GlobalProperties)SpringContextHolder.getBean(GlobalProperties.class)).isTenantOpen()) {
            if (ToolUtil.isNotEmpty((Object)shiroUser)) {
                try {
                    DataSourceUtil.changeTempDs((String)shiroUser.getConnName());
                    boolean bl = this.userFilter(request, response, httpServletRequest, httpServletResponse, globalProperties, requestUri, ua, ip, isRemembered, session, subject, shiroUser);
                    return bl;
                }
                finally {
                    DataSourceUtil.poll();
                }
            }
            return this.userFilter(request, response, httpServletRequest, httpServletResponse, globalProperties, requestUri, ua, ip, isRemembered, session, subject, shiroUser);
        }
        return this.userFilter(request, response, httpServletRequest, httpServletResponse, globalProperties, requestUri, ua, ip, isRemembered, session, subject, shiroUser);
    }

    private boolean userFilter(ServletRequest request, ServletResponse response, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, GlobalProperties globalProperties, String requestUri, String ua, String ip, Boolean isRemembered, Session session, Subject subject, ShiroUser shiroUser) throws Exception {
        String accessLoginEndTime;
        String connName = DataSourceUtil.currentDsName();
        if (isRemembered.booleanValue()) {
            ISysUsersService iSysUsersService = (ISysUsersService)SpringContextHolder.getBean(ISysUsersService.class);
            IThemeService themeService = (IThemeService)SpringContextHolder.getBean(IThemeService.class);
            String userAccount = shiroUser.getAccount();
            SysUsers sysUsers = (SysUsers)((Object)iSysUsersService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ACCOUNT", (Object)userAccount)).eq((Object)"ACCOUNT_STATUS", (Object)UserStatus.OK.getCode()), false));
            session.setAttribute((Object)"sessionFlag", (Object)true);
            session.setAttribute((Object)"shiroUser", (Object)shiroUser);
            session.setAttribute((Object)"userId", (Object)shiroUser.getId());
            session.setAttribute((Object)"theme", (Object)themeService.getUserTheme());
            if (sysUsers != null && "1".equals(sysUsers.getLoginTimeLimit())) {
                session.setAttribute((Object)"startTime", (Object)sysUsers.getAccessLoginStartTime());
                session.setAttribute((Object)"endTime", (Object)sysUsers.getAccessLoginEndTime());
            }
            ISysOnlineHistService iSysOnlineHistService = (ISysOnlineHistService)SpringContextHolder.getBean(ISysOnlineHistService.class);
            SysOnline online = iSysOnlineHistService.addRecord();
            session.setAttribute((Object)"online", (Object)online);
        }
        if (!subject.isAuthenticated() && !isRemembered.booleanValue()) {
            if (shiroUser != null && session.getAttribute((Object)"csrfFlag") == null) {
                session.setAttribute((Object)"csrfFlag", (Object)true);
                httpServletRequest.getRequestDispatcher(this.kickoutUrl).forward(request, response);
                return false;
            }
            httpServletRequest.getRequestURI();
            httpServletRequest.getRemoteHost();
            if (httpServletRequest.getHeader("x-requested-with") != null && "XMLHttpRequest".equalsIgnoreCase(httpServletRequest.getHeader("x-requested-with"))) {
                httpServletResponse.setHeader("sessionstatus", "timeout");
                return false;
            }
            String referer = httpServletRequest.getHeader("Referer");
            if (referer == null) {
                this.saveRequestAndRedirectToLogin(request, response);
                return false;
            }
            return false;
        }
        String accessLoginStartTime = session.getAttribute((Object)"startTime") == null ? "" : (String)session.getAttribute((Object)"startTime");
        String string = accessLoginEndTime = session.getAttribute((Object)"endTime") == null ? "" : (String)session.getAttribute((Object)"endTime");
        if (!Arrays.asList(Constants.MANAGE_USER).contains(shiroUser.getAccount()) && ToolUtil.isNotEmpty((Object)accessLoginStartTime) && ToolUtil.isNotEmpty((Object)accessLoginEndTime)) {
            boolean flag = false;
            Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
            SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
            try {
                Date dt1 = df.parse(accessLoginStartTime);
                Date dt2 = df.parse(accessLoginEndTime);
                Date now = df.parse(df.format(date));
                if (dt1.getTime() <= now.getTime() && now.getTime() <= dt2.getTime()) {
                    flag = true;
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            if (!flag) {
                subject.logout();
                throw new LoginTimeRefuseException(shiroUser.getName(), "\u5f53\u524d\u65f6\u95f4\u7981\u6b62\u767b\u5f55");
            }
        }
        if (globalProperties.isSessionLimit()) {
            Session kickoutSession;
            SysUsersMapper usersMapper = (SysUsersMapper)SpringContextHolder.getBean(SysUsersMapper.class);
            SessionLimit sessionLimit = (SessionLimit)SpringContextHolder.getBean(SessionLimit.class);
            ISysBaseConfigService sysBaseConfigService = (ISysBaseConfigService)SpringContextHolder.getBean(ISysBaseConfigService.class);
            SysUsers sysUser = (SysUsers)((Object)usersMapper.selectById((Serializable)((Object)shiroUser.getId())));
            String userId = shiroUser.getId();
            Serializable sessionId = session.getId();
            String currentIp = httpServletRequest.getRemoteAddr();
            String maxSessionStr = sysBaseConfigService.getSysBaseConfig("max_session_num").getConfigValue();
            this.maxSession = Long.parseLong(maxSessionStr);
            if (this.maxSession != -1L) {
                Collection collection = this.sessionDAO.getActiveSessions();
                Iterator it = collection.iterator();
                long now = System.currentTimeMillis();
                while (it.hasNext()) {
                    Serializable activeId;
                    Session s = (Session)it.next();
                    Boolean sessionFlag = (Boolean)s.getAttribute((Object)"sessionFlag");
                    if (sessionFlag != null && now - s.getLastAccessTime().getTime() <= s.getTimeout() || subject.isRemembered() && sessionId.equals(activeId = s.getId())) continue;
                    if (globalProperties.isTenantOpen()) {
                        sessionLimit.removeBySession(s, connName);
                    } else {
                        sessionLimit.removeBySession(s);
                    }
                    this.sessionDAO.delete(s);
                }
                collection = this.sessionDAO.getActiveSessions();
                if (globalProperties.isSessionLimit() && (long)collection.size() > this.maxSession) {
                    try {
                        kickoutSession = this.sessionManager.getSession((SessionKey)new DefaultSessionKey(sessionId));
                        if (kickoutSession != null) {
                            kickoutSession.setAttribute((Object)KICKOUT, (Object)true);
                            kickoutSession.setAttribute((Object)LOGIN_NEW_SESSIONID, (Object)sessionId);
                            kickoutSession.setAttribute((Object)LOGIN_NEW_IP, (Object)currentIp);
                            kickoutSession.setAttribute((Object)CAUSE, (Object)SYSTEM_MAX_SESSION);
                        }
                    }
                    catch (SessionException e) {
                        e.printStackTrace();
                    }
                }
            }
            String userName = shiroUser.getName();
            int userMaxSession = sysUser.getMaxSessions().intValue();
            if (userMaxSession != -1) {
                Deque<Serializable> deque = globalProperties.isTenantOpen() ? sessionLimit.getUserSession(userId, connName) : sessionLimit.getUserSession(userId);
                if (!deque.contains(sessionId) && session.getAttribute((Object)KICKOUT) == null) {
                    deque.push(sessionId);
                    if (globalProperties.isTenantOpen()) {
                        sessionLimit.addUserSession(userId, connName, deque);
                    } else {
                        sessionLimit.addUserSession(userId, deque);
                    }
                }
                if (deque.size() > userMaxSession && !isRemembered.booleanValue()) {
                    Serializable kickoutSessionId = null;
                    if (globalProperties.isKickoutAfter()) {
                        kickoutSessionId = deque.removeFirst();
                        logger.debug(String.format("\u8e22\u51fa\u540e\u8005\u64cd\u4f5c\uff1a \u5f53\u524d\u7528\u6237: %s (%s) \u7684\u6700\u5927\u5141\u8bb8\u4f1a\u8bdd\u6570\u4e3a: %s ,\u5df2\u7ecf\u5728\u522b\u5904\u767b\u5f55\uff0c\u522b\u5904\u767b\u5f55\u7684SessionId\u4e3a\uff1a%s\uff0c\u5f53\u524dSessionId\uff1a %s \u4e0d\u5141\u8bb8\u767b\u5f55\uff0c\u5f53\u524d\u8bf7\u6c42\u5730\u5740\u4e3a: %s , \u5ba2\u6237\u7aefIP: %s , \u6d4f\u89c8\u5668\u4fe1\u606f: %s", userName, userId, userMaxSession, kickoutSessionId, sessionId, requestUri, ip, ua));
                    } else {
                        kickoutSessionId = deque.removeLast();
                        logger.debug(String.format("\u8e22\u51fa\u524d\u8005\u64cd\u4f5c\uff1a \u5f53\u524d\u7528\u6237: %s (%s) \u7684\u6700\u5927\u5141\u8bb8\u4f1a\u8bdd\u6570\u4e3a: %s ,\u5df2\u7ecf\u5728\u522b\u5904\u767b\u5f55\uff0c\u522b\u5904\u767b\u5f55\u7684SessionId\u4e3a\uff1a%s\uff0c\u5df2\u7ecf\u88ab\u8e22\u51fa\uff0c\u5f53\u524dSessionId\uff1a %s ,\u5f53\u524d\u8bf7\u6c42\u5730\u5740\u4e3a: %s , \u5ba2\u6237\u7aefIP: %s , \u6d4f\u89c8\u5668\u4fe1\u606f: %s", userName, userId, userMaxSession, kickoutSessionId, sessionId, requestUri, ip, ua));
                    }
                    if (globalProperties.isTenantOpen()) {
                        sessionLimit.addUserSession(userId, connName, deque);
                    } else {
                        sessionLimit.addUserSession(userId, deque);
                    }
                    try {
                        kickoutSession = this.sessionManager.getSession((SessionKey)new DefaultSessionKey(kickoutSessionId));
                        if (kickoutSession != null) {
                            kickoutSession.setAttribute((Object)KICKOUT, (Object)true);
                            kickoutSession.setAttribute((Object)LOGIN_NEW_SESSIONID, (Object)sessionId);
                            kickoutSession.setAttribute((Object)LOGIN_NEW_IP, (Object)currentIp);
                        }
                    }
                    catch (SessionException e) {
                        e.printStackTrace();
                    }
                }
            }
            if ((Boolean)session.getAttribute((Object)KICKOUT) != null && ((Boolean)session.getAttribute((Object)KICKOUT)).booleanValue()) {
                String cause = (String)session.getAttribute((Object)CAUSE);
                logger.debug(String.format("\u5f53\u524d\u4f1a\u8bdd\u88ab\u8e22\u51fa\uff1a \u5f53\u524d\u7528\u6237: %s (%s) \u7684\u6700\u5927\u5141\u8bb8\u4f1a\u8bdd\u6570\u4e3a: %s ,\u5df2\u7ecf\u5728\u522b\u5904\u767b\u5f55\uff0c\u5f53\u524d\u88ab\u8e22\u51fa\u7684SessionId\u4e3a\uff1a%s\uff0c\u5df2\u7ecf\u88ab\u8e22\u51fa\uff0c\u5f53\u524d\u8bf7\u6c42\u5730\u5740\u4e3a: %s , \u5ba2\u6237\u7aefIP: %s , \u6d4f\u89c8\u5668\u4fe1\u606f: %s", userName, userId, userMaxSession, sessionId, requestUri, ip, ua));
                subject.logout();
                if (SYSTEM_MAX_SESSION.equals(cause)) {
                    throw new LoginSessionException(userName, MSG_SYSTEM_MAX_SESSION);
                }
                throw new LoginSessionException(userName, MSG_KICKOUT);
            }
            return true;
        }
        return true;
    }

    private void out(ServletResponse hresponse, Map<String, Object> resultMap) throws IOException {
        hresponse.setCharacterEncoding("UTF-8");
        PrintWriter out = hresponse.getWriter();
        out.println(JSON.toJSONString(resultMap));
        out.flush();
        out.close();
    }

    private String getIP(HttpServletRequest request) {
        StringBuffer ip = new StringBuffer();
        ip.append("X-Requested-For\uff1a").append(request.getHeader("X-Requested-For")).append(" , ");
        ip.append("X-Forwarded-For\uff1a").append(request.getHeader("X-Forwarded-For")).append(" , ");
        ip.append("Proxy-Client-IP\uff1a").append(request.getHeader("Proxy-Client-IP")).append(" , ");
        ip.append("WL-Proxy-Client-IP\uff1a").append(request.getHeader("WL-Proxy-Client-IP")).append(" , ");
        ip.append("HTTP_CLIENT_IP\uff1a").append(request.getHeader("HTTP_CLIENT_IP")).append(" , ");
        ip.append("HTTP_X_FORWARDED_FOR\uff1a").append(request.getHeader("HTTP_X_FORWARDED_FOR")).append(" , ");
        ip.append("RemoteAddr\uff1a").append(request.getRemoteAddr());
        return ip.toString();
    }

    private String getUsreAgent(HttpServletRequest request) {
        return request.getHeader("User-Agent");
    }
}

