/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config.cas;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="cas")
public class ShiroCasConfiguration {
    private String serverUrlPrefix;
    private String serverLoginUrl;
    private String serverLogoutUrl;
    private String localUrl;
    private String frontUrl;
    private String[] urlPatterns;
    private String clientName;
    private String welcomePage;
    private String smUri;
    private String appId;
    private String activeType = "";
    private String loginAccount;
    private String clientToken = "";
    private String mqPrefix = "";
    private Boolean allowHussarLogin = false;

    public String getClientToken() {
        return this.clientToken;
    }

    public String getMqPrefix() {
        return this.mqPrefix;
    }

    public void setMqPrefix(String mqPrefix) {
        this.mqPrefix = mqPrefix;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getLoginAccount() {
        return this.loginAccount;
    }

    public void setLoginAccount(String loginAccount) {
        this.loginAccount = loginAccount;
    }

    public String getActiveType() {
        return this.activeType;
    }

    public void setActiveType(String activeType) {
        this.activeType = activeType;
    }

    public boolean isActive() {
        return "CASClient".equals(this.activeType) || "CASServer".equals(this.activeType);
    }

    public String getServerLoginUrl() {
        return this.serverLoginUrl;
    }

    public void setServerLoginUrl(String serverLoginUrl) {
        this.serverLoginUrl = serverLoginUrl;
    }

    public String getLocalUrl() {
        return this.localUrl;
    }

    public void setLocalUrl(String localUrl) {
        this.localUrl = localUrl;
    }

    public String getFrontUrl() {
        return this.frontUrl;
    }

    public void setFrontUrl(String frontUrl) {
        this.frontUrl = frontUrl;
    }

    public String getServerUrlPrefix() {
        return this.serverUrlPrefix;
    }

    public void setServerUrlPrefix(String serverUrlPrefix) {
        this.serverUrlPrefix = serverUrlPrefix;
    }

    public String[] getUrlPatterns() {
        String[] stringArray;
        if (this.urlPatterns != null && this.urlPatterns.length != 0) {
            stringArray = this.urlPatterns;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "/*";
        }
        return stringArray;
    }

    public void setUrlPatterns(String[] urlPatterns) {
        this.urlPatterns = urlPatterns;
    }

    public String getClientName() {
        return this.clientName == null ? "Hussar V8" : this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getWelcomePage() {
        return this.welcomePage;
    }

    public void setWelcomePage(String welcomePage) {
        this.welcomePage = welcomePage;
    }

    public String getSmUri() {
        return this.smUri;
    }

    public void setSmUri(String smUri) {
        this.smUri = smUri;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getServerLogoutUrl() {
        return this.serverLogoutUrl;
    }

    public void setServerLogoutUrl(String serverLogoutUrl) {
        this.serverLogoutUrl = serverLogoutUrl;
    }

    public Boolean getAllowHussarLogin() {
        return this.allowHussarLogin;
    }

    public void setAllowHussarLogin(Boolean allowHussarLogin) {
        this.allowHussarLogin = allowHussarLogin;
    }
}

