/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.loginstatistics.service.impl;

import com.jxdinfo.hussar.common.loginstatistics.dao.LoginStatisticsMapper;
import com.jxdinfo.hussar.common.loginstatistics.service.LoginStatisticsService;
import com.jxdinfo.hussar.common.loginstatistics.vo.LoginStatisticsVo;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.stereotype.Service;

@Service
public class LoginStatisticsServiceImpl
implements LoginStatisticsService {
    @Resource
    private LoginStatisticsMapper loginStatisticsMapper;
    @Resource
    private DataSource dataSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LoginStatisticsVo> getChartData(Timestamp start) {
        Connection connection = null;
        String url = "";
        try {
            connection = this.dataSource.getConnection();
            url = connection.getMetaData().getURL();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (url.contains("mysql")) {
            return this.loginStatisticsMapper.getChartDataMysql(start);
        }
        if (url.contains("oracle")) {
            return this.loginStatisticsMapper.getChartDataOracle(start);
        }
        if (url.contains("dm")) {
            return this.loginStatisticsMapper.getChartDataDm(start);
        }
        if (url.contains("oscar")) {
            return this.loginStatisticsMapper.getChartDataOscar(start);
        }
        if (url.contains("kingbase")) {
            return this.loginStatisticsMapper.getChartDataKingbase(start);
        }
        if (url.contains("postgresql")) {
            return this.loginStatisticsMapper.getChartDataPostgreSql(start);
        }
        if (url.contains("highgo")) {
            return this.loginStatisticsMapper.getChartDataHighGo(start);
        }
        return this.loginStatisticsMapper.getChartDataMysql(start);
    }
}

