/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.loginstatistics.controller;

import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.loginstatistics.service.LoginStatisticsService;
import com.jxdinfo.hussar.common.loginstatistics.vo.LoginStatisticsVo;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.util.DateUtil;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/loginStatistics"})
public class LoginStatisticsController
extends BaseController {
    @Resource
    private LoginStatisticsService loginStatisticsService;

    @RequestMapping(value={"/view"})
    @BussinessLog(key="/loginStatistics/view", type="04", value="\u767b\u5f55\u7edf\u8ba1\u9875\u9762")
    @RequiresPermissions(value={"loginStatistics:view"})
    public String view() {
        return "/common/loginstatistics/loginstatistics.html";
    }

    @RequestMapping(value={"/chartData"})
    @BussinessLog(key="/loginStatistics/chartData", type="04", value="\u83b7\u53d6\u56fe\u8868\u6570\u636e")
    @ResponseBody
    public Object getChartData() {
        String date_range = super.getPara("date_range");
        Timestamp start = this.getStartTime(date_range);
        HashMap result = new HashMap(5);
        ArrayList<String> xdata = new ArrayList<String>();
        ArrayList<String> ydata = new ArrayList<String>();
        List<LoginStatisticsVo> data = null;
        try {
            data = this.loginStatisticsService.getChartData(start);
            for (LoginStatisticsVo loginStatisticsVo : data) {
                xdata.add(loginStatisticsVo.getName());
                ydata.add(loginStatisticsVo.getNum());
            }
            result.put("xdata", xdata);
            result.put("ydata", ydata);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Timestamp getStartTime(String dateRange) {
        String todayTime = DateUtil.formatDate((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyy-MM-dd 00:00:00");
        Date date = DateUtil.parse((String)todayTime, (String)"yyyy-MM-dd HH:mm:ss");
        if (!"today".equals(dateRange)) {
            if ("threeday".equals(dateRange)) {
                date = DateUtil.addDay((Date)date, (int)-3);
            } else if ("week".equals(dateRange)) {
                date = DateUtil.addWeek((Date)date, (int)-1);
            } else if ("month".equals(dateRange)) {
                date = DateUtil.addMonth((Date)date, (int)-1);
            }
        }
        return new Timestamp(date.getTime());
    }
}

