/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.firewall.xss;

import com.jxdinfo.hussar.common.firewall.xss.XssHttpServletRequestWrapper;
import com.jxdinfo.hussar.core.filter.HussarPathMatcher;
import com.jxdinfo.hussar.core.filter.PatternMatcher;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;

@Component
public class XssFilter
implements Filter {
    FilterConfig filterConfig;
    public static final String PARAM_NAME_EXCLUSIONS = "exclusions";
    public static final String PARAM_NAME_PATHCHECKS = "pathChecks";
    private String xssLevel;
    private Set<String> excludesPattern;
    private Set<String> pathCheck;
    protected String contextPath;
    protected PatternMatcher pathMatcher = HussarPathMatcher.getInstance();

    public void init(FilterConfig filterConfig) throws ServletException {
        String exclusions = filterConfig.getInitParameter(PARAM_NAME_EXCLUSIONS);
        String pathChecks = filterConfig.getInitParameter(PARAM_NAME_PATHCHECKS);
        if (exclusions != null && exclusions.trim().length() != 0) {
            this.excludesPattern = new HashSet<String>(Arrays.asList(exclusions.split("\\s*,\\s*")));
            this.pathCheck = new HashSet<String>(Arrays.asList(pathChecks.split("\\s*,\\s*")));
        }
        this.filterConfig = filterConfig;
        this.contextPath = this.getContextPath(filterConfig.getServletContext());
    }

    private String getContextPath(ServletContext servletContext) {
        String contextPath = servletContext.getContextPath();
        if (contextPath == null || contextPath.length() == 0) {
            contextPath = "/";
        }
        return contextPath;
    }

    public void destroy() {
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String requestUri = httpServletRequest.getRequestURI();
        for (String blackPath : this.pathCheck) {
            if (!this.pathMatcher.matches(blackPath, requestUri)) continue;
            request.getRequestDispatcher("/exception/500").forward(request, response);
            return;
        }
        if (this.isExclusion(requestUri)) {
            chain.doFilter(request, response);
        } else {
            chain.doFilter((ServletRequest)new XssHttpServletRequestWrapper((HttpServletRequest)request, this.getXssLevel()), response);
        }
    }

    public String getXssLevel() {
        return this.xssLevel;
    }

    public void setXssLevel(String xssLevel) {
        this.xssLevel = xssLevel;
    }

    private boolean isExclusion(String requestURI) {
        String requestURItmp = requestURI;
        boolean isexclusion = false;
        if (this.excludesPattern != null && requestURItmp != null) {
            if (this.contextPath != null && requestURItmp.startsWith(this.contextPath) && !(requestURItmp = requestURItmp.substring(this.contextPath.length())).startsWith("/")) {
                requestURItmp = "/" + requestURItmp;
            }
            for (String pattern : this.excludesPattern) {
                if (!this.pathMatcher.matches(pattern, requestURItmp)) continue;
                isexclusion = true;
            }
        }
        return isexclusion;
    }
}

