/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.converter;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.jxdinfo.hussar.common.exception.ApiException;
import com.jxdinfo.hussar.common.firewall.xss.XssChecker;
import com.jxdinfo.hussar.core.constant.HttpCode;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class XssStringDeserializer
extends JsonDeserializer<String> {
    StringDeserializer proxy = new StringDeserializer();

    public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String value = this.proxy.deserialize(p, ctxt);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        String xss = XssChecker.checkXss(value);
        if (!StringUtils.isEmpty((CharSequence)xss)) {
            throw new ApiException(HttpCode.BAD_REQUEST.value().intValue(), "invalid request , xss code:" + xss);
        }
        return value;
    }
}

