/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.attachment.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.attachment.model.AttachmentManagerModel;
import com.jxdinfo.hussar.common.attachment.service.AttachmentManagerService;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.config.properties.HussarProperties;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/attachment"})
public class AttachmentManagerController
extends BaseController {
    private static Logger logger = LogManager.getLogger(AttachmentManagerController.class);
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private HussarProperties hussarProperties;
    @Resource
    private GlobalProperties globalProperties;

    @RequiresPermissions(value={"attachment:upload"})
    @RequestMapping(method={RequestMethod.POST}, path={"/upload"})
    @BussinessLog(key="/attachment/upload", type="03", value="\u4e0a\u4f20\u6587\u4ef6")
    @ResponseBody
    public String upload(@RequestPart(value="file") MultipartFile file) {
        String fileName = file.getOriginalFilename();
        String suffix = fileName.substring(fileName.lastIndexOf("."));
        String fName = IdWorker.get32UUID() + suffix;
        try {
            String fileSavePath = this.hussarProperties.getFileUploadPath();
            file.transferTo(new File(fileSavePath + fName));
        }
        catch (IOException e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.UPLOAD_ERROR);
        }
        return fName;
    }

    @RequiresPermissions(value={"attachment:uploadfilewithdrag"})
    @RequestMapping(method={RequestMethod.POST}, path={"/uploadfilewithdrag"})
    @BussinessLog(key="/attachment/uploadfilewithdrag", type="03", value="\u591a\u6587\u4ef6\u4e0a\u4f20")
    @ResponseBody
    public Map<String, String> uploadfileWithDrag(MultipartHttpServletRequest multipartRequest) throws Exception {
        multipartRequest.setCharacterEncoding("UTF-8");
        HashMap<String, String> result = new HashMap<String, String>();
        String businessId = multipartRequest.getParameter("businessId");
        MultipartFile multipartFile = null;
        Map map = multipartRequest.getFileMap();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            MultipartFile value;
            multipartFile = value = (MultipartFile)iterator.next();
        }
        if (ToolUtil.isNotEmpty(multipartFile)) {
            String fileName = multipartFile.getOriginalFilename();
            String suffix = fileName.substring(fileName.lastIndexOf("."));
            String id = IdWorker.get32UUID();
            try {
                String fileSavePath = this.hussarProperties.getFileUploadPath();
                if (this.globalProperties.isTenantOpen()) {
                    String tenantCode = ShiroKit.getUser().getTenantCode();
                    File tenantFolder = new File(fileSavePath = fileSavePath + tenantCode + "\\");
                    if (!tenantFolder.exists()) {
                        tenantFolder.mkdir();
                    }
                }
                multipartFile.transferTo(new File(fileSavePath + id + suffix));
                AttachmentManagerModel attachment = new AttachmentManagerModel();
                attachment.setId(id);
                attachment.setBusinessId(businessId);
                attachment.setAttachmentName(fileName);
                attachment.setAttachmentType(suffix.replace(".", ""));
                attachment.setUploadPer(ShiroKit.getUser().getId());
                attachment.setAttachmentDir(fileSavePath);
                attachment.setUploadDate(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
                this.attachmentManagerService.save((Object)attachment);
                result.put("id", id);
                result.put("fileName", fileName);
            }
            catch (IOException e) {
                throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.UPLOAD_ERROR);
            }
            finally {
                DataSourceUtil.poll();
            }
        }
        return result;
    }

    @RequiresPermissions(value={"attachment:fileDownload"})
    @RequestMapping(value={"/fileDownload"})
    @BussinessLog(key="/attachment/fileDownload", type="03", value="\u6587\u4ef6\u4e0b\u8f7d")
    @ResponseBody
    public void fileDownload(HttpServletResponse response) {
        String fileId = super.getPara("fileId");
        AttachmentManagerModel attachmentModel = (AttachmentManagerModel)((Object)this.attachmentManagerService.getById((Serializable)((Object)fileId)));
        String id = attachmentModel.getId();
        String fileName = attachmentModel.getAttachmentName();
        String prefix = fileName.substring(fileName.lastIndexOf("."));
        String path = attachmentModel.getAttachmentDir() + id + prefix;
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(new File(path)), 10240);
             BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            fileName = URLEncoder.encode(fileName, "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("multipart/form-data");
            int len = 0;
            int i = ((InputStream)bis).available();
            byte[] buff = new byte[i];
            while ((len = ((InputStream)bis).read(buff)) > 0) {
                out.write(buff, 0, len);
                out.flush();
            }
        }
        catch (FileNotFoundException e) {
            logger.error("\u6587\u4ef6\u672a\u627e\u5230" + e.getMessage());
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.FILE_NOT_FOUND);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u4e0d\u652f\u6301\u7684\u7f16\u7801\u5f02\u5e38\uff1a" + e.getMessage());
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.DOWNLOAD_ERROR);
        }
        catch (IOException e) {
            logger.error("IO\u5f02\u5e38\uff1a" + e.getMessage());
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.DOWNLOAD_ERROR);
        }
    }

    @RequiresPermissions(value={"attachment:BatchDownload"})
    @RequestMapping(value={"/BatchDownload"}, method={RequestMethod.GET})
    @BussinessLog(key="/attachment/BatchDownload", type="03", value="\u6279\u91cf\u4e0b\u8f7d")
    public void batchDownload(@RequestParam(value="fileId") String ids, HttpServletResponse response) throws ServletException, IOException {
        ServletOutputStream os = response.getOutputStream();
        ZipOutputStream zos = new ZipOutputStream((OutputStream)os);
        BufferedInputStream bis = null;
        List<String> fileIdList = Arrays.asList(ids.split(","));
        List attachList = this.attachmentManagerService.listByIds(fileIdList);
        try {
            String sourceFilePath = "\u6279\u91cf\u4e0b\u8f7d.zip";
            response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(sourceFilePath, "UTF-8"));
            int count = 0;
            for (AttachmentManagerModel attach : attachList) {
                ++count;
                String id = attach.getId();
                String fileName = attach.getAttachmentName();
                String suffix = fileName.substring(fileName.lastIndexOf("."));
                String path = attach.getAttachmentDir() + id + suffix;
                BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(new File(path)));
                byte[] buf = new byte[((InputStream)inputStream).available()];
                int len = 0;
                ZipEntry zipEntry = new ZipEntry(count + "-" + fileName);
                zos.putNextEntry(zipEntry);
                bis = new BufferedInputStream(inputStream, 10240);
                while ((len = bis.read(buf)) > 0) {
                    zos.write(buf, 0, len);
                    zos.flush();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.DOWNLOAD_ERROR);
        }
        finally {
            zos.close();
            if (null != bis) {
                bis.close();
            }
        }
    }

    @RequiresPermissions(value={"attachment:view"})
    @RequestMapping(value={"/view"})
    @BussinessLog(key="/attachment/view", type="04", value="\u8df3\u8f6c\u5230\u9644\u4ef6\u5217\u8868\u9875\u9762")
    public String viewList() {
        return "/common/attachment/attachmentList.html";
    }

    @RequiresPermissions(value={"attachment:delete"})
    @RequestMapping(value={"/delete"})
    @BussinessLog(key="/attachment/delete", type="02", value="\u5220\u9664\u6587\u4ef6")
    public Object fileDelete(@RequestParam String fileId) {
        String fId = fileId.replace("[\"", "").replace("\"]", "");
        Map<String, String> fileMap = this.attachmentManagerService.findById(fId);
        String fileName = fileMap.get("name");
        String id = fileMap.get("id");
        String fileSavePath = this.attachmentManagerService.finddirById(id);
        String prefix = fileName.substring(fileName.lastIndexOf("."));
        File file = new File(fileSavePath.replace("\\", "/") + id + prefix);
        if (file.exists() && file.isFile()) {
            file.delete();
        }
        this.attachmentManagerService.deleteFile(fId);
        return BaseController.SUCCESS_TIP;
    }

    @RequiresPermissions(value={"attachment:getAttachmentList"})
    @RequestMapping(value={"/getAttachmentList"})
    @BussinessLog(key="/attachment/getAttachmentList", type="04", value="\u9644\u4ef6\u4fe1\u606f\u5217\u8868\u67e5\u8be2")
    @ResponseBody
    public JSONObject testPage() {
        String pageName = super.getPara("curr");
        String limitName = super.getPara("nums");
        String attachmentName = super.getPara("attachmentName");
        String startDate = super.getPara("dateStart");
        String endDate = super.getPara("dateEnd");
        if (ToolUtil.isNotEmpty((Object)attachmentName)) {
            attachmentName = attachmentName.replace("%", "\\\\%").replace("_", "\\\\_");
        }
        Page<Map<String, Object>> page = new Page<Map<String, Object>>((long)Integer.valueOf(pageName).intValue(), (long)Integer.valueOf(limitName).intValue());
        page = this.attachmentManagerService.getPageList((Page)page, attachmentName, startDate, endDate);
        JSONObject json = new JSONObject();
        json.put("data", (Object)page.getRecords());
        json.put("code", (Object)"0");
        json.put("msg", (Object)"");
        json.put("count", (Object)page.getTotal());
        return json;
    }

    @RequiresPermissions(value={"attachment:showPicture"})
    @RequestMapping(value={"/showPicture"})
    @BussinessLog(key="/attachment/showPicture", type="04", value="\u663e\u793a\u56fe\u7247")
    public void showImage(HttpServletResponse response) {
        response.setContentType("text/html; charset=UTF-8");
        response.setContentType("image/jpeg");
        String id = super.getPara("image");
        AttachmentManagerModel image = (AttachmentManagerModel)((Object)this.attachmentManagerService.getById((Serializable)((Object)id)));
        String fileName = image.getAttachmentName();
        String fileId = image.getId();
        String fileSavePath = image.getAttachmentDir();
        String suffix = fileName.substring(fileName.lastIndexOf("."));
        String absolutePath = fileSavePath.replace("\\", "/") + fileId + suffix;
        try (FileInputStream fis = new FileInputStream(absolutePath);
             ServletOutputStream os = response.getOutputStream();){
            byte[] byt = new byte[fis.available()];
            fis.read(byt);
            os.write(byt);
            os.flush();
        }
        catch (IOException e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SHOWIMG_ERROR);
        }
    }

    @RequiresPermissions(value={"attachment:uploadFileQuery"})
    @RequestMapping(value={"/uploadFileQuery"})
    @ResponseBody
    public ApiResponse<Map<String, String>> uploadFileQuery(@RequestBody Map<String, String> map) {
        String fileId = map.get("fileId");
        AttachmentManagerModel attachmentModel = (AttachmentManagerModel)((Object)this.attachmentManagerService.getById((Serializable)((Object)fileId)));
        String id = attachmentModel.getId();
        String fileName = attachmentModel.getAttachmentName();
        String prefix = fileName.substring(fileName.lastIndexOf("."));
        String path = attachmentModel.getAttachmentDir() + id + prefix;
        File file = new File(path);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("id", id);
        result.put("fileName", fileName);
        result.put("path ", path);
        result.put("byte ", String.valueOf(file.length()));
        return ApiResponse.data(result);
    }
}

