/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.tenant.service.impl;

import com.baomidou.dynamic.datasource.annotation.Master;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.datasource.model.SysDataSource;
import com.jxdinfo.hussar.bsp.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.bsp.loginuser.service.SysLoginUserService;
import com.jxdinfo.hussar.bsp.loginuser.service.SysUserTenantService;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysIdtableService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.bsp.tenant.dao.SysTenantMapper;
import com.jxdinfo.hussar.bsp.tenant.model.SysTenant;
import com.jxdinfo.hussar.bsp.tenant.service.SysTenantService;
import com.jxdinfo.hussar.common.exception.TenantException;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.config.front.common.response.ResultCode;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.datasource.DruidProperties;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.response.BpmResponseResult;
import com.jxdinfo.hussar.tenant.TenantService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Master
public class SysTenantServiceImpl
extends ServiceImpl<SysTenantMapper, SysTenant>
implements SysTenantService {
    @Resource
    private SysTenantMapper sysTenantMapper;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private DruidProperties druidProperties;
    @Resource
    private SysDataSourceService sysDataSourceService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private SysLoginUserService sysLoginUserService;
    @Resource
    private SysUserTenantService sysUserTenantService;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private ServerProperties serverProperties;

    @Override
    public String getTenantCodeByDomain(String domain) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"TENANT_DOMAIN", (Object)domain)).orderByAsc((Object)"TENANT_CODE");
        List sysTenantList = this.sysTenantMapper.selectList((Wrapper)queryWrapper);
        if (sysTenantList != null && sysTenantList.size() > 0) {
            return ((SysTenant)((Object)sysTenantList.get(0))).getTenantCode();
        }
        return null;
    }

    @Override
    public ApiResponse<SysTenant> getDetail(String tenantId) {
        SysTenant sysTenant = this.sysTenantMapper.getDetail(tenantId);
        if ("000000".equals(sysTenant.getTenantCode())) {
            sysTenant.setTenantDomain(this.druidProperties.getDomain());
            sysTenant.setDbName("\u9ed8\u8ba4\u6570\u636e\u6e90");
        }
        if (sysTenant.getBpmTenantId() == null && sysTenant.getBpmTenantCipher() == null) {
            sysTenant.setIsBpmType("0");
        } else if ("".equals(sysTenant.getBpmTenantId()) && "".equals(sysTenant.getBpmTenantCipher())) {
            sysTenant.setIsBpmType("0");
        } else {
            sysTenant.setIsBpmType("1");
        }
        return ApiResponse.data((Object)((Object)sysTenant));
    }

    @Override
    public Map<String, Object> queryList(String tenantName, String domain, String page, String limit) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        if (ToolUtil.isNotEmpty((Object)page) && ToolUtil.isNotEmpty((Object)limit)) {
            String masterDomain = this.druidProperties.getDomain();
            Page pages = new Page((long)Integer.parseInt(page), (long)Integer.parseInt(limit));
            List<SysTenant> list = this.sysTenantMapper.queryList(pages, tenantName, domain, masterDomain);
            map.put("count", pages.getTotal());
            map.put("data", list);
            map.put("code", 0);
            return map;
        }
        map.put("data", null);
        map.put("code", "500");
        map.put("msg", "\u53c2\u6570\u4e0d\u7b26");
        map.put("count", null);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<SysTenant> add(SysTenant sysTenant, boolean generateCode) {
        block41: {
            String str;
            String code;
            String validate = this.validateTenant(sysTenant);
            if (validate != null) {
                return ApiResponse.fail((String)validate);
            }
            if (generateCode) {
                String tenantCode = this.getTenantCode();
                if (StringUtils.isEmpty((CharSequence)tenantCode)) {
                    throw new TenantException("\u751f\u6210\u79df\u6237\u7f16\u7801\u5931\u8d25\uff01");
                }
                sysTenant.setTenantCode(tenantCode);
            }
            Date now = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
            sysTenant.setCreateTime(now);
            sysTenant.setCreateUser(Objects.requireNonNull(ShiroKit.getUser()).getId());
            sysTenant.setIsDeleted("0");
            sysTenant.setLoginTimeLimit(sysTenant.getLoginTimeLimit());
            sysTenant.setAccessLoginStartTime(sysTenant.getAccessLoginStartTime());
            sysTenant.setAccessLoginEndTime(sysTenant.getAccessLoginEndTime());
            String username = this.druidProperties.getUsername();
            String password = this.druidProperties.getPassword();
            String driverClassName = this.druidProperties.getDriverClassName();
            String url = this.druidProperties.getUrl();
            String dbName = code = sysTenant.getTenantCode();
            String connName = null;
            String connectionName = "USER" + code;
            String connectionPass = "PWD" + code;
            if (this.globalProperties.getTenantLevel().equals("3")) {
                String dbId = sysTenant.getDbId();
                QueryWrapper query = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"db_id", (Object)dbId)).eq((Object)"is_deleted", (Object)"0");
                List list = this.sysDataSourceService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"db_id", (Object)dbId)).eq((Object)"is_deleted", (Object)"0"));
                SysDataSource sysDataSource = (SysDataSource)((Object)list.get(0));
                connName = sysDataSource.getConnName();
                username = sysTenant.getTenantName();
                connectionName = sysDataSource.getUserName();
                connectionPass = sysDataSource.getPassword();
                url = sysDataSource.getJdbcUrl();
                if (url.startsWith("jdbc:mysql")) {
                    str = url.substring(url.indexOf("/") + 2, url.indexOf("?"));
                    dbName = str.substring(str.indexOf("/") + 1);
                }
                if (this.list((Wrapper)query).size() > 0) {
                    return ApiResponse.fail((String)"\u8be5\u6570\u636e\u6e90\u5df2\u7ed1\u5b9a\u79df\u6237\uff01");
                }
            } else {
                ApiResponse<?> result;
                String str1;
                if (url.startsWith("jdbc:mysql")) {
                    str1 = this.sysTenantMapper.getDatabase(sysTenant.getTenantCode());
                    if (str1 != null) {
                        return ApiResponse.fail((String)"\u6570\u636e\u5e93\u5df2\u5b58\u5728\uff01");
                    }
                    result = this.sysDataSourceService.isMysql(username, password, driverClassName, url, code);
                    connectionName = username;
                    connectionPass = password;
                } else if (url.startsWith("jdbc:oscar")) {
                    if (this.getDbUserName("USER" + code)) {
                        return ApiResponse.fail((String)"\u521b\u5efa\u5931\u8d25\uff01\u7528\u6237\u540d\u5df2\u5b58\u5728");
                    }
                    result = this.sysDataSourceService.isOscar(driverClassName, url, code);
                } else if (url.startsWith("jdbc:oracle")) {
                    if (this.getDbUserName("USER" + code)) {
                        return ApiResponse.fail((String)"\u521b\u5efa\u5931\u8d25\uff01\u7528\u6237\u540d\u5df2\u5b58\u5728");
                    }
                    result = this.sysDataSourceService.isOracle(driverClassName, url, code);
                } else if (url.startsWith("jdbc:dm")) {
                    if (this.getDbUserName("USER" + code)) {
                        return ApiResponse.fail((String)"\u521b\u5efa\u5931\u8d25\uff01\u7528\u6237\u540d\u5df2\u5b58\u5728");
                    }
                    result = this.sysDataSourceService.isDm(driverClassName, url, code);
                } else if (url.startsWith("jdbc:postgresql")) {
                    str1 = this.sysTenantMapper.getPGDatabase("USER" + code);
                    if (str1 != null) {
                        return ApiResponse.fail((String)"\u6570\u636e\u5e93\u5df2\u5b58\u5728\uff01");
                    }
                    String str2 = this.sysTenantMapper.getPGRole("USER" + code);
                    if (str2 != null) {
                        return ApiResponse.fail((String)"\u521b\u5efa\u5931\u8d25\uff01\u89d2\u8272\u540d\u5df2\u5b58\u5728");
                    }
                    result = this.sysDataSourceService.isPostgresql(username, password, driverClassName, url, code);
                } else {
                    return ApiResponse.fail((String)"\u6570\u636e\u5e93\u7c7b\u578b\u6682\u4e0d\u652f\u6301\uff01");
                }
                username = sysTenant.getTenantName();
                if (ResultCode.SUCCESS.getCode() == result.getCode()) {
                    QueryWrapper sysDataSource = (QueryWrapper)new QueryWrapper().eq((Object)"conn_name", (Object)("tenant" + code));
                    sysTenant.setDbId(((SysDataSource)((Object)this.sysDataSourceService.list((Wrapper)sysDataSource).get(0))).getDbId());
                } else {
                    return ApiResponse.fail((String)result.getMsg());
                }
            }
            if ("1".equals(sysTenant.getIsBpmType())) {
                String connectionPort;
                String connectionIp;
                String dbType;
                String userAccount = code;
                if (url.startsWith("jdbc:mysql")) {
                    dbType = "Mysql";
                    str = url.substring(url.indexOf("/") + 2, url.indexOf("?"));
                    String i = str.substring(0, str.indexOf("/"));
                    connectionIp = i.substring(0, i.indexOf(":"));
                    connectionPort = i.substring(i.indexOf(":") + 1);
                } else if (url.startsWith("jdbc:oracle")) {
                    dbType = "Oracle";
                    str = url.substring(url.indexOf("@") + 1);
                    connectionIp = str.substring(0, str.indexOf(":"));
                    connectionPort = str.split(":")[1];
                    dbName = str.split(":")[2];
                } else if (url.startsWith("jdbc:oscar")) {
                    dbType = "Oscar";
                    str = url.substring(url.indexOf("/") + 2);
                    connectionIp = str.substring(0, str.indexOf(":"));
                    connectionPort = str.substring(str.indexOf(":") + 1, str.indexOf("/"));
                    dbName = str.substring(str.indexOf("/") + 1);
                } else if (url.startsWith("jdbc:dm")) {
                    dbType = "Dm";
                    str = url.substring(url.indexOf("/") + 2);
                    connectionIp = str.split(":")[0];
                    connectionPort = str.split(":")[1];
                    dbName = "USER" + code;
                } else {
                    return ApiResponse.fail((String)"\u6570\u636e\u5e93\u7c7b\u578b\u6682\u4e0d\u652f\u6301\uff01");
                }
                try {
                    BpmResponseResult responseResult = TenantService.tenantInsertReturnInfo((String)userAccount, (String)username, (String)dbType, (String)dbName, (String)connectionIp, (String)connectionPort, (String)connectionName, (String)connectionPass);
                    if (!"1".equals(responseResult.getCode())) {
                        return ApiResponse.fail((String)responseResult.getMsg());
                    }
                    sysTenant.setBpmTenantId((String)responseResult.getResult().getJSONObject(0).get((Object)"tenantId"));
                    sysTenant.setBpmTenantCipher((String)responseResult.getResult().getJSONObject(0).get((Object)"tenantCipher"));
                    if (!this.globalProperties.getTenantLevel().equals("3")) break block41;
                    String address = "http://" + this.sysDataSourceService.getIP() + ":" + this.serverProperties.getPort();
                    String id = sysTenant.getBpmTenantId();
                    try {
                        this.sysDataSourceService.addDataSourceByConnName(connName);
                        DataSourceUtil.changeTempDs((String)connName);
                        TenantService.insertSysActConfig((String)id, (String)address);
                    }
                    finally {
                        DataSourceUtil.poll();
                    }
                }
                catch (Exception e) {
                    UpdateWrapper queryWrapper = (UpdateWrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"DB_NAME", (Object)code)).eq((Object)"IS_DELETED", (Object)"0")).set((Object)"IS_DELETED", (Object)"1");
                    this.sysDataSourceService.update((Wrapper)queryWrapper);
                    throw new TenantException("\u5de5\u4f5c\u6d41\u670d\u52a1\u672a\u542f\u52a8\uff01");
                }
            }
        }
        if (this.sysTenantMapper.insert((Object)sysTenant) > 0) {
            return ApiResponse.data((Object)((Object)sysTenant));
        }
        throw new TenantException("\u6dfb\u52a0\u79df\u6237\u9ed8\u8ba4\u6570\u636e\u5931\u8d25");
    }

    @Override
    public String getTenantCode() {
        String result = this.sysIdtableService.getCurrentCode("TENANT_CODE", "SYS_TENANT");
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            return result;
        }
        return null;
    }

    private String validateTenant(SysTenant sysTenant) {
        String domain;
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"TENANT_NAME", (Object)sysTenant.getTenantName())).eq((Object)"IS_DELETED", (Object)"0");
        int tenantCount = this.sysTenantMapper.selectCount((Wrapper)queryWrapper);
        if (tenantCount > 0) {
            return "\u79df\u6237\u540d\u79f0\u5df2\u5b58\u5728\uff01";
        }
        if ("1".equals(this.globalProperties.getTenantUserModel()) && !StringUtils.isEmpty((CharSequence)(domain = sysTenant.getTenantDomain()))) {
            if (domain.equals(this.druidProperties.getDomain())) {
                return "\u57df\u540d\u5df2\u88ab\u4f7f\u7528\uff01";
            }
            queryWrapper.clear();
            ((QueryWrapper)queryWrapper.eq((Object)"TENANT_DOMAIN", (Object)domain)).eq((Object)"IS_DELETED", (Object)"0");
            int domainCount = this.sysTenantMapper.selectCount((Wrapper)queryWrapper);
            if (domainCount > 0) {
                return "\u57df\u540d\u5df2\u88ab\u4f7f\u7528\uff01";
            }
        }
        return null;
    }

    @Override
    public ApiResponse<SysTenant> edit(SysTenant sysTenant) {
        String validate;
        if (!"000000".equals(sysTenant.getTenantCode()) && (validate = this.validateEditTenant(sysTenant)) != null) {
            return ApiResponse.fail((String)validate);
        }
        sysTenant.setUpdateTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        String msg = this.clearBpmMenu(sysTenant);
        if (msg != null) {
            return ApiResponse.fail((String)msg);
        }
        sysTenant.setTenantCode(null);
        return ApiResponse.status((this.sysTenantMapper.updateById((Object)sysTenant) > 0 ? 1 : 0) != 0);
    }

    private String validateEditTenant(SysTenant sysTenant) {
        QueryWrapper queryWrapper = new QueryWrapper();
        String domain = sysTenant.getTenantDomain();
        if (!StringUtils.isEmpty((CharSequence)domain)) {
            if (domain.equals(this.druidProperties.getDomain())) {
                return "\u57df\u540d\u5df2\u88ab\u4f7f\u7528\uff01";
            }
            ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"TENANT_DOMAIN", (Object)domain)).ne((Object)"TENANT_ID", (Object)sysTenant.getTenantId())).eq((Object)"IS_DELETED", (Object)"0");
            int domainCount = this.sysTenantMapper.selectCount((Wrapper)queryWrapper);
            if (domainCount > 0) {
                return "\u57df\u540d\u5df2\u88ab\u4f7f\u7528\uff01";
            }
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<SysTenant> delete(String ids, boolean type) {
        if ("2".equals(this.globalProperties.getTenantLevel())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"TENANT_ID", Arrays.asList(ids.split(",")));
            List sysTenantList = this.sysTenantMapper.selectList((Wrapper)queryWrapper);
            UpdateWrapper updateDataSource = new UpdateWrapper();
            ArrayList<String> list = new ArrayList<String>();
            for (SysTenant sysTenant : sysTenantList) {
                String dbId = sysTenant.getDbId();
                list.add(dbId);
            }
            ((UpdateWrapper)updateDataSource.in((Object)"DB_ID", list)).set((Object)"IS_DELETED", (Object)"1");
            this.sysDataSourceService.update((Wrapper)updateDataSource);
            if (type) {
                this.delBpmTenant(sysTenantList);
            }
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.in((Object)"TENANT_ID", Arrays.asList(ids.split(",")));
        updateWrapper.set((Object)"IS_DELETED", (Object)"1");
        return ApiResponse.status((boolean)this.update((Wrapper)updateWrapper));
    }

    private void delBpmTenant(List<SysTenant> sysTenantList) {
        ArrayList list = new ArrayList();
        for (SysTenant sysTenant : sysTenantList) {
            if (sysTenant.getBpmTenantId() == null || "".equals(sysTenant.getBpmTenantId())) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("tenantId", sysTenant.getBpmTenantId());
            map.put("tenantCipher", sysTenant.getBpmTenantCipher());
            list.add(map);
        }
        try {
            TenantService.deleteTenantList(list);
        }
        catch (Exception e) {
            throw new TenantException("\u5de5\u4f5c\u6d41\u670d\u52a1\u672a\u542f\u52a8\uff01");
        }
    }

    @Override
    public String getTenantNameByCode(String tenantCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"TENANT_CODE", (Object)tenantCode);
        SysTenant sysTenant = (SysTenant)((Object)this.sysTenantMapper.selectOne((Wrapper)queryWrapper));
        if (sysTenant != null) {
            return sysTenant.getTenantName();
        }
        return "";
    }

    @Override
    @Master
    public SysTenant getTenantByConnName(String connName) {
        return this.sysTenantMapper.getTenantByConnName(connName);
    }

    @Override
    public boolean getDbUserName(String dbUserName) {
        boolean flag = false;
        if (this.sysTenantMapper.getDbUserName(dbUserName) != null) {
            flag = true;
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResponse<?> syncTenantUser(String tenantCode) {
        if (!"2".equals(this.globalProperties.getTenantUserModel())) {
            return ApiResponse.status((boolean)true);
        }
        SysDataSource dataSource = this.sysDataSourceService.getByTenantCode(tenantCode);
        List<SysUsers> userList = new ArrayList<SysUsers>();
        if (ToolUtil.isNotEmpty((Object)((Object)dataSource))) {
            this.sysDataSourceService.addDataSourceByConnName(dataSource.getConnName());
            try {
                DataSourceUtil.changeTempDs((String)dataSource.getConnName());
                userList = this.sysUsersService.list((Wrapper)new QueryWrapper());
            }
            finally {
                DataSourceUtil.poll();
            }
        }
        return this.sysLoginUserService.syncTenantUser(userList, tenantCode);
    }

    @Override
    public List<JSTreeModel> getTenantTree() {
        List<String> tenantCodes;
        ShiroUser user = ShiroKit.getUser();
        ArrayList<JSTreeModel> list = new ArrayList<JSTreeModel>();
        list.add(this.getRoot());
        if (ToolUtil.isNotEmpty((Object)user) && (tenantCodes = this.sysUserTenantService.getTenantCodesByAccount(user.getAccount())).size() > 0) {
            List<JSTreeModel> nodeList = this.sysTenantMapper.getTenantTree(tenantCodes);
            list.addAll(nodeList);
        }
        return list;
    }

    private JSTreeModel getRoot() {
        JSTreeModel root = new JSTreeModel();
        root.setId("11");
        root.setCode("11");
        root.setText("\u53ef\u8bbf\u95ee\u79df\u6237");
        root.setIsLeaf("0");
        root.setParent("#");
        root.setType("isRoot");
        return root;
    }

    private String clearBpmMenu(SysTenant sysTenant) {
        String id = null;
        String connName = null;
        String tenantCode = sysTenant.getTenantCode();
        ShiroUser shiroUser = ShiroKit.getUser();
        if (ToolUtil.isNotEmpty((Object)shiroUser)) {
            id = shiroUser.getId();
            connName = shiroUser.getConnName();
        }
        if (!"000000".equals(tenantCode)) {
            connName = ((SysDataSource)((Object)this.sysDataSourceService.getById((Serializable)((Object)sysTenant.getDbId())))).getConnName();
        }
        HussarCacheManager hussarCacheManager = (HussarCacheManager)SpringContextHolder.getBean(HussarCacheManager.class);
        hussarCacheManager.delete("menu_info", "shiro_menus:" + id + connName);
        return null;
    }
}

