/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.sysvisualizeconfig.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.permit.dao.SysRoleGroupMapper;
import com.jxdinfo.hussar.bsp.sysvisualizeconfig.dao.SysVisualizeConfigMapper;
import com.jxdinfo.hussar.bsp.sysvisualizeconfig.model.SysVisualizeConfig;
import com.jxdinfo.hussar.bsp.sysvisualizeconfig.service.ISysVisualizeConfigService;
import com.jxdinfo.hussar.bsp.sysvisualizeconfig.vo.SysVisualizeParamVO;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysVisualizeConfigServiceImpl
extends ServiceImpl<SysVisualizeConfigMapper, SysVisualizeConfig>
implements ISysVisualizeConfigService {
    @Resource
    private SysRoleGroupMapper sysRoleGroupMapper;
    @Resource
    private HussarCacheManager hussarCacheManager;

    @Override
    public boolean saveOrUpdateVisualize(SysVisualizeParamVO sysVisualizeParamVO) {
        String types;
        ArrayList<SysVisualizeConfig> list = new ArrayList<SysVisualizeConfig>();
        List<String> roleIds = sysVisualizeParamVO.getRoleIds();
        ShiroUser shiroUser = ShiroKit.getUser();
        String string = types = roleIds.size() <= 0 ? "0" : "1";
        if ("0".equals(types)) {
            roleIds.add(shiroUser.getId());
        }
        for (String roleId : roleIds) {
            String key = "welcome_config" + roleId + ":" + types;
            this.hussarCacheManager.delete("welcome_config", key);
        }
        this.remove((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"USER_ID", roleIds)).eq((Object)"TYPES", (Object)types));
        this.setLeftComList(sysVisualizeParamVO.getLeftComList1(), roleIds, types, 1, list);
        this.setLeftComList(sysVisualizeParamVO.getLeftComList2(), roleIds, types, 2, list);
        this.setLeftComList(sysVisualizeParamVO.getLeftComList3(), roleIds, types, 3, list);
        this.setLeftComList(sysVisualizeParamVO.getLeftComList4(), roleIds, types, 4, list);
        return this.saveBatch(list);
    }

    private void setLeftComList(List<SysVisualizeConfig> leftComList, List<String> roles, String types, Integer listId, List<SysVisualizeConfig> sysVisualizeConfigs) {
        ShiroUser shiroUser = ShiroKit.getUser();
        Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        for (int i = 0; i < leftComList.size(); ++i) {
            SysVisualizeConfig sysVisualizeConfig = leftComList.get(i);
            sysVisualizeConfig.setUpdateUser(shiroUser.getId());
            sysVisualizeConfig.setUpdateTime(date);
            sysVisualizeConfig.setCreateUser(shiroUser.getId());
            sysVisualizeConfig.setCreateTime(date);
            sysVisualizeConfig.setTypes(types);
            sysVisualizeConfig.setListId(listId);
            sysVisualizeConfig.setSEQ(i);
            roles.parallelStream().forEach(str -> {
                sysVisualizeConfig.setUserId((String)str);
                sysVisualizeConfigs.add(sysVisualizeConfig);
            });
        }
    }

    @Override
    public SysVisualizeParamVO queryVisualizeList(Map<String, String> map) {
        ShiroUser user = ShiroKit.getUser();
        String userId = map == null ? user.getId() : map.get("roleId");
        ArrayList<String> roles = new ArrayList<String>();
        String type = map == null ? "0" : "1";
        String key = "welcome_config" + userId + ":" + type;
        SysVisualizeParamVO visualizeVo = null;
        Object object = this.hussarCacheManager.getObject("welcome_config", key);
        if (ToolUtil.isEmpty((Object)object)) {
            List list = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"TYPES", (Object)type)).eq((Object)"USER_ID", (Object)userId));
            if (list.size() <= 0 && map == null && (list = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"TYPES", (Object)"1")).eq((Object)"USER_ID", user.getRolesList().get(0)))).size() <= 0) {
                list = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"TYPES", (Object)"1")).eq((Object)"USER_ID", (Object)"superadmin_role"));
            }
            if (map != null) {
                roles.add(userId);
            }
            SysVisualizeParamVO sysVisualizeParamVO = new SysVisualizeParamVO();
            sysVisualizeParamVO.setRoleIds(roles);
            sysVisualizeParamVO.setLeftComList1(this.getLeftComList(list, 1));
            sysVisualizeParamVO.setLeftComList2(this.getLeftComList(list, 2));
            sysVisualizeParamVO.setLeftComList3(this.getLeftComList(list, 3));
            sysVisualizeParamVO.setLeftComList4(this.getLeftComList(list, 4));
            visualizeVo = sysVisualizeParamVO;
        } else {
            visualizeVo = (SysVisualizeParamVO)object;
        }
        return visualizeVo;
    }

    private List<SysVisualizeConfig> getLeftComList(List<SysVisualizeConfig> list, Integer index) {
        return list.parallelStream().filter(sysVisualizeConfig -> sysVisualizeConfig.getListId() == index).sorted(Comparator.comparing(SysVisualizeConfig::getSEQ)).collect(Collectors.toList());
    }

    @Override
    public List<JSTreeModel> getLazyRoleTree(String nodeId) {
        List<JSTreeModel> jsTreeModels = nodeId.equals("#") ? this.sysRoleGroupMapper.getFirstRoleTree() : this.sysRoleGroupMapper.getLazyRoleTree(nodeId);
        return jsTreeModels;
    }

    @Override
    public List<String> queryUserIds() {
        List<String> userIds = ((SysVisualizeConfigMapper)this.baseMapper).selectUserIdsByTypes();
        return userIds;
    }
}

