/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.sqlmonitor.service.impl;

import com.alibaba.druid.stat.DruidStatManagerFacade;
import com.alibaba.druid.util.MapComparator;
import com.jxdinfo.hussar.bsp.sqlmonitor.service.ISqlMonitorService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class SqlMonitorServiceImpl
implements ISqlMonitorService {
    @Override
    public Map<String, Object> getList(Map<String, String> parameters) {
        List array = DruidStatManagerFacade.getInstance().getSqlStatDataList(null);
        List<Map<String, Object>> sortedArray = this.comparatorOrderBy(array, parameters);
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        for (int i = sortedArray.size() - 1; i >= 0; --i) {
            Map<String, Object> objectMap = sortedArray.get(i);
            if (null != objectMap.get("LastSlowParameters") && !"[]".equals(objectMap.get("LastSlowParameters"))) continue;
            sortedArray.remove(i);
        }
        map.put("count", sortedArray.size());
        map.put("data", sortedArray);
        map.put("code", 0);
        map.put("msg", "success");
        return map;
    }

    private List<Map<String, Object>> comparatorOrderBy(List<Map<String, Object>> array, Map<String, String> parameters) {
        if (array != null && !array.isEmpty()) {
            String orderBy;
            String orderType = null;
            Integer page = 1;
            Integer perPageCount = Integer.MAX_VALUE;
            if (parameters == null) {
                orderBy = "SQL";
                orderType = "asc";
                page = 1;
                perPageCount = Integer.MAX_VALUE;
            } else {
                String pageCountParam;
                orderBy = parameters.get("orderBy");
                orderType = parameters.get("orderType");
                String pageParam = parameters.get("page");
                if (pageParam != null && pageParam.length() != 0) {
                    page = Integer.parseInt(pageParam);
                }
                if ((pageCountParam = parameters.get("perPageCount")) != null && pageCountParam.length() > 0) {
                    perPageCount = Integer.parseInt(pageCountParam);
                }
            }
            orderBy = orderBy == null ? "SQL" : orderBy;
            String string = orderType = orderType == null ? "asc" : orderType;
            if (!"desc".equals(orderType)) {
                orderType = "asc";
            }
            if (orderBy.trim().length() != 0) {
                Collections.sort(array, new MapComparator((Object)orderBy, "desc".equals(orderType)));
            }
            int fromIndex = (page - 1) * perPageCount;
            int toIndex = page * perPageCount;
            if (toIndex > array.size()) {
                toIndex = array.size();
            }
            return array.subList(fromIndex, toIndex);
        }
        return new ArrayList<Map<String, Object>>();
    }
}

