/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.shortcutconfig.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.menu.model.MenuInfo;
import com.jxdinfo.hussar.bsp.menu.service.ISysMenuManageService;
import com.jxdinfo.hussar.bsp.shortcutconfig.dao.ShortCutConfigMapper;
import com.jxdinfo.hussar.bsp.shortcutconfig.model.ShortCutConfig;
import com.jxdinfo.hussar.bsp.shortcutconfig.service.IShortCutConfigService;
import com.jxdinfo.hussar.bsp.shortcutconfig.vo.ShortCutConfigVO;
import com.jxdinfo.hussar.common.constant.factory.ConstantFactory;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShortCutConfigServiceImpl
extends ServiceImpl<ShortCutConfigMapper, ShortCutConfig>
implements IShortCutConfigService {
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private ISysMenuManageService iSysMenuManageService;
    @Value(value="${spring.profiles.active}")
    private String profiles;

    @Override
    public List<ShortCutConfigVO> queryShortCutConfig() {
        return ((ShortCutConfigMapper)this.baseMapper).selectGroupAndShoortCut();
    }

    @Override
    public List<ShortCutConfig> queryShortCutConfigUserList() {
        ShiroUser shiroUser = ShiroKit.getUser();
        List<ShortCutConfig> list = ((ShortCutConfigMapper)this.baseMapper).selectOrderShortCut();
        List<String> menuIds = this.getMenuIds();
        Iterator<ShortCutConfig> iterator = list.iterator();
        while (iterator.hasNext()) {
            ShortCutConfig shortCutConfig2 = iterator.next();
            if (menuIds.contains(shortCutConfig2.getMenuId()) || !"1".equals(shortCutConfig2.getOpenType())) continue;
            iterator.remove();
        }
        List userShortCutConfigList = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"CREATE_USER", (Object)shiroUser.getId())).ne((Object)"PARENT_ID", (Object)"0"));
        if (userShortCutConfigList.size() > 0) {
            Set userShortSet = userShortCutConfigList.parallelStream().map(ShortCutConfig::getParentId).collect(Collectors.toSet());
            list.parallelStream().forEach(shortCutConfig -> shortCutConfig.setShowAdd(!userShortSet.contains(shortCutConfig.getId())));
        } else {
            list.parallelStream().forEach(shortCutConfig -> shortCutConfig.setShowAdd(!"1".equals(shortCutConfig.getIsDefault())));
        }
        return list;
    }

    @Override
    public List<String> getMenuIds() {
        List<MenuInfo> menus;
        ShiroUser shiroUser = ShiroKit.getUser();
        List<String> roleIdList = ConstantFactory.me().getRolesIdByShiroUser(shiroUser);
        if (roleIdList != null && roleIdList.size() > 0) {
            menus = this.globalProperties.isTenantOpen() ? this.iSysMenuManageService.getTenantMenuByRoles(shiroUser.getId(), roleIdList, this.profiles, shiroUser.getConnName(), null) : this.iSysMenuManageService.getMenuByRoles(shiroUser.getId(), roleIdList, this.profiles, null);
        } else {
            return new ArrayList<String>();
        }
        ArrayList<String> menuInfoList = new ArrayList<String>();
        this.getMenuInfo(menuInfoList, menus);
        return menuInfoList;
    }

    @Override
    @Cacheable(value={"shortcut_user_list"}, key="'shortcut_user_list'+#userId")
    public List<ShortCutConfig> queryUserShortCut(String userId) {
        List list = ((ShortCutConfigMapper)this.baseMapper).selectShortCutListByUserId(userId);
        if (list.size() == 1 && "65535".equals(list.get(0).getParentId())) {
            list.remove(0);
        } else if (list.size() <= 0) {
            list = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PARENT_ID", (Object)"0")).eq((Object)"IS_DEFAULT", (Object)"1"));
            List<String> menuIds = this.getMenuIds();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ShortCutConfig shortCutConfig = (ShortCutConfig)((Object)iterator.next());
                if (menuIds.contains(shortCutConfig.getMenuId()) || !"1".equals(shortCutConfig.getOpenType())) continue;
                iterator.remove();
            }
        }
        return list;
    }

    private void getMenuInfo(List<String> menuInfoList, List<MenuInfo> menuInfos) {
        for (MenuInfo menuInfo : menuInfos) {
            menuInfoList.add(menuInfo.getMenuId());
            if (menuInfo.getChildMenus().size() <= 0) continue;
            this.getMenuInfo(menuInfoList, menuInfo.getChildMenus());
        }
    }

    @Override
    @Transactional
    public boolean saveShortCutUserConfig(Map<String, Object> map) {
        String orderInfo;
        String string = orderInfo = map.get("parentIds") == null ? "" : map.get("parentIds").toString();
        if (ToolUtil.isEmpty((Object)orderInfo)) {
            return false;
        }
        JSONArray treeArr = JSON.parseArray((String)orderInfo);
        ShiroUser shiroUser = ShiroKit.getUser();
        this.remove((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"CREATE_USER", (Object)shiroUser.getId())).ne((Object)"PARENT_ID", (Object)"0"));
        if (treeArr.size() == 0) {
            ShortCutConfig shortCutConfig = new ShortCutConfig();
            shortCutConfig.setParentId("65535");
            shortCutConfig.setCreateUser(shiroUser.getId());
            return this.save((Object)shortCutConfig);
        }
        ArrayList<ShortCutConfig> shortCutConfigList = new ArrayList<ShortCutConfig>();
        for (int i = 0; i < treeArr.size(); ++i) {
            JSONObject json = treeArr.getJSONObject(i);
            String id = json.getString("id");
            ShortCutConfig shortCutConfig = new ShortCutConfig();
            shortCutConfig.setParentId(id);
            shortCutConfig.setCreateUser(shiroUser.getId());
            shortCutConfig.setCreateTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
            String order = i + 1 + "";
            shortCutConfig.setSeq(new BigDecimal(order));
            shortCutConfigList.add(shortCutConfig);
        }
        return this.saveBatch(shortCutConfigList);
    }
}

