/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.jxdinfo.hussar.bpm.messagepush.AbstractBpmPushMsgMatcher;
import com.jxdinfo.hussar.bsp.audit.dao.SysStruAuditMapper;
import com.jxdinfo.hussar.bsp.audit.dao.SysUsersAuditMapper;
import com.jxdinfo.hussar.bsp.audit.model.SysUserIpAudit;
import com.jxdinfo.hussar.bsp.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.bsp.audit.service.ISysUserIpAuditService;
import com.jxdinfo.hussar.bsp.audit.util.CopyPropertieUtils;
import com.jxdinfo.hussar.bsp.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.bsp.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.bsp.constant.Constants;
import com.jxdinfo.hussar.bsp.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.bsp.organ.CreateUserSendMailUtil;
import com.jxdinfo.hussar.bsp.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.bsp.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.bsp.organ.model.SysOrgan;
import com.jxdinfo.hussar.bsp.organ.model.SysStru;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.permit.dao.SysGetBackPasswordMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysPasswordHistMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysUserProxyMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysUserroleAuditMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysGetBackPassword;
import com.jxdinfo.hussar.bsp.permit.model.SysPasswordHist;
import com.jxdinfo.hussar.bsp.permit.model.SysUserRole;
import com.jxdinfo.hussar.bsp.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.model.vo.UserQueryReqVO;
import com.jxdinfo.hussar.bsp.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysGetBackPasswordService;
import com.jxdinfo.hussar.bsp.permit.service.ISysRolesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.bsp.permit.vo.UserOrgVo;
import com.jxdinfo.hussar.bsp.sysuserip.model.SysUserIp;
import com.jxdinfo.hussar.bsp.sysuserip.service.ISysUserIpService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.exception.DormancyException;
import com.jxdinfo.hussar.common.exception.HussarLockedAccountException;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.config.properties.HussarProperties;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.encrypt.CryptoUtil;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.encrypt.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.core.shiro.factory.ShiroFactroy;
import com.jxdinfo.hussar.core.shiro.lock.LoginLock;
import com.jxdinfo.hussar.core.util.DataExportUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SerializeUtils;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.system.controller.util.GeneratePassword;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DependsOn(value={"springContextHolder"})
public class SysUsersServiceImpl
extends ServiceImpl<SysUsersMapper, SysUsers>
implements ISysUsersService {
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private SysUsersAuditMapper sysUsersAuditMapper;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private SysGetBackPasswordMapper sysGetBackPasswordMapper;
    @Resource
    private SysPasswordHistMapper sysPasswordHistMapper;
    @Resource
    private SysUserProxyMapper sysUserProxyMapper;
    @Resource
    private SysUserroleAuditMapper sysUserroleAuditMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private HussarProperties hussarProperties;
    @Resource
    private ISysUserroleAuditService sysUserroleAuditService;
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysRolesService sysRolesService;
    private static final String ADD = "1";
    private static final String DELETE = "2";
    @Resource
    private ISysBaseConfigService iSysBaseConfigService;
    @Resource
    private ISysUserIpService iSysUserIpService;
    @Resource
    private ISysUserIpAuditService iSysUserIpAuditService;
    @Resource
    private ISysConfRolesService iSysConfRolesService;
    @Resource
    private AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Resource
    private ISysGetBackPasswordService iSysGetBackPasswordService;
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;
    @Resource
    private AbstractBpmPushMsgMatcher bpmAbstractPushMsgMatcher;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    private SysOrgManageService sysOrgManageService;
    @Resource
    private SysStruAuditMapper sysStruAuditMapper;
    @Resource
    private SysOrganMapper sysOrganMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String addUser(Map<String, Object> map) {
        String[] roleIds = map.get("roleIds").toString().split(",");
        SysUsers sysUsers = (SysUsers)((Object)map.get("sysUsers"));
        String pass = "";
        pass = this.globalProperties.getCreateUserSendEmail() != false && this.globalProperties.getCreateUserUseDefaultPass() == false ? GeneratePassword.generate((String)this.globalProperties.getPwdRule()) : this.globalProperties.getDefaultPassword();
        String pwd = this.credentialsMatcher.passwordEncode(String.valueOf(pass).getBytes());
        sysUsers.setPassword(pwd);
        this.sysUsersMapper.insert((Object)sysUsers);
        this.abstractPushMsgMatcher.insertOperation("user", "add", (Object)sysUsers, "");
        this.bpmAbstractPushMsgMatcher.pushUser(sysUsers, "add", ((SysOrgan)((Object)this.sysOrganMapper.selectById((Serializable)((Object)((SysStru)((Object)this.sysStruMapper.selectById((Serializable)((Object)sysUsers.getEmployeeId())))).getOrganId())))).getOrganCode());
        sysUsers.setAccountStatus(UserStatus.LOCKED.getCode());
        this.saveUserIP(sysUsers.getUserId(), sysUsers.getAccessLoginIp());
        String userId = sysUsers.getUserId();
        if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isRoleAudit()) {
            SysUserRole sysUserRole = new SysUserRole();
            sysUserRole.setUserId(userId);
            sysUserRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
            sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
            sysUserRole.setCreateTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
            sysUserRole.setLastTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
            this.sysUserRoleMapper.insert((Object)sysUserRole);
            ArrayList<SysUserroleAudit> sysUserroleAuditList = new ArrayList<SysUserroleAudit>();
            if (roleIds.length > 0) {
                for (String roleId : roleIds) {
                    if (ToolUtil.isEmpty((Object)roleId) || SysUserAndRole.PUBLIC_ROLE.getValue().equals(roleId)) continue;
                    SysUserroleAudit sysUserroleAudit = new SysUserroleAudit();
                    sysUserroleAudit.setUserId(userId);
                    sysUserroleAudit.setRoleId(roleId);
                    sysUserroleAudit.setStatus(UserStatus.LOCKED.getCode());
                    sysUserroleAudit.setCreator(ShiroKit.getUser().getAccount());
                    sysUserroleAudit.setCreateTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
                    sysUserroleAudit.setLastTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
                    sysUserroleAudit.setOperationType(ADD);
                    sysUserroleAuditList.add(sysUserroleAudit);
                }
            }
            if (ToolUtil.isNotEmpty(sysUserroleAuditList)) {
                this.sysUserroleAuditService.saveBatch(sysUserroleAuditList, sysUserroleAuditList.size());
            }
        } else {
            this.sysUserRoleMapper.delete((Wrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)userId));
            ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
            Date currentDate = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
            String currentUser = ShiroKit.getUser().getAccount();
            for (String roleId : roleIds) {
                if (ToolUtil.isEmpty((Object)roleId)) continue;
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(userId);
                sysUserRole.setGrantedRole(roleId);
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                sysUserRole.setCreateTime(currentDate);
                sysUserRole.setLastTime(currentDate);
                sysUserRole.setCreator(currentUser);
                sysUserRole.setLastEditor(currentUser);
                userRoleList.add(sysUserRole);
            }
            if (ToolUtil.isNotEmpty(userRoleList)) {
                this.sysUserRoleService.saveBatch(userRoleList, userRoleList.size());
                this.abstractPushMsgMatcher.insertOperation("userRole", "add", userRoleList, "");
                this.bpmAbstractPushMsgMatcher.pushUserRole(userRoleList, "add");
            }
        }
        if (this.globalProperties.getCreateUserSendEmail().booleanValue() && sysUsers.getEMail() != null) {
            CreateUserSendMailUtil.sendMail(sysUsers, pass);
        }
        return userId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Tip editUser(Map<String, Object> map) {
        String userId = map.get("userId").toString();
        String[] roleIds = (String[])map.get("roleIds");
        SysUsers sysUsers = (SysUsers)((Object)map.get("sysUsers"));
        SuccessTip tip = new SuccessTip();
        if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isRoleAudit()) {
            List<SysUserroleAudit> auditList = this.sysUserroleAuditMapper.getHasReviewList(userId);
            List connList = this.sysUserRoleMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)userId)).eq((Object)"admin_option", (Object)Whether.YES.getValue()));
            ArrayList<String> adds = new ArrayList<String>();
            String[] dels = new ArrayList();
            for (SysUserRole sysUserRole : connList) {
                int isSame = 0;
                for (String roleId : roleIds) {
                    if (ToolUtil.isEmpty((Object)roleId) || !roleId.equals(sysUserRole.getGrantedRole())) continue;
                    isSame = 1;
                    break;
                }
                if (isSame != 0) continue;
                dels.add(sysUserRole.getGrantedRole());
            }
            for (String roleId : roleIds) {
                if (ToolUtil.isEmpty((Object)roleId)) continue;
                boolean isSame = false;
                for (SysUserRole sysUserRole : connList) {
                    if (!roleId.equals(sysUserRole.getGrantedRole())) continue;
                    isSame = true;
                    break;
                }
                if (isSame || SysUserAndRole.PUBLIC_ROLE.getValue().equals(roleId)) continue;
                adds.add(roleId);
            }
            if (ToolUtil.isNotEmpty(adds)) {
                this.insertAndUpdateUserRoleAudit(adds, auditList, userId, ADD);
            }
            if (ToolUtil.isNotEmpty((Object)dels)) {
                this.insertAndUpdateUserRoleAudit((List<String>)dels, auditList, userId, DELETE);
            }
        } else {
            this.sysRolesService.delRedisAuthInfo(userId);
            if (ShiroKit.getUser().isGradeadmin()) {
                this.sysUserRoleMapper.delOrganRoleIdByUserId(userId);
                this.abstractPushMsgMatcher.insertOperation("userRole", "delete", userId, "");
            } else {
                List<String> roleList = this.sysUserRoleMapper.getSysRolesByUserId(userId);
                if (CollectionUtils.isNotEmpty(roleList)) {
                    this.sysUserRoleMapper.delSysRolesByUserId(userId, roleList);
                }
                this.abstractPushMsgMatcher.insertOperation("userRole", "delete", userId, "");
            }
            this.bpmAbstractPushMsgMatcher.delete("userRole", userId, "deleteByUserId");
            ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
            Date currentDate = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
            String currentUser = ShiroKit.getUser().getAccount();
            for (String roleId : roleIds) {
                if (ToolUtil.isEmpty((Object)roleId) || "public_role".equals(roleId) && ShiroKit.getUser().isGradeadmin()) continue;
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(userId);
                sysUserRole.setGrantedRole(roleId);
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                sysUserRole.setCreateTime(currentDate);
                sysUserRole.setLastTime(currentDate);
                sysUserRole.setCreator(currentUser);
                sysUserRole.setLastEditor(currentUser);
                userRoleList.add(sysUserRole);
            }
            String isSys = sysUsers.getIsSys();
            this.sysUserRoleMapper.delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)sysUsers.getUserId())).eq((Object)"GRANTED_ROLE", (Object)"gradeadmin_role"));
            if (ToolUtil.isNotEmpty(userRoleList)) {
                this.sysUserRoleService.saveBatch(userRoleList, userRoleList.size());
                this.abstractPushMsgMatcher.insertOperation("userRole", "add", userRoleList, "");
                this.bpmAbstractPushMsgMatcher.pushUserRole(userRoleList, "add");
            }
        }
        SysUsersAudit sysUsersAudit = new SysUsersAudit();
        if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isUserAudit()) {
            CopyPropertieUtils.copyProperties((Object)((Object)sysUsersAudit), (Object)((Object)sysUsers));
            sysUsersAudit.setCurrentStatus(ADD);
            sysUsersAudit.setIsAudit("0");
            sysUsersAudit.setCreateTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
            this.sysUsersAuditMapper.insert((Object)sysUsersAudit);
            this.saveUserAuditIP(userId, sysUsers.getAccessLoginIp(), ADD);
            tip.setMessage("\u4fee\u6539\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
            return tip;
        }
        SysUsers old = (SysUsers)((Object)this.sysUsersMapper.selectById((Serializable)((Object)sysUsers.getUserId())));
        if (!ADD.equals(old.getAccountStatus()) && ADD.equals(sysUsers.getAccountStatus())) {
            sysUsers.setLastLoginTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
            LoginLock loginLock = (LoginLock)SpringContextHolder.getBean(LoginLock.class);
            String connName = DataSourceUtil.currentDsName();
            if (this.globalProperties.isTenantOpen()) {
                loginLock.removeUserCache(sysUsers.getUserAccount(), connName);
            } else {
                loginLock.removeUserCache(sysUsers.getUserAccount());
            }
        }
        this.sysUsersMapper.updateById((Object)sysUsers);
        this.abstractPushMsgMatcher.insertOperation("user", "update", (Object)sysUsers, "");
        this.bpmAbstractPushMsgMatcher.pushUser(sysUsers, "update", null);
        this.iSysUserIpService.remove((Wrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)userId));
        this.saveUserIP(userId, sysUsers.getAccessLoginIp());
        tip.setMessage("\u4fee\u6539\u6210\u529f\uff01");
        return tip;
    }

    private void insertAndUpdateUserRoleAudit(List<String> roleIds, List<SysUserroleAudit> auditList, String userId, String operationType) {
        ArrayList<SysUserroleAudit> updateAuditList = new ArrayList<SysUserroleAudit>();
        HashMap<String, Object> updateMap = new HashMap<String, Object>();
        ArrayList<SysUserroleAudit> addAuditList = new ArrayList<SysUserroleAudit>();
        Date currentDate = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        String account = ToolUtil.isNotEmpty((Object)ShiroKit.getUser()) ? ShiroKit.getUser().getAccount() : null;
        for (String roleId : roleIds) {
            boolean isExist = false;
            for (SysUserroleAudit sysUserroleAudit : auditList) {
                if (!roleId.equals(sysUserroleAudit.getRoleId())) continue;
                isExist = true;
                updateAuditList.add(sysUserroleAudit);
                break;
            }
            if (isExist) continue;
            SysUserroleAudit sysUserroleAudit = new SysUserroleAudit();
            sysUserroleAudit.setUserId(userId);
            sysUserroleAudit.setRoleId(roleId);
            sysUserroleAudit.setStatus(UserRoleStatus.LOCKED.getCode());
            sysUserroleAudit.setOperationType(operationType);
            sysUserroleAudit.setCreateTime(currentDate);
            sysUserroleAudit.setLastTime(currentDate);
            sysUserroleAudit.setCreator(account);
            sysUserroleAudit.setLastEditor(account);
            addAuditList.add(sysUserroleAudit);
        }
        if (updateAuditList.size() > 0) {
            updateMap.put("userId", userId);
            updateMap.put("operationType", operationType);
            updateMap.put("status", UserRoleStatus.LOCKED.getCode());
            updateMap.put("lastTime", currentDate);
            updateMap.put("lastEditor", account);
            updateMap.put("updateAuditList", updateAuditList);
            this.sysUserroleAuditMapper.updateAuditBatch(updateMap);
        }
        if (addAuditList.size() > 0) {
            this.sysUserroleAuditService.saveBatch(addAuditList);
        }
    }

    @Override
    public Tip changeOrg(Map<String, Object> map) {
        String userId = map.get("userId").toString();
        String corporationId = map.get("corporationId").toString();
        String permitId = map.get("permitId").toString();
        SuccessTip tip = new SuccessTip();
        SysUsers sysUsers = (SysUsers)((Object)this.sysUsersMapper.selectById((Serializable)((Object)userId)));
        sysUsers.setCorporationId(corporationId);
        sysUsers.setDepartmentId(corporationId);
        sysUsers.setPermissionStruId(permitId);
        if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isUserAudit()) {
            SysUsersAudit sysUsersAudit = new SysUsersAudit();
            CopyPropertieUtils.copyProperties((Object)((Object)sysUsersAudit), (Object)((Object)sysUsers));
            sysUsersAudit.setIsAudit("0");
            sysUsersAudit.setCreateTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
            sysUsersAudit.setCurrentStatus("3");
            if (this.sysUsersAuditMapper.insert((Object)sysUsersAudit) == 1) {
                tip.setMessage("\u8f6c\u79fb\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
                return tip;
            }
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u8f6c\u79fb\u5931\u8d25\uff01");
        }
        if (this.sysUsersMapper.updateById((Object)sysUsers) == 1) {
            this.abstractPushMsgMatcher.insertOperation("user", "update", (Object)sysUsers, "");
            this.bpmAbstractPushMsgMatcher.pushUser(sysUsers, "update", null);
            tip.setMessage("\u8f6c\u79fb\u6210\u529f\uff01");
            return tip;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u8f6c\u79fb\u5931\u8d25\uff01");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"authorization_info"}, key="'shiro_authInfo:'+#sysUser.userId")
    public Tip delUser(SysUsers sysUser) {
        SuccessTip tip = new SuccessTip();
        SysUsersAudit sysUsersAudit = new SysUsersAudit();
        if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isUserAudit()) {
            CopyPropertieUtils.copyProperties((Object)((Object)sysUsersAudit), (Object)((Object)sysUser));
            sysUsersAudit.setIsAudit("0");
            sysUsersAudit.setCurrentStatus(DELETE);
            sysUsersAudit.setCreateTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
            if (this.sysUsersAuditMapper.insert((Object)sysUsersAudit) == 1) {
                tip.setMessage("\u5220\u9664\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
                return tip;
            }
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5220\u9664\u5931\u8d25\uff01");
        }
        String employeeId = sysUser.getEmployeeId();
        sysUser.setAccountStatus(UserStatus.DELETE.getCode());
        sysUser.setEmployeeId("");
        this.sysStruMapper.updatePrincipal(sysUser.getUserId());
        this.sysUserroleAuditService.remove((Wrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)sysUser.getUserId()));
        this.iSysUserIpService.remove((Wrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)sysUser.getUserId()));
        if (this.sysUsersMapper.updateById((Object)sysUser) == 1) {
            tip.setMessage("\u5220\u9664\u6210\u529f\uff01");
            this.abstractPushMsgMatcher.insertOperation("user", "delete", (Object)sysUser, "");
            sysUser.setEmployeeId(employeeId);
            this.bpmAbstractPushMsgMatcher.delete("organ", sysUser.getUserId(), null);
            this.bpmAbstractPushMsgMatcher.delete("userRole", sysUser.getUserId(), "deleteByUserId");
            return tip;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5220\u9664\u5931\u8d25\uff01");
    }

    @Override
    public boolean isExistAccount(String userAccount) {
        boolean flag = false;
        List<Map<String, Object>> result = this.sysUsersMapper.isExistAccount(userAccount);
        if (result.size() > 0) {
            flag = true;
        }
        return flag;
    }

    @Override
    @Transactional(noRollbackFor={DormancyException.class, HussarLockedAccountException.class})
    public ArrayList<Object> getUserInfo(String userId) {
        ArrayList<Object> result = new ArrayList<Object>();
        SysUsers user = (SysUsers)((Object)this.sysUsersMapper.selectById((Serializable)((Object)userId)));
        if (user.getLastLoginTime() != null) {
            Date lastLoginDate = user.getLastLoginTime();
            SysBaseConfig noLogin = this.iSysBaseConfigService.getSysBaseConfig("nologin_day");
            SysBaseConfig userAccountStatus = this.iSysBaseConfigService.getSysBaseConfig("user_account_status");
            String days = noLogin.getConfigValue();
            String status = userAccountStatus.getConfigValue();
            Date date = DateUtil.addDay((Date)lastLoginDate, (int)Integer.parseInt(days));
            if (date.getTime() < System.currentTimeMillis()) {
                if (UserStatus.DORMANCY.getCode().equals(status)) {
                    user.setAccountStatus(UserStatus.DORMANCY.getCode());
                } else {
                    user.setAccountStatus(UserStatus.LOCKED.getCode());
                }
                this.updateById((Object)user);
            }
        }
        if (UserStatus.TEMPORARY.getCode().equals(user.getTypeProperty())) {
            String beginTime = user.getStartTime();
            String endTime = user.getExpiredTime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date begin = sdf.parse(beginTime);
                Date end = sdf.parse(endTime);
                Date now = sdf.parse(sdf.format(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant())));
                if (begin.getTime() > now.getTime() || end.getTime() < now.getTime()) {
                    user.setAccountStatus(UserStatus.DORMANCY.getCode());
                    this.updateById((Object)user);
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        List userRole = this.sysUserRoleMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)userId)).eq((Object)"ADMIN_OPTION", (Object)UserStatus.OK.getCode()));
        List userProxy = this.sysUserProxyMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)userId));
        List byProxy = this.sysUserProxyMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"PROXY_USER_ID", (Object)userId));
        List<String> userIps = this.iSysUserIpService.selectUserIp(userId);
        StringBuilder ips = new StringBuilder();
        String ipsStr = "";
        if (userIps != null && userIps.size() > 0) {
            for (String sysUserIp : userIps) {
                ips.append(sysUserIp);
                ips.append(",");
            }
            ipsStr = ips.toString();
            ipsStr = ipsStr.substring(0, ipsStr.length() - 1);
        }
        user.setPassword("");
        result.add((Object)user);
        result.add(userRole);
        result.add(userProxy);
        result.add(byProxy);
        result.add(userIps);
        result.add(ipsStr);
        return result;
    }

    @Override
    @Transactional(noRollbackFor={DormancyException.class, HussarLockedAccountException.class})
    public Map<String, Object> getUserInfoList(Page page, UserQueryReqVO userQueryReqVO) {
        HashMap<String, Object> userPageMap = new HashMap<String, Object>(4);
        userPageMap.put("code", 0);
        ShiroUser currentUser = ShiroKit.getUser();
        String parentStruId = userQueryReqVO.getDepStruId();
        if (currentUser.isGradeadmin()) {
            SysStru currentNodeStru = (SysStru)((Object)this.sysStruMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"STRU_ID", (Object)userQueryReqVO.getDepStruId())));
            SysStru sysStru = (SysStru)((Object)this.sysStruMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"STRU_ID", (Object)currentUser.getDeptId())));
            if (sysStru == null || currentNodeStru == null || currentNodeStru.getStruLevel().intValue() < sysStru.getStruLevel().intValue() || currentNodeStru.getStruLevel().intValue() == sysStru.getStruLevel().intValue() && !currentNodeStru.getStruId().equals(sysStru.getStruId())) {
                userPageMap.put("count", 0L);
                userPageMap.put("data", null);
                return userPageMap;
            }
        }
        ArrayList depStruIdList = Lists.newArrayList();
        depStruIdList.add(userQueryReqVO.getDepStruId());
        userQueryReqVO.setUserDepStruIdList(depStruIdList);
        Map<String, Object> dataScopeMap = ShiroFactroy.me().getDataScopeInfo(currentUser);
        Set optStruNodeIdList = (Set)dataScopeMap.get("data_scope_list");
        String dataScopeType = dataScopeMap.get("data_scope_type").toString();
        if (!ADD.equals(dataScopeType)) {
            if ("4".equals(dataScopeType) && currentUser.getDeptId().equals(parentStruId)) {
                userQueryReqVO.setUserName(currentUser.getName());
                List<UserOrgVo> userInfoList = this.sysUsersMapper.findAccountUserList(page, userQueryReqVO);
                userPageMap.put("count", page.getTotal());
                userPageMap.put("data", userInfoList);
                return userPageMap;
            }
            if (!optStruNodeIdList.contains(parentStruId)) {
                userPageMap.put("count", 0);
                userPageMap.put("data", null);
                return userPageMap;
            }
        }
        List<UserOrgVo> userInfoList = this.sysUsersMapper.findAccountUserList(page, userQueryReqVO);
        userPageMap.put("count", page.getTotal());
        userPageMap.put("data", userInfoList);
        return userPageMap;
    }

    @Override
    public boolean isFirstLogin(String userId) {
        boolean flag = false;
        Integer count = this.sysGetBackPasswordMapper.selectCount((Wrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)userId));
        if (count == 0) {
            flag = true;
        }
        return flag;
    }

    @Override
    public boolean isPwdOverdue(String userId) {
        boolean flag = false;
        List<SysPasswordHist> list = this.sysPasswordHistMapper.lastCreateTime(userId);
        if (list.size() >= 1 && ToolUtil.isNotEmpty(list)) {
            SysPasswordHist sysPasswordHist = list.get(0);
            String currentTime = DateUtil.getTime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            long days = DateUtil.getDaySub((String)sdf.format(sysPasswordHist.getCreateTime()), (String)currentTime);
            if (days >= this.globalProperties.getPasswordHist()) {
                flag = true;
            }
        } else {
            flag = true;
        }
        return flag;
    }

    @Override
    public SysUsers getUser(String userId) {
        return (SysUsers)((Object)this.sysUsersMapper.selectById((Serializable)((Object)userId)));
    }

    @Override
    public List<SysPasswordHist> getPwdHist(String userId) {
        return this.sysPasswordHistMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)userId)).orderByDesc((Object)"CREATE_TIME"));
    }

    @Override
    public void updatePwd(SysUsers sysUsers) {
        SysUsers user = (SysUsers)((Object)this.sysUsersMapper.selectById((Serializable)((Object)sysUsers.getUserId())));
        user.setPassword(sysUsers.getPassword());
        user.setPswdUptTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        String pwdExtinctTime = DateUtil.getAfterDayDate((String)(this.globalProperties.getPasswordHist() + ""));
        user.setPswdTime(DateUtil.parseTime((String)pwdExtinctTime));
        user.updateById();
        List<SysPasswordHist> list = this.sysPasswordHistMapper.lastCreateTime(sysUsers.getUserId());
        if (list.size() >= this.globalProperties.getPwdRepeatTime() && list.size() != 0) {
            SysPasswordHist sysPasswordHist = list.get(list.size() - 1);
            this.sysPasswordHistMapper.delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)sysPasswordHist.getUserId())).eq((Object)"PASSWORD", (Object)sysPasswordHist.getPassword()));
        }
        SysPasswordHist sph = new SysPasswordHist();
        sph.setUserId(sysUsers.getUserId());
        sph.setPassword(sysUsers.getPassword());
        sph.setCreateTime(new Timestamp(System.currentTimeMillis()));
        this.sysPasswordHistMapper.insert((Object)sph);
        LoginLock loginLock = (LoginLock)SpringContextHolder.getBean(LoginLock.class);
        String connName = DataSourceUtil.currentDsName();
        if (this.globalProperties.isTenantOpen()) {
            loginLock.removeUserCache(sysUsers.getUserId(), connName);
        } else {
            loginLock.removeUserCache(sysUsers.getUserId());
        }
    }

    @Override
    public boolean setGetBackPwd(Map<String, Object> map) {
        String userId = map.get("userId").toString();
        String ques = map.get("ques").toString();
        String key = map.get("key").toString();
        SysGetBackPassword sysGetBackPassword = new SysGetBackPassword();
        sysGetBackPassword.setUserId(userId);
        sysGetBackPassword.setpQues(ques);
        sysGetBackPassword.setpKey(key);
        return this.iSysGetBackPasswordService.saveOrUpdate((Object)sysGetBackPassword);
    }

    @Override
    public long resetAllPwd(Map<String, Object> map) {
        String newPwd = map.get("newPwd").toString();
        String[] userIds = (String[])map.get("userIds");
        long count = 0L;
        LoginLock loginLock = (LoginLock)SpringContextHolder.getBean(LoginLock.class);
        String connName = DataSourceUtil.currentDsName();
        for (String userId : userIds) {
            if (!ToolUtil.isNotEmpty((Object)userId)) continue;
            SysUsers sysUsers = new SysUsers();
            sysUsers.setPassword(newPwd);
            count += (long)this.sysUsersMapper.update((Object)sysUsers, (Wrapper)new UpdateWrapper().eq((Object)"USER_ID", (Object)userId));
            if (this.globalProperties.isTenantOpen()) {
                loginLock.removeUserCache(userId, connName);
                continue;
            }
            loginLock.removeUserCache(userId);
        }
        return count;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void resetVueAllPwd(Map<String, Object> map) {
        String newPwd = map.get("newPwd").toString();
        String[] userIds = (String[])map.get("userIds");
        LoginLock loginLock = (LoginLock)SpringContextHolder.getBean(LoginLock.class);
        String connName = DataSourceUtil.currentDsName();
        this.sysUsersMapper.resetAllPwd(userIds, newPwd);
        for (String userId : userIds) {
            if (!ToolUtil.isNotEmpty((Object)userId)) continue;
            if (this.globalProperties.isTenantOpen()) {
                loginLock.removeUserCache(userId, connName);
                continue;
            }
            loginLock.removeUserCache(userId);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveUserOrder(JSONArray treeArr) {
        ArrayList<SysUsers> sysUsersList = new ArrayList<SysUsers>();
        for (int i = 0; i < treeArr.size(); ++i) {
            JSONObject json = new JSONObject();
            json = treeArr.getJSONObject(i);
            String id = json.getString("id");
            String order = json.getString("struOrder");
            SysUsers sysUsers = new SysUsers();
            sysUsers.setUserId(id);
            sysUsers.setUserOrder(new BigDecimal(order));
            sysUsersList.add(sysUsers);
            this.abstractPushMsgMatcher.insertOperation("user", "update", (Object)sysUsers, "");
            this.bpmAbstractPushMsgMatcher.pushUser(sysUsers, "update", null);
        }
        return ToolUtil.isNotEmpty(sysUsersList) && super.updateBatchById(sysUsersList, sysUsersList.size());
    }

    @Override
    public Long getMaxOrder(String corporationId) {
        return this.sysUsersMapper.getMaxOrder(corporationId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean copyRole(String copyFrom, String copyTo) {
        List rolesFrom = this.sysUserRoleMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)copyFrom)).eq((Object)"admin_option", (Object)Whether.YES.getValue()));
        List rolesTo = this.sysUserRoleMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)copyTo)).eq((Object)"admin_option", (Object)Whether.YES.getValue()));
        ArrayList<String> adds = new ArrayList<String>();
        for (SysUserRole from : rolesFrom) {
            if (ToolUtil.isEmpty((Object)from.getGrantedRole())) continue;
            boolean isSame = false;
            for (SysUserRole to : rolesTo) {
                if (!from.getGrantedRole().equals(to.getGrantedRole())) continue;
                isSame = true;
                break;
            }
            if (isSame || SysUserAndRole.PUBLIC_ROLE.getValue().equals(from.getGrantedRole())) continue;
            adds.add(from.getGrantedRole());
        }
        int size = adds.size();
        String[] toRolesArray = new String[rolesTo.size()];
        String[] addArray = adds.toArray(new String[size]);
        for (int i = 0; i < rolesTo.size(); ++i) {
            toRolesArray[i] = ((SysUserRole)((Object)rolesTo.get(i))).getGrantedRole();
        }
        int arryLen1 = addArray.length;
        int arryLen2 = toRolesArray.length;
        addArray = Arrays.copyOf(addArray, arryLen1 + arryLen2);
        System.arraycopy(toRolesArray, 0, addArray, arryLen1, arryLen2);
        if (this.iSysConfRolesService.isIncludeConfRole(addArray)) {
            return false;
        }
        if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isRoleAudit()) {
            List<SysUserroleAudit> auditList = this.sysUserroleAuditMapper.getHasReviewList(copyTo);
            if (ToolUtil.isNotEmpty(adds)) {
                this.insertAndUpdateUserRoleAudit(adds, auditList, copyTo, ADD);
            }
        } else {
            ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
            Date currentDate = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
            String currentUser = ShiroKit.getUser().getAccount();
            for (String roleId : adds) {
                if (ToolUtil.isEmpty((Object)roleId)) continue;
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(copyTo);
                sysUserRole.setGrantedRole(roleId);
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                sysUserRole.setCreateTime(currentDate);
                sysUserRole.setLastTime(currentDate);
                sysUserRole.setCreator(currentUser);
                sysUserRole.setLastEditor(currentUser);
                userRoleList.add(sysUserRole);
            }
            if (ToolUtil.isNotEmpty(userRoleList)) {
                this.sysUserRoleService.saveBatch(userRoleList, userRoleList.size());
                this.abstractPushMsgMatcher.insertOperation("userRole", "add", userRoleList, "");
                this.bpmAbstractPushMsgMatcher.pushUserRole(userRoleList, "add");
            }
        }
        return true;
    }

    @Override
    public Page<SysUsers> getUserList(Page<SysUsers> page, String userAccount, String userName) {
        page.setRecords(this.sysUsersMapper.getUserList(page, userAccount, userName));
        return page;
    }

    @Override
    public List<JSTreeModel> getUserTreeByRole(String roleId) {
        return this.sysUsersMapper.getUserTreeByRole(roleId);
    }

    @Override
    public List<JSTreeModel> getLazyUserTreeByRole(String roleId) {
        return this.sysUsersMapper.getLazyUserTreeByRole(roleId);
    }

    @Override
    public void updateUserStatus() {
        SysBaseConfig noLogin = this.iSysBaseConfigService.getSysBaseConfig("nologin_day");
        SysBaseConfig userAccountStatus = this.iSysBaseConfigService.getSysBaseConfig("user_account_status");
        String days = noLogin.getConfigValue();
        String status = userAccountStatus.getConfigValue();
        Instant now = Instant.now();
        Instant before = now.minus(Duration.ofDays(Integer.valueOf(days).intValue()));
        Date dateBefore = Date.from(before);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Timestamp previous = Timestamp.valueOf(df.format(dateBefore));
        this.sysUsersMapper.updateUserStatus(previous, status);
    }

    @Override
    public boolean reChecking(String reUrl, String userName, String pass) {
        if (this.hussarProperties.getTotpOpen().booleanValue()) {
            SysUsers sysUsers = (SysUsers)((Object)super.getOne((Wrapper)new QueryWrapper().eq((Object)"USER_ACCOUNT", (Object)userName), false));
            String totpKey = sysUsers.getTotpKey();
            return this.abstractOTPCredentialsMatcher.verify(totpKey, pass, this.hussarProperties.getTotpOffsetMin());
        }
        String password = CryptoUtil.decode((String)pass);
        SysUsers sysUsers = (SysUsers)((Object)super.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ACCOUNT", (Object)userName)).eq((Object)"ACCOUNT_STATUS", (Object)UserStatus.OK.getCode()), false));
        String pwd = this.credentialsMatcher.passwordEncode(String.valueOf(password).getBytes());
        return sysUsers.getPassword().equals(pwd);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"authorization_info"}, key="'shiro_authInfo:'+#sysUser.userId")
    public Tip cancelUser(SysUsers sysUser) {
        SysUsersAudit sysUsersAudit = new SysUsersAudit();
        SuccessTip tip = new SuccessTip();
        if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isUserAudit()) {
            CopyPropertieUtils.copyProperties((Object)((Object)sysUsersAudit), (Object)((Object)sysUser));
            sysUsersAudit.setIsAudit("0");
            sysUsersAudit.setCurrentStatus("4");
            sysUsersAudit.setCreateTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
            if (this.sysUsersAuditMapper.insert((Object)sysUsersAudit) == 1) {
                tip.setMessage("\u6ce8\u9500\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
                return tip;
            }
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u6ce8\u9500\u5931\u8d25\uff01");
        }
        String employeeId = sysUser.getEmployeeId();
        sysUser.setAccountStatus(UserStatus.CANCEL.getCode());
        sysUser.setEmployeeId("");
        this.sysUserroleAuditService.remove((Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)sysUser.getUserId()));
        if (this.sysUsersMapper.updateById((Object)sysUser) == 1) {
            this.abstractPushMsgMatcher.insertOperation("user", "update", (Object)sysUser, "");
            sysUser.setEmployeeId(employeeId);
            this.bpmAbstractPushMsgMatcher.delete("organ", sysUser.getUserId(), null);
            this.bpmAbstractPushMsgMatcher.delete("userRole", sysUser.getUserId(), "deleteByUserId");
            tip.setMessage("\u6ce8\u9500\u6210\u529f\uff01");
            return tip;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u6ce8\u9500\u5931\u8d25\uff01");
    }

    private boolean saveUserIP(String userId, String accessLoginIp) {
        boolean flag = false;
        ArrayList<SysUserIp> sysUserIps = new ArrayList<SysUserIp>();
        if (StringUtils.isNotEmpty((CharSequence)accessLoginIp)) {
            List<String> list = Arrays.asList(accessLoginIp.split(","));
            for (String ip : list) {
                SysUserIp sysUserIp = new SysUserIp();
                sysUserIp.setUserId(userId);
                sysUserIp.setUserIp(ip);
                sysUserIps.add(sysUserIp);
            }
        }
        if (sysUserIps.size() > 0) {
            flag = this.iSysUserIpService.saveBatch(sysUserIps);
        }
        return flag;
    }

    private boolean saveUserAuditIP(String userId, String accessLoginIp, String currentStatus) {
        boolean flag = false;
        ArrayList<SysUserIpAudit> listAudit = new ArrayList<SysUserIpAudit>();
        if (StringUtils.isNotEmpty((CharSequence)accessLoginIp)) {
            List<String> list = Arrays.asList(accessLoginIp.split(","));
            for (String ip : list) {
                SysUserIpAudit sysUserIpAudit = new SysUserIpAudit();
                sysUserIpAudit.setUserId(userId);
                sysUserIpAudit.setUserIp(ip);
                sysUserIpAudit.setIsAudit("0");
                sysUserIpAudit.setCurrentStatus(currentStatus);
                listAudit.add(sysUserIpAudit);
            }
        }
        if (listAudit.size() > 0) {
            flag = this.iSysUserIpAuditService.saveBatch(listAudit);
        }
        return flag;
    }

    @Override
    public void exportData(List<String> idList, HttpServletResponse response) {
        List users = this.sysUsersMapper.selectBatchIds(idList);
        ArrayList<String> employeeIds = new ArrayList<String>();
        for (SysUsers sysUsers : users) {
            String employeeId = sysUsers.getEmployeeId();
            if (employeeId == null) continue;
            employeeIds.add(employeeId);
        }
        List strus = new ArrayList();
        if (employeeIds.size() > 0) {
            strus = this.sysStruMapper.selectBatchIds(employeeIds);
        }
        List userRoles = this.sysUserRoleMapper.selectBatchIds(idList);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("users", users);
        data.put("userRoles", userRoles);
        data.put("strus", strus);
        data.put("export_type", "user");
        byte[] serializeData = SerializeUtils.serialize(data);
        String fileName = "user_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile(serializeData, fileName, response);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Tip importData(byte[] content) {
        Map data = (Map)SerializeUtils.deserialize((byte[])content);
        String export_type = (String)data.get("export_type");
        if (!"user".equals(export_type)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u60a8\u5bfc\u5165\u7684\u662f" + (String)Constants.EXPORT_MAP.get(export_type) + ",\u8bf7\u5bfc\u5165" + (String)Constants.EXPORT_MAP.get("user"));
        }
        List users = (List)data.get("users");
        List userRoles = (List)data.get("userRoles");
        List strus = (List)data.get("strus");
        Map<String, Integer> userCount = this.insertOrUpdateList(users);
        Map<String, Integer> userRoleCount = this.insertOrUpdateList(userRoles);
        Map<String, Integer> strusCount = this.insertOrUpdateList(strus);
        SuccessTip success = new SuccessTip();
        success.setMessage("\u5bfc\u5165\u6210\u529f\u3002\u7528\u6237\u65b0\u589e\u6570\u636e" + userCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + userCount.get("update") + "\u6761\uff1b\u7528\u6237\u89d2\u8272\u5173\u7cfb\u65b0\u589e\u6570\u636e" + userRoleCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + userRoleCount.get("update") + "\u6761\u3002");
        return success;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Map<String, String> importVueData(byte[] content) {
        Map data;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            data = (Map)SerializeUtils.deserialize((byte[])content);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.FILE_READING_ERROR);
        }
        if (ToolUtil.isEmpty((Object)data)) {
            map.put("success", "fileError");
            map.put("message", "\u5bfc\u5165\u6570\u636e\u6709\u8bef");
            map.put("import", "user");
            return map;
        }
        String export_type = (String)data.get("export_type");
        if (!"user".equals(export_type)) {
            map.put("success", "false");
            map.put("errorImport", export_type);
            map.put("import", "employee");
            return map;
        }
        List users = (List)data.get("users");
        List userRoles = (List)data.get("userRoles");
        List strus = (List)data.get("strus");
        Map<String, Integer> userCount = this.insertOrUpdateList(users);
        Map<String, Integer> userRoleCount = this.insertOrUpdateList(userRoles);
        Map<String, Integer> strusCount = this.insertOrUpdateList(strus);
        map.put("success", "true");
        map.put("userInsert", "" + userCount.get("insert"));
        map.put("userUpdate", "" + userCount.get("update"));
        map.put("userRoleInsert", "" + userRoleCount.get("insert"));
        map.put("userRoleUpdate", "" + userRoleCount.get("update"));
        return map;
    }

    @Override
    public List<JSTreeModel> getUserTree(String isExport, String parentId) {
        String newParentId = parentId;
        ShiroUser shiroUser = ShiroKit.getUser();
        String empolyeeId = shiroUser.getEmployeeId();
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            String struLevel = this.sysStruMapper.selectStruLevel(empolyeeId);
            level = Integer.parseInt(struLevel);
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setId("11");
        jsTreeModel.setCode("11");
        jsTreeModel.setText("\u7cfb\u7edf\u7528\u6237");
        jsTreeModel.setParent("#");
        jsTreeModel.setType("isRoot");
        if (isGradeAdmin) {
            jsTreeModel.getState().put("gradeDisabled", true);
        }
        List<Object> list = new ArrayList();
        ArrayList<JSTreeModel> list1 = new ArrayList();
        if (this.globalProperties.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)newParentId)) {
            if (ToolUtil.equals((Object)"#", (Object)newParentId)) {
                newParentId = "11";
                result.add(jsTreeModel);
            }
            list1 = this.sysOrgManageService.getUserTree(newParentId);
        } else {
            result.add(jsTreeModel);
            list1 = this.sysOrgManageService.getUserTree();
        }
        list = isGradeAdmin ? this.sysOrgManageService.getGradeStruTree(list1, level) : list1;
        result.addAll(list);
        if (Boolean.parseBoolean(isExport)) {
            for (JSTreeModel model : result) {
                String type = model.getType();
                if (type != null && "USER".equals(type)) {
                    model.setState(false, false, false);
                    continue;
                }
                model.setState(false, false, true);
            }
        }
        return result;
    }

    @Override
    public List<JSTreeModel> getUserTreeVue(String isExport, String parentId) {
        String newParentId = parentId;
        ShiroUser shiroUser = ShiroKit.getUser();
        String empolyeeId = shiroUser.getEmployeeId();
        Map<String, Object> map = ShiroFactroy.me().getDataScopeInfo(shiroUser);
        String dataScopeType = map.get("data_scope_type").toString();
        Set orgList = (Set)map.get("data_scope_list");
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            String struLevel = this.sysStruMapper.selectStruLevel(empolyeeId);
            level = Integer.parseInt(struLevel);
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setId("11");
        jsTreeModel.setCode("11");
        jsTreeModel.setText("\u7cfb\u7edf\u7528\u6237");
        jsTreeModel.setParent("#");
        jsTreeModel.setType("isRoot");
        if (isGradeAdmin) {
            jsTreeModel.getState().put("gradeDisabled", true);
        }
        if (!ADD.equals(dataScopeType)) {
            jsTreeModel.getState().put("dataScopeDisabled", true);
        }
        List<Object> list = new ArrayList();
        ArrayList<JSTreeModel> list1 = new ArrayList();
        if (this.globalProperties.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)newParentId)) {
            if (ToolUtil.equals((Object)"#", (Object)newParentId)) {
                newParentId = "11";
                result.add(jsTreeModel);
            }
            list1 = this.sysOrgManageService.getUserTree(newParentId);
        } else {
            result.add(jsTreeModel);
            list1 = this.sysOrgManageService.getUserTree();
        }
        list = isGradeAdmin ? this.sysOrgManageService.getGradeStruTree(list1, level) : (ADD.equals(dataScopeType) ? list1 : this.sysOrgManageService.getDataScopeTree(list1, dataScopeType, orgList));
        result.addAll(list);
        if (Boolean.parseBoolean(isExport)) {
            for (JSTreeModel model : result) {
                String type = model.getType();
                if (type != null && "USER".equals(type)) {
                    model.setState(false, false, false);
                    continue;
                }
                model.setState(false, false, true);
            }
        }
        return result;
    }

    @Override
    public List<JSTreeModel> getUserDepTreeVue(String parentId, String reqModule) {
        ShiroUser shiroUser = ShiroKit.getUser();
        String empolyeeId = shiroUser.getEmployeeId();
        Map<String, Object> map = ShiroFactroy.me().getDataScopeInfo(shiroUser);
        String dataScopeType = map.get("data_scope_type").toString();
        Set orgList = (Set)map.get("data_scope_list");
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            String struLevel = this.sysStruMapper.selectStruLevel(empolyeeId);
            level = Integer.parseInt(struLevel);
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel jsTreeRootModel = new JSTreeModel();
        jsTreeRootModel.setCode("11");
        jsTreeRootModel.setId("11");
        jsTreeRootModel.setParent("#");
        String rootText = "role".equals(reqModule) ? "\u89d2\u8272\u6811" : "\u7cfb\u7edf\u7528\u6237";
        jsTreeRootModel.setText(rootText);
        jsTreeRootModel.setType("isRoot");
        if (isGradeAdmin) {
            jsTreeRootModel.getState().put("gradeDisabled", true);
        }
        if (!ADD.equals(dataScopeType)) {
            jsTreeRootModel.getState().put("dataScopeDisabled", true);
        }
        List<Object> list1 = Lists.newArrayList();
        if (this.globalProperties.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)parentId)) {
            if (ToolUtil.equals((Object)"#", (Object)parentId)) {
                parentId = "11";
                result.add(jsTreeRootModel);
            }
            list1 = this.sysOrgManageService.getUserDepChildTree(parentId);
        }
        List<Object> list = isGradeAdmin ? this.sysOrgManageService.getGradeStruTree(list1, level) : (ADD.equals(dataScopeType) ? list1 : this.sysOrgManageService.getDataScopeTree(list1, dataScopeType, orgList));
        result.addAll(list);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Tip addUser(SysUsers sysUsers, String roleIds) {
        if (!this.hussarProperties.getLoginUpperOpen().booleanValue()) {
            sysUsers.setUserAccount(sysUsers.getUserAccount().toUpperCase());
        }
        if (this.isExistAccount(sysUsers.getUserAccount())) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u7528\u6237\u540d\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09");
        }
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"real_stru_id", (Object)sysUsers.getEmployeeId())).eq((Object)"state", (Object)"0");
        Integer count = this.sysStruAuditMapper.selectCount((Wrapper)wrapper);
        if (count > 0) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5f53\u524d\u4eba\u5458\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u65b0\u589e\uff01");
        }
        String[] ids = roleIds.split(",");
        if (this.iSysConfRolesService.isIncludeConfRole(ids)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u65b0\u589e\u5931\u8d25\uff01\uff08\u6240\u9009\u89d2\u8272\u4e0d\u5141\u8bb8\u8d85\u8fc7\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\u7684\u57fa\u6570\uff01\uff09");
        }
        sysUsers.setDepartmentId(sysUsers.getCorporationId());
        Long order = this.getMaxOrder(sysUsers.getCorporationId());
        order = ToolUtil.isEmpty((Object)order) ? Long.valueOf(1L) : Long.valueOf(order + 1L);
        BigDecimal userOrder = BigDecimal.valueOf(order);
        sysUsers.setUserOrder(userOrder);
        sysUsers.setCreateTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        sysUsers.setTotpKey(this.abstractOTPCredentialsMatcher.getRandomSecretBase32());
        sysUsers.setUserId(IdWorker.get32UUID());
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("sysUsers", (Object)sysUsers);
        map.put("roleIds", roleIds);
        String userId = this.addUser(map);
        SuccessTip successTip = new SuccessTip();
        successTip.setMessage(userId);
        return successTip;
    }

    @Override
    @Deprecated
    public Tip addUserRole(String userId, String roleIds) {
        return new ErrorTip(0, "\u8be5\u529f\u80fd\u5df2\u8fc7\u671f\u4f5c\u5e9f");
    }

    @Override
    @Deprecated
    public Tip addUserInfo(SysUsers sysUsers) {
        return this.addUser(sysUsers, SysUserAndRole.PUBLIC_ROLE.getValue());
    }

    @Override
    public Map<String, Object> getAccountList(Map<String, String> map, Page<UserOrgVo> pages) {
        String orgId;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String userName = map.get("userName");
        String userAccount = map.get("userAccount");
        String userStatus = map.get("userStatus");
        String userProperty = map.get("userProperty");
        String string = orgId = map.get("orgId") == null ? "" : map.get("orgId");
        if (ToolUtil.isNotEmpty((Object)userAccount)) {
            userAccount = userAccount.replace("%", "\\\\%").replace("_", "\\\\_");
        }
        if (ToolUtil.isNotEmpty((Object)userName)) {
            userName = userName.replace("%", "\\\\%").replace("_", "\\\\_");
        }
        List<UserOrgVo> list = this.sysUsersMapper.getAccountList(userName, userAccount, userStatus, userProperty, orgId, pages);
        result.put("count", pages.getTotal());
        result.put("data", list);
        return result;
    }

    @Override
    public List<SysUsers> updateUserStatusToLock(String status) {
        int nologinDay = Integer.parseInt(this.iSysBaseConfigService.getSysBaseConfig("nologin_day").getConfigValue());
        Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        Date previous = DateUtil.addDay((Date)date, (int)(-nologinDay));
        List<SysUsers> noLoginList = this.sysUsersMapper.getNoLoginList(previous, UserStatus.OK.getCode());
        if (ToolUtil.isNotEmpty(noLoginList)) {
            this.sysUsersMapper.updateToLock(date, status, noLoginList);
        } else {
            noLoginList = new ArrayList<SysUsers>();
        }
        return noLoginList;
    }

    @Override
    public List<SysUsers> getWillLogoutList() {
        int logoutDay = Integer.parseInt(this.iSysBaseConfigService.getSysBaseConfig("logout_day").getConfigValue());
        int warnDay = Integer.parseInt(this.iSysBaseConfigService.getSysBaseConfig("email_before_logout_day").getConfigValue());
        int days = logoutDay - warnDay;
        Date date = DateUtil.addDay((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (int)(-days));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String startTime = sdf.format(date) + " 00:00:00";
        String endTime = sdf.format(date) + " 23:59:59";
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return ((SysUsersMapper)this.baseMapper).getWillLogoutList(dateFormat.parse(startTime), dateFormat.parse(endTime));
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean updateUserStatusToCancel() {
        int logoutDay = Integer.parseInt(this.iSysBaseConfigService.getSysBaseConfig("logout_day").getConfigValue());
        Date previous = DateUtil.addDay((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (int)(-logoutDay));
        return ((SysUsersMapper)this.baseMapper).updateToCancel(previous, UserStatus.CANCEL.getCode());
    }

    public Map<String, Object> getSysUserInfo(Page page, UserQueryReqVO userQueryReqVO) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("code", 0);
        ShiroUser currentUser = ShiroKit.getUser();
        String parentStruId = userQueryReqVO.getDepStruId();
        Map<String, Object> dataScopeMap = ShiroFactroy.me().getDataScopeInfo(currentUser);
        Set optStruNodeIdList = (Set)dataScopeMap.get("data_scope_list");
        String dataScopeType = dataScopeMap.get("data_scope_type").toString();
        if (!ADD.equals(dataScopeType)) {
            map.put("count", 0L);
            map.put("data", null);
            return map;
        }
        if (ShiroKit.getUser().isGradeadmin()) {
            map.put("count", 0L);
            map.put("data", null);
        } else {
            userQueryReqVO.setIsSys(ADD);
            List<UserOrgVo> sysUserList = this.sysUsersMapper.findAccountUserList(page, userQueryReqVO);
            map.put("count", page.getTotal());
            map.put("data", sysUserList);
        }
        return map;
    }

    private Map<String, Integer> insertOrUpdateList(List<?> objects) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer update = 0;
        Integer insert = 0;
        if (CollectionUtils.isEmpty(objects)) {
            result.put("update", update);
            result.put("insert", insert);
            return result;
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = objects.size();
            for (int i = 0; i < size; ++i) {
                Integer n;
                Integer n2;
                Object obj = objects.get(i);
                if (obj instanceof SysUsers) {
                    SysUsers user = (SysUsers)((Object)obj);
                    if (this.updateById((Object)user)) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.save((Object)user);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (obj instanceof SysUserRole) {
                    SysUserRole userRole = (SysUserRole)((Object)obj);
                    if (this.sysUserRoleService.update((Object)userRole, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)userRole.getUserId())).eq((Object)"GRANTED_ROLE", (Object)userRole.getGrantedRole()))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysUserRoleService.save((Object)userRole);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (obj instanceof SysStru) {
                    SysStru sysStru = (SysStru)((Object)obj);
                    if (SqlHelper.retBool((Integer)this.sysStruMapper.updateById((Object)sysStru))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysStruMapper.insert((Object)sysStru);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new MybatisPlusException("Error: Cannot execute insertOrUpdateBatch Method. Cause", e);
        }
        result.put("update", update);
        result.put("insert", insert);
        return result;
    }
}

