/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bpm.messagepush.AbstractBpmPushMsgMatcher;
import com.jxdinfo.hussar.bsp.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.bsp.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysUserroleAuditMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysUserRole;
import com.jxdinfo.hussar.bsp.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.bsp.permit.service.ISysRolesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.bsp.permit.vo.SysUserRoleVo;
import com.jxdinfo.hussar.common.annotion.DataScope;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.entity.BaseEntity;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysUserroleAuditServiceImpl
extends ServiceImpl<SysUserroleAuditMapper, SysUserroleAudit>
implements ISysUserroleAuditService {
    @Resource
    private SysUserroleAuditMapper sysUserroleAuditMapper;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private ISysRolesService iSysRolesService;
    private static final String ADD = "1";
    private static final String DELETE = "2";
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;
    @Resource
    private AbstractBpmPushMsgMatcher bpmAbstractPushMsgMatcher;

    @Override
    public Map<String, Object> getUserRoleReviewList(String page, String limit, String userAccount, String userName, String type) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        Page pages = new Page((long)Integer.valueOf(page).intValue(), (long)Integer.valueOf(limit).intValue());
        List<SysUserRoleVo> list = this.sysUserroleAuditMapper.getUserRoleReviewList((Page<Map<String, Object>>)pages, userName, userAccount, type);
        map.put("count", pages.getTotal());
        map.put("data", list);
        map.put("code", 0);
        return map;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void reviewSubmit(String userId, String roleId, String opsType) {
        String[] uids = userId.split(",");
        String[] rids = roleId.split(",");
        String[] oids = opsType.split(",");
        for (String uid : uids) {
            this.iSysRolesService.delRedisAuthInfo(uid);
        }
        if (uids.length == rids.length && uids.length == oids.length && rids.length == oids.length) {
            ArrayList<SysUserRole> addBpmList = new ArrayList<SysUserRole>();
            ArrayList<SysUserRole> deleteBpmList = new ArrayList<SysUserRole>();
            List userRoleList = this.sysUserRoleMapper.selectList((Wrapper)new QueryWrapper().in((Object)"user_id", Arrays.asList(uids)));
            ArrayList<SysUserRole> addList = new ArrayList<SysUserRole>();
            ArrayList<SysUserRole> updateList = new ArrayList<SysUserRole>();
            ArrayList<SysUserroleAudit> auditList = new ArrayList<SysUserroleAudit>();
            for (int i = 0; i < uids.length; ++i) {
                int count = 0;
                for (SysUserRole userRole : userRoleList) {
                    if (!uids[i].equals(userRole.getUserId()) || !rids[i].equals(userRole.getGrantedRole())) continue;
                    ++count;
                    break;
                }
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setCreateTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
                sysUserRole.setLastTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
                sysUserRole.setCreator(ShiroKit.getUser().getAccount());
                sysUserRole.setLastEditor(ShiroKit.getUser().getAccount());
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                sysUserRole.setUserId(uids[i]);
                sysUserRole.setGrantedRole(rids[i]);
                if (ADD.equals(oids[i])) {
                    sysUserRole.setAdminOption(UserStatus.OK.getCode());
                } else {
                    sysUserRole.setAdminOption(UserStatus.LOCKED.getCode());
                }
                if (count == 0) {
                    addList.add(sysUserRole);
                    if (ADD.equals(oids[i])) {
                        addBpmList.add(sysUserRole);
                    } else {
                        deleteBpmList.add(sysUserRole);
                    }
                } else {
                    updateList.add(sysUserRole);
                    if (ADD.equals(oids[i])) {
                        addBpmList.add(sysUserRole);
                    } else {
                        deleteBpmList.add(sysUserRole);
                    }
                }
                SysUserroleAudit sysUserroleAudit = new SysUserroleAudit();
                sysUserroleAudit.setLastTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
                sysUserroleAudit.setStatus(UserRoleStatus.OK.getCode());
                sysUserroleAudit.setLastEditor(ShiroKit.getUser().getAccount());
                sysUserroleAudit.setUserId(uids[i]);
                sysUserroleAudit.setRoleId(rids[i]);
                sysUserroleAudit.setOperationType(oids[i]);
                auditList.add(sysUserroleAudit);
            }
            if (addList.size() > 0) {
                this.sysUserRoleMapper.insertUserRoleBatch(addList);
            }
            if (updateList.size() > 0) {
                this.sysUserRoleMapper.updateUserRoleBatch(updateList);
            }
            if (auditList.size() > 0) {
                this.sysUserroleAuditMapper.updateIsAuditBatch(auditList);
            }
            this.abstractPushMsgMatcher.insertOperation("userRole", "add", addBpmList, "");
            this.abstractPushMsgMatcher.insertOperation("userRole", "delete", deleteBpmList, "");
            this.bpmAbstractPushMsgMatcher.pushUserRole(addBpmList, "add");
            this.bpmAbstractPushMsgMatcher.pushUserRole(deleteBpmList, "delete");
        }
    }

    @Override
    public void refuseSubmit(String userId, String roleId, String opsType) {
        String[] uids = userId.split(",");
        String[] rids = roleId.split(",");
        String[] oids = opsType.split(",");
        ArrayList<SysUserroleAudit> auditList = new ArrayList<SysUserroleAudit>();
        if (uids.length == rids.length && uids.length == oids.length && rids.length == oids.length) {
            for (int i = 0; i < uids.length; ++i) {
                SysUserroleAudit sysUserroleAudit = new SysUserroleAudit();
                sysUserroleAudit.setLastTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
                sysUserroleAudit.setStatus(UserRoleStatus.REFUSE.getCode());
                sysUserroleAudit.setLastEditor(ShiroKit.getUser().getAccount());
                sysUserroleAudit.setUserId(uids[i]);
                sysUserroleAudit.setRoleId(rids[i]);
                sysUserroleAudit.setOperationType(oids[i]);
                auditList.add(sysUserroleAudit);
            }
            if (auditList.size() > 0) {
                this.sysUserroleAuditMapper.updateIsAuditBatch(auditList);
            }
        }
    }

    @Override
    public int isDelete(String id) {
        return this.sysUserroleAuditMapper.isDelete(id);
    }

    @Override
    @DataScope(deptAlias="t4.stru_id", userAlias="t1.user_id")
    public Map<String, Object> getUserRoleReviewListByDataScope(String page, String limit, String userAccount, String userName, String type, BaseEntity baseEntity) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        Page pages = new Page((long)Integer.valueOf(page).intValue(), (long)Integer.valueOf(limit).intValue());
        List<SysUserRoleVo> list = this.sysUserroleAuditMapper.getUserRoleReviewListByDataScope(pages, userName, userAccount, type, baseEntity.getDataScopeSql());
        map.put("count", pages.getTotal());
        map.put("data", list);
        map.put("code", 0);
        return map;
    }
}

