/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bpm.messagepush.AbstractBpmPushMsgMatcher;
import com.jxdinfo.hussar.bsp.organ.vo.RoleOrgUserVo;
import com.jxdinfo.hussar.bsp.permit.dao.SysConfRolesMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysUserroleAuditMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysUserRole;
import com.jxdinfo.hussar.bsp.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysRolesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.MessageTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysUserRoleServiceImpl
extends ServiceImpl<SysUserRoleMapper, SysUserRole>
implements ISysUserRoleService {
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private ISysConfRolesService isConfRolesService;
    @Resource
    private SysConfRolesMapper sysConfRolesMapper;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private ISysUserroleAuditService sysUserroleAuditService;
    @Resource
    private SysUserroleAuditMapper sysUserroleAuditMapper;
    @Resource
    private ISysRolesService sysRolesService;
    private static final String DISABLED = "0";
    private static final String ADD = "1";
    private static final String DELETE = "2";
    @Resource
    private AbstractBpmPushMsgMatcher bpmAbstractPushMsgMatcher;

    @Override
    public void deleteNotPublicRole(String userId) {
        this.sysUserRoleMapper.deleteNotPublicRole(userId);
    }

    @Override
    public void addRecord(SysUserRole sysUserRole) {
        this.sysUserRoleMapper.insert((Object)sysUserRole);
    }

    @Override
    public List<String> getRolesByUserId(String userId) {
        if (userId == null) {
            return new ArrayList<String>();
        }
        return this.sysUserRoleMapper.getRolesByUserId(userId);
    }

    @Override
    public List<String> selectUserIdByRoleId(String roleId) {
        return this.sysUserRoleMapper.selectUserIdByRoleId(roleId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Tip addOrDelUserRole(List<RoleOrgUserVo> adds, List<RoleOrgUserVo> dels, String roleId) {
        if (ToolUtil.isEmpty((Object)roleId)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "");
        }
        ArrayList<String> hasDel = new ArrayList<String>();
        for (RoleOrgUserVo roleOrgUserVo : dels) {
            hasDel.add(roleOrgUserVo.getId());
        }
        ArrayList<String> addIds = new ArrayList<String>();
        ArrayList<String> addIdsTemp = new ArrayList<String>();
        for (RoleOrgUserVo roleOrgUserVo : adds) {
            addIds.add(roleOrgUserVo.getId());
            addIdsTemp.add(roleOrgUserVo.getId());
        }
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"GRANTED_ROLE", (Object)roleId)).eq((Object)"ADMIN_OPTION", (Object)ADD);
        List se = this.sysUserRoleMapper.selectList((Wrapper)wrapper);
        for (Object sysUserRole : se) {
            for (int i = 0; i < addIdsTemp.size(); ++i) {
                if (!((String)addIdsTemp.get(i)).equals(((SysUserRole)((Object)sysUserRole)).getUserId()) || !ADD.equals(((SysUserRole)((Object)sysUserRole)).getAdminOption())) continue;
                addIds.remove(addIdsTemp.get(i));
            }
        }
        ArrayList<String> delNew = new ArrayList<String>();
        for (SysUserRole sysUserRole : se) {
            for (String del : hasDel) {
                if (!del.equals(sysUserRole.getUserId()) || DELETE.equals(sysUserRole.getAdminOption())) continue;
                delNew.add(del);
            }
        }
        Integer count = this.sysConfRolesMapper.selectCount((Wrapper)new QueryWrapper().eq((Object)"ROLE_ID", (Object)roleId));
        if (count > 0) {
            for (String userId : addIds) {
                List<String> rolesList = this.getRolesByUserId(userId);
                if (!rolesList.contains(roleId)) {
                    rolesList.add(roleId);
                }
                if (!this.isConfRolesService.isIncludeConfRole(rolesList.toArray(new String[rolesList.size()]))) continue;
                SysUsers user = (SysUsers)((Object)this.sysUsersMapper.selectById((Serializable)((Object)userId)));
                return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u4fee\u6539\u5931\u8d25\uff01\uff08" + user.getUserName() + " \u8fdd\u53cd\u4e86\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\u89c4\u5219\uff09");
            }
        }
        List auditList = this.sysUserroleAuditMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"ROLE_ID", (Object)roleId));
        String currentUser = ShiroKit.getUser().getId();
        Date currentDate = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        if (this.globalProperties.isRoleAudit() && this.globalProperties.isCriticalOperationsAudit()) {
            Object sysUserroleAudit;
            boolean exist;
            if (ToolUtil.isNotEmpty(addIds)) {
                for (String userId : addIds) {
                    exist = false;
                    for (SysUserroleAudit audit : auditList) {
                        if (!userId.equals(audit.getUserId())) continue;
                        exist = true;
                        audit.setOperationType(ADD);
                        audit.setStatus(UserRoleStatus.LOCKED.getCode());
                        audit.setLastTime(currentDate);
                        audit.setLastEditor(currentUser);
                        this.sysUserroleAuditService.update((Object)audit, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)userId)).eq((Object)"ROLE_ID", (Object)audit.getRoleId()));
                    }
                    if (exist) continue;
                    sysUserroleAudit = new SysUserroleAudit();
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setUserId(userId);
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setRoleId(roleId);
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setStatus(UserRoleStatus.LOCKED.getCode());
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setOperationType(ADD);
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setCreateTime(currentDate);
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setLastTime(currentDate);
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setCreator(currentUser);
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setLastEditor(currentUser);
                    this.sysUserroleAuditService.save(sysUserroleAudit);
                }
            }
            if (ToolUtil.isNotEmpty(delNew)) {
                for (String userId : delNew) {
                    exist = false;
                    for (SysUserroleAudit audit : auditList) {
                        if (!userId.equals(audit.getUserId())) continue;
                        exist = true;
                        audit.setOperationType(DELETE);
                        audit.setStatus(UserRoleStatus.LOCKED.getCode());
                        audit.setLastTime(currentDate);
                        audit.setLastEditor(currentUser);
                        this.sysUserroleAuditService.update((Object)audit, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)userId)).eq((Object)"ROLE_ID", (Object)audit.getRoleId()));
                    }
                    if (exist) continue;
                    sysUserroleAudit = new SysUserroleAudit();
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setUserId(userId);
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setRoleId(roleId);
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setStatus(UserRoleStatus.LOCKED.getCode());
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setOperationType(DELETE);
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setCreateTime(currentDate);
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setLastTime(currentDate);
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setCreator(currentUser);
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setLastEditor(currentUser);
                    this.sysUserroleAuditService.save(sysUserroleAudit);
                }
            }
            if (addIds.size() > 0 || delNew.size() > 0) {
                return new MessageTip("\u63d0\u4ea4\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
            }
        } else {
            if (ToolUtil.isNotEmpty(delNew)) {
                this.sysUserRoleMapper.delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"GRANTED_ROLE", (Object)roleId)).in((Object)"USER_ID", delNew));
                this.bpmAbstractPushMsgMatcher.deleteUserRole(delNew, null, null, roleId);
            }
            ArrayList<SysUserRole> userRoleList2 = new ArrayList<SysUserRole>();
            for (String userId : addIds) {
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(userId);
                sysUserRole.setGrantedRole(roleId);
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                sysUserRole.setCreateTime(currentDate);
                sysUserRole.setLastTime(currentDate);
                sysUserRole.setCreator(currentUser);
                sysUserRole.setLastEditor(currentUser);
                userRoleList2.add(sysUserRole);
                this.sysRolesService.delRedisAuthInfo(userId);
            }
            if (ToolUtil.isNotEmpty(userRoleList2)) {
                this.saveBatch(userRoleList2, userRoleList2.size());
                this.bpmAbstractPushMsgMatcher.pushUserRole(userRoleList2, "add");
            }
        }
        return new MessageTip("\u4fdd\u5b58\u6210\u529f\uff01");
    }
}

