/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.bsp.permit.dao.SysStruRoleAuditMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysStruRoleMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysStruRole;
import com.jxdinfo.hussar.bsp.permit.model.SysStruRoleAudit;
import com.jxdinfo.hussar.bsp.permit.service.ISysStruRoleAuditService;
import com.jxdinfo.hussar.bsp.permit.vo.SysStruRoleVo;
import com.jxdinfo.hussar.common.annotion.DataScope;
import com.jxdinfo.hussar.common.constant.state.StruRoleStatus;
import com.jxdinfo.hussar.common.entity.BaseEntity;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysStruRoleAuditServiceImpl
extends ServiceImpl<SysStruRoleAuditMapper, SysStruRoleAudit>
implements ISysStruRoleAuditService {
    @Resource
    private SysStruRoleAuditMapper sysStruRoleAuditMapper;
    @Resource
    private SysStruRoleMapper sysStruRoleMapper;
    private static final String ADD = "1";
    private static final String DELETE = "2";
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;

    @Override
    public Map<String, Object> getStruRoleReviewList(String page, String limit, String organName, String type) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        Page pages = new Page((long)Integer.valueOf(page).intValue(), (long)Integer.valueOf(limit).intValue());
        List<SysStruRoleVo> list = this.sysStruRoleAuditMapper.getStruRoleReviewList((Page<Map<String, Object>>)pages, organName, type);
        map.put("count", pages.getTotal());
        map.put("data", list);
        map.put("code", 0);
        return map;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void reviewSubmit(String struId, String roleId, String opsType) {
        String[] sids = struId.split(",");
        String[] rids = roleId.split(",");
        String[] oids = opsType.split(",");
        SysStruRoleAudit sysStruRoleAudit = new SysStruRoleAudit();
        sysStruRoleAudit.setLastTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        sysStruRoleAudit.setStatus(StruRoleStatus.OK.getCode());
        sysStruRoleAudit.setLastEditor(ShiroKit.getUser().getId());
        if (sids.length == rids.length && sids.length == oids.length && rids.length == oids.length) {
            ArrayList<SysStruRole> addBpmList = new ArrayList<SysStruRole>();
            ArrayList<SysStruRole> deleteBpmList = new ArrayList<SysStruRole>();
            for (int i = 0; i < sids.length; ++i) {
                SysStruRole sysStruRole;
                List list = this.sysStruRoleMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"stru_id", (Object)sids[i])).eq((Object)"granted_role", (Object)rids[i]));
                if (ToolUtil.isEmpty((Object)list)) {
                    sysStruRole = new SysStruRole();
                    sysStruRole.setCreateTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
                    sysStruRole.setLastTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
                    sysStruRole.setCreator(ShiroKit.getUser().getId());
                    sysStruRole.setLastEditor(ShiroKit.getUser().getId());
                    sysStruRole.setStruId(sids[i]);
                    sysStruRole.setGrantedRole(rids[i]);
                    if (ADD.equals(oids[i])) {
                        this.sysStruRoleMapper.insert((Object)sysStruRole);
                        addBpmList.add(sysStruRole);
                    }
                    if (DELETE.equals(oids[i])) {
                        deleteBpmList.add(sysStruRole);
                    }
                } else {
                    sysStruRole = new SysStruRole();
                    sysStruRole.setLastTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
                    sysStruRole.setCreator(ShiroKit.getUser().getId());
                    sysStruRole.setLastEditor(ShiroKit.getUser().getId());
                    sysStruRole.setStruId(sids[i]);
                    sysStruRole.setGrantedRole(rids[i]);
                    if (ADD.equals(oids[i])) {
                        this.sysStruRoleMapper.update((Object)sysStruRole, (Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"stru_id", (Object)sids[i])).eq((Object)"granted_role", (Object)rids[i]));
                        addBpmList.add(sysStruRole);
                    }
                    if (DELETE.equals(oids[i])) {
                        this.sysStruRoleMapper.delete((Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"stru_id", (Object)sids[i])).eq((Object)"granted_role", (Object)rids[i]));
                        deleteBpmList.add(sysStruRole);
                    }
                }
                this.sysStruRoleAuditMapper.update((Object)sysStruRoleAudit, (Wrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"STRU_ID", (Object)sids[i])).eq((Object)"role_id", (Object)rids[i])).eq((Object)"operation_type", (Object)oids[i]));
            }
            this.abstractPushMsgMatcher.insertOperation("struRole", "add", addBpmList, "");
            this.abstractPushMsgMatcher.insertOperation("struRole", "delete", deleteBpmList, "");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void refuseSubmit(String struId, String roleId, String opsType) {
        SysStruRoleAudit sysStruRoleAudit = new SysStruRoleAudit();
        sysStruRoleAudit.setLastTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        sysStruRoleAudit.setStatus(StruRoleStatus.REFUSE.getCode());
        this.sysStruRoleAuditMapper.update((Object)sysStruRoleAudit, (Wrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"stru_id", (Object)struId)).eq((Object)"role_id", (Object)roleId)).eq((Object)"operation_type", (Object)opsType));
    }

    @Override
    public int isDelete(String id) {
        return this.sysStruRoleAuditMapper.isDelete(id);
    }

    @Override
    @DataScope(deptAlias="t1.stru_id", userAlias="t1.creator")
    public Map<String, Object> getStruRoleReviewListByDataScope(String page, String limit, String organName, String type, BaseEntity baseEntity) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        Page pages = new Page((long)Integer.valueOf(page).intValue(), (long)Integer.valueOf(limit).intValue());
        List<SysStruRoleVo> list = this.sysStruRoleAuditMapper.getStruRoleReviewListByDataScope((Page<Map<String, Object>>)pages, organName, type, baseEntity.getDataScopeSql());
        map.put("count", pages.getTotal());
        map.put("data", list);
        map.put("code", 0);
        return map;
    }
}

