/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.bsp.organ.model.SysStru;
import com.jxdinfo.hussar.bsp.organ.service.ISysStruRuleService;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.organ.service.impl.SysEmployeeServiceImpl;
import com.jxdinfo.hussar.bsp.permit.dao.SysStruAssistOrganMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.bsp.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.factory.ShiroFactroy;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class SysStruAssistOrganImpl
extends ServiceImpl<SysStruAssistOrganMapper, SysStruAssistOrgan>
implements ISysStruAssistOrganService {
    @Resource
    SysStruAssistOrganMapper sysStruAssistOrganMapper;
    @Lazy
    @Resource
    SysOrgManageService sysOrgManageService;
    @Lazy
    @Resource
    ISysStruRuleService sysStruRuleService;
    @Lazy
    @Resource
    SysEmployeeServiceImpl sysEmployeeService;
    @Resource
    SysStruMapper sysStruMapper;

    @Override
    public Boolean saveAssistOrgan(String organIds, String struId) {
        String[] ids = organIds.split(",");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"stru_id", (Object)struId);
        int delete = this.sysStruAssistOrganMapper.delete((Wrapper)wrapper);
        if (ToolUtil.equals((Object)"", (Object)organIds)) {
            return true;
        }
        ArrayList<SysStruAssistOrgan> sysStruAssistOrganList = new ArrayList<SysStruAssistOrgan>();
        for (String organId : ids) {
            if (ToolUtil.isEmpty((Object)organId)) continue;
            SysStruAssistOrgan sysStruAssistOrgan = new SysStruAssistOrgan();
            sysStruAssistOrgan.setAssistParentId(organId);
            sysStruAssistOrgan.setStruId(struId);
            sysStruAssistOrgan.setCreateTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
            sysStruAssistOrgan.setLastTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
            sysStruAssistOrgan.setCreator(ShiroKit.getUser().getId());
            sysStruAssistOrgan.setLastEditor(ShiroKit.getUser().getId());
            sysStruAssistOrganList.add(sysStruAssistOrgan);
        }
        boolean b = this.saveBatch(sysStruAssistOrganList, sysStruAssistOrganList.size());
        return b;
    }

    @Override
    public List<JSTreeModel> getOrgTree(String isEmployee, String parentId) {
        ShiroUser shiroUser = ShiroKit.getUser();
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        Map<String, Object> map = ShiroFactroy.me().getDataScopeInfo(shiroUser);
        String dataScopeType = map.get("data_scope_type").toString();
        Set orgList = (Set)map.get("data_scope_list");
        if (isGradeAdmin) {
            String empolyeeId = shiroUser.getEmployeeId();
            String struLevel = this.sysEmployeeService.selectStruLevel(empolyeeId);
            level = Integer.parseInt(struLevel);
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId("11");
        root.setCode("11");
        root.setText("\u4eba\u5458\u7ec4\u7ec7\u673a\u6784");
        root.setIsLeaf("0");
        root.setParent("#");
        root.setStruLevel("0");
        root.setType("isRoot");
        root.setState(false, false, true);
        result.add(root);
        if (isGradeAdmin) {
            root.getState().put("gradeDisabled", true);
        }
        if (!"1".equals(dataScopeType)) {
            root.getState().put("dataScopeDisabled", true);
        }
        List<JSTreeModel> orgTree = this.sysStruAssistOrganMapper.getHNOrganTree(isEmployee);
        List<Object> orgTree1 = new ArrayList();
        List<String> list = this.sysStruRuleService.getAllowStaffOrganType();
        orgTree1 = isGradeAdmin ? this.sysOrgManageService.getGradeStruTree(orgTree, level) : ("1".equals(dataScopeType) ? orgTree : this.sysOrgManageService.getDataScopeTree(orgTree, dataScopeType, orgList));
        for (JSTreeModel jSTreeModel : orgTree1) {
            if (ToolUtil.equals((Object)parentId, (Object)jSTreeModel.getId())) {
                jSTreeModel.setState(false, false, true);
            }
            if (!list.contains(jSTreeModel.getType())) {
                jSTreeModel.setState(false, false, true);
            }
            List<String> parents = this.getParents(level);
            if (!isGradeAdmin || !parents.contains(jSTreeModel.getId())) continue;
            jSTreeModel.setState(false, false, true);
        }
        result.addAll(orgTree1);
        return result;
    }

    @Override
    public List<SysStruAssistOrgan> getAssistOrgan(String struId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"stru_id", (Object)struId);
        List assistOrgan = this.sysStruAssistOrganMapper.selectList((Wrapper)wrapper);
        return assistOrgan;
    }

    @Override
    public List<Map<String, Object>> getAllAssistOrgan(String struId) {
        return this.sysStruAssistOrganMapper.getAllAssistOrgan(struId);
    }

    @Override
    public List<SysStruAssistOrgan> getAssistOrganByParent(String struId) {
        List list = this.sysStruAssistOrganMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"assist_parent_id", (Object)struId));
        return list;
    }

    private List<String> getParents(Integer currentLevel) {
        ShiroUser shiroUser = ShiroKit.getUser();
        String currentStruId = shiroUser.getEmployeeId();
        String currentUserId = shiroUser.getId();
        String currentDeptId = shiroUser.getDeptId();
        String deptId = shiroUser.getDeptId();
        List<SysStru> list = this.sysStruMapper.getParentStruTree(currentLevel);
        List<SysStru> childList = this.sysStruMapper.getChildStruTree(currentLevel - 1);
        HashMap<String, String> idMap = new HashMap<String, String>();
        for (SysStru sysStru : list) {
            String id = sysStru.getStruId();
            String parentId = sysStru.getParentId();
            idMap.put(id, parentId);
        }
        String struId = currentStruId;
        String parentId = currentStruId;
        ArrayList<String> idList = new ArrayList<String>();
        do {
            struId = parentId;
            parentId = (String)idMap.get(struId);
            idList.add(struId);
        } while (idMap.containsKey(parentId));
        idList.remove(currentDeptId);
        return idList;
    }
}

