/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.bpm.messagepush.AbstractBpmPushMsgMatcher;
import com.jxdinfo.hussar.bsp.constant.Constants;
import com.jxdinfo.hussar.bsp.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.bsp.organ.model.SysStru;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.permit.dao.SysRoleGroupMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysRoleResourceMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysUserroleAuditMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.bsp.permit.model.SysRoleResource;
import com.jxdinfo.hussar.bsp.permit.model.SysRoles;
import com.jxdinfo.hussar.bsp.permit.model.vo.RoleInfoVO;
import com.jxdinfo.hussar.bsp.permit.service.ISysRoleDataScopeService;
import com.jxdinfo.hussar.bsp.permit.service.ISysRoleGroupService;
import com.jxdinfo.hussar.bsp.permit.service.ISysRolesService;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.util.DataExportUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SerializeUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSession;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysRolesServiceImpl
extends ServiceImpl<SysRolesMapper, SysRoles>
implements ISysRolesService {
    @Resource
    private SysRolesMapper sysRolesMapper;
    @Resource
    private SysRoleResourceMapper sysRoleResourceMapper;
    @Resource
    private SysUserroleAuditMapper auditMapper;
    @Resource
    private HussarCacheManager hussarCacheManager;
    @Resource
    private SysRoleGroupMapper sysRoleGroupMapper;
    @Resource
    private ISysRoleGroupService sysRoleGroupService;
    @Resource
    private SysOrgManageService sysOrgManageService;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private AbstractBpmPushMsgMatcher bpmAbstractPushMsgMatcher;
    @Resource
    private ISysRoleDataScopeService roleDataScopeService;

    @Override
    public String addRole(Map<String, String> map) {
        String roleName = map.get("roleName");
        String roleYw = map.get("roleYw");
        String checkNodeId = map.get("checkNodeId");
        boolean isOrganRoleAdd = Boolean.parseBoolean(map.get("isOrganRoleAdd"));
        SysRoles sysRoles = new SysRoles();
        sysRoles.setRoleId(null);
        sysRoles.setRoleName(roleName);
        sysRoles.setRoleAlias(roleYw);
        sysRoles.setIsSys("0");
        if (isOrganRoleAdd) {
            sysRoles.setCorporationId(checkNodeId);
            sysRoles.setGroupId(null);
        } else {
            sysRoles.setCorporationId("1");
            sysRoles.setGroupId(checkNodeId);
        }
        sysRoles.setCreateTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        sysRoles.setLastTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        sysRoles.setCreator(ShiroKit.getUser().getId());
        this.sysRolesMapper.insert((Object)sysRoles);
        this.bpmAbstractPushMsgMatcher.pushRole("add", sysRoles, null);
        return sysRoles.getRoleId();
    }

    @Override
    public boolean editRole(Map<String, String> map) {
        String roleId = map.get("roleId");
        String roleName = map.get("roleName");
        String roleYw = map.get("roleYw");
        SysRoles sysRoles = new SysRoles();
        sysRoles.setRoleId(roleId);
        sysRoles.setRoleName(roleName);
        sysRoles.setRoleAlias(roleYw);
        sysRoles.setLastTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        sysRoles.setLastEditor(ShiroKit.getUser().getId());
        int num = this.sysRolesMapper.updateById((Object)sysRoles);
        if (num == 0) {
            return false;
        }
        this.bpmAbstractPushMsgMatcher.pushRole("update", sysRoles, null);
        List<String> userIds = this.delCacheAuthInfo(sysRoles.getRoleId());
        for (String userId : userIds) {
            this.delRedisAuthInfo(userId);
        }
        return true;
    }

    @Override
    public Map<String, Object> getRoleViewMap(String id) {
        String[] idStr = id.split(",");
        HashMap<String, Object> map = new HashMap<String, Object>();
        List roleList = this.sysRolesMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"ROLE_ID", (Object)idStr[0]));
        map.put("roleMessage", roleList);
        if (roleList.size() == 1) {
            String groupId = ((SysRoles)((Object)roleList.get(0))).getGroupId();
            if (groupId != null) {
                List group = this.sysRoleGroupMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"GROUP_ID", (Object)((SysRoles)((Object)roleList.get(0))).getGroupId()));
                if (group != null) {
                    map.put("roleGroup", group);
                } else {
                    map.put("roleGroup", "");
                }
            } else {
                map.put("roleGroup", "");
            }
        }
        return map;
    }

    @Override
    public List<SysRoleResource> getRoleResource(String id) {
        String[] idStr = id.split(",");
        return new ArrayList<SysRoleResource>(this.sysRoleResourceMapper.selectList((Wrapper)new QueryWrapper().in((Object)"ROLE_ID", Arrays.asList(idStr))));
    }

    @Override
    public List<Object> getRoleView(String id) {
        String[] idStr = id.split(",");
        ArrayList<Object> list = new ArrayList<Object>();
        List roleList = this.sysRolesMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"ROLE_ID", (Object)idStr[0]));
        ArrayList resourceList = new ArrayList(this.sysRoleResourceMapper.selectList((Wrapper)new QueryWrapper().in((Object)"ROLE_ID", Arrays.asList(idStr))));
        list.add(roleList);
        list.add(resourceList);
        if (roleList.size() == 1) {
            String groupId = ((SysRoles)((Object)roleList.get(0))).getGroupId();
            if (groupId != null) {
                List gropu = this.sysRoleGroupMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"GROUP_ID", (Object)((SysRoles)((Object)roleList.get(0))).getGroupId()));
                if (gropu != null) {
                    list.add(gropu);
                } else {
                    list.add("");
                }
            } else {
                list.add("");
            }
        }
        return list;
    }

    @Override
    @Transactional(rollbackFor={SQLException.class})
    public boolean delRole(String id) {
        Integer num = this.sysRolesMapper.deleteById((Serializable)((Object)id));
        if (num == 0) {
            return false;
        }
        this.sysRoleResourceMapper.deleteById((Serializable)((Object)id));
        this.auditMapper.delete((Wrapper)new QueryWrapper().eq((Object)"ROLE_ID", (Object)id));
        this.bpmAbstractPushMsgMatcher.delete("role", id, null);
        this.bpmAbstractPushMsgMatcher.delete("userRole", id, "deleteByRoleId");
        return true;
    }

    @Override
    public List<String> delCacheAuthInfo(String roleId) {
        return this.sysRolesMapper.getUserIdByRoleId(roleId);
    }

    @Override
    @CacheEvict(value={"authorization_info"}, key="'shiro_authInfo:'+#userId")
    public void delRedisAuthInfo(String userId) {
        if (this.globalProperties.isTenantOpen()) {
            ShiroUser shiroUser = ShiroKit.getUser();
            String code = null;
            if (ToolUtil.isNotEmpty((Object)shiroUser)) {
                code = shiroUser.getConnName();
            }
            this.hussarCacheManager.delete("menu_info", "shiro_menus:" + userId + code);
        } else {
            this.hussarCacheManager.delete("menu_info", "shiro_menus:" + userId);
        }
    }

    @Override
    public List<JSTreeModel> getRoleTree() {
        return this.sysRoleGroupMapper.getRoleTree();
    }

    @Override
    public List<JSTreeModel> getLazyRoleTree(String nodeId) {
        List<JSTreeModel> jsTreeModels;
        if (nodeId.equals("#")) {
            jsTreeModels = this.sysRoleGroupMapper.getFirstRoleTree();
            JSTreeModel jsTreeModel = new JSTreeModel();
            jsTreeModel.setParent("#");
            jsTreeModel.setCode("GROUP");
            jsTreeModel.setText("\u89d2\u8272\u6811");
            jsTreeModel.setId("1");
            jsTreeModel.setType("isRoot");
            jsTreeModels.add(jsTreeModel);
        } else {
            jsTreeModels = this.sysRoleGroupMapper.getLazyRoleTree(nodeId);
        }
        return jsTreeModels;
    }

    @Override
    public List<JSTreeModel> loadRoleGroupTree() {
        ArrayList jsTreeModels = Lists.newArrayList();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setParent("#");
        jsTreeModel.setCode("GROUP");
        jsTreeModel.setText("\u89d2\u8272\u6811");
        jsTreeModel.setId("1");
        jsTreeModel.setType("isRoot");
        jsTreeModels.add(jsTreeModel);
        ShiroUser shiroUser = ShiroKit.getUser();
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            jsTreeModel.setId("11");
            String struLevel = this.sysStruMapper.selectStruLevel(shiroUser.getEmployeeId());
            int currentLevel = Integer.parseInt(struLevel);
            HashSet chooseStruId = Sets.newHashSet((Object[])new String[]{shiroUser.getEmployeeId()});
            List<SysStru> superiorList = this.sysStruMapper.getParentStruTree(currentLevel);
            HashSet ancestorStruIds = Sets.newHashSet((Object[])new String[]{shiroUser.getDeptId()});
            for (SysStru parentStru : superiorList) {
                if (!ancestorStruIds.contains(parentStru.getStruId())) continue;
                chooseStruId.add(parentStru.getStruId());
                ancestorStruIds.add(parentStru.getParentId());
            }
            List<SysStru> childStruList = this.sysStruMapper.getChildStruTree(currentLevel - 1);
            HashSet subStruIds = Sets.newHashSet((Object[])new String[]{shiroUser.getEmployeeId()});
            for (SysStru subStru : childStruList) {
                if (!subStruIds.contains(subStru.getParentId())) continue;
                chooseStruId.add(subStru.getStruId());
                subStruIds.add(subStru.getStruId());
            }
            List<JSTreeModel> gradAdminRoleTree = this.sysStruMapper.findOrganRoleTreeForGradeAdmin(new ArrayList<String>(chooseStruId));
            jsTreeModels.addAll(gradAdminRoleTree);
        } else {
            jsTreeModels.addAll(this.sysRoleGroupMapper.getRoleGroupTree());
        }
        return jsTreeModels;
    }

    @Override
    public List<JSTreeModel> getGroupOrderTree() {
        List<JSTreeModel> result = this.sysRoleGroupMapper.getGroupOrderTree();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setParent("#");
        jsTreeModel.setCode("GROUP");
        jsTreeModel.setText("\u89d2\u8272\u6811");
        jsTreeModel.setId("1");
        jsTreeModel.setType("isRoot");
        result.add(jsTreeModel);
        return result;
    }

    @Override
    public List<JSTreeModel> getRoleOrderTree(String parent) {
        List<Object> result = new ArrayList();
        if (ShiroKit.getUser().isGradeadmin()) {
            List<JSTreeModel> result1 = this.getLazyOrganRoleTree(parent, false);
            String parentId = parent;
            for (JSTreeModel jsTreeModel : result1) {
                String type = jsTreeModel.getType();
                if (!"ORGANROLE".equals(type)) continue;
                result.add(jsTreeModel);
                parentId = jsTreeModel.getParent();
            }
            JSTreeModel root = new JSTreeModel();
            root.setId(parentId);
            root.setCode("ORGANROLEROOT");
            root.setText("\u7ec4\u7ec7\u89d2\u8272\u6811");
            root.setParent("#");
            root.setType("ORGANROLEROOT");
            result.add(root);
        } else {
            result = this.sysRoleGroupMapper.getRoleOrderTree(parent);
            JSTreeModel root = new JSTreeModel();
            SysRoleGroup group = (SysRoleGroup)((Object)this.sysRoleGroupMapper.selectById((Serializable)((Object)parent)));
            if (ToolUtil.isNotEmpty((Object)((Object)group))) {
                root.setParent("#");
                root.setCode("GROUP");
                root.setText(group.getGroupName());
                root.setId(group.getGroupId());
                root.setType("GROUP");
            } else {
                root.setParent("#");
                root.setCode("GROUP");
                root.setText("\u89d2\u8272\u6811");
                root.setId("1");
                root.setType("isRoot");
            }
            result.add(root);
        }
        return result;
    }

    @Override
    public boolean saveGroupOrder(JSONArray treeArr) {
        ArrayList<SysRoleGroup> list = new ArrayList<SysRoleGroup>();
        for (int i = 0; i < treeArr.size(); ++i) {
            JSONObject json = treeArr.getJSONObject(i);
            String id = json.getString("id");
            String order = i + 1 + "";
            SysRoleGroup group = new SysRoleGroup();
            group.setGroupId(id);
            if (ToolUtil.isNotEmpty((Object)order)) {
                group.setGroupOrder(new BigDecimal(order));
            } else {
                group.setGroupOrder(new BigDecimal(1));
            }
            list.add(group);
        }
        this.bpmAbstractPushMsgMatcher.pushRoleSort(list, null);
        return ToolUtil.isNotEmpty(list) && this.sysRoleGroupService.updateBatchById(list, list.size());
    }

    @Override
    public boolean saveRoleOrder(JSONArray treeArr) {
        ArrayList<SysRoles> list = new ArrayList<SysRoles>();
        for (int i = 0; i < treeArr.size(); ++i) {
            JSONObject json = treeArr.getJSONObject(i);
            String id = json.getString("id");
            String order = i + 1 + "";
            SysRoles role = new SysRoles();
            role.setRoleId(id);
            if (ToolUtil.isNotEmpty((Object)order)) {
                role.setRoleOrder(new BigDecimal(order));
            } else {
                role.setRoleOrder(new BigDecimal(1));
            }
            list.add(role);
        }
        this.bpmAbstractPushMsgMatcher.pushRoleSort(null, list);
        return ToolUtil.isNotEmpty(list) && super.updateBatchById(list, list.size());
    }

    @Override
    public boolean saveGroup(String groupName, String checkId, String groupAlias) {
        SysRoleGroup sysRoleGroup = new SysRoleGroup();
        sysRoleGroup.setGroupId(null);
        sysRoleGroup.setGroupName(groupName);
        sysRoleGroup.setParentId(checkId);
        sysRoleGroup.setGroupAlias(groupAlias);
        sysRoleGroup.setCreateTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        sysRoleGroup.setCreator(ShiroKit.getUser().getId());
        int count = this.sysRoleGroupMapper.insert((Object)sysRoleGroup);
        if (count == 1) {
            this.bpmAbstractPushMsgMatcher.pushRole("add", null, sysRoleGroup);
            return true;
        }
        return false;
    }

    @Override
    public boolean editGroup(String groupName, String checkId, String groupAlias) {
        SysRoleGroup sysRoleGroup = new SysRoleGroup();
        sysRoleGroup.setGroupId(checkId);
        sysRoleGroup.setGroupName(groupName);
        sysRoleGroup.setGroupAlias(groupAlias);
        sysRoleGroup.setLastEditor(ShiroKit.getUser().getAccount());
        sysRoleGroup.setLastTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        int count = this.sysRoleGroupMapper.updateById((Object)sysRoleGroup);
        if (count == 1) {
            this.bpmAbstractPushMsgMatcher.pushRole("update", null, sysRoleGroup);
            return true;
        }
        return false;
    }

    @Override
    public List<JSTreeModel> getLazyOrganRoleTree(String nodeId, boolean isExport) {
        String parentId = nodeId;
        ShiroUser shiroUser = ShiroKit.getUser();
        String empolyeeId = shiroUser.getEmployeeId();
        int userLevel = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            String struLevel = this.sysStruMapper.selectStruLevel(empolyeeId);
            userLevel = Integer.parseInt(struLevel);
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setId("11");
        jsTreeModel.setCode("11");
        jsTreeModel.setText("\u7ec4\u7ec7\u89d2\u8272\u6811");
        jsTreeModel.setParent("#");
        jsTreeModel.setType("isRoot");
        if (isGradeAdmin) {
            jsTreeModel.getState().put("isOrganRoleTree", true);
            jsTreeModel.getState().put("gradeDisabled", true);
        }
        List<Object> list = new ArrayList();
        List<JSTreeModel> list1 = new ArrayList<JSTreeModel>();
        if (this.globalProperties.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)parentId)) {
            if (ToolUtil.equals((Object)"#", (Object)parentId)) {
                parentId = "11";
                result.add(jsTreeModel);
            }
            list1 = this.sysOrgManageService.geOrganRoleTree(parentId);
        } else {
            result.add(jsTreeModel);
        }
        if (isGradeAdmin) {
            list = this.sysOrgManageService.getGradeStruTree(list1, userLevel);
            for (JSTreeModel jSTreeModel : list) {
                jSTreeModel.getState().put("isOrganRoleTree", true);
            }
        } else {
            list = list1;
        }
        result.addAll(list);
        if (isExport) {
            for (JSTreeModel jSTreeModel : result) {
                String type = jSTreeModel.getType();
                if ("ORGANROLE".equals(type)) {
                    jSTreeModel.setState(false, false, false);
                    continue;
                }
                jSTreeModel.setState(false, false, true);
            }
        }
        return result;
    }

    @Override
    public void exportData(List<String> idList, HttpServletResponse response) {
        List roleGroups = this.sysRoleGroupMapper.selectBatchIds(idList);
        List roles = this.sysRolesMapper.selectBatchIds(idList);
        List roleResources = this.sysRoleResourceMapper.selectBatchIds(idList);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("roleGroups", roleGroups);
        data.put("roles", roles);
        data.put("roleResources", roleResources);
        data.put("export_type", "role");
        byte[] serializeData = SerializeUtils.serialize(data);
        String fileName = "role_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile(serializeData, fileName, response);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Tip importData(byte[] content) {
        Map data = (Map)SerializeUtils.deserialize((byte[])content);
        String export_type = (String)data.get("export_type");
        if (!"role".equals(export_type)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u60a8\u5bfc\u5165\u7684\u662f" + (String)Constants.EXPORT_MAP.get(export_type) + ",\u8bf7\u5bfc\u5165" + (String)Constants.EXPORT_MAP.get("role"));
        }
        List roleGroups = (List)data.get("roleGroups");
        List roles = (List)data.get("roles");
        List roleResources = (List)data.get("roleResources");
        Map<String, Integer> roleGroupsCount = this.insertOrUpdateList(roleGroups);
        Map<String, Integer> rolesCount = this.insertOrUpdateList(roles);
        Map<String, Integer> roleResourcesCount = this.insertOrUpdateList(roleResources);
        SuccessTip success = new SuccessTip();
        success.setMessage("\u5bfc\u5165\u6210\u529f\u3002\u89d2\u8272\u5206\u7ec4\u65b0\u589e\u6570\u636e" + roleGroupsCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + roleGroupsCount.get("update") + "\u6761\uff1b\u89d2\u8272\u65b0\u589e\u6570\u636e" + rolesCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + rolesCount.get("update") + "\u6761\uff1b\u89d2\u8272\u8d44\u6e90\u5173\u7cfb\u65b0\u589e\u6570\u636e" + roleResourcesCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + roleResourcesCount.get("update") + "\u6761\u3002");
        return success;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Map<String, String> importVueData(byte[] content) {
        Map data;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            data = (Map)SerializeUtils.deserialize((byte[])content);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.FILE_READING_ERROR);
        }
        if (ToolUtil.isEmpty((Object)data)) {
            map.put("success", "fileError");
            map.put("message", "\u5bfc\u5165\u6570\u636e\u6709\u8bef");
            map.put("import", "role");
            return map;
        }
        String export_type = (String)data.get("export_type");
        if (!"role".equals(export_type)) {
            map.put("success", "false");
            map.put("errorImport", export_type);
            map.put("import", "role");
            return map;
        }
        List roleGroups = (List)data.get("roleGroups");
        List roles = (List)data.get("roles");
        List roleResources = (List)data.get("roleResources");
        Map<String, Integer> roleGroupsCount = this.insertOrUpdateList(roleGroups);
        Map<String, Integer> rolesCount = this.insertOrUpdateList(roles);
        Map<String, Integer> roleResourcesCount = this.insertOrUpdateList(roleResources);
        map.put("success", "true");
        map.put("insertGroups", "" + roleGroupsCount.get("insert"));
        map.put("updateGroups", "" + roleGroupsCount.get("update"));
        map.put("insertRoles", "" + rolesCount.get("insert"));
        map.put("updateRoles", "" + rolesCount.get("update"));
        map.put("insertRoleResources", "" + roleResourcesCount.get("insert"));
        map.put("updateRoleResources", "" + roleResourcesCount.get("update"));
        return map;
    }

    @Override
    public List<JSTreeModel> getRoleTree(String nodeId, String userId, String functionType) {
        List<Object> result = new ArrayList();
        ShiroUser shiroUser = ShiroKit.getUser();
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            String roleId;
            String type;
            List<JSTreeModel> gradeAdminStruList = this.getLazyOrganRoleTree(nodeId, false);
            List<Object> rolesList = new ArrayList();
            if (userId != null) {
                rolesList = this.sysUserRoleMapper.getRolesByUserId(userId);
            }
            if ("view".equals(functionType)) {
                for (JSTreeModel jsTreeModel : gradeAdminStruList) {
                    type = jsTreeModel.getType();
                    if ("ORGANROLE".equals(type)) {
                        roleId = jsTreeModel.getId();
                        if (rolesList.contains(roleId)) {
                            jsTreeModel.setState(true, true, true);
                        } else {
                            jsTreeModel.setState(false, false, true);
                        }
                        result.add(jsTreeModel);
                        continue;
                    }
                    jsTreeModel.setState(false, false, true);
                    result.add(jsTreeModel);
                }
            }
            if ("edit".equals(functionType) || "add".equals(functionType)) {
                for (JSTreeModel jsTreeModel : gradeAdminStruList) {
                    type = jsTreeModel.getType();
                    if ("ORGANROLE".equals(type)) {
                        roleId = jsTreeModel.getId();
                        if (rolesList.contains(roleId)) {
                            jsTreeModel.setState(true, true, false);
                        } else {
                            jsTreeModel.setState(false, false, false);
                        }
                        result.add(jsTreeModel);
                        continue;
                    }
                    jsTreeModel.setState(false, false, true);
                    result.add(jsTreeModel);
                }
            }
        } else {
            result = this.getRoleTree();
            JSTreeModel jsTreeModel = new JSTreeModel();
            jsTreeModel.setParent("#");
            jsTreeModel.setCode("GROUP");
            jsTreeModel.setText("\u89d2\u8272\u6811");
            jsTreeModel.setId("1");
            jsTreeModel.setType("isRoot");
            result.add(jsTreeModel);
        }
        return result;
    }

    @Override
    public List<JSTreeModel> getSelfRoleTree(String[] roleIds) {
        List<JSTreeModel> tree = new ArrayList<JSTreeModel>();
        ShiroUser shiroUser = ShiroKit.getUser();
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (!isGradeAdmin) {
            List<JSTreeModel> result = this.orgMaintenanceService.selfRoleTree(roleIds);
            tree = this.doRecursive(result);
            for (JSTreeModel js : tree) {
                if (Arrays.asList(roleIds).contains(js.getId())) {
                    js.setState(true, true, true);
                    continue;
                }
                js.setState(false, false, true);
            }
        }
        return tree;
    }

    @Override
    public List<String> getUserRoleList(String userId) {
        return this.sysUserRoleMapper.getRolesByUserId(userId);
    }

    @Override
    public String getRoleDataScopeByUserId(Set<String> orgList, String userId) {
        List<String> roleIds = this.getUserRoleList(userId);
        String type = "";
        if (ToolUtil.isNotEmpty(roleIds)) {
            List roles = this.list((Wrapper)new QueryWrapper().in((Object)"role_id", roleIds));
            for (SysRoles role : roles) {
                String roleType = role.getDataScopeType();
                if (ToolUtil.isEmpty((Object)roleType)) continue;
                if (ToolUtil.isEmpty((Object)type)) {
                    type = roleType;
                }
                if (Long.parseLong(roleType) < Long.parseLong(type)) {
                    type = roleType;
                }
                if (!"5".equals(roleType)) continue;
                List<String> orgIds = this.roleDataScopeService.getOrgListByRoleId(role.getRoleId());
                orgList.addAll(orgIds);
            }
        }
        if (ToolUtil.isEmpty((Object)type)) {
            type = "1";
        }
        return type;
    }

    @Override
    public Map<String, Object> getRoleInfoList(Map<String, Object> queryParamMap, String roleGroupOrDepId) {
        int pageNo = queryParamMap.get("page") == null ? 1 : (Integer)queryParamMap.get("page");
        int limit = queryParamMap.get("limit") == null ? 20 : (Integer)queryParamMap.get("limit");
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        ShiroUser shiroUser = ShiroKit.getUser();
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            String roleName;
            Page roleInfoPage = new Page((long)pageNo, (long)limit);
            HashMap mapperQuery = Maps.newHashMap();
            mapperQuery.put("deptId", roleGroupOrDepId);
            String string = roleName = queryParamMap.get("roleName") == null ? "" : queryParamMap.get("roleName").toString().trim();
            if (StringUtils.isNotBlank((CharSequence)roleName)) {
                mapperQuery.put("roleName", roleName);
            }
            List<RoleInfoVO> roleInfoVOList = this.sysRolesMapper.findRoleList(roleInfoPage, mapperQuery);
            for (RoleInfoVO roleInfoVO : roleInfoVOList) {
                roleInfoVO.setRoleType("STRU_ROLE");
            }
            map.put("count", roleInfoPage.getTotal());
            map.put("data", roleInfoVOList);
        } else if ("1".equals(roleGroupOrDepId)) {
            String groupName;
            Page roleGroupPage = new Page((long)pageNo, (long)limit);
            QueryWrapper queryRoleCondition = (QueryWrapper)new QueryWrapper().eq((Object)"parent_id", (Object)roleGroupOrDepId);
            String string = groupName = queryParamMap.get("groupName") == null ? "" : queryParamMap.get("groupName").toString().trim();
            if (StringUtils.isNotBlank((CharSequence)groupName)) {
                queryRoleCondition.like((Object)"group_name", (Object)("%" + groupName + "%"));
            }
            queryRoleCondition.orderByAsc((Object)"groupOrder");
            this.sysRoleGroupMapper.selectPage((IPage)roleGroupPage, (Wrapper)queryRoleCondition);
            ArrayList fmtGroupDataList = Lists.newArrayList();
            for (SysRoleGroup roleGroup : roleGroupPage.getRecords()) {
                TreeMap roleGroupVO = Maps.newTreeMap();
                roleGroupVO.put("groupId", roleGroup.getGroupId());
                roleGroupVO.put("groupName", roleGroup.getGroupName());
                roleGroupVO.put("groupAlias", roleGroup.getGroupAlias());
                roleGroupVO.put("groupOrder", roleGroup.getGroupOrder());
                roleGroupVO.put("roleType", "GROUP");
                fmtGroupDataList.add(roleGroupVO);
            }
            map.put("count", roleGroupPage.getTotal());
            map.put("data", fmtGroupDataList);
        } else {
            String roleName;
            Page roleInfoPage = new Page((long)pageNo, (long)limit);
            HashMap mapperQuery = Maps.newHashMap();
            mapperQuery.put("roleGroupId", roleGroupOrDepId);
            String string = roleName = queryParamMap.get("roleName") == null ? "" : queryParamMap.get("roleName").toString().trim();
            if (StringUtils.isNotBlank((CharSequence)roleName)) {
                mapperQuery.put("roleName", roleName);
            }
            List<RoleInfoVO> roleInfoVOList = this.sysRolesMapper.findRoleList(roleInfoPage, mapperQuery);
            for (RoleInfoVO roleInfoVO : roleInfoVOList) {
                roleInfoVO.setRoleType("ROLE");
            }
            map.put("count", roleInfoPage.getTotal());
            map.put("data", roleInfoVOList);
        }
        map.put("code", 0);
        return map;
    }

    public List<JSTreeModel> doRecursive(List<JSTreeModel> list) {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        this.recursive(list, result, "");
        JSTreeModel model = new JSTreeModel();
        model.setId("1");
        model.setCode("GROUP");
        model.setParent("#");
        model.setText("\u89d2\u8272\u6811");
        model.setType("isRoot");
        result.add(model);
        return result;
    }

    public void recursive(List<JSTreeModel> list, List<JSTreeModel> result, String parentId) {
        String newParentId = parentId;
        for (int i = 0; i < list.size(); ++i) {
            JSTreeModel map = list.get(i);
            if (!"ROLE".equals(map.getCode()) && !newParentId.equals(map.getId())) continue;
            newParentId = map.getParent();
            result.add(map);
            list.remove(map);
            --i;
            this.recursive(list, result, newParentId);
        }
    }

    private Map<String, Integer> insertOrUpdateList(List<?> objects) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer update = 0;
        Integer insert = 0;
        if (CollectionUtils.isEmpty(objects)) {
            result.put("update", update);
            result.put("insert", insert);
            return result;
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = objects.size();
            for (int i = 0; i < size; ++i) {
                Integer n;
                Integer n2;
                Object obj = objects.get(i);
                if (obj instanceof SysRoles) {
                    SysRoles role = (SysRoles)((Object)obj);
                    if (this.updateById((Object)role)) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.save((Object)role);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (obj instanceof SysRoleGroup) {
                    SysRoleGroup roleGroup = (SysRoleGroup)((Object)obj);
                    if (SqlHelper.retBool((Integer)this.sysRoleGroupMapper.updateById((Object)roleGroup))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysRoleGroupMapper.insert((Object)roleGroup);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (obj instanceof SysRoleResource) {
                    SysRoleResource roleResource = (SysRoleResource)((Object)obj);
                    if (SqlHelper.retBool((Integer)this.sysRoleResourceMapper.update((Object)roleResource, (Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"ROLE_ID", (Object)roleResource.getRoleId())).eq((Object)"RESOURCE_ID", (Object)roleResource.getResourceId())))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysRoleResourceMapper.insert((Object)roleResource);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new MybatisPlusException("Error: Cannot execute insertOrUpdateBatch Method. Cause", e);
        }
        result.put("update", update);
        result.put("insert", insert);
        return result;
    }
}

