/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.permit.dao.SysRoleResourceMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysUserroleAuditMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysRoleResource;
import com.jxdinfo.hussar.bsp.permit.model.SysUserRole;
import com.jxdinfo.hussar.bsp.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.bsp.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.bsp.permit.service.ISysRolesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.bsp.permit.vo.SysRoleResourceVo;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysRoleResourceServiceImpl
extends ServiceImpl<SysRoleResourceMapper, SysRoleResource>
implements ISysRoleResourceService {
    @Resource
    private SysRoleResourceMapper sysRoleResourceMapper;
    @Resource
    private ISysUserroleAuditService sysUserroleAuditService;
    @Resource
    private SysUserroleAuditMapper sysUserroleAuditMapper;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private GlobalProperties globalProperties;
    private static final String ADD = "1";
    private static final String DELETE = "2";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveResource(String ids, String roId) {
        this.sysRoleResourceMapper.deleteById((Serializable)((Object)roId));
        String[] id = ids.split(",");
        ArrayList<SysRoleResource> sysRoleResourceList = new ArrayList<SysRoleResource>();
        for (String reId : id) {
            if (ToolUtil.isEmpty((Object)reId)) continue;
            SysRoleResource sysRoleResource = new SysRoleResource();
            sysRoleResource.setRoleId(roId);
            sysRoleResource.setCreateTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
            sysRoleResource.setCreator(ShiroKit.getUser().getId());
            sysRoleResource.setLastEditor(ShiroKit.getUser().getId());
            sysRoleResource.setLastTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
            sysRoleResource.setResourceId(reId);
            sysRoleResourceList.add(sysRoleResource);
        }
        if (ToolUtil.isNotEmpty(sysRoleResourceList)) {
            super.saveBatch(sysRoleResourceList, sysRoleResourceList.size());
        }
    }

    @Override
    public void reclaimPerm(String id) {
        this.sysRoleResourceMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    public List<SysRoleResource> queryPerm(String id) {
        List list = this.sysRoleResourceMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"ROLE_ID", (Object)id));
        return list;
    }

    @Override
    public void saveRoleUserAdd(List<String> userIds, String roleId) {
        String currentUser = ShiroKit.getUser().getId();
        Date currentDate = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isRoleAudit()) {
            ArrayList<SysUserroleAudit> sysUserroleAuditList = new ArrayList<SysUserroleAudit>();
            for (String userId : userIds) {
                SysUserroleAudit sysUserroleAudit = new SysUserroleAudit();
                sysUserroleAudit.setUserId(userId);
                sysUserroleAudit.setRoleId(roleId);
                sysUserroleAudit.setStatus(UserStatus.LOCKED.getCode());
                sysUserroleAudit.setCreator(currentUser);
                sysUserroleAudit.setCreateTime(currentDate);
                sysUserroleAudit.setLastEditor(currentUser);
                sysUserroleAudit.setLastTime(currentDate);
                sysUserroleAudit.setOperationType(ADD);
                sysUserroleAuditList.add(sysUserroleAudit);
            }
            if (ToolUtil.isNotEmpty(sysUserroleAuditList)) {
                this.sysUserroleAuditService.saveBatch(sysUserroleAuditList, sysUserroleAuditList.size());
            }
        } else {
            ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
            for (String userId : userIds) {
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(userId);
                sysUserRole.setGrantedRole(roleId);
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                sysUserRole.setCreateTime(currentDate);
                sysUserRole.setLastTime(currentDate);
                sysUserRole.setCreator(currentUser);
                sysUserRole.setLastEditor(currentUser);
                userRoleList.add(sysUserRole);
                this.sysRolesService.delRedisAuthInfo(userId);
            }
            if (ToolUtil.isNotEmpty(userRoleList)) {
                this.sysUserRoleService.saveBatch(userRoleList, userRoleList.size());
            }
        }
    }

    @Override
    public void saveRoleUserEdit(List<String> userIds, String roleId) {
        boolean exist;
        List userRoleList = this.sysUserRoleMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"GRANTED_ROLE", (Object)roleId)).eq((Object)"ADMIN_OPTION", (Object)Whether.YES.getValue()));
        List auditList = this.sysUserroleAuditMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"ROLE_ID", (Object)roleId));
        ArrayList<String> addList = new ArrayList<String>();
        ArrayList<String> delList = new ArrayList<String>();
        for (SysUserRole userRole : userRoleList) {
            exist = false;
            for (String userId : userIds) {
                if (ToolUtil.isEmpty((Object)userId) || !userId.equals(userRole.getUserId())) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            delList.add(userRole.getUserId());
        }
        for (String userId : userIds) {
            if (ToolUtil.isEmpty((Object)userId)) continue;
            exist = false;
            for (SysUserRole userRole : userRoleList) {
                if (!userRole.getUserId().equals(userId)) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            addList.add(userId);
        }
        String currentUser = ShiroKit.getUser().getId();
        Date currentDate = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isRoleAudit()) {
            Object sysUserroleAudit;
            if (ToolUtil.isNotEmpty(addList)) {
                for (String userId : addList) {
                    boolean exist2 = false;
                    for (SysUserroleAudit audit : auditList) {
                        if (!userId.equals(audit.getUserId())) continue;
                        exist2 = true;
                        audit.setOperationType(ADD);
                        audit.setStatus(UserRoleStatus.LOCKED.getCode());
                        audit.setLastTime(currentDate);
                        audit.setLastEditor(currentUser);
                        this.sysUserroleAuditService.update((Object)audit, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)userId)).eq((Object)"ROLE_ID", (Object)audit.getRoleId()));
                    }
                    if (exist2) continue;
                    sysUserroleAudit = new SysUserroleAudit();
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setUserId(userId);
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setRoleId(roleId);
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setStatus(UserRoleStatus.LOCKED.getCode());
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setOperationType(ADD);
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setCreateTime(currentDate);
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setLastTime(currentDate);
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setCreator(currentUser);
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setLastEditor(currentUser);
                    this.sysUserroleAuditService.save(sysUserroleAudit);
                }
            }
            if (ToolUtil.isNotEmpty(delList)) {
                for (String userId : delList) {
                    boolean exist3 = false;
                    for (SysUserroleAudit audit : auditList) {
                        if (!userId.equals(audit.getUserId())) continue;
                        exist3 = true;
                        audit.setOperationType(DELETE);
                        audit.setStatus(UserRoleStatus.LOCKED.getCode());
                        audit.setLastTime(currentDate);
                        audit.setLastEditor(currentUser);
                        this.sysUserroleAuditService.update((Object)audit, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)userId)).eq((Object)"ROLE_ID", (Object)audit.getRoleId()));
                    }
                    if (exist3) continue;
                    sysUserroleAudit = new SysUserroleAudit();
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setUserId(userId);
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setRoleId(roleId);
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setStatus(UserRoleStatus.LOCKED.getCode());
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setOperationType(DELETE);
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setCreateTime(currentDate);
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setLastTime(currentDate);
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setCreator(currentUser);
                    ((SysUserroleAudit)((Object)sysUserroleAudit)).setLastEditor(currentUser);
                    this.sysUserroleAuditService.save(sysUserroleAudit);
                }
            }
        } else {
            if (ToolUtil.isNotEmpty(delList)) {
                this.sysUserRoleMapper.delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"GRANTED_ROLE", (Object)roleId)).in((Object)"USER_ID", delList));
            }
            for (String userId : delList) {
                this.sysRolesService.delRedisAuthInfo(userId);
            }
            ArrayList<SysUserRole> userRoleList2 = new ArrayList<SysUserRole>();
            for (String userId : addList) {
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(userId);
                sysUserRole.setGrantedRole(roleId);
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                sysUserRole.setCreateTime(currentDate);
                sysUserRole.setLastTime(currentDate);
                sysUserRole.setCreator(currentUser);
                sysUserRole.setLastEditor(currentUser);
                userRoleList2.add(sysUserRole);
                this.sysRolesService.delRedisAuthInfo(userId);
            }
            if (ToolUtil.isNotEmpty(userRoleList2)) {
                this.sysUserRoleService.saveBatch(userRoleList2, userRoleList2.size());
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean resourceEditSaveRole(String resourceId, String[] roleIds) {
        boolean flag = false;
        this.remove((Wrapper)new QueryWrapper().eq((Object)"RESOURCE_ID", (Object)resourceId));
        Date currentDate = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        String currentUser = ShiroKit.getUser().getAccount();
        ArrayList<SysRoleResource> sysRoleResourceList = new ArrayList<SysRoleResource>();
        for (String roleId : roleIds) {
            if (ToolUtil.isEmpty((Object)roleId)) continue;
            SysRoleResource sysRoleResource = new SysRoleResource();
            sysRoleResource.setRoleId(roleId);
            sysRoleResource.setResourceId(resourceId);
            sysRoleResource.setCreateTime(currentDate);
            sysRoleResource.setCreator(currentUser);
            sysRoleResource.setLastEditor(currentUser);
            sysRoleResource.setLastTime(currentDate);
            sysRoleResourceList.add(sysRoleResource);
        }
        if (ToolUtil.isNotEmpty(sysRoleResourceList)) {
            flag = this.saveBatch(sysRoleResourceList, sysRoleResourceList.size());
        }
        return flag;
    }

    @Override
    public List<SysRoleResourceVo> checkResource(String roleId, String ids) {
        String[] resourceIds = ids.split(",");
        List<SysRoleResourceVo> voList = new ArrayList<SysRoleResourceVo>();
        if (this.globalProperties.isRoleResourceCheck()) {
            voList = ((SysRoleResourceMapper)this.baseMapper).checkResource(roleId, resourceIds).stream().collect(Collectors.groupingBy(SysRoleResourceVo::getResourceId)).entrySet().stream().map(stEntity -> {
                ArrayList roleIds = new ArrayList();
                ArrayList roleNames = new ArrayList();
                String resourceName = ((SysRoleResourceVo)((List)stEntity.getValue()).get(0)).getResourceName();
                ((List)stEntity.getValue()).stream().peek(st -> roleIds.add(st.getRoleId())).forEach(st -> roleNames.add(st.getRoleName()));
                SysRoleResourceVo sysRoleResourceVo = new SysRoleResourceVo();
                sysRoleResourceVo.setResourceId((String)stEntity.getKey());
                sysRoleResourceVo.setResourceName(resourceName);
                sysRoleResourceVo.setRoleId(String.join((CharSequence)",", roleIds));
                sysRoleResourceVo.setRoleName(String.join((CharSequence)",", roleNames));
                return sysRoleResourceVo;
            }).collect(Collectors.toList());
        }
        return voList;
    }
}

