/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.bsp.constant.Constants;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.permit.dao.SysFunctionsMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysModulesMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysRoleResourceMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysFunctions;
import com.jxdinfo.hussar.bsp.permit.model.SysModules;
import com.jxdinfo.hussar.bsp.permit.model.SysResources;
import com.jxdinfo.hussar.bsp.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.bsp.permit.service.ISysModulesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysResManageService;
import com.jxdinfo.hussar.bsp.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysStruResourcesService;
import com.jxdinfo.hussar.bsp.permit.vo.SysFunctionVO;
import com.jxdinfo.hussar.bsp.permit.vo.SysModuleVO;
import com.jxdinfo.hussar.bsp.permit.vo.SysResourcesVo;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.sys.service.ISysDicRefService;
import com.jxdinfo.hussar.core.util.DataExportUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SerializeUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysResManageServiceImpl
implements ISysResManageService {
    @Resource
    private SysResourcesMapper sysResourcesMapper;
    @Resource
    private SysModulesMapper sysModulesMapper;
    @Resource
    private SysFunctionsMapper sysFunctionsMapper;
    @Resource
    private SysRoleResourceMapper sysRoleResourceMapper;
    @Resource
    private ISysModulesService sysModulesService;
    @Resource
    private ISysFunctionsService sysFunctionsService;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private ISysStruResourcesService sysStruResourcesService;
    @Resource
    private ISysModulesService iSysModulesService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private GlobalProperties globalProperties;

    @Override
    public List<JSTreeModel> getResTree() {
        return this.sysModulesMapper.getModulesTree();
    }

    @Override
    public SysModules getModuleInfoById(String moduleId) {
        return this.sysModulesMapper.getModuleInfoById(moduleId);
    }

    @Override
    public Integer moduleSave(SysModules sysModules) {
        int count;
        Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        String userId = "";
        if (sysModules.getCreator() != null && "godaxe".equals(sysModules.getCreator())) {
            userId = sysModules.getCreator();
        } else if (ToolUtil.isNotEmpty((Object)ShiroKit.getUser())) {
            userId = ShiroKit.getUser().getId();
        }
        if (ToolUtil.isEmpty((Object)sysModules.getModuleId())) {
            sysModules.setModuleId(null);
            Long max = this.sysModulesMapper.getMaxOrderByParentId(sysModules.getParentModuleId());
            if (ToolUtil.isNotEmpty((Object)max)) {
                BigDecimal num = new BigDecimal(1);
                BigDecimal order = BigDecimal.valueOf(max);
                sysModules.setSeq(order.add(num));
            } else {
                sysModules.setSeq(new BigDecimal(1));
            }
            sysModules.setCreateTime(date);
            sysModules.setCreator(userId);
            count = this.sysModulesMapper.insert((Object)sysModules);
        } else {
            sysModules.setLastTime(date);
            sysModules.setLastEditor(userId);
            count = this.sysModulesMapper.updateById((Object)sysModules);
        }
        return count;
    }

    @Override
    public List<JSTreeModel> moduleTreeById(String moduleId) {
        return this.sysModulesMapper.moduleTreeById(moduleId);
    }

    @Override
    public Integer functionSave(SysFunctions sysFunctions) {
        int count;
        Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        String userId = "";
        if (sysFunctions.getCreator() != null && "godaxe".equals(sysFunctions.getCreator())) {
            userId = sysFunctions.getCreator();
        } else if (ToolUtil.isNotEmpty((Object)ShiroKit.getUser())) {
            userId = ShiroKit.getUser().getId();
        }
        if (ToolUtil.isEmpty((Object)sysFunctions.getFunctionId())) {
            sysFunctions.setFunctionId(null);
            Long max = this.sysFunctionsMapper.getMaxOrderByParentId(sysFunctions.getModuleId());
            if (ToolUtil.isNotEmpty((Object)max)) {
                BigDecimal num = new BigDecimal(1);
                BigDecimal order = BigDecimal.valueOf(max);
                sysFunctions.setSeq(order.add(num));
            } else {
                sysFunctions.setSeq(new BigDecimal(1));
            }
            sysFunctions.setCreateTime(date);
            sysFunctions.setCreator(userId);
            count = this.sysFunctionsMapper.insert((Object)sysFunctions);
        } else {
            sysFunctions.setLastTime(date);
            sysFunctions.setLastEditor(userId);
            count = this.sysFunctionsMapper.updateById((Object)sysFunctions);
        }
        return count;
    }

    @Override
    public SysFunctions getFunctionInfoById(String functionId) {
        return this.sysFunctionsMapper.getFunctionInfoById(functionId);
    }

    @Override
    public String resourceSave(SysResources sysResources) {
        Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        String userId = "";
        if (sysResources.getCreator() != null && "godaxe".equals(sysResources.getCreator())) {
            userId = sysResources.getCreator();
        } else if (ToolUtil.isNotEmpty((Object)ShiroKit.getUser())) {
            userId = ShiroKit.getUser().getId();
        }
        if (ToolUtil.isEmpty((Object)sysResources.getResourceId())) {
            sysResources.setResourceId(null);
            Long max = this.sysResourcesMapper.getMaxOrderByParentId(sysResources.getFunctionId());
            if (ToolUtil.isNotEmpty((Object)max)) {
                BigDecimal num = new BigDecimal(1);
                BigDecimal order = BigDecimal.valueOf(max);
                sysResources.setSeq(order.add(num));
            } else {
                sysResources.setSeq(new BigDecimal(1));
            }
            sysResources.setCreateTime(date);
            sysResources.setCreator(userId);
            this.sysResourcesMapper.insert((Object)sysResources);
        } else {
            sysResources.setLastTime(date);
            sysResources.setLastEditor(userId);
            this.sysResourcesMapper.updateById((Object)sysResources);
        }
        return sysResources.getResourceId();
    }

    @Override
    public SysResources getResourceInfoById(String resourceId) {
        return this.sysResourcesMapper.getResourceInfoById(resourceId);
    }

    @Override
    public JSONObject delModule(String moduleId) {
        List<Map<String, Object>> modulesResult = this.sysModulesMapper.getModulesByParentId(moduleId);
        List<Map<String, Object>> functionsResult = this.sysFunctionsMapper.getFunctionsByModuleId(moduleId);
        boolean isDel = true;
        if (ToolUtil.isNotEmpty(modulesResult) || ToolUtil.isNotEmpty(functionsResult)) {
            isDel = false;
        }
        if (isDel) {
            this.sysModulesMapper.deleteById((Serializable)((Object)moduleId));
        }
        JSONObject json = new JSONObject();
        json.put("success", (Object)isDel);
        return json;
    }

    @Override
    public JSONObject delFunction(String functionId) {
        List<Map<String, Object>> resourcesResult = this.sysResourcesMapper.getResourcesByFunctionId(functionId);
        boolean isDel = true;
        if (ToolUtil.isNotEmpty(resourcesResult)) {
            isDel = false;
        }
        if (isDel) {
            this.sysFunctionsMapper.deleteById((Serializable)((Object)functionId));
        }
        JSONObject json = new JSONObject();
        json.put("success", (Object)isDel);
        return json;
    }

    @Override
    public JSONObject delResource(String resourceId) {
        List<Map<String, Object>> roleResourcesResult = this.sysRoleResourceMapper.getRoleResourceByResourceId(resourceId);
        boolean isDel = true;
        if (ToolUtil.isNotEmpty(roleResourcesResult)) {
            isDel = false;
        }
        if (isDel) {
            this.sysResourcesMapper.deleteById((Serializable)((Object)resourceId));
        }
        JSONObject json = new JSONObject();
        json.put("success", (Object)isDel);
        return json;
    }

    @Override
    public void saveModuleTreeOrder(JSONArray treeArr) {
        ArrayList<SysModules> sysModulesList = new ArrayList<SysModules>();
        for (int i = 0; i < treeArr.size(); ++i) {
            JSONObject json = treeArr.getJSONObject(i);
            String id = json.getString("id");
            String order = json.getString("seq");
            SysModules sysModules = new SysModules();
            sysModules.setModuleId(id);
            sysModules.setSeq(new BigDecimal(order));
            sysModulesList.add(sysModules);
        }
        if (ToolUtil.isNotEmpty(sysModulesList)) {
            this.sysModulesService.updateBatchById(sysModulesList, sysModulesList.size());
        }
    }

    @Override
    public List<JSTreeModel> functionTreeByModuleId(String moduleId) {
        return this.sysFunctionsMapper.functionTreeByModuleId(moduleId);
    }

    @Override
    public void saveFunctionTreeOrder(JSONArray treeArr) {
        ArrayList<SysFunctions> sysFunctionsList = new ArrayList<SysFunctions>();
        for (int i = 0; i < treeArr.size(); ++i) {
            JSONObject json = treeArr.getJSONObject(i);
            String id = json.getString("id");
            String order = json.getString("seq");
            SysFunctions sysFunctions = new SysFunctions();
            sysFunctions.setFunctionId(id);
            sysFunctions.setSeq(new BigDecimal(order));
            sysFunctionsList.add(sysFunctions);
        }
        if (ToolUtil.isNotEmpty(sysFunctionsList)) {
            this.sysFunctionsService.updateBatchById(sysFunctionsList, sysFunctionsList.size());
        }
    }

    @Override
    public List<JSTreeModel> resourceTreeByModuleId(String functionId) {
        return this.sysResourcesMapper.resourceTreeByModuleId(functionId);
    }

    @Override
    public boolean saveResourceTreeOrder(JSONArray treeArr) {
        ArrayList<SysResources> sysResourcesList = new ArrayList<SysResources>();
        boolean flag = false;
        for (int i = 0; i < treeArr.size(); ++i) {
            JSONObject json = treeArr.getJSONObject(i);
            String id = json.getString("id");
            String order = json.getString("seq");
            SysResources sysResources = new SysResources();
            sysResources.setResourceId(id);
            sysResources.setSeq(new BigDecimal(order));
            sysResourcesList.add(sysResources);
        }
        if (ToolUtil.isNotEmpty(sysResourcesList)) {
            flag = this.sysResourcesService.updateBatchById(sysResourcesList, sysResourcesList.size());
        }
        return flag;
    }

    @Override
    public List<JSTreeModel> moduleChangeById(String moduleId, String isLeaf) {
        return this.sysModulesMapper.moduleChangeTreeById(moduleId, isLeaf);
    }

    @Override
    public void functionTreeChange(String functionId, String parentId) {
        Long max = this.sysFunctionsMapper.getMaxOrderByParentId(parentId);
        BigDecimal order = new BigDecimal(1);
        if (ToolUtil.isNotEmpty((Object)max)) {
            BigDecimal num = new BigDecimal(1);
            order = BigDecimal.valueOf(max);
            order = order.add(num);
        }
        this.sysFunctionsMapper.functionTreeChange(functionId, parentId, order);
    }

    @Override
    public List<JSTreeModel> resourceChangeById(String resourceId) {
        return this.sysFunctionsMapper.resourceChangeById(resourceId);
    }

    @Override
    public void resourceTreeChange(String resourceId, String parentId) {
        Long max = this.sysResourcesMapper.getMaxOrderByParentId(parentId);
        BigDecimal order = new BigDecimal(1);
        if (ToolUtil.isNotEmpty((Object)max)) {
            BigDecimal num = new BigDecimal(1);
            order = BigDecimal.valueOf(max);
            order = order.add(num);
        }
        this.sysResourcesMapper.resourceTreeChange(resourceId, parentId, order);
    }

    @Override
    public void moduleTreeChange(String moduleId, String parentId) {
        Long max = this.sysModulesMapper.getMaxOrderByParentId(parentId);
        BigDecimal order = new BigDecimal(1);
        if (ToolUtil.isNotEmpty((Object)max)) {
            BigDecimal num = new BigDecimal(1);
            order = BigDecimal.valueOf(max);
            order = order.add(num);
        }
        this.sysModulesMapper.moduleTreeChange(moduleId, parentId, order);
    }

    @Override
    public List<JSTreeModel> selfResourceTree(String[] rsourceIds) {
        return this.sysResourcesMapper.selfResourceTree(rsourceIds);
    }

    @Override
    public SysModules getModuleById(String moduleId) {
        return (SysModules)((Object)this.sysModulesMapper.selectById((Serializable)((Object)moduleId)));
    }

    @Override
    public SysFunctions getFunctionById(String functionId) {
        return (SysFunctions)((Object)this.sysFunctionsMapper.selectById((Serializable)((Object)functionId)));
    }

    @Override
    public List<JSTreeModel> getMenuResTree(String resType) {
        return this.sysModulesMapper.getMenuModulesTree(resType);
    }

    @Override
    public boolean isAllowEditModule(SysModules sysModules) {
        boolean flag = false;
        List<Map<String, Object>> modulesResult = this.sysModulesMapper.getModulesByParentId(sysModules.getModuleId());
        List<Map<String, Object>> functionsResult = this.sysFunctionsMapper.getFunctionsByModuleId(sysModules.getModuleId());
        SysModules oldModule = this.sysModulesMapper.getModuleInfoById(sysModules.getModuleId());
        if (oldModule.getIsLeaf().equals(sysModules.getIsLeaf())) {
            flag = true;
        } else if (ToolUtil.isEmpty(modulesResult) && ToolUtil.isEmpty(functionsResult)) {
            flag = true;
        }
        return flag;
    }

    @Override
    public List<JSTreeModel> getMoudleAndFunctionTree(String parentId) {
        return this.sysModulesMapper.getLazyLoadModulesTree(parentId);
    }

    @Override
    public List<JSTreeModel> getFunctionAndResTree(String nodeId) {
        return this.sysModulesMapper.getFunctionAndResTree(nodeId);
    }

    @Override
    public void exportRes(List<String> idList, HttpServletResponse response) {
        List modules = this.sysModulesMapper.selectBatchIds(idList);
        List functions = this.sysFunctionsMapper.selectBatchIds(idList);
        List resources = this.sysResourcesMapper.selectBatchIds(idList);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("modules", modules);
        data.put("functions", functions);
        data.put("resources", resources);
        data.put("export_type", "resource");
        byte[] serializeData = SerializeUtils.serialize(data);
        String fileName = "resource_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile(serializeData, fileName, response);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Tip importRes(byte[] content) {
        Map data = (Map)SerializeUtils.deserialize((byte[])content);
        String export_type = (String)data.get("export_type");
        if (!"resource".equals(export_type)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u60a8\u5bfc\u5165\u7684\u662f" + (String)Constants.EXPORT_MAP.get(export_type) + ",\u8bf7\u5bfc\u5165" + (String)Constants.EXPORT_MAP.get("resource"));
        }
        List modules = (List)data.get("modules");
        List functions = (List)data.get("functions");
        List resources = (List)data.get("resources");
        Map<String, Integer> moduleCount = this.sysModulesService.insertOrUpdateList(modules);
        Map<String, Integer> functionCount = this.sysFunctionsService.insertOrUpdateList(functions);
        Map<String, Integer> resourceCount = this.sysResourcesService.insertOrUpdateList(resources);
        SuccessTip success = new SuccessTip();
        success.setMessage("\u5bfc\u5165\u6210\u529f\u3002\u6a21\u5757\u65b0\u589e\u6570\u636e" + moduleCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + moduleCount.get("update") + "\u6761\uff1b\u529f\u80fd\u65b0\u589e\u6570\u636e" + functionCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + functionCount.get("update") + "\u6761\uff1b\u8d44\u6e90\u65b0\u589e\u6570\u636e" + resourceCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + resourceCount.get("update") + "\u6761\u3002");
        return success;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Map<String, String> importVueRes(byte[] content) {
        Map data;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            data = (Map)SerializeUtils.deserialize((byte[])content);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.FILE_READING_ERROR);
        }
        if (ToolUtil.isEmpty((Object)data)) {
            map.put("success", "fileError");
            map.put("message", "\u5bfc\u5165\u6570\u636e\u6709\u8bef");
            map.put("import", "resource");
            return map;
        }
        String export_type = (String)data.get("export_type");
        if (!"resource".equals(export_type)) {
            map.put("success", "false");
            map.put("errorImport", export_type);
            map.put("import", "resource");
            return map;
        }
        List modules = (List)data.get("modules");
        List functions = (List)data.get("functions");
        List resources = (List)data.get("resources");
        Map<String, Integer> moduleCount = this.sysModulesService.insertOrUpdateList(modules);
        Map<String, Integer> functionCount = this.sysFunctionsService.insertOrUpdateList(functions);
        Map<String, Integer> resourceCount = this.sysResourcesService.insertOrUpdateList(resources);
        map.put("success", "true");
        map.put("moduleInsert", "" + moduleCount.get("insert"));
        map.put("moduleUpdate", "" + moduleCount.get("update"));
        map.put("functionInsert", "" + functionCount.get("insert"));
        map.put("functionUpdate", "" + functionCount.get("update"));
        map.put("resourceInsert", "" + resourceCount.get("insert"));
        map.put("resourceUpdate", "" + resourceCount.get("update"));
        return map;
    }

    @Override
    public List<JSTreeModel> getFunResource(String type, String nodeId, String leaf, String nodeType) {
        List<JSTreeModel> list1;
        String gradeParentId;
        String newNodeId = nodeId;
        ShiroUser shiroUser = ShiroKit.getUser();
        String struId = "";
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            struId = shiroUser.getEmployeeId();
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId("1");
        root.setCode("1");
        root.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
        root.setParent("#");
        root.setIsLeaf("0");
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        if (isGradeAdmin) {
            root.getState().put("gradeDisabled", true);
        }
        List<Object> resourceIdList = new ArrayList();
        ArrayList<String> functionIdList = new ArrayList<String>();
        ArrayList<SysModules> moduleIdList = new ArrayList<SysModules>();
        ArrayList<String> moduleIdList1 = new ArrayList<String>();
        ArrayList<Object> list = new ArrayList<Object>();
        if (isGradeAdmin && (resourceIdList = this.sysStruResourcesService.getResIdList(gradeParentId = this.orgMaintenanceService.getOneOrg(struId).getId())).size() > 0) {
            functionIdList.addAll(this.sysStruResourcesService.getFunId(resourceIdList));
            List<SysModules> leafModules = this.sysStruResourcesService.getGradeAdminModuleId(functionIdList);
            moduleIdList.addAll(leafModules);
            ArrayList<String> tmpModuleIds = new ArrayList<String>();
            tmpModuleIds.clear();
            for (SysModules sysModules : leafModules) {
                String parentId = sysModules.getParentModuleId();
                if ("1".equals(parentId)) continue;
                tmpModuleIds.add(parentId);
            }
            List<SysModules> parentModules = this.iSysModulesService.getParentModuleTree(tmpModuleIds);
            moduleIdList.addAll(parentModules);
            for (SysModules sysModules : moduleIdList) {
                String moduleId = sysModules.getModuleId();
                if (moduleIdList1.contains(moduleId)) continue;
                moduleIdList1.add(moduleId);
            }
            list.addAll(resourceIdList);
            list.addAll(functionIdList);
            list.addAll(moduleIdList1);
        }
        if ("menuRes".equals(type)) {
            String resType = this.sysDicRefService.getDictValue("res_type", "\u83dc\u5355\u8d44\u6e90");
            list1 = this.getMenuResTree(resType);
            result.add(root);
        } else if (this.globalProperties.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)newNodeId)) {
            boolean isFunAndRes;
            boolean isModule = ToolUtil.equals((Object)"isModule", (Object)nodeType);
            boolean isLeaf = ToolUtil.equals((Object)"1", (Object)leaf);
            boolean isFun = ToolUtil.equals((Object)"isFun", (Object)nodeType);
            boolean bl = isFunAndRes = isModule && isLeaf || isFun;
            if (ToolUtil.equals((Object)"#", (Object)newNodeId)) {
                newNodeId = "1";
                result.add(root);
                list1 = this.getMoudleAndFunctionTree(newNodeId);
            } else {
                list1 = isModule && !isLeaf ? this.getMoudleAndFunctionTree(newNodeId) : (isFunAndRes ? this.getFunctionAndResTree(newNodeId) : new ArrayList<JSTreeModel>());
            }
        } else {
            list1 = this.getResTree();
            result.add(root);
        }
        if (isGradeAdmin) {
            for (JSTreeModel model : list1) {
                String id = model.getId();
                if (!list.contains(id)) continue;
                model.getState().put("gradeDisabled", true);
                result.add(model);
            }
        } else {
            result.addAll(list1);
        }
        for (JSTreeModel model : result) {
            String isLeaf = model.getIsLeaf();
            String isModule = model.getType();
            if (!"isModule".equals(isModule) || !"0".equals(isLeaf)) continue;
            model.getState().put("notLeafModule", true);
        }
        return result;
    }

    @Override
    public List<JSTreeModel> getResFunTree(String parentNodeId, String isLeafModule, String nodeType) {
        String struId;
        String gradeParentId;
        List<String> resourceIdList;
        ShiroUser shiroUser = ShiroKit.getUser();
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        JSTreeModel rootNode = new JSTreeModel();
        rootNode.setId("1");
        rootNode.setCode("1");
        rootNode.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
        rootNode.setParent("#");
        rootNode.setIsLeaf("0");
        rootNode.setIsModule("1");
        rootNode.setType("isRoot");
        rootNode.setConstant("0");
        if (isGradeAdmin) {
            rootNode.getState().put("gradeDisabled", true);
        }
        boolean leafModuleYes = ToolUtil.equals((Object)"1", (Object)isLeafModule);
        boolean funModuleYes = ToolUtil.equals((Object)"isModule", (Object)nodeType);
        HashSet gradeRefFunModuleIds = Sets.newHashSet();
        if (isGradeAdmin && (resourceIdList = this.sysStruResourcesService.getResIdList(gradeParentId = this.orgMaintenanceService.getOneOrg(struId = shiroUser.getEmployeeId()).getId())).size() > 0) {
            List<String> functionIdList = this.sysStruResourcesService.getFunId(resourceIdList);
            gradeRefFunModuleIds.addAll(functionIdList);
            if (!leafModuleYes) {
                List<SysModules> leafModules = this.sysStruResourcesService.getGradeAdminModuleId(functionIdList);
                List moduleIdList = leafModules.stream().map(SysModules::getModuleId).collect(Collectors.toList());
                gradeRefFunModuleIds.addAll(moduleIdList);
                ArrayList tmpModuleIds = Lists.newArrayList();
                tmpModuleIds.clear();
                for (SysModules sysModules : leafModules) {
                    String parentId = sysModules.getParentModuleId();
                    if ("1".equals(parentId)) continue;
                    tmpModuleIds.add(parentId);
                }
                List<SysModules> parentModules = this.iSysModulesService.getParentModuleTree(tmpModuleIds);
                gradeRefFunModuleIds.addAll(parentModules.stream().map(SysModules::getModuleId).collect(Collectors.toSet()));
            }
        }
        ArrayList<JSTreeModel> treeNodeResult = new ArrayList<JSTreeModel>();
        List<Object> lazyTreeNodeList = Lists.newArrayList();
        if (this.globalProperties.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)parentNodeId)) {
            if (ToolUtil.equals((Object)"#", (Object)parentNodeId)) {
                parentNodeId = "1";
                treeNodeResult.add(rootNode);
                lazyTreeNodeList = this.getMoudleAndFunctionTree(parentNodeId);
            } else {
                lazyTreeNodeList = funModuleYes && !leafModuleYes ? this.getMoudleAndFunctionTree(parentNodeId) : (funModuleYes && leafModuleYes ? this.sysFunctionsMapper.functionTreeByModuleId(parentNodeId) : new ArrayList());
            }
        }
        if (isGradeAdmin) {
            for (JSTreeModel model : lazyTreeNodeList) {
                String moduleOrFunId = model.getId();
                if (!gradeRefFunModuleIds.contains(moduleOrFunId)) continue;
                model.getState().put("gradeDisabled", true);
                treeNodeResult.add(model);
            }
        } else {
            treeNodeResult.addAll(lazyTreeNodeList);
        }
        for (JSTreeModel model : treeNodeResult) {
            String isLeaf = model.getIsLeaf();
            String isModule = model.getType();
            if ("isModule".equals(isModule) && "0".equals(isLeaf)) {
                model.getState().put("notLeafModule", true);
            }
            if (!"isFun".equals(isModule)) continue;
            model.setChildren("false");
        }
        return treeNodeResult;
    }

    @Override
    public List<JSTreeModel> getEditResTree() {
        Iterator gradeParentId;
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        List<JSTreeModel> list1 = this.getResTree();
        ShiroUser shiroUser = ShiroKit.getUser();
        String struId = "";
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            struId = shiroUser.getEmployeeId();
        }
        List<Object> resourceIdList = new ArrayList();
        ArrayList<String> functionIdList = new ArrayList<String>();
        ArrayList<SysModules> moduleIdList = new ArrayList<SysModules>();
        ArrayList<String> moduleIdList1 = new ArrayList<String>();
        ArrayList<Object> list = new ArrayList<Object>();
        if (isGradeAdmin && (resourceIdList = this.sysStruResourcesService.getResIdList((String)((Object)(gradeParentId = this.orgMaintenanceService.getOneOrg(struId).getId())))).size() > 0) {
            functionIdList.addAll(this.sysStruResourcesService.getFunId(resourceIdList));
            List<SysModules> leafModules = this.sysStruResourcesService.getGradeAdminModuleId(functionIdList);
            moduleIdList.addAll(leafModules);
            ArrayList<String> tmpModuleIds = new ArrayList<String>();
            tmpModuleIds.clear();
            for (SysModules sysModules : leafModules) {
                String parentId = sysModules.getParentModuleId();
                if ("1".equals(parentId)) continue;
                tmpModuleIds.add(parentId);
            }
            List<SysModules> parentModules = this.iSysModulesService.getParentModuleTree(tmpModuleIds);
            moduleIdList.addAll(parentModules);
            for (SysModules sysModules : moduleIdList) {
                String moduleId = sysModules.getModuleId();
                if (moduleIdList1.contains(moduleId)) continue;
                moduleIdList1.add(moduleId);
            }
            list.addAll(resourceIdList);
            list.addAll(functionIdList);
            list.addAll(moduleIdList1);
        }
        if (isGradeAdmin) {
            for (JSTreeModel model : list1) {
                String id = model.getId();
                if (!list.contains(id)) continue;
                model.getState().put("gradeDisabled", true);
                result.add(model);
            }
        } else {
            result.addAll(list1);
        }
        for (JSTreeModel js : result) {
            js.setState(false, false, false);
            if (!ToolUtil.equals((Object)js.getConstant(), (Object)"1")) continue;
            js.setState(false, false, true);
        }
        JSTreeModel root = new JSTreeModel();
        root.setId("1");
        root.setCode("1");
        root.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
        root.setParent("#");
        root.setIsLeaf("0");
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        result.add(root);
        return result;
    }

    @Override
    public Map<String, Object> getResNodeSubList(Map<String, String> paramMap) {
        ShiroUser shiroUser = ShiroKit.getUser();
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        int pageNo = paramMap.get("page") == null ? 1 : Integer.parseInt(paramMap.get("page"));
        int limit = paramMap.get("limit") == null ? 20 : Integer.parseInt(paramMap.get("limit"));
        String nodeId = paramMap.get("nodeId") == null ? null : paramMap.get("nodeId");
        String nodeType = paramMap.get("nodeType") == null ? null : paramMap.get("nodeType");
        String isLeafModule = paramMap.get("isLeaf") == null ? null : paramMap.get("isLeaf");
        HashMap<String, Object> resPageMap = new HashMap<String, Object>(4);
        if (ToolUtil.equals((Object)"1", (Object)nodeId)) {
            nodeType = "isModule";
        }
        boolean funModuleYes = ToolUtil.equals((Object)"isModule", (Object)nodeType);
        boolean leafModuleYes = ToolUtil.equals((Object)"1", (Object)isLeafModule);
        boolean funNodeYes = ToolUtil.equals((Object)"isFun", (Object)nodeType);
        if (funModuleYes) {
            if (leafModuleYes) {
                List<Object> functionVOList;
                Page funcPage = new Page((long)pageNo, (long)limit);
                HashMap queryFuncParams = Maps.newHashMap();
                queryFuncParams.put("moduleId", nodeId);
                String functionName = StringUtils.isBlank((CharSequence)paramMap.get("functionName")) ? null : paramMap.get("functionName").trim();
                String functionCode = StringUtils.isBlank((CharSequence)paramMap.get("functionCode")) ? null : paramMap.get("functionCode").trim();
                queryFuncParams.put("functionName", functionName);
                queryFuncParams.put("functionCode", functionCode);
                if (isGradeAdmin) {
                    List<Object> functionIdList = Lists.newArrayList();
                    String struId = shiroUser.getEmployeeId();
                    String gradeParentId = this.orgMaintenanceService.getOneOrg(struId).getId();
                    List<String> resourceIdList = this.sysStruResourcesService.getResIdList(gradeParentId);
                    if (resourceIdList.size() > 0) {
                        functionIdList = this.sysStruResourcesService.getFunId(resourceIdList);
                    }
                    if (functionIdList.size() > 0) {
                        queryFuncParams.put("functionIdList", functionIdList);
                        functionVOList = this.sysFunctionsMapper.findFunctionByModuleId(funcPage, queryFuncParams);
                        for (SysFunctionVO sysFunctionVO : functionVOList) {
                            if (!functionIdList.contains(sysFunctionVO.getFunctionId())) {
                                sysFunctionVO.setGradeDisabled(Boolean.TRUE);
                                continue;
                            }
                            sysFunctionVO.setGradeDisabled(Boolean.FALSE);
                        }
                    } else {
                        functionVOList = Lists.newArrayList();
                    }
                } else {
                    functionVOList = this.sysFunctionsMapper.findFunctionByModuleId(funcPage, queryFuncParams);
                }
                resPageMap.put("count", funcPage.getTotal());
                resPageMap.put("data", functionVOList);
            } else {
                List<Object> moduleVOList;
                Page modulePage = new Page((long)pageNo, (long)limit);
                HashMap queryModuleParams = Maps.newHashMap();
                queryModuleParams.put("parentModuleId", nodeId);
                String moduleName = StringUtils.isBlank((CharSequence)paramMap.get("moduleName")) ? null : paramMap.get("moduleName").trim();
                String moduleCode = StringUtils.isBlank((CharSequence)paramMap.get("moduleCode")) ? null : paramMap.get("moduleCode").trim();
                queryModuleParams.put("moduleName", moduleName);
                queryModuleParams.put("moduleCode", moduleCode);
                if (isGradeAdmin) {
                    List<String> list;
                    ArrayList moduleIdList = Lists.newArrayList();
                    String struId = shiroUser.getEmployeeId();
                    String gradeParentId = this.orgMaintenanceService.getOneOrg(struId).getId();
                    List<String> resourceIdList = this.sysStruResourcesService.getResIdList(gradeParentId);
                    if (resourceIdList.size() > 0 && !(list = this.sysStruResourcesService.getFunId(resourceIdList)).isEmpty()) {
                        List<SysModules> list2 = this.sysStruResourcesService.getGradeAdminModuleId(list);
                        moduleIdList.addAll(list2.stream().map(SysModules::getModuleId).collect(Collectors.toList()));
                        ArrayList tmpModuleIds = Lists.newArrayList();
                        tmpModuleIds.clear();
                        for (SysModules sysModules : list2) {
                            String parentId = sysModules.getParentModuleId();
                            if ("1".equals(parentId)) continue;
                            tmpModuleIds.add(parentId);
                        }
                        List<SysModules> parentModules = this.iSysModulesService.getParentModuleTree(tmpModuleIds);
                        moduleIdList.addAll(parentModules.stream().map(SysModules::getModuleId).collect(Collectors.toSet()));
                    }
                    if (moduleIdList.size() > 0) {
                        queryModuleParams.put("moduleIdList", moduleIdList);
                        moduleVOList = this.sysModulesMapper.findModuleByParentModuleId(modulePage, queryModuleParams);
                        for (SysModuleVO sysModuleVO : moduleVOList) {
                            if (!moduleIdList.contains(sysModuleVO.getModuleId())) {
                                sysModuleVO.setGradeDisabled(Boolean.TRUE);
                                continue;
                            }
                            sysModuleVO.setGradeDisabled(Boolean.FALSE);
                        }
                    } else {
                        moduleVOList = Lists.newArrayList();
                    }
                } else {
                    moduleVOList = this.sysModulesMapper.findModuleByParentModuleId(modulePage, queryModuleParams);
                }
                resPageMap.put("count", modulePage.getTotal());
                resPageMap.put("data", moduleVOList);
            }
        } else if (funNodeYes) {
            List<Object> resourcesVoList;
            Page resPage = new Page((long)pageNo, (long)limit);
            HashMap queryResParams = Maps.newHashMap();
            queryResParams.put("functionId", nodeId);
            String resourceName = StringUtils.isBlank((CharSequence)paramMap.get("resourceName")) ? null : paramMap.get("resourceName").trim();
            String resourceCode = StringUtils.isBlank((CharSequence)paramMap.get("resourceCode")) ? null : paramMap.get("resourceCode").trim();
            queryResParams.put("resourceName", resourceName);
            queryResParams.put("resourceCode", resourceCode);
            queryResParams.put("resType", "res_type");
            if (isGradeAdmin) {
                String struId = shiroUser.getEmployeeId();
                String gradeParentId = this.orgMaintenanceService.getOneOrg(struId).getId();
                List<String> resourceIdList = this.sysStruResourcesService.getResIdList(gradeParentId);
                if (resourceIdList.isEmpty()) {
                    resourcesVoList = Lists.newArrayList();
                } else {
                    queryResParams.put("resourceIdList", resourceIdList);
                    resourcesVoList = this.sysResourcesMapper.selectResourceListByFuncId(resPage, queryResParams);
                    for (SysResourcesVo sysResourcesVo : resourcesVoList) {
                        if (!resourceIdList.contains(sysResourcesVo.getResourceId())) {
                            sysResourcesVo.setGradeDisabled(Boolean.TRUE);
                            continue;
                        }
                        sysResourcesVo.setGradeDisabled(Boolean.FALSE);
                    }
                }
            } else {
                resourcesVoList = this.sysResourcesMapper.selectResourceListByFuncId(resPage, queryResParams);
            }
            resPageMap.put("count", resPage.getTotal());
            resPageMap.put("data", resourcesVoList);
        }
        resPageMap.put("code", 0);
        return resPageMap;
    }
}

