/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.permit.dao.SysOnlineMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysOnline;
import com.jxdinfo.hussar.bsp.permit.service.ISysOnlineService;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.sessionlimit.SessionLimit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.springframework.stereotype.Service;

@Service
public class SysOnlineServiceImpl
extends ServiceImpl<SysOnlineMapper, SysOnline>
implements ISysOnlineService {
    @Resource
    private SessionDAO sessionDAO;
    @Resource
    SessionLimit sessionLimit;
    @Resource
    private GlobalProperties globalProperties;

    @Override
    public Page<SysOnline> getOnlineList(Page<SysOnline> page, String userAccount, String userName) {
        Collection collection = this.sessionDAO.getActiveSessions();
        Iterator it = collection.iterator();
        ArrayList<SysOnline> onlineUserList = new ArrayList<SysOnline>();
        long now = System.currentTimeMillis();
        while (it.hasNext()) {
            SysOnline online;
            Session s = (Session)it.next();
            if (now - s.getLastAccessTime().getTime() > s.getTimeout()) {
                if (this.globalProperties.isTenantOpen()) {
                    this.sessionLimit.removeBySession(s, DataSourceUtil.currentDsName());
                } else {
                    this.sessionLimit.removeBySession(s);
                }
                this.sessionDAO.delete(s);
                continue;
            }
            String connName = ToolUtil.isNotEmpty((Object)ShiroKit.getUser()) ? ShiroKit.getUser().getConnName() : "";
            ShiroUser user = (ShiroUser)s.getAttribute((Object)"shiroUser");
            if (ToolUtil.isNotEmpty((Object)user) && StringUtils.isNotEmpty((CharSequence)connName) && !connName.equals(user.getConnName()) || !ToolUtil.isNotEmpty((Object)((Object)(online = (SysOnline)((Object)s.getAttribute((Object)"online"))))) || !ToolUtil.contains((Object)online.getUserAccount(), (Object)ToolUtil.getValue((Object)userAccount, (Object)"")) || !ToolUtil.contains((Object)online.getUserName(), (Object)ToolUtil.getValue((Object)userName, (Object)""))) continue;
            onlineUserList.add(online);
        }
        long limit = page.getSize();
        long curr = page.getCurrent() - 1L;
        long startIndex = curr * limit;
        long endIndex = curr * limit + limit;
        int size = onlineUserList.size();
        if (endIndex > (long)size) {
            endIndex = size;
        }
        page.setRecords(onlineUserList.subList(Integer.parseInt(Long.toString(startIndex)), Integer.parseInt(Long.toString(endIndex))));
        page.setTotal((long)onlineUserList.size());
        return page;
    }

    @Override
    public void delRecord(String ids) {
        Collection collection = this.sessionDAO.getActiveSessions();
        Iterator it = collection.iterator();
        String[] sessionIds = ids.split(",");
        String connName = DataSourceUtil.currentDsName();
        block0: for (String id : sessionIds) {
            while (it.hasNext()) {
                Session session = (Session)it.next();
                if (!id.equals(session.getId())) continue;
                Object shiroUser = session.getAttribute((Object)"shiroUser");
                if (shiroUser != null) {
                    Deque<Serializable> sessionQue;
                    ShiroUser user = (ShiroUser)shiroUser;
                    String userId = user.getId();
                    if (this.globalProperties.isTenantOpen()) {
                        sessionQue = this.sessionLimit.getUserSession(userId, connName);
                        if (sessionQue.size() > 0 && sessionQue.contains(id)) {
                            sessionQue.remove(id);
                            this.sessionLimit.addUserSession(userId, connName, sessionQue);
                        }
                    } else {
                        sessionQue = this.sessionLimit.getUserSession(userId);
                        if (sessionQue.size() > 0 && sessionQue.contains(id)) {
                            sessionQue.remove(id);
                            this.sessionLimit.addUserSession(userId, sessionQue);
                        }
                    }
                }
                this.sessionDAO.delete(session);
                continue block0;
            }
        }
    }
}

