/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.bsp.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.bsp.permit.dao.SysOnlineHistMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysOnline;
import com.jxdinfo.hussar.bsp.permit.model.SysOnlineHist;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysOnlineHistService;
import com.jxdinfo.hussar.common.browserutil.GetBrowserUtil;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.sql.Timestamp;
import javax.annotation.Resource;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.web.util.WebUtils;
import org.springframework.stereotype.Service;

@Service
public class SysOnlineHistServiceImpl
extends ServiceImpl<SysOnlineHistMapper, SysOnlineHist>
implements ISysOnlineHistService {
    @Resource
    private SysOnlineHistMapper sysOnlineHistMapper;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private GetBrowserUtil getBrowserUtil;

    @Override
    public Page<SysOnlineHist> getOnlineHistList(Page<SysOnlineHist> page, Timestamp startTime, Timestamp endTime, String userAccount) {
        page.setRecords(this.sysOnlineHistMapper.getOnlineHistList(page, startTime, endTime, userAccount));
        return page;
    }

    @Override
    public SysOnline addRecord() {
        SysOnlineHist sysOnlineHist;
        String sessionId = (String)((Object)ShiroKit.getSession().getId());
        String userId = (String)ShiroKit.getSession().getAttribute((Object)"userId");
        if (ToolUtil.isEmpty((Object)userId)) {
            return null;
        }
        SysUsers sysUsers = (SysUsers)((Object)this.sysUsersMapper.selectById((Serializable)((Object)userId)));
        SysOrganVo dept = this.sysStruMapper.getOrgInfoByOrgId(sysUsers.getDepartmentId());
        String deptName = "";
        if (ToolUtil.isNotEmpty((Object)dept) && ToolUtil.isNotEmpty((Object)dept.getShortName())) {
            deptName = dept.getShortName();
        }
        if (ToolUtil.isEmpty((Object)((Object)(sysOnlineHist = (SysOnlineHist)((Object)this.sysOnlineHistMapper.selectById((Serializable)((Object)sessionId))))))) {
            sysOnlineHist = new SysOnlineHist();
            sysOnlineHist.setSessionId(sessionId);
            sysOnlineHist.setUserId(sysUsers.getUserId());
            sysOnlineHist.setUserAccount(sysUsers.getUserAccount());
            sysOnlineHist.setUserName(sysUsers.getUserName());
            sysOnlineHist.setCorporationId(sysUsers.getDepartmentId());
            sysOnlineHist.setCorporationName(deptName);
            sysOnlineHist.setLoginTime(new Timestamp(System.currentTimeMillis()));
            sysOnlineHist.setRemoteaddr(HttpKit.getIp());
            sysOnlineHist.setRemotehost(HttpKit.getHost());
            sysOnlineHist.setRemoteport(HttpKit.getPort());
            HttpServletRequest requestNew = WebUtils.toHttp((ServletRequest)HttpKit.getRequest());
            sysOnlineHist.setBrowserType(this.getBrowserUtil.getBrowser(requestNew));
            this.saveOrUpdate((Object)sysOnlineHist);
        }
        SysOnline online = new SysOnline();
        online.setSessionId(sysOnlineHist.getSessionId());
        online.setUserId(sysOnlineHist.getUserId());
        online.setUserAccount(sysOnlineHist.getUserAccount());
        online.setUserName(sysOnlineHist.getUserName());
        online.setCorporationId(sysOnlineHist.getCorporationId());
        online.setCorporationName(sysOnlineHist.getCorporationName());
        online.setLoginTime(sysOnlineHist.getLoginTime());
        online.setRemoteaddr(sysOnlineHist.getRemoteaddr());
        online.setRemotehost(sysOnlineHist.getRemotehost());
        online.setRemoteport(sysOnlineHist.getRemoteport());
        online.setBrowserType(sysOnlineHist.getBrowserType());
        return online;
    }

    @Override
    public void updateLogoffTime() {
        String sessionId = (String)((Object)ShiroKit.getSession().getId());
        SysOnlineHist sysOnlineHist = (SysOnlineHist)((Object)this.sysOnlineHistMapper.selectById((Serializable)((Object)sessionId)));
        if (ToolUtil.isNotEmpty((Object)((Object)sysOnlineHist))) {
            sysOnlineHist.setLogoffTime(new Timestamp(System.currentTimeMillis()));
            this.sysOnlineHistMapper.updateById((Object)sysOnlineHist);
        }
    }
}

