/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.constant.Constants;
import com.jxdinfo.hussar.bsp.permit.dao.SysIdtableInfoMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysIdtableMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysIdtable;
import com.jxdinfo.hussar.bsp.permit.model.SysIdtableInfo;
import com.jxdinfo.hussar.bsp.permit.service.ISysIdtableService;
import com.jxdinfo.hussar.bsp.permit.vo.SysIdtableInfoVo;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.util.DataExportUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SerializeUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.ibatis.session.SqlSession;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysIdtableServiceImpl
extends ServiceImpl<SysIdtableMapper, SysIdtable>
implements ISysIdtableService {
    @Resource
    SysIdtableMapper sysIdtableMapper;
    @Resource
    SysIdtableInfoMapper sysIdtableInfoMapper;

    @Override
    public JSONObject getList(String page, String limit, String serIdDesc, String serFieldName, String serTableName) {
        JSONObject jsonObject = new JSONObject();
        if (ToolUtil.isNotEmpty((Object)page) && ToolUtil.isNotEmpty((Object)limit)) {
            Page pages = new Page((long)Integer.valueOf(page).intValue(), (long)Integer.valueOf(limit).intValue());
            List<SysIdtable> list = this.sysIdtableMapper.selectListByQuery(pages, serIdDesc, serFieldName, serTableName);
            jsonObject.put("count", (Object)pages.getTotal());
            jsonObject.put("data", list);
            jsonObject.put("code", (Object)0);
        } else {
            jsonObject.put("data", null);
            jsonObject.put("code", (Object)"500");
            jsonObject.put("msg", (Object)"\u53c2\u6570\u4e0d\u7b26");
            jsonObject.put("count", null);
        }
        return jsonObject;
    }

    @Override
    public int saveIdtable(SysIdtable sysIdtable) {
        String id = sysIdtable.getIdId();
        if (ToolUtil.isNotEmpty((Object)id)) {
            return this.sysIdtableMapper.updateById((Object)sysIdtable);
        }
        BigDecimal num = new BigDecimal(0);
        sysIdtable.setIdValue(num);
        return this.sysIdtableMapper.insert((Object)sysIdtable);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean delByIds(List list) {
        boolean flag = super.removeByIds((Collection)list);
        if (flag) {
            this.sysIdtableInfoMapper.delete((Wrapper)new QueryWrapper().in((Object)"IDTABLE_ID", (Collection)list));
        }
        return flag;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public synchronized String getCurrentCode(String fieldName, String tableName) {
        SysIdtable sysIdtable = this.sysIdtableMapper.getIdtableByQuery(fieldName, tableName);
        if (ToolUtil.isNotEmpty((Object)((Object)sysIdtable))) {
            String isPrefix = sysIdtable.getIsPrefix();
            String idPrefix = sysIdtable.getIdPrefix();
            String isSuffix = sysIdtable.getIsSuffix();
            String idSuffix = sysIdtable.getIdSuffix();
            StringBuilder currentCode = new StringBuilder();
            if ("1".equals(isPrefix)) {
                String lastDate;
                if (idPrefix.indexOf("[") == 0 && idPrefix.indexOf("]") == idPrefix.length() - 1) {
                    idPrefix = idPrefix.substring(1, idPrefix.length());
                    idPrefix = idPrefix.substring(0, idPrefix.length() - 1);
                    SimpleDateFormat sdf = new SimpleDateFormat(idPrefix);
                    idPrefix = sdf.format(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
                }
                if (!ToolUtil.equals((Object)(lastDate = sysIdtable.getLastDate()), (Object)idPrefix)) {
                    sysIdtable.setLastDate(idPrefix);
                    sysIdtable.updateById();
                    sysIdtable.setIdValue(new BigDecimal(0));
                }
                currentCode.append(idPrefix);
            }
            BigDecimal result = sysIdtable.getIdValue().add(sysIdtable.getCacheSize());
            BigDecimal length = sysIdtable.getIdLength();
            String idLength = length.toString();
            String resultCode = result.toString();
            int zeroLength = Integer.valueOf(idLength) - resultCode.length();
            if (zeroLength < 0) {
                throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.EXCEEDING_LENGTH_IDTABLE);
            }
            for (int i = 0; i < zeroLength; ++i) {
                currentCode.append("0");
            }
            currentCode.append(result);
            if ("1".equals(isSuffix)) {
                currentCode.append(idSuffix);
            }
            sysIdtable.setIdValue(result);
            this.sysIdtableMapper.updateById((Object)sysIdtable);
            return currentCode.toString();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public synchronized String getCurrentCode(String fieldName, String tableName, String parentNumber) {
        SysIdtable sysIdtable = this.sysIdtableMapper.getIdtableByQuery(fieldName, tableName);
        if (ToolUtil.isNotEmpty((Object)((Object)sysIdtable))) {
            if (ToolUtil.equals((Object)sysIdtable.getIsLevel(), (Object)"0")) {
                throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.NOT_LEAF_IDTABLE);
            }
            List<SysIdtableInfoVo> list = this.sysIdtableMapper.getIdTableByParentNumber(fieldName, tableName, parentNumber);
            if (list.size() == 0) {
                SysIdtableInfo sysIdtableInfo = new SysIdtableInfo();
                sysIdtableInfo.setInfoId(null);
                sysIdtableInfo.setIdtableId(sysIdtable.getIdId());
                sysIdtableInfo.setIdValue("1");
                sysIdtableInfo.setParentNumber(parentNumber);
                this.sysIdtableInfoMapper.insert((Object)sysIdtableInfo);
                BigDecimal length = sysIdtable.getIdLength();
                String idLength = length.toString();
                int zeroLength = Integer.valueOf(idLength) - sysIdtableInfo.getIdValue().length();
                StringBuffer currentCode = new StringBuffer();
                if (ToolUtil.isNotEmpty((Object)parentNumber)) {
                    currentCode.append(parentNumber);
                }
                for (int i = 0; i < zeroLength; ++i) {
                    currentCode.append("0");
                }
                if (zeroLength < 0) {
                    throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.EXCEEDING_LENGTH_IDTABLE);
                }
                currentCode.append(sysIdtableInfo.getIdValue());
                return currentCode.toString();
            }
            int result = Integer.parseInt(list.get(0).getIdValue()) + sysIdtable.getCacheSize().intValue();
            BigDecimal length = sysIdtable.getIdLength();
            String idLength = length.toString();
            String resultCode = String.valueOf(result);
            int zeroLength = Integer.valueOf(idLength) - resultCode.length();
            StringBuilder currentCode = new StringBuilder();
            if (ToolUtil.isNotEmpty((Object)parentNumber)) {
                currentCode.append(parentNumber);
            }
            for (int i = 0; i < zeroLength; ++i) {
                currentCode.append("0");
            }
            if (zeroLength < 0) {
                throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.EXCEEDING_LENGTH_IDTABLE);
            }
            currentCode.append(result);
            SysIdtableInfo sysIdtableInfo = new SysIdtableInfo();
            sysIdtableInfo.setInfoId(list.get(0).getInfoId());
            sysIdtableInfo.setIdValue(resultCode);
            this.sysIdtableInfoMapper.updateById((Object)sysIdtableInfo);
            return currentCode.toString();
        }
        return null;
    }

    @Override
    public SysIdtable getIdtableByQuery(String fieldName, String tableName) {
        return this.sysIdtableMapper.getIdtableByQuery(fieldName, tableName);
    }

    @Override
    public void exportData(List<String> idList, HttpServletResponse response) {
        List idTable = this.sysIdtableMapper.selectBatchIds(idList);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("idTable", idTable);
        data.put("export_type", "idTable");
        byte[] serializeData = SerializeUtils.serialize(data);
        String fileName = "idtable_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile(serializeData, fileName, response);
    }

    @Override
    public Tip importData(byte[] content) {
        Map data = (Map)SerializeUtils.deserialize((byte[])content);
        String export_type = (String)data.get("export_type");
        if (!"idTable".equals(export_type)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u60a8\u5bfc\u5165\u7684\u662f" + (String)Constants.EXPORT_MAP.get(export_type) + ",\u8bf7\u5bfc\u5165" + (String)Constants.EXPORT_MAP.get("idTable"));
        }
        List idtable = (List)data.get("idTable");
        Map<String, Integer> count = this.insertOrUpdateList(idtable);
        SuccessTip success = new SuccessTip();
        success.setMessage("\u5bfc\u5165\u6210\u529f\uff0c\u65b0\u589e\u6570\u636e" + count.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + count.get("update") + "\u6761\u3002");
        return success;
    }

    @Override
    public JSONObject importIdTableData(byte[] content) {
        JSONObject result = new JSONObject();
        Map data = (Map)SerializeUtils.deserialize((byte[])content);
        String export_type = (String)data.get("export_type");
        if (!"idTable".equals(export_type)) {
            result.put("success", (Object)"false");
            result.put("importType", (Object)export_type);
            result.put("trueType", (Object)"idTable");
            return result;
        }
        List idtable = (List)data.get("idTable");
        Map<String, Integer> count = this.insertOrUpdateList(idtable);
        result.put("success", (Object)"true");
        result.put("insertCount", (Object)count.get("insert"));
        result.put("updateCount", (Object)count.get("update"));
        return result;
    }

    @Override
    public Map<String, Integer> insertOrUpdateList(List<SysIdtable> idTableList) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer update = 0;
        Integer insert = 0;
        if (CollectionUtils.isEmpty(idTableList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = idTableList.size();
            for (int i = 0; i < size; ++i) {
                Integer n;
                Integer n2;
                if (super.updateById((Object)idTableList.get(i))) {
                    n2 = update;
                    n = update = Integer.valueOf(update + 1);
                } else {
                    super.save((Object)idTableList.get(i));
                    n2 = insert;
                    n = insert = Integer.valueOf(insert + 1);
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new MybatisPlusException("Error: Cannot execute insertOrUpdateBatch Method. Cause", e);
        }
        result.put("update", update);
        result.put("insert", insert);
        return result;
    }
}

