/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit;

import com.jxdinfo.hussar.bsp.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.bsp.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.mail.core.exceptions.MailException;
import com.jxdinfo.hussar.mail.util.HussarMailUtils;
import java.io.File;
import java.util.HashMap;
import org.apache.commons.lang.text.StrSubstitutor;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"springContextHolder"})
public class AccountStatusChangeMailUtil {
    private static ISysBaseConfigService iSysBaseConfigService = (ISysBaseConfigService)SpringContextHolder.getBean(ISysBaseConfigService.class);

    public static void sendMail(SysUsers sysUsers, String status) {
        String mailSubject = "";
        String content = "";
        HashMap<String, String> map = new HashMap<String, String>();
        if (UserStatus.LOCKED.getCode().equals(status) || UserStatus.DORMANCY.getCode().equals(status)) {
            mailSubject = iSysBaseConfigService.getSysBaseConfig("status_change_email_title").getConfigValue();
            SysBaseConfig sysBaseConfig = iSysBaseConfigService.getSysBaseConfig("nologin_day");
            String noLoginDay = sysBaseConfig.getConfigValue();
            String statusName = UserStatus.LOCKED.getCode().equals(status) ? UserStatus.LOCKED.getMessage() : UserStatus.DORMANCY.getMessage();
            content = iSysBaseConfigService.getSysBaseConfig("status_change_email").getConfigValue();
            map.put("nologin_day", noLoginDay);
            map.put("user_account_status", statusName);
            map.put("user_account", sysUsers.getUserAccount());
        }
        if (UserStatus.CANCEL.getCode().equals(status)) {
            mailSubject = iSysBaseConfigService.getSysBaseConfig("logout_warn_email_title").getConfigValue();
            String beforeLogout = iSysBaseConfigService.getSysBaseConfig("email_before_logout_day").getConfigValue();
            content = iSysBaseConfigService.getSysBaseConfig("logout_warn_email").getConfigValue();
            map.put("user_account", sysUsers.getUserAccount());
            map.put("email_before_logout_day", beforeLogout);
        }
        StrSubstitutor strSubstitutor = new StrSubstitutor(map);
        content = strSubstitutor.replace(content);
        try {
            HussarMailUtils.send((String)sysUsers.getEMail(), (String)mailSubject, (String)content, (boolean)true, (File[])new File[0]);
        }
        catch (MailException e) {
            System.out.println("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25->" + e.getMessage());
        }
    }
}

