/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.organ.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.bpm.messagepush.AbstractBpmPushMsgMatcher;
import com.jxdinfo.hussar.bsp.audit.dao.SysUsersAuditMapper;
import com.jxdinfo.hussar.bsp.audit.model.SysOfficeAudit;
import com.jxdinfo.hussar.bsp.audit.model.SysOrganAudit;
import com.jxdinfo.hussar.bsp.audit.model.SysStaffAudit;
import com.jxdinfo.hussar.bsp.audit.model.SysStruAudit;
import com.jxdinfo.hussar.bsp.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.bsp.audit.service.ISysOfficeAuditService;
import com.jxdinfo.hussar.bsp.audit.service.ISysOrganAuditService;
import com.jxdinfo.hussar.bsp.audit.service.ISysStaffAuditService;
import com.jxdinfo.hussar.bsp.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.bsp.audit.service.ISysUsersAuditService;
import com.jxdinfo.hussar.bsp.audit.util.CopyPropertieUtils;
import com.jxdinfo.hussar.bsp.bspinterface.service.ISysOrgEventService;
import com.jxdinfo.hussar.bsp.constant.Constants;
import com.jxdinfo.hussar.bsp.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.bsp.organ.dao.SysOfficeMapper;
import com.jxdinfo.hussar.bsp.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.bsp.organ.dao.SysOrganTypeMapper;
import com.jxdinfo.hussar.bsp.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.bsp.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.bsp.organ.dao.SysStruRuleMapper;
import com.jxdinfo.hussar.bsp.organ.model.SysOffice;
import com.jxdinfo.hussar.bsp.organ.model.SysOrgan;
import com.jxdinfo.hussar.bsp.organ.model.SysOrganType;
import com.jxdinfo.hussar.bsp.organ.model.SysStaff;
import com.jxdinfo.hussar.bsp.organ.model.SysStru;
import com.jxdinfo.hussar.bsp.organ.model.SysStruRule;
import com.jxdinfo.hussar.bsp.organ.service.ISysOfficeService;
import com.jxdinfo.hussar.bsp.organ.service.ISysOrganService;
import com.jxdinfo.hussar.bsp.organ.service.ISysStaffService;
import com.jxdinfo.hussar.bsp.organ.service.ISysStruService;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.organ.vo.OrganInfoVo;
import com.jxdinfo.hussar.bsp.organ.vo.ProxyTreeVo;
import com.jxdinfo.hussar.bsp.organ.vo.SysOrganTypeVo;
import com.jxdinfo.hussar.bsp.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.bsp.permit.dao.SysConfRolesetMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysIdtableMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysStruAssistOrganMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysStruRoleAuditMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysStruRoleMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysIdtable;
import com.jxdinfo.hussar.bsp.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.bsp.permit.model.SysStruRole;
import com.jxdinfo.hussar.bsp.permit.model.SysStruRoleAudit;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysIdtableService;
import com.jxdinfo.hussar.bsp.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.bsp.permit.service.ISysStruRoleAuditService;
import com.jxdinfo.hussar.bsp.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.factory.ShiroFactroy;
import com.jxdinfo.hussar.core.util.DataExportUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SerializeUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.session.SqlSession;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysOrgManageServiceImpl
extends ServiceImpl<SysStruMapper, SysStru>
implements SysOrgManageService {
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysOrganMapper sysOrganMapper;
    @Resource
    private SysOrganTypeMapper sysOrganTypeMapper;
    @Resource
    private SysStaffMapper sysStaffMapper;
    @Resource
    private ISysStaffService sysStaffService;
    @Resource
    private SysStruRuleMapper sysStruRuleMapper;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private SysRolesMapper sysRolesMapper;
    @Resource
    private SysConfRolesetMapper sysConfRolesetMapper;
    @Resource
    private SysOfficeMapper sysOfficeMapper;
    @Resource
    private ISysOfficeService iSysOfficeService;
    @Resource
    private ISysOrgEventService iSysOrgEventService;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    ISysOrganAuditService iSysOrganAuditService;
    @Resource
    ISysStruAuditService iSysStruAuditService;
    @Resource
    ISysStaffAuditService iSysStaffAuditService;
    @Resource
    ISysUsersAuditService iSysUsersAuditService;
    @Resource
    ISysOfficeAuditService iSysOfficeAuditService;
    @Resource
    private SysUsersAuditMapper sysUsersAuditMapper;
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;
    @Resource
    private AbstractBpmPushMsgMatcher bpmAbstractPushMsgMatcher;
    @Resource
    ISysStruAssistOrganService iSysStruAssistOrganService;
    @Resource
    SysStruAssistOrganMapper sysStruAssistOrganMapper;
    @Resource
    private SysStruRoleMapper sysStruRoleMapper;
    @Resource
    private ISysStruRoleService sysStruRoleService;
    @Resource
    private SysStruRoleAuditMapper sysStruRoleAuditMapper;
    @Resource
    private ISysStruRoleAuditService sysStruRoleAuditService;
    @Resource
    private SysIdtableMapper sysIdtableMapper;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private ISysOrganService sysOrganService;
    @Resource
    private ISysStruService sysStruService;
    private static final String ADD = "1";
    private static final String DELETE = "2";

    @Override
    public List<JSTreeModel> getOrgTree(String isEmployee) {
        return this.sysStruMapper.getOrgTree(isEmployee);
    }

    @Override
    public SysOrganVo getOrgInfoById(String struId) {
        return this.sysStruMapper.getOrgInfoByOrgId(struId);
    }

    @Override
    public Map<String, Object> getOrgInfoListByParentId(Map<String, String> reqParamMap) {
        HashMap<String, Object> organPageMap = new HashMap<String, Object>(4);
        int pageNo = reqParamMap.get("page") == null ? 1 : Integer.parseInt(reqParamMap.get("page"));
        int limit = reqParamMap.get("limit") == null ? 20 : Integer.parseInt(reqParamMap.get("limit"));
        String parentStruId = reqParamMap.get("parentStruId");
        String orangeName = reqParamMap.get("orangeName") == null ? "" : reqParamMap.get("orangeName").trim();
        String orangeCode = reqParamMap.get("orangeCode") == null ? "" : reqParamMap.get("orangeCode").trim();
        HashMap queryOrgParams = Maps.newHashMap();
        queryOrgParams.put("parentStruId", parentStruId);
        queryOrgParams.put("orangeName", orangeName);
        queryOrgParams.put("orangeCode", orangeCode);
        queryOrgParams.put("gradeAdminFlag", "0");
        queryOrgParams.put("gradeDepStruLevel", 1L);
        ShiroUser currentUser = ShiroKit.getUser();
        if (currentUser.isGradeadmin()) {
            queryOrgParams.put("gradeAdminFlag", ADD);
            String gradeDepStruLevel = this.sysStruMapper.selectStruLevel(ShiroKit.getUser().getDeptId());
            queryOrgParams.put("gradeDepStruLevel", Long.valueOf(gradeDepStruLevel));
            String searchStruLevel = "0";
            if (!ToolUtil.equals((Object)"11", (Object)parentStruId)) {
                searchStruLevel = this.sysStruMapper.selectStruLevel(parentStruId);
            }
            if (Integer.parseInt(searchStruLevel) < Integer.parseInt(gradeDepStruLevel)) {
                HashSet parenetStruIdSet = Sets.newHashSet((Object[])new String[]{ShiroKit.getUser().getDeptId()});
                List ancestorStrus = this.sysStruMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().le((Object)"STRU_LEVEL", (Object)gradeDepStruLevel)).orderByDesc((Object)"STRU_LEVEL"));
                for (SysStru sysStru : ancestorStrus) {
                    if (!parenetStruIdSet.contains(sysStru.getStruId())) continue;
                    parenetStruIdSet.add(sysStru.getParentId());
                }
                if (CollectionUtils.isNotEmpty((Collection)parenetStruIdSet)) {
                    queryOrgParams.put("ancestorStruIds", new ArrayList(parenetStruIdSet));
                }
            }
            Page organPage = new Page((long)pageNo, (long)limit);
            List<SysOrganVo> sysOrganVos = this.sysStruMapper.getOrgInfoListByParentId(organPage, queryOrgParams);
            organPageMap.put("count", organPage.getTotal());
            organPageMap.put("data", sysOrganVos);
        } else {
            List<SysOrganVo> sysOrganVos = this.sysStruMapper.getOrgInfoListByParentId(queryOrgParams);
            Map<String, Object> dataScopeMap = ShiroFactroy.me().getDataScopeInfo(currentUser);
            Set optStruNodeIdList = (Set)dataScopeMap.get("data_scope_list");
            String dataScopeType = dataScopeMap.get("data_scope_type").toString();
            if (!ADD.equals(dataScopeType)) {
                sysOrganVos = this.getOrganVOInDataScope(sysOrganVos, dataScopeType, optStruNodeIdList);
            }
            if (sysOrganVos.size() > 0) {
                List<SysOrganVo> pageOrganVoList = this.pageSysOrganList(sysOrganVos, pageNo, limit);
                organPageMap.put("data", pageOrganVoList);
            } else {
                organPageMap.put("data", sysOrganVos);
            }
            organPageMap.put("count", sysOrganVos.size());
        }
        organPageMap.put("code", 0);
        return organPageMap;
    }

    @Override
    public ArrayList<Object> getStruRole(String id) {
        ArrayList<Object> result = new ArrayList<Object>();
        List userRole = this.sysStruRoleMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"STRU_ID", (Object)id));
        result.add(userRole);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JSONObject orgInfoSave(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, SysOffice sysOffice, Boolean isAdd) {
        JSONObject json = new JSONObject();
        Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        String userId = ShiroKit.getUser().getId();
        if (isAdd.booleanValue()) {
            this.iSysOrgEventService.beforeAdd(sysStru, sysOrgan, sysOffice);
            sysOrgan.setCreateTime(date);
            sysOrgan.setCreator(userId);
            sysOrgan.setLastEditor(userId);
            sysOrgan.setLastTime(date);
            sysStru.setCreateTime(date);
            sysStru.setCreator(userId);
            if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isOrganAudit()) {
                this.auditAdd(sysOrgan, sysStru, sysStaff, sysOffice, ADD);
                json.put("code", (Object)HttpCode.OK.value());
                json.put("message", (Object)"\u65b0\u589e\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
            } else {
                this.sysOrganMapper.insert((Object)sysOrgan);
                sysStru.setOrganId(sysOrgan.getOrganId());
                this.sysStruMapper.insert((Object)sysStru);
                if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
                    sysStaff.setStruId(sysStru.getStruId());
                    this.sysStaffMapper.insert((Object)sysStaff);
                }
                if (ToolUtil.isNotEmpty((Object)((Object)sysOffice))) {
                    sysOffice.setStruId(sysStru.getStruId());
                    this.sysOfficeMapper.insert((Object)sysOffice);
                }
                json.put("code", (Object)HttpCode.OK.value());
                json.put("message", (Object)"\u65b0\u589e\u6210\u529f\uff01");
                JSONObject object = new JSONObject();
                object.put("sysOrgan", (Object)sysOrgan);
                object.put("sysStru", (Object)sysStru);
                if (ToolUtil.isNotEmpty((Object)((Object)sysOffice))) {
                    object.put("sysOffice", (Object)sysOffice);
                }
                if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
                    object.put("sysStaff", (Object)sysStaff);
                }
                this.abstractPushMsgMatcher.insertOperation("organ", "add", object, "");
                this.bpmAbstractPushMsgMatcher.pushOrgan(sysOrgan, sysStru, "add");
            }
            this.iSysOrgEventService.afterAdd(sysStru, sysOrgan, sysOffice);
        } else {
            this.iSysOrgEventService.beforeEdit(sysStru, sysOrgan, sysOffice);
            sysOrgan.setLastEditor(userId);
            sysOrgan.setLastTime(date);
            sysStru.setLastEditor(userId);
            sysStru.setLastTime(date);
            if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isOrganAudit()) {
                this.auditAdd(sysOrgan, sysStru, sysStaff, sysOffice, DELETE);
                json.put("code", (Object)HttpCode.OK.value());
                json.put("message", (Object)"\u4fee\u6539\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
            } else {
                this.sysOrganMapper.updateById((Object)sysOrgan);
                this.sysStruMapper.updateById((Object)sysStru);
                if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
                    sysStaff.setName(sysOrgan.getOrganName());
                    this.sysStaffService.saveOrUpdate((Object)sysStaff);
                }
                if (ToolUtil.isNotEmpty((Object)((Object)sysOffice))) {
                    this.iSysOfficeService.saveOrUpdate((Object)sysOffice);
                }
                json.put("code", (Object)HttpCode.OK.value());
                json.put("message", (Object)"\u4fee\u6539\u6210\u529f\uff01");
                JSONObject object = new JSONObject();
                object.put("sysOrgan", (Object)sysOrgan);
                object.put("sysStru", (Object)sysStru);
                if (ToolUtil.isNotEmpty((Object)((Object)sysOffice))) {
                    object.put("sysOffice", (Object)sysOffice);
                }
                if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
                    object.put("sysStaff", (Object)sysStaff);
                }
                this.abstractPushMsgMatcher.insertOperation("organ", "update", object, "");
                this.bpmAbstractPushMsgMatcher.pushOrgan(sysOrgan, sysStru, "update");
            }
            this.iSysOrgEventService.afterEdit(sysStru, sysOrgan, sysOffice);
        }
        return json;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JSONObject orgInfoSaveVue(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, SysOffice sysOffice, Boolean isAdd) {
        String struId = sysStru.getStruId();
        String roleId = sysStru.getRoleIds().trim();
        String[] roleIds = roleId.split(",");
        JSONObject json = new JSONObject();
        Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        String userId = ShiroKit.getUser().getId();
        if (isAdd.booleanValue()) {
            this.iSysOrgEventService.beforeAdd(sysStru, sysOrgan, sysOffice);
            sysOrgan.setCreateTime(date);
            sysOrgan.setCreator(userId);
            sysOrgan.setLastEditor(userId);
            sysOrgan.setLastTime(date);
            sysStru.setCreateTime(date);
            sysStru.setCreator(userId);
            if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isOrganAudit()) {
                this.auditAdd(sysOrgan, sysStru, sysStaff, sysOffice, ADD);
                json.put("code", (Object)HttpCode.OK.value());
                json.put("message", (Object)"\u65b0\u589e\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
            } else {
                this.sysOrganMapper.insert((Object)sysOrgan);
                sysStru.setOrganId(sysOrgan.getOrganId());
                this.sysStruMapper.insert((Object)sysStru);
                if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
                    sysStaff.setStruId(sysStru.getStruId());
                    this.sysStaffMapper.insert((Object)sysStaff);
                }
                if (ToolUtil.isNotEmpty((Object)((Object)sysOffice))) {
                    sysOffice.setStruId(sysStru.getStruId());
                    this.sysOfficeMapper.insert((Object)sysOffice);
                }
                json.put("code", (Object)HttpCode.OK.value());
                json.put("message", (Object)"\u65b0\u589e\u6210\u529f\uff01");
                JSONObject object = new JSONObject();
                object.put("sysOrgan", (Object)sysOrgan);
                object.put("sysStru", (Object)sysStru);
                if (ToolUtil.isNotEmpty((Object)((Object)sysOffice))) {
                    object.put("sysOffice", (Object)sysOffice);
                }
                if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
                    object.put("sysStaff", (Object)sysStaff);
                }
                this.abstractPushMsgMatcher.insertOperation("organ", "add", object, "");
                this.bpmAbstractPushMsgMatcher.pushOrgan(sysOrgan, sysStru, "add");
                struId = sysStru.getStruId();
                if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isStruAudit()) {
                    ArrayList<SysStruRoleAudit> auditList = new ArrayList<SysStruRoleAudit>();
                    ArrayList<String> adds = new ArrayList<String>(Arrays.asList(roleIds));
                    if (ToolUtil.isNotEmpty(adds)) {
                        this.insertAndUpdateStruRoleAudit(adds, auditList, struId, ADD);
                        json.put("code", (Object)HttpCode.OK.value());
                        json.put("message", (Object)"\u4fee\u6539\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
                    } else {
                        json.put("code", (Object)HttpCode.OK.value());
                        json.put("message", (Object)"\u4fee\u6539\u6210\u529f\uff01");
                    }
                } else {
                    ArrayList<SysStruRole> struRoleList = new ArrayList<SysStruRole>();
                    for (String roleId1 : roleIds) {
                        if (ToolUtil.isEmpty((Object)roleId1)) continue;
                        SysStruRole sysStruRole = new SysStruRole();
                        sysStruRole.setStruId(struId);
                        sysStruRole.setGrantedRole(roleId1);
                        sysStruRole.setCreateTime(date);
                        sysStruRole.setLastTime(date);
                        sysStruRole.setCreator(userId);
                        sysStruRole.setLastEditor(userId);
                        struRoleList.add(sysStruRole);
                    }
                    if (ToolUtil.isNotEmpty(struRoleList)) {
                        this.sysStruRoleService.saveBatch(struRoleList, struRoleList.size());
                        this.abstractPushMsgMatcher.insertOperation("struRole", "add", struRoleList, "");
                    }
                }
            }
            this.iSysOrgEventService.afterAdd(sysStru, sysOrgan, sysOffice);
        } else {
            this.iSysOrgEventService.beforeEdit(sysStru, sysOrgan, sysOffice);
            sysOrgan.setLastEditor(userId);
            sysOrgan.setLastTime(date);
            sysStru.setLastEditor(userId);
            sysStru.setLastTime(date);
            if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isOrganAudit()) {
                this.auditAdd(sysOrgan, sysStru, sysStaff, sysOffice, DELETE);
                json.put("code", (Object)HttpCode.OK.value());
                json.put("message", (Object)"\u4fee\u6539\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
            } else {
                this.sysOrganMapper.updateById((Object)sysOrgan);
                this.sysStruMapper.updateById((Object)sysStru);
                if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
                    sysStaff.setName(sysOrgan.getOrganName());
                    this.sysStaffService.saveOrUpdate((Object)sysStaff);
                }
                if (ToolUtil.isNotEmpty((Object)((Object)sysOffice))) {
                    this.iSysOfficeService.saveOrUpdate((Object)sysOffice);
                }
                json.put("code", (Object)HttpCode.OK.value());
                json.put("message", (Object)"\u4fee\u6539\u6210\u529f\uff01");
                JSONObject object = new JSONObject();
                object.put("sysOrgan", (Object)sysOrgan);
                object.put("sysStru", (Object)sysStru);
                if (ToolUtil.isNotEmpty((Object)((Object)sysOffice))) {
                    object.put("sysOffice", (Object)sysOffice);
                }
                if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
                    object.put("sysStaff", (Object)sysStaff);
                }
                this.abstractPushMsgMatcher.insertOperation("organ", "update", object, "");
                this.bpmAbstractPushMsgMatcher.pushOrgan(sysOrgan, sysStru, "update");
            }
            if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isStruAudit()) {
                List<SysStruRoleAudit> auditList = this.sysStruRoleAuditMapper.getHasReviewList(struId);
                List connList = this.sysStruRoleMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"stru_id", (Object)struId));
                ArrayList<String> adds = new ArrayList<String>();
                ArrayList<String> dels = new ArrayList<String>();
                for (SysStruRole sysStruRole : connList) {
                    boolean isSame = false;
                    for (String roleId1 : roleIds) {
                        if (ToolUtil.isEmpty((Object)roleId1) || !roleId1.equals(sysStruRole.getGrantedRole())) continue;
                        isSame = true;
                        break;
                    }
                    if (isSame) continue;
                    dels.add(sysStruRole.getGrantedRole());
                }
                for (String roleId1 : roleIds) {
                    if (ToolUtil.isEmpty((Object)roleId1)) continue;
                    boolean isSame = false;
                    for (SysStruRole sysStruRole : connList) {
                        if (!roleId1.equals(sysStruRole.getGrantedRole())) continue;
                        isSame = true;
                        break;
                    }
                    if (isSame || SysUserAndRole.PUBLIC_ROLE.getValue().equals(roleId1)) continue;
                    adds.add(roleId1);
                }
                if (ToolUtil.isNotEmpty(adds)) {
                    this.insertAndUpdateStruRoleAudit(adds, auditList, struId, ADD);
                }
                if (ToolUtil.isNotEmpty(dels)) {
                    this.insertAndUpdateStruRoleAudit(dels, auditList, struId, DELETE);
                }
                if (ToolUtil.isNotEmpty(adds) && ToolUtil.isNotEmpty(dels)) {
                    json.put("code", (Object)HttpCode.OK.value());
                    json.put("message", (Object)"\u4fee\u6539\u6210\u529f\uff01");
                } else {
                    json.put("code", (Object)HttpCode.OK.value());
                    json.put("message", (Object)"\u4fee\u6539\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
                }
            } else {
                if (ShiroKit.getUser().isGradeadmin()) {
                    this.sysStruRoleMapper.delOrganRoleIdByStruId(struId);
                    this.abstractPushMsgMatcher.insertOperation("struRole", "delete", struId, "");
                } else {
                    this.sysStruRoleMapper.delSysRolesByStruId(struId);
                    this.abstractPushMsgMatcher.insertOperation("struRole", "delete", struId, "");
                }
                this.bpmAbstractPushMsgMatcher.delete("struRole", struId, "deleteByStruId");
                ArrayList<SysStruRole> struRoleList = new ArrayList<SysStruRole>();
                for (String roleId1 : roleIds) {
                    if (ToolUtil.isEmpty((Object)roleId1)) continue;
                    SysStruRole sysStruRole = new SysStruRole();
                    sysStruRole.setStruId(struId);
                    sysStruRole.setGrantedRole(roleId1);
                    sysStruRole.setCreateTime(date);
                    sysStruRole.setLastTime(date);
                    sysStruRole.setCreator(userId);
                    sysStruRole.setLastEditor(userId);
                    struRoleList.add(sysStruRole);
                }
                if (ToolUtil.isNotEmpty(struRoleList)) {
                    this.sysStruRoleService.saveBatch(struRoleList, struRoleList.size());
                    this.abstractPushMsgMatcher.insertOperation("struRole", "add", struRoleList, "");
                }
            }
            this.iSysOrgEventService.afterEdit(sysStru, sysOrgan, sysOffice);
        }
        return json;
    }

    private void insertAndUpdateStruRoleAudit(List<String> roleIds, List<SysStruRoleAudit> auditList, String struId, String operationType) {
        ArrayList<SysStruRoleAudit> updateAuditList = new ArrayList<SysStruRoleAudit>();
        HashMap<String, Object> updateMap = new HashMap<String, Object>();
        ArrayList<SysStruRoleAudit> addAuditList = new ArrayList<SysStruRoleAudit>();
        Date currentDate = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        String account = ToolUtil.isNotEmpty((Object)ShiroKit.getUser()) ? ShiroKit.getUser().getAccount() : null;
        for (String roleId : roleIds) {
            boolean isExist = false;
            for (SysStruRoleAudit sysStruRoleAudit : auditList) {
                if (!roleId.equals(sysStruRoleAudit.getRoleId())) continue;
                isExist = true;
                updateAuditList.add(sysStruRoleAudit);
                break;
            }
            if (isExist) continue;
            SysStruRoleAudit sysStruRoleAudit = new SysStruRoleAudit();
            sysStruRoleAudit.setStruId(struId);
            sysStruRoleAudit.setRoleId(roleId);
            sysStruRoleAudit.setStatus(UserRoleStatus.LOCKED.getCode());
            sysStruRoleAudit.setOperationType(operationType);
            sysStruRoleAudit.setCreateTime(currentDate);
            sysStruRoleAudit.setLastTime(currentDate);
            sysStruRoleAudit.setCreator(account);
            sysStruRoleAudit.setLastEditor(account);
            addAuditList.add(sysStruRoleAudit);
        }
        if (updateAuditList.size() > 0) {
            updateMap.put("struId", struId);
            updateMap.put("operationType", operationType);
            updateMap.put("status", UserRoleStatus.LOCKED.getCode());
            updateMap.put("lastTime", currentDate);
            updateMap.put("lastEditor", account);
            updateMap.put("updateAuditList", updateAuditList);
            this.sysStruRoleAuditMapper.updateAuditBatch(updateMap);
        }
        if (addAuditList.size() > 0) {
            this.sysStruRoleAuditService.saveBatch(addAuditList);
        }
    }

    private void auditAdd(SysOrgan sysOrgan, SysStru sysStru, SysStaff sysStaff, SysOffice sysOffice, String flag) {
        SysOrganAudit sysOrganAudit = new SysOrganAudit();
        CopyPropertieUtils.copyProperties((Object)((Object)sysOrganAudit), (Object)((Object)sysOrgan));
        sysOrganAudit.setInUse(flag);
        if (DELETE.equals(flag)) {
            sysOrganAudit.setRealOrganId(sysOrgan.getOrganId());
            sysOrganAudit.setOrganId(null);
        }
        this.iSysOrganAuditService.save((Object)sysOrganAudit);
        SysStruAudit sysStruAudit = new SysStruAudit();
        CopyPropertieUtils.copyProperties((Object)((Object)sysStruAudit), (Object)((Object)sysStru));
        sysStruAudit.setOrganId(sysOrganAudit.getOrganId());
        if (DELETE.equals(flag)) {
            sysStruAudit.setOrganId(sysOrganAudit.getOrganId());
            sysStruAudit.setRealStruId(sysStru.getStruId());
            sysStruAudit.setStruId(null);
            sysStruAudit.setLastTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        }
        sysStruAudit.setState("0");
        sysStruAudit.setInUse(flag);
        this.iSysStruAuditService.save((Object)sysStruAudit);
        if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
            SysStaffAudit sysStaffAudit = new SysStaffAudit();
            CopyPropertieUtils.copyProperties((Object)((Object)sysStaffAudit), (Object)((Object)sysStaff));
            sysStaffAudit.setStruId(sysStruAudit.getStruId());
            if (DELETE.equals(flag)) {
                sysStaffAudit.setStruId(sysStruAudit.getStruId());
                sysStaffAudit.setRealStaffId(sysStaff.getStaffId());
                sysStaffAudit.setStaffId(null);
            }
            this.iSysStaffAuditService.save((Object)sysStaffAudit);
        }
        if (ToolUtil.isNotEmpty((Object)((Object)sysOffice))) {
            SysOfficeAudit sysOfficeAudit = new SysOfficeAudit();
            CopyPropertieUtils.copyProperties((Object)((Object)sysOfficeAudit), (Object)((Object)sysOffice));
            sysOfficeAudit.setStruId(sysStruAudit.getStruId());
            if (DELETE.equals(flag)) {
                sysOfficeAudit.setStruId(sysStruAudit.getStruId());
                sysOfficeAudit.setRealOfficeId(sysOffice.getOfficeId());
                sysOfficeAudit.setOfficeId(null);
            }
            this.iSysOfficeAuditService.save((Object)sysOfficeAudit);
        }
    }

    @Override
    public List<SysStruRule> getOrgRoleByCode(String orgType, String isRoot) {
        return this.sysStruRuleMapper.getOrgRoleByCode(orgType, isRoot);
    }

    @Override
    public List<JSTreeModel> getOrgTreeById(String orgId, String isEmployee) {
        return this.sysStruMapper.getOrgTreeById(orgId, isEmployee);
    }

    @Override
    public List<JSTreeModel> selfRoleTree(String[] roleIds) {
        return this.sysStruMapper.selfRoleTree(roleIds);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrgTreeOrder(JSONArray treeArr) {
        ArrayList<SysStru> sysStruList = new ArrayList<SysStru>();
        for (int i = 0; i < treeArr.size(); ++i) {
            JSONObject json = treeArr.getJSONObject(i);
            SysStru sysStru = new SysStru();
            sysStru.setStruId(json.getString("id"));
            long order = Long.parseLong(json.getString("struOrder"));
            sysStru.setStruOrder(BigDecimal.valueOf(order));
            sysStruList.add(sysStru);
        }
        if (ToolUtil.isNotEmpty(sysStruList)) {
            this.updateBatchById(sysStruList, sysStruList.size());
        }
        this.abstractPushMsgMatcher.insertOperation("organ", "update", treeArr, "");
        SysStru sysStru = (SysStru)((Object)this.sysStruMapper.selectById((Serializable)((Object)treeArr.getJSONObject(0).getString("id"))));
        if (ToolUtil.isNotEmpty((Object)((Object)sysStru)) && ToolUtil.isNotEmpty((Object)sysStru.getOrganId())) {
            String organType = ((SysOrgan)((Object)this.sysOrganMapper.selectById((Serializable)((Object)sysStru.getOrganId())))).getOrganType();
            if (treeArr.size() != 0 && !ToolUtil.equals((Object)"9", (Object)organType)) {
                this.bpmAbstractPushMsgMatcher.pushOrganSort(null, null, treeArr);
            }
        }
    }

    @Override
    public List<JSTreeModel> getUserTree() {
        return this.sysStruMapper.getUserTree();
    }

    @Override
    public List<String> getEmpolyeeId(List<String> list6) {
        return this.sysStruMapper.getEmpolyeeId(list6);
    }

    @Override
    public List<ProxyTreeVo> getProxyTree(String[] proxys) {
        return this.sysStruMapper.getProxyTree(proxys);
    }

    @Override
    public List<JSTreeModel> getUserOrderTree(String orgId) {
        return this.sysStruMapper.getUserOrderTree(orgId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JSONObject delOrgById(String orgId) {
        this.iSysOrgEventService.beforeDel(orgId);
        List<Map<String, Object>> orgList = this.sysStruMapper.getOrgListByParentId(orgId);
        List<Map<String, Object>> userList = this.sysUsersMapper.getUsersByOrgId(orgId);
        List<Map<String, Object>> roleList = this.sysRolesMapper.getRolesByOrgId(orgId);
        List<Map<String, Object>> noRoleList = this.sysConfRolesetMapper.getRolesByOrgId(orgId);
        boolean isDel = true;
        StringBuffer msg = new StringBuffer();
        msg.append("\u65e0\u6cd5\u5220\u9664\uff01");
        StringBuilder reason = new StringBuilder();
        boolean hasOther = false;
        if (ToolUtil.isNotEmpty(orgList)) {
            isDel = false;
            reason.append("\u5b58\u5728\u4e0b\u7ea7\u7ec4\u7ec7\u673a\u6784\u6216\u4eba\u5458\uff01");
            hasOther = true;
        }
        if (ToolUtil.isNotEmpty(userList)) {
            isDel = false;
            reason.append("\u5b58\u5728\u5173\u8054\u7528\u6237\uff01");
            hasOther = true;
        }
        if (ToolUtil.isNotEmpty(roleList)) {
            isDel = false;
            reason.append("\u5b58\u5728\u5173\u8054\u89d2\u8272\uff01");
            hasOther = true;
        }
        if (ToolUtil.isNotEmpty(noRoleList)) {
            isDel = false;
            reason.append("\u5b58\u5728\u5173\u8054\u4e0d\u76f8\u5bb9\u89d2\u8272\uff01");
            hasOther = true;
        }
        if (hasOther) {
            msg.append("\uff08");
            msg.append((CharSequence)reason);
            msg.append("\uff09");
        }
        this.iSysOrgEventService.afterDel(orgId);
        JSONObject json = new JSONObject();
        json.put("success", (Object)isDel);
        if (!this.iSysStruAuditService.checkCanOperate(orgId)) {
            json.put("success", (Object)false);
            json.put("msg", (Object)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u5220\u9664\uff01");
            return json;
        }
        if (isDel) {
            if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isOrganAudit()) {
                SysStru sysStru = (SysStru)((Object)this.sysStruMapper.selectById((Serializable)((Object)orgId)));
                SysStruAudit sysStruAudit = new SysStruAudit();
                CopyPropertieUtils.copyProperties((Object)((Object)sysStruAudit), (Object)((Object)sysStru));
                sysStruAudit.setStruId(null);
                sysStruAudit.setRealStruId(sysStru.getStruId());
                sysStruAudit.setState("0");
                sysStruAudit.setInUse("3");
                this.iSysStruAuditService.save((Object)sysStruAudit);
                json.put("msg", (Object)"\u5220\u9664\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
            } else {
                this.sysStruMapper.deleteByOrgId(orgId);
                this.abstractPushMsgMatcher.insertOperation("organ", "delete", orgId, "");
                if (!ToolUtil.equals((Object)"9", (Object)((SysOrgan)((Object)this.sysOrganMapper.selectById((Serializable)((Object)((SysStru)((Object)this.sysStruMapper.selectById((Serializable)((Object)orgId)))).getOrganId())))).getOrganType())) {
                    this.bpmAbstractPushMsgMatcher.delete("organ", orgId, "");
                }
                json.put("msg", (Object)"\u5220\u9664\u6210\u529f\uff01");
            }
        } else {
            json.put("msg", (Object)msg);
        }
        return json;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JSONObject delOrgByIdVue(String orgId) {
        this.iSysOrgEventService.beforeDel(orgId);
        List<Map<String, Object>> orgList = this.sysStruMapper.getOrgListByParentId(orgId);
        List<Map<String, Object>> userList = this.sysUsersMapper.getUsersByOrgId(orgId);
        List<Map<String, Object>> roleList = this.sysRolesMapper.getRolesByOrgId(orgId);
        List<Map<String, Object>> noRoleList = this.sysConfRolesetMapper.getRolesByOrgId(orgId);
        List<SysStruAssistOrgan> assistOrganChildrenList = this.iSysStruAssistOrganService.getAssistOrganByParent(orgId);
        boolean isDel = true;
        StringBuffer msg = new StringBuffer();
        msg.append("\u65e0\u6cd5\u5220\u9664\uff01");
        StringBuilder reason = new StringBuilder();
        boolean hasOther = false;
        if (ToolUtil.isNotEmpty(orgList)) {
            isDel = false;
            reason.append("\u5b58\u5728\u4e0b\u7ea7\u7ec4\u7ec7\u673a\u6784\u6216\u4eba\u5458\uff01");
            hasOther = true;
        }
        if (ToolUtil.isNotEmpty(userList)) {
            isDel = false;
            reason.append("\u5b58\u5728\u5173\u8054\u7528\u6237\uff01");
            hasOther = true;
        }
        if (ToolUtil.isNotEmpty(roleList)) {
            isDel = false;
            reason.append("\u5b58\u5728\u5173\u8054\u89d2\u8272\uff01");
            hasOther = true;
        }
        if (ToolUtil.isNotEmpty(noRoleList)) {
            isDel = false;
            reason.append("\u5b58\u5728\u5173\u8054\u4e0d\u76f8\u5bb9\u89d2\u8272\uff01");
            hasOther = true;
        }
        if (ToolUtil.isNotEmpty(assistOrganChildrenList)) {
            isDel = false;
            reason.append("\u5b58\u5728\u4e0b\u7ea7\u517c\u4efb\u4eba\u5458\uff01");
            hasOther = true;
        }
        if (hasOther) {
            msg.append("\uff08");
            msg.append((CharSequence)reason);
            msg.append("\uff09");
        }
        this.iSysOrgEventService.afterDel(orgId);
        JSONObject json = new JSONObject();
        json.put("success", (Object)isDel);
        if (!this.iSysStruAuditService.checkCanOperate(orgId)) {
            json.put("success", (Object)false);
            json.put("msg", (Object)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u5220\u9664\uff01");
            return json;
        }
        if (isDel) {
            if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isOrganAudit()) {
                SysStru sysStru = (SysStru)((Object)this.sysStruMapper.selectById((Serializable)((Object)orgId)));
                SysStruAudit sysStruAudit = new SysStruAudit();
                CopyPropertieUtils.copyProperties((Object)((Object)sysStruAudit), (Object)((Object)sysStru));
                sysStruAudit.setStruId(null);
                sysStruAudit.setRealStruId(sysStru.getStruId());
                sysStruAudit.setState("0");
                sysStruAudit.setInUse("3");
                this.iSysStruAuditService.save((Object)sysStruAudit);
                json.put("msg", (Object)"\u5220\u9664\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
            } else {
                this.sysStruMapper.deleteByOrgId(orgId);
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"stru_id", (Object)orgId);
                this.sysStruRoleAuditMapper.delete((Wrapper)queryWrapper);
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"stru_id", (Object)orgId);
                this.sysStruAssistOrganMapper.delete((Wrapper)wrapper);
                this.abstractPushMsgMatcher.insertOperation("organ", "delete", orgId, "");
                if (!ToolUtil.equals((Object)"9", (Object)((SysOrgan)((Object)this.sysOrganMapper.selectById((Serializable)((Object)((SysStru)((Object)this.sysStruMapper.selectById((Serializable)((Object)orgId)))).getOrganId())))).getOrganType())) {
                    this.bpmAbstractPushMsgMatcher.delete("organ", orgId, "");
                }
                json.put("msg", (Object)"\u5220\u9664\u6210\u529f\uff01");
            }
        } else {
            json.put("msg", (Object)msg);
        }
        return json;
    }

    @Override
    public Long getMaxOrderById(String parentId) {
        return this.sysStruMapper.getMaxOrderById(parentId);
    }

    @Override
    public Page<Map<String, Object>> getPageList(Page page, String string) {
        page.setRecords(this.sysOrganMapper.selectOrgList(page, "string"));
        return page;
    }

    @Override
    public Page getPrincipalSelectList(Page page, String userName, String departmentName) {
        page.setRecords(this.sysUsersMapper.getPrincipalSelectList(page, userName, departmentName));
        return page;
    }

    @Override
    public Page getPrincipalSelectList(Page page, String userName, String departmentName, String deptId) {
        page.setRecords(this.sysUsersMapper.getGrantPrincipalSelectList(page, userName, departmentName, deptId));
        return page;
    }

    @Override
    public Page getPrincipalSelectListByOrgIds(Page page, String userName, String departmentName, Set<String> orgIds, String type) {
        if ("4".equals(type)) {
            orgIds.addAll(this.getSelfOrgList());
        }
        page.setRecords(this.sysUsersMapper.getPrincipalSelectListByOrgIds(page, userName, departmentName, orgIds));
        return page;
    }

    @Override
    public List<JSTreeModel> orgChangeById(String orgId, String isEmployee) {
        return this.sysStruMapper.orgChangeById(orgId, isEmployee);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JSONObject orgTreeChange(String orgId, String parentId, String orgType, String isRoot, String changeLevel) {
        this.iSysOrgEventService.beforeOrgChange(orgId, parentId);
        List<Map<String, Object>> map = this.sysStruRuleMapper.getOrgRoleById(parentId, orgType);
        if (ToolUtil.isNotEmpty((Object)isRoot) && ADD.equals(isRoot)) {
            map = this.sysStruRuleMapper.getOrgTypeByType(orgType, isRoot);
        }
        JSONObject json = new JSONObject();
        if (!this.iSysStruAuditService.checkCanOperate(orgId)) {
            json.put("success", (Object)false);
            json.put("msg", (Object)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u8f6c\u79fb\uff01");
            return json;
        }
        if (map.size() == 0) {
            json.put("success", (Object)false);
            json.put("msg", (Object)"\u8f6c\u79fb\u5931\u8d25\uff01\uff08\u8be5\u8f6c\u79fb\u4e0d\u7b26\u5408\u7ec4\u7ec7\u673a\u6784\u89c4\u5219\uff01\uff09");
        } else {
            SysUsers user = null;
            if ("9".equals(orgType) && (user = (SysUsers)((Object)SqlHelper.getObject((Log)this.log, (List)this.sysUsersMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"EMPLOYEE_ID", (Object)orgId))))) != null) {
                if (this.iSysUsersAuditService.adjustEdit(user.getUserId())) {
                    json.put("success", (Object)false);
                    json.put("msg", (Object)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u8f6c\u79fb\uff01");
                    return json;
                }
                user.setCorporationId(parentId);
                user.setDepartmentId(parentId);
            }
            long orderTree = 1L;
            Long maxOrder = this.sysStruMapper.getMaxOrderById(parentId);
            if (ToolUtil.isNotEmpty((Object)maxOrder)) {
                orderTree = maxOrder + 1L;
            }
            BigDecimal struOrder = BigDecimal.valueOf(orderTree);
            long level = Long.valueOf(changeLevel) + 1L;
            if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isOrganAudit()) {
                SysStru sysStru = (SysStru)((Object)this.sysStruMapper.selectById((Serializable)((Object)orgId)));
                SysStruAudit sysStruAudit = new SysStruAudit();
                CopyPropertieUtils.copyProperties((Object)((Object)sysStruAudit), (Object)((Object)sysStru));
                sysStruAudit.setStruId(null);
                sysStruAudit.setInUse("4");
                sysStruAudit.setStruOrder(struOrder);
                sysStruAudit.setRealStruId(sysStru.getStruId());
                sysStruAudit.setState("0");
                sysStruAudit.setStruLevel(BigDecimal.valueOf(level));
                sysStruAudit.setParentId(parentId);
                this.iSysStruAuditService.save((Object)sysStruAudit);
                if (user != null) {
                    SysUsersAudit sysUsersAudit = new SysUsersAudit();
                    CopyPropertieUtils.copyProperties((Object)((Object)sysUsersAudit), (Object)((Object)user));
                    sysUsersAudit.setIsAudit("0");
                    sysUsersAudit.setCreateTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
                    sysUsersAudit.setCurrentStatus("3");
                    this.sysUsersAuditMapper.insert((Object)sysUsersAudit);
                }
                json.put("success", (Object)true);
                json.put("msg", (Object)"\u8f6c\u79fb\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
            } else {
                this.sysStruMapper.orgTreeChange(orgId, parentId, struOrder, level);
                if (user != null) {
                    this.sysUsersMapper.updateById((Object)user);
                    this.bpmAbstractPushMsgMatcher.pushUser(user, "update", null);
                } else {
                    this.bpmAbstractPushMsgMatcher.pushOrgan((SysOrgan)((Object)this.sysOrganMapper.selectById((Serializable)((Object)orgId))), (SysStru)((Object)this.sysStruMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"organ_id", (Object)orgId))), "update");
                }
                json.put("success", (Object)true);
                json.put("msg", (Object)"\u8f6c\u79fb\u6210\u529f\uff01");
                SysStru sysStru = new SysStru();
                sysStru.setStruId(orgId);
                sysStru.setParentId(parentId);
                sysStru.setStruOrder(struOrder);
                sysStru.setStruLevel(new BigDecimal(level));
                JSONObject object = new JSONObject();
                object.put("sysStru", (Object)sysStru);
                this.abstractPushMsgMatcher.insertOperation("organ", "update", object, "");
            }
            this.iSysOrgEventService.afterOrgChange(orgId, parentId);
        }
        return json;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JSONObject orgTreeChangeVue(String orgId, String parentId, String orgType, String isRoot, String changeLevel) {
        this.iSysOrgEventService.beforeOrgChange(orgId, parentId);
        List<Map<String, Object>> map = this.sysStruRuleMapper.getOrgRoleById(parentId, orgType);
        if (ToolUtil.isNotEmpty((Object)isRoot) && ADD.equals(isRoot)) {
            map = this.sysStruRuleMapper.getOrgTypeByType(orgType, isRoot);
        }
        JSONObject json = new JSONObject();
        if (!this.iSysStruAuditService.checkCanOperate(orgId)) {
            json.put("success", (Object)false);
            json.put("msg", (Object)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u8f6c\u79fb\uff01");
            return json;
        }
        if (map.size() == 0) {
            json.put("success", (Object)false);
            json.put("msg", (Object)"\u8f6c\u79fb\u5931\u8d25\uff01\uff08\u8be5\u8f6c\u79fb\u4e0d\u7b26\u5408\u7ec4\u7ec7\u673a\u6784\u89c4\u5219\uff01\uff09");
        } else {
            SysUsers user = null;
            if ("9".equals(orgType) && (user = (SysUsers)((Object)SqlHelper.getObject((Log)this.log, (List)this.sysUsersMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"EMPLOYEE_ID", (Object)orgId))))) != null) {
                if (this.iSysUsersAuditService.adjustEdit(user.getUserId())) {
                    json.put("success", (Object)false);
                    json.put("msg", (Object)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u8f6c\u79fb\uff01");
                    return json;
                }
                user.setCorporationId(parentId);
                user.setDepartmentId(parentId);
            }
            long orderTree = 1L;
            Long maxOrder = this.sysStruMapper.getMaxOrderById(parentId);
            if (ToolUtil.isNotEmpty((Object)maxOrder)) {
                orderTree = maxOrder + 1L;
            }
            BigDecimal struOrder = BigDecimal.valueOf(orderTree);
            long level = Long.valueOf(changeLevel) + 1L;
            if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isOrganAudit()) {
                SysStru sysStru = (SysStru)((Object)this.sysStruMapper.selectById((Serializable)((Object)orgId)));
                SysStruAudit sysStruAudit = new SysStruAudit();
                CopyPropertieUtils.copyProperties((Object)((Object)sysStruAudit), (Object)((Object)sysStru));
                sysStruAudit.setStruId(null);
                sysStruAudit.setInUse("4");
                sysStruAudit.setStruOrder(struOrder);
                sysStruAudit.setRealStruId(sysStru.getStruId());
                sysStruAudit.setState("0");
                sysStruAudit.setStruLevel(BigDecimal.valueOf(level));
                sysStruAudit.setParentId(parentId);
                this.iSysStruAuditService.save((Object)sysStruAudit);
                if (user != null) {
                    SysUsersAudit sysUsersAudit = new SysUsersAudit();
                    CopyPropertieUtils.copyProperties((Object)((Object)sysUsersAudit), (Object)((Object)user));
                    sysUsersAudit.setIsAudit("0");
                    sysUsersAudit.setCreateTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
                    sysUsersAudit.setCurrentStatus("3");
                    this.sysUsersAuditMapper.insert((Object)sysUsersAudit);
                }
                json.put("success", (Object)true);
                json.put("msg", (Object)"\u8f6c\u79fb\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
            } else {
                this.orgCodeChange(orgId, parentId, orgType, level);
                this.sysStruMapper.orgTreeChange(orgId, parentId, struOrder, level);
                QueryWrapper wrapper = new QueryWrapper();
                ((QueryWrapper)wrapper.eq((Object)"stru_id", (Object)orgId)).eq((Object)"assist_parent_id", (Object)parentId);
                this.sysStruAssistOrganMapper.delete((Wrapper)wrapper);
                if (user != null) {
                    this.sysUsersMapper.updateById((Object)user);
                    this.bpmAbstractPushMsgMatcher.pushUser(user, "update", null);
                } else {
                    this.bpmAbstractPushMsgMatcher.pushOrgan((SysOrgan)((Object)this.sysOrganMapper.selectById((Serializable)((Object)orgId))), (SysStru)((Object)this.sysStruMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"organ_id", (Object)orgId))), "update");
                }
                json.put("success", (Object)true);
                json.put("msg", (Object)"\u8f6c\u79fb\u6210\u529f\uff01");
                SysStru sysStru = new SysStru();
                sysStru.setStruId(orgId);
                sysStru.setParentId(parentId);
                sysStru.setStruOrder(struOrder);
                sysStru.setStruLevel(new BigDecimal(level));
                JSONObject object = new JSONObject();
                object.put("sysStru", (Object)sysStru);
                this.abstractPushMsgMatcher.insertOperation("organ", "update", object, "");
            }
            this.iSysOrgEventService.afterOrgChangeVue();
        }
        return json;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateMoveNode(String orgId, boolean isUp) {
        SysStru thatStru;
        SysStru thisStru = (SysStru)((Object)this.sysStruMapper.selectById((Serializable)((Object)orgId)));
        QueryWrapper ew = (QueryWrapper)new QueryWrapper().eq((Object)"PARENT_ID", (Object)thisStru.getParentId());
        if (isUp) {
            ((QueryWrapper)((QueryWrapper)((QueryWrapper)ew.lt((Object)"STRU_ORDER", (Object)thisStru.getStruOrder())).eq((Object)"in_use", (Object)ADD)).ne((Object)"stru_type", (Object)"9")).orderByDesc((Object)"STRU_ORDER");
        } else {
            ((QueryWrapper)((QueryWrapper)((QueryWrapper)ew.gt((Object)"STRU_ORDER", (Object)thisStru.getStruOrder())).eq((Object)"in_use", (Object)ADD)).ne((Object)"stru_type", (Object)"9")).orderByAsc((Object)"STRU_ORDER");
        }
        List thatStruList = this.sysStruMapper.selectList((Wrapper)ew);
        if (thatStruList.size() > 0 && (thatStru = (SysStru)((Object)thatStruList.get(0))) != null) {
            BigDecimal temp = thisStru.getStruOrder();
            thisStru.setStruOrder(thatStru.getStruOrder());
            thatStru.setStruOrder(temp);
            this.sysStruMapper.updateById((Object)thisStru);
            JSONObject object = new JSONObject();
            object.put("sysStru", (Object)thisStru);
            this.abstractPushMsgMatcher.insertOperation("organ", "update", object, "");
            this.sysStruMapper.updateById((Object)thatStru);
            JSONObject object1 = new JSONObject();
            object1.put("sysStru", (Object)thatStru);
            this.abstractPushMsgMatcher.insertOperation("organ", "update", object1, "");
            this.bpmAbstractPushMsgMatcher.pushOrganSort(thisStru, thatStru, null);
        }
    }

    @Override
    public List<JSTreeModel> getUserTree(String parentId) {
        return this.sysStruMapper.getLazyLoadingUserTree(parentId);
    }

    @Override
    public List<JSTreeModel> getUserDepChildTree(String parentId) {
        return this.sysStruMapper.getLazyLoadingUserDepTree(parentId);
    }

    @Override
    public JSTreeModel getOneOrg(String struId) {
        return this.sysStruMapper.getOneOrg(struId);
    }

    @Override
    public List<JSTreeModel> getGradeStruTree(List<JSTreeModel> list1, int currentLevel) {
        String struId;
        ShiroUser shiroUser = ShiroKit.getUser();
        String currentStruId = shiroUser.getEmployeeId();
        String currentUserId = shiroUser.getId();
        String deptId = shiroUser.getDeptId();
        List<SysStru> list = this.sysStruMapper.getParentStruTree(currentLevel);
        List<SysStru> childList = this.sysStruMapper.getChildStruTree(currentLevel - 1);
        HashMap<String, String> idMap = new HashMap<String, String>();
        for (SysStru sysStru : list) {
            String id = sysStru.getStruId();
            String parentId = sysStru.getParentId();
            idMap.put(id, parentId);
        }
        String parentId = currentStruId;
        ArrayList<String> idList = new ArrayList<String>();
        do {
            struId = parentId;
            parentId = (String)idMap.get(struId);
            idList.add(struId);
            idList.add(parentId);
        } while (idMap.containsKey(parentId));
        HashMap<String, String> childIdMap = new HashMap<String, String>();
        for (SysStru sysStru : childList) {
            String id = sysStru.getStruId();
            String parentId2 = sysStru.getParentId();
            childIdMap.put(id, parentId2);
        }
        ArrayList<String> childIdList = new ArrayList<String>();
        struId = deptId;
        this.getAllChilden(childIdMap, childIdList, struId);
        int i = -1;
        ArrayList<JSTreeModel> rtnList = new ArrayList<JSTreeModel>();
        for (JSTreeModel jsTreeModel : list1) {
            String type;
            ++i;
            String modelId = jsTreeModel.getId();
            String struLevelStr = jsTreeModel.getStruLevel();
            int struLevel = 0;
            if (struLevelStr != null) {
                struLevel = Integer.parseInt(struLevelStr);
            }
            if (struLevel == currentLevel - 1) {
                jsTreeModel.getState().put("changeDisabled", true);
            }
            if (struLevel < currentLevel) {
                if (!idList.contains(modelId)) continue;
                if (struLevel < currentLevel - 1) {
                    jsTreeModel.getState().put("gradeDisabled", true);
                }
                rtnList.add(jsTreeModel);
                continue;
            }
            if (struLevel == currentLevel) {
                if (list1.get(i).getPrime() != null && "0".equals(list1.get(i).getPrime())) {
                    jsTreeModel.getState().put("isOrganRoleNode", true);
                    rtnList.add(jsTreeModel);
                    continue;
                }
                String parent = jsTreeModel.getParent();
                if (!deptId.equals(parent)) continue;
                type = jsTreeModel.getType();
                rtnList.add(jsTreeModel);
                if ("ORGANROLE".equals(type)) {
                    jsTreeModel.getState().put("isOrganRoleNode", true);
                    continue;
                }
                if ("USER".equals(type)) {
                    if (!modelId.equals(currentUserId)) continue;
                    jsTreeModel.getState().put("currentUser", true);
                    continue;
                }
                if (!modelId.equals(currentStruId)) continue;
                jsTreeModel.getState().put("currentEmployee", true);
                continue;
            }
            String id = jsTreeModel.getId();
            type = jsTreeModel.getType();
            if ("ORGANROLE".equals(type)) {
                id = jsTreeModel.getParent();
                jsTreeModel.getState().put("isOrganRoleNode", true);
            }
            if ("USER".equals(type)) {
                id = jsTreeModel.getEmployeeId();
            }
            if (!childIdList.contains(id)) continue;
            rtnList.add(jsTreeModel);
        }
        return rtnList;
    }

    @Override
    public List<JSTreeModel> getOrgTree(String isEmployee, String parentId) {
        return this.sysStruMapper.getLazyLoadingOrgTree(isEmployee, parentId);
    }

    @Override
    public OrganInfoVo getOldOrgInfoById(String struId) {
        return this.sysStruMapper.getOldOrgInfoById(struId);
    }

    @Override
    public List<Object> getRoleOrgUser(Page<Object> page, String roleId, String orgId, String name, String account) {
        ShiroUser user = ShiroKit.getUser();
        Map<String, Object> map = ShiroFactroy.me().getDataScopeInfo(user);
        String type = map.get("data_scope_type").toString();
        if (user.isGradeadmin()) {
            String deptId = user.getDeptId();
            if (orgId == null) {
                return new ArrayList<Object>();
            }
            SysStru stru = (SysStru)((Object)this.sysStruMapper.selectById((Serializable)((Object)orgId)));
            if (stru == null) {
                return new ArrayList<Object>();
            }
            int checkResult = this.sysStruMapper.checkIsGradeStru(deptId, orgId);
            if (checkResult == 1) {
                return this.sysStruMapper.getRoleOrgUser(page, roleId, orgId, name, account);
            }
            return new ArrayList<Object>();
        }
        if (!ADD.equals(type) && ToolUtil.isEmpty((Object)orgId)) {
            Set orgList = (Set)map.get("data_scope_list");
            if ("4".equals(type)) {
                orgList.addAll(this.getSelfOrgList());
            }
            return this.sysStruMapper.getRoleOrgUserByOrgIds(page, roleId, orgList, name, account);
        }
        return this.sysStruMapper.getRoleOrgUser(page, roleId, orgId, name, account);
    }

    @Override
    public List<JSTreeModel> geOrganRoleTree(String parentId) {
        return this.sysStruMapper.getLazyLoadingOrganRoleTree(parentId);
    }

    private List<String> getKey(Map<String, String> map, Object value) {
        Set<Map.Entry<String, String>> set = map.entrySet();
        Iterator<Map.Entry<String, String>> iterator = set.iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if (!entry.getValue().equals(value)) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    private void getAllChilden(Map<String, String> childIdMap, List<String> childIdList, String struId) {
        List<String> tmpList;
        if (childIdMap.containsValue(struId) && (tmpList = this.getKey(childIdMap, struId)).size() > 0) {
            for (String string : tmpList) {
                childIdList.add(string);
                this.getAllChilden(childIdMap, childIdList, string);
            }
        }
    }

    @Override
    public void exportData(List<String> idList, HttpServletResponse response) {
        List strus = this.sysStruMapper.selectBatchIds(idList);
        ArrayList<String> organIdList = new ArrayList<String>();
        ArrayList<String> struTypeList = new ArrayList<String>();
        for (SysStru sysStru : strus) {
            String organId = sysStru.getOrganId();
            String struType = sysStru.getStruType();
            organIdList.add(organId);
            struTypeList.add(struType);
        }
        List organs = this.sysOrganMapper.selectBatchIds(organIdList);
        List organTypes = this.sysOrganTypeMapper.selectBatchIds(struTypeList);
        List offices = this.sysOfficeMapper.selectList((Wrapper)new QueryWrapper().in((Object)"STRU_ID", idList));
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("strus", strus);
        data.put("organs", organs);
        data.put("organTypes", organTypes);
        data.put("offices", offices);
        data.put("export_type", "organ");
        byte[] serializeData = SerializeUtils.serialize(data);
        String fileName = "organ_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile(serializeData, fileName, response);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Tip importData(byte[] content) {
        Map data = (Map)SerializeUtils.deserialize((byte[])content);
        String export_type = (String)data.get("export_type");
        if (!"organ".equals(export_type)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u60a8\u5bfc\u5165\u7684\u662f" + (String)Constants.EXPORT_MAP.get(export_type) + ",\u8bf7\u5bfc\u5165" + (String)Constants.EXPORT_MAP.get("organ"));
        }
        List strus = (List)data.get("strus");
        List organs = (List)data.get("organs");
        List organTypes = (List)data.get("organTypes");
        List offices = (List)data.get("offices");
        Map<String, Integer> struCount = this.insertOrUpdateList(strus);
        Map<String, Integer> organCount = this.insertOrUpdateList(organs);
        Map<String, Integer> organTypeCount = this.insertOrUpdateList(organTypes);
        Map<String, Integer> officeCount = this.insertOrUpdateList(offices);
        SuccessTip success = new SuccessTip();
        success.setMessage("\u5bfc\u5165\u6210\u529f\u3002\u7ec4\u7ec7\u7ed3\u6784\u65b0\u589e\u6570\u636e" + struCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + struCount.get("update") + "\u6761\uff1b\u7ec4\u7ec7\u673a\u6784\u65b0\u589e\u6570\u636e" + organCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + organCount.get("update") + "\u6761\uff1b\u7ec4\u7ec7\u7c7b\u578b\u65b0\u589e\u6570\u636e" + organTypeCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + organTypeCount.get("update") + "\u6761\u3002");
        return success;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Map<String, String> importVueOrg(byte[] content) {
        Map data;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            data = (Map)SerializeUtils.deserialize((byte[])content);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.FILE_READING_ERROR);
        }
        if (ToolUtil.isEmpty((Object)data)) {
            map.put("success", "fileError");
            map.put("message", "\u5bfc\u5165\u6570\u636e\u6709\u8bef");
            map.put("import", "organ");
            return map;
        }
        String export_type = (String)data.get("export_type");
        if (!"organ".equals(export_type)) {
            map.put("success", "false");
            map.put("errorImport", export_type);
            map.put("import", "organ");
            return map;
        }
        List strus = (List)data.get("strus");
        List organs = (List)data.get("organs");
        List organTypes = (List)data.get("organTypes");
        List offices = (List)data.get("offices");
        Map<String, Integer> struCount = this.insertOrUpdateList(strus);
        Map<String, Integer> organCount = this.insertOrUpdateList(organs);
        Map<String, Integer> organTypeCount = this.insertOrUpdateList(organTypes);
        Map<String, Integer> officeCount = this.insertOrUpdateList(offices);
        map.put("success", "true");
        map.put("struInsert", "" + struCount.get("insert"));
        map.put("struUpdate", "" + struCount.get("update"));
        map.put("orgType", "" + struCount.get("insert"));
        map.put("orgUpdate", "" + organTypeCount.get("update"));
        return map;
    }

    @Override
    public JSONObject getImgUrl(HttpServletRequest request) {
        List<SysOrganTypeVo> list = this.sysOrganTypeMapper.getOrganTypeList(new Page(0L, 99999L), null, null);
        JSONObject json = new JSONObject();
        for (SysOrganTypeVo sysOrganTypeVo : list) {
            JSONObject jsonObject = new JSONObject();
            if (request instanceof HttpServletRequest) {
                HttpServletRequest hreq = request;
                String contextPath = "";
                contextPath = hreq.getSession().getServletContext().getContextPath();
                jsonObject.put("icon", (Object)(contextPath + sysOrganTypeVo.getImgUrl()));
            } else {
                jsonObject.put("icon", (Object)(request.getServletContext().getContextPath() + sysOrganTypeVo.getImgUrl()));
            }
            json.put(sysOrganTypeVo.getOrganType(), (Object)jsonObject);
        }
        return json;
    }

    @Override
    public List<JSTreeModel> getOrgTreeById(String orgId, String isEmployee, String isHead) {
        Boolean isRoot = Boolean.valueOf(isHead);
        List<JSTreeModel> result = this.getOrgTreeById(orgId, isEmployee);
        if (isRoot.booleanValue()) {
            JSTreeModel root = new JSTreeModel();
            root.setId("11");
            root.setCode("");
            root.setText("\u7ec4\u7ec7\u673a\u6784");
            root.setStruLevel("0");
            root.setParent("#");
            root.setIsLeaf("0");
            root.setType("isRoot");
            result.add(root);
        }
        return result;
    }

    @Override
    public List<JSTreeModel> getOrgTreeByIdVue(String orgId, String isEmployee, String isHead) {
        Boolean isRoot = Boolean.valueOf(isHead);
        List<JSTreeModel> result = this.getOrgTreeById(orgId, isEmployee);
        Map<String, Object> map = ShiroFactroy.me().getDataScopeInfo(ShiroKit.getUser());
        String dataScopeType = map.get("data_scope_type").toString();
        Set orgList = (Set)map.get("data_scope_list");
        if (!ADD.equals(dataScopeType)) {
            result = this.getDataScopeTree(result, dataScopeType, orgList);
        }
        if (isRoot.booleanValue()) {
            JSTreeModel root = new JSTreeModel();
            root.setId("11");
            root.setCode("");
            root.setText("\u7ec4\u7ec7\u673a\u6784");
            root.setStruLevel("0");
            root.setParent("#");
            root.setIsLeaf("0");
            root.setType("isRoot");
            result.add(root);
        }
        return result;
    }

    private List<SysOrganVo> pageSysOrganList(List<SysOrganVo> allSysOrganVOList, int pageNo, int limit) {
        ArrayList<SysOrganVo> currentPageList = new ArrayList<SysOrganVo>();
        if (allSysOrganVOList != null && allSysOrganVOList.size() > 0) {
            int currIdx = pageNo > 1 ? (pageNo - 1) * limit : 0;
            for (int i = 0; i < limit && i < allSysOrganVOList.size() - currIdx; ++i) {
                SysOrganVo itemData = allSysOrganVOList.get(currIdx + i);
                currentPageList.add(itemData);
            }
        }
        return currentPageList;
    }

    /*
     * WARNING - void declaration
     */
    private List<SysOrganVo> getOrganVOInDataScope(List<SysOrganVo> allSysOrganVOList, String dataScopeType, Set<String> optStruIdList) {
        List<Object> orgCodeList = new ArrayList<String>();
        ShiroUser user = ShiroKit.getUser();
        if (ToolUtil.isNotEmpty(optStruIdList)) {
            orgCodeList = this.sysStruMapper.getOrgCodeListByIdList(new ArrayList<String>(optStruIdList));
        }
        if ("4".equals(dataScopeType)) {
            orgCodeList.addAll(this.sysOrganMapper.selfOrgCode(user.getId()));
            if (ToolUtil.isNotEmpty(orgCodeList)) {
                optStruIdList = new HashSet<String>(this.sysStruMapper.getStruIdByOrgCodeList(orgCodeList));
            }
        }
        SysIdtable sysIdtable = this.sysIdtableMapper.getIdtableByQuery("STRU_CODE", "SYS_STRU");
        int idLength = sysIdtable.getIdLength().intValue();
        HashSet<String> parentCodeList = new HashSet<String>();
        for (String string : orgCodeList) {
            int length = string.length();
            for (int i = length - idLength; i >= 0; i -= idLength) {
                String parentCode = string.substring(0, i);
                parentCodeList.add(parentCode);
            }
        }
        ArrayList<SysOrganVo> dataScopeOrgList = new ArrayList<SysOrganVo>();
        ArrayList arrayList = new ArrayList();
        if (ToolUtil.isNotEmpty(optStruIdList)) {
            if (ToolUtil.isNotEmpty(parentCodeList)) {
                List<String> list = this.sysStruMapper.getStruIdByOrgCodeList(new ArrayList<String>(parentCodeList));
            }
            for (SysOrganVo sysOrganVo : allSysOrganVOList) {
                void var10_13;
                String struId = sysOrganVo.getStruId();
                if (optStruIdList.contains(struId)) {
                    dataScopeOrgList.add(sysOrganVo);
                    continue;
                }
                if (!var10_13.contains(struId)) continue;
                sysOrganVo.setDataScopeDisabled(ADD);
                dataScopeOrgList.add(sysOrganVo);
            }
        }
        return dataScopeOrgList;
    }

    @Override
    public List<JSTreeModel> getDataScopeTree(List<JSTreeModel> list, String type, Set<String> orgListParam) {
        Set<String> orgList = orgListParam;
        ArrayList<String> codeList = new ArrayList<String>();
        ShiroUser user = ShiroKit.getUser();
        if (ToolUtil.isNotEmpty(orgList)) {
            codeList = this.sysStruMapper.getOrgCodeListByIdList(new ArrayList<String>(orgList));
        }
        if ("4".equals(type)) {
            codeList.addAll(this.sysOrganMapper.selfOrgCode(user.getId()));
            if (ToolUtil.isNotEmpty(codeList)) {
                orgList = new HashSet<String>(this.sysStruMapper.getStruIdByOrgCodeList(codeList));
            }
        }
        HashSet<String> parentCodeList = new HashSet<String>();
        SysIdtable sysIdtable = this.sysIdtableMapper.getIdtableByQuery("STRU_CODE", "SYS_STRU");
        int idLength = sysIdtable.getIdLength().intValue();
        ArrayList<JSTreeModel> dataScopeList = new ArrayList<JSTreeModel>();
        for (String code : codeList) {
            int length = code.length();
            for (int i = length - idLength; i >= 0; i -= idLength) {
                String parentCode = code.substring(0, i);
                parentCodeList.add(parentCode);
            }
        }
        List<Object> parentIdList = new ArrayList();
        if (ToolUtil.isNotEmpty(orgList)) {
            if (ToolUtil.isNotEmpty(parentCodeList)) {
                parentIdList = this.sysStruMapper.getStruIdByOrgCodeList(new ArrayList<String>(parentCodeList));
            }
            for (JSTreeModel jsTreeModel : list) {
                String id = jsTreeModel.getId();
                if (orgList.contains(id)) {
                    dataScopeList.add(jsTreeModel);
                } else if (parentIdList.contains(id)) {
                    jsTreeModel.getState().put("dataScopeDisabled", true);
                    dataScopeList.add(jsTreeModel);
                }
                if (!ADD.equals(jsTreeModel.getIsEmployee()) && !"USER".equals(jsTreeModel.getType()) || !orgList.contains(jsTreeModel.getParent())) continue;
                if (jsTreeModel.getId().equals(user.getEmployeeId())) {
                    jsTreeModel.getState().put("currentEmployee", true);
                }
                if (jsTreeModel.getId().equals(user.getId())) {
                    jsTreeModel.getState().put("currentUser", true);
                }
                dataScopeList.add(jsTreeModel);
            }
        }
        return dataScopeList;
    }

    @Override
    public void orgCodeChange(String orgId, String parentId, String orgType, Long level) {
        SysOrgan parentOrg = this.sysStruMapper.getOrganInfoByDeparmentId(parentId);
        SysOrgan sysOrgan = this.sysStruMapper.getOrganInfoByDeparmentId(orgId);
        if ("9".equals(orgType)) {
            String newCode = sysOrgan.getOrganCode().replace(sysOrgan.getParentTypeCode(), parentOrg.getOrganCode());
            sysOrgan.setOrganCode(newCode);
            sysOrgan.setParentTypeCode(parentOrg.getOrganCode());
            this.sysOrganMapper.updateById((Object)sysOrgan);
        } else {
            SysStru sysStru = (SysStru)((Object)this.sysStruMapper.selectById((Serializable)((Object)orgId)));
            long oldLevel = sysStru.getStruLevel().longValue();
            long subLevel = level - oldLevel;
            String businessName = "STRU_CODE";
            String tableName = "SYS_STRU";
            String currentCode = this.sysIdtableService.getCurrentCode(businessName, tableName, parentOrg.getOrganCode());
            sysOrgan.setParentTypeCode(parentOrg.getOrganCode());
            List oldOrganList = this.sysOrganMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().likeRight((Object)"organ_code", (Object)sysOrgan.getOrganCode())).eq((Object)"in_use", (Object)ADD));
            ArrayList<SysOrgan> organList = new ArrayList<SysOrgan>();
            ArrayList<String> organIdList = new ArrayList<String>();
            if (ToolUtil.isNotEmpty((Object)oldOrganList)) {
                for (SysOrgan organ : oldOrganList) {
                    String newCode = organ.getOrganCode().replace(sysOrgan.getOrganCode(), currentCode);
                    organ.setOrganCode(newCode);
                    organ.setParentTypeCode(currentCode);
                    organList.add(organ);
                    organIdList.add(organ.getOrganId());
                }
            }
            sysOrgan.setOrganCode(currentCode);
            organList.add(sysOrgan);
            this.sysOrganService.updateBatchById(organList);
            if (ToolUtil.isNotEmpty(organIdList)) {
                List oldStruList = this.sysStruMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"organ_id", organIdList)).eq((Object)"in_use", (Object)ADD));
                ArrayList<SysStru> sysStruList = new ArrayList<SysStru>();
                for (SysStru stru : oldStruList) {
                    long struLevel = stru.getStruLevel().intValue();
                    stru.setStruLevel(new BigDecimal(struLevel + subLevel));
                    sysStruList.add(stru);
                }
                this.sysStruService.updateBatchById(sysStruList);
            }
        }
    }

    private Map<String, Integer> insertOrUpdateList(List<?> objects) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer update = 0;
        Integer insert = 0;
        if (CollectionUtils.isEmpty(objects)) {
            result.put("update", update);
            result.put("insert", insert);
            return result;
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = objects.size();
            for (int i = 0; i < size; ++i) {
                Integer n;
                Integer n2;
                Object object = objects.get(i);
                if (object instanceof SysStru) {
                    SysStru stru = (SysStru)((Object)object);
                    if (this.updateById((Object)stru)) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.save((Object)stru);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (object instanceof SysOrgan) {
                    SysOrgan organ = (SysOrgan)((Object)object);
                    if (SqlHelper.retBool((Integer)this.sysOrganMapper.updateById((Object)organ))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysOrganMapper.insert((Object)organ);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (object instanceof SysOffice) {
                    SysOffice office = (SysOffice)((Object)object);
                    if (SqlHelper.retBool((Integer)this.sysOfficeMapper.updateById((Object)office))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysOfficeMapper.insert((Object)office);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (object instanceof SysOrganType) {
                    SysOrganType organType = (SysOrganType)((Object)object);
                    if (SqlHelper.retBool((Integer)this.sysOrganTypeMapper.updateById((Object)organType))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysOrganTypeMapper.insert((Object)organType);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new MybatisPlusException("Error: Cannot execute insertOrUpdateBatch Method. Cause", e);
        }
        result.put("update", update);
        result.put("insert", insert);
        return result;
    }

    private Set<String> getSelfOrgList() {
        ShiroUser user = ShiroKit.getUser();
        HashSet<String> orgIds = new HashSet<String>();
        List<String> codeList = this.sysOrganMapper.selfOrgCode(user.getId());
        if (ToolUtil.isNotEmpty(codeList)) {
            orgIds = new HashSet<String>(this.sysStruMapper.getStruIdByOrgCodeList(codeList));
        }
        return orgIds;
    }
}

