/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.organ.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.bsp.audit.model.SysOrganAudit;
import com.jxdinfo.hussar.bsp.audit.model.SysStaffAudit;
import com.jxdinfo.hussar.bsp.audit.model.SysStruAudit;
import com.jxdinfo.hussar.bsp.audit.service.ISysOrganAuditService;
import com.jxdinfo.hussar.bsp.audit.service.ISysStaffAuditService;
import com.jxdinfo.hussar.bsp.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.bsp.audit.service.impl.SysStruAssistOrganAuditServiceImpl;
import com.jxdinfo.hussar.bsp.audit.util.CopyPropertieUtils;
import com.jxdinfo.hussar.bsp.constant.Constants;
import com.jxdinfo.hussar.bsp.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.bsp.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.bsp.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.bsp.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.bsp.organ.model.SysOrgan;
import com.jxdinfo.hussar.bsp.organ.model.SysStaff;
import com.jxdinfo.hussar.bsp.organ.model.SysStru;
import com.jxdinfo.hussar.bsp.organ.service.ISysEmployeeService;
import com.jxdinfo.hussar.bsp.organ.service.ISysStaffService;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.organ.vo.SysStaffVO;
import com.jxdinfo.hussar.bsp.permit.dao.SysStruAssistOrganMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.MessageTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.factory.ShiroFactroy;
import com.jxdinfo.hussar.core.util.DataExportUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SerializeUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.utils.Lists;
import org.apache.ibatis.session.SqlSession;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysEmployeeServiceImpl
extends ServiceImpl<SysStruMapper, SysStru>
implements ISysEmployeeService {
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private SysOrganMapper sysOrganMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysStaffMapper sysStaffMapper;
    @Resource
    private ISysStaffService sysStaffService;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    ISysOrganAuditService iSysOrganAuditService;
    @Resource
    ISysStruAuditService iSysStruAuditService;
    @Resource
    ISysStaffAuditService iSysStaffAuditService;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private SysStruAssistOrganMapper sysStruAssistOrganMapper;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    AbstractPushMsgMatcher abstractPushMsgMatcher;
    @Resource
    ISysStruAssistOrganService iSysStruAssistOrganService;
    @Resource
    SysStruAssistOrganAuditServiceImpl sysStruAssistOrganAuditService;

    @Override
    public List<String> selectRole(String userId) {
        return this.sysStruMapper.selectRole(userId);
    }

    @Override
    public String selectStruLevel(String empolyeeId) {
        return this.sysStruMapper.selectStruLevel(empolyeeId);
    }

    @Override
    public List<String> selectGradeadminRole(String userId) {
        return this.sysStruMapper.selectGradeadminRole(userId);
    }

    @Override
    public List<JSTreeModel> getEmployeeTree(String isEmployee) {
        return this.sysStruMapper.getOrgTree(isEmployee);
    }

    @Override
    public List<JSTreeModel> getEmployeeTreeById(String orgId) {
        return this.sysStruMapper.getEmployeeTreeById(orgId, false);
    }

    @Override
    public List<JSTreeModel> getEmployeeTree(String isEmployee, String parentId) {
        return this.sysStruMapper.getLazyLoadingOrgTree(isEmployee, parentId);
    }

    @Override
    public List<JSTreeModel> getEmployeeTreeVue(String isEmployee, String parentId) {
        return this.sysStruMapper.getLazyLoadingStfTree(isEmployee, parentId);
    }

    @Override
    public List<JSTreeModel> getEmployeeTreeById(String orgId, boolean isUserOnOneEmp) {
        return this.sysStruMapper.getEmployeeTreeById(orgId, isUserOnOneEmp);
    }

    @Override
    public void addStaff(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff) {
        Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        String userId = ShiroKit.getUser().getId();
        sysOrgan.setInUse("1");
        sysOrgan.setCreateTime(date);
        sysOrgan.setCreator(userId);
        sysStru.setStruId(null);
        sysStru.setOrganAlias(sysOrgan.getOrganName());
        sysStru.setIsLeaf("0");
        sysStru.setInUse("1");
        sysStru.setStruPath("");
        sysStru.setStruLevel(sysStru.getStruLevel().add(new BigDecimal(1)));
        sysStru.setCreateTime(date);
        sysStru.setCreator(userId);
        long struOrder = 1L;
        Long maxOrder = this.orgMaintenanceService.getMaxOrderById(sysStru.getParentId());
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            struOrder = maxOrder + 1L;
        }
        sysStru.setStruOrder(new BigDecimal(struOrder));
        this.sysOrganMapper.insert((Object)sysOrgan);
        sysStru.setOrganId(sysOrgan.getOrganId());
        this.sysStruMapper.insert((Object)sysStru);
        if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
            sysStaff.setStruId(sysStru.getStruId());
            sysStaff.setName(sysOrgan.getOrganName());
            this.sysStaffMapper.insert((Object)sysStaff);
        }
        JSONObject object = new JSONObject();
        object.put("sysOrgan", (Object)sysOrgan);
        object.put("sysStru", (Object)sysStru);
        if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
            object.put("sysStaff", (Object)sysStaff);
        }
        this.abstractPushMsgMatcher.insertOperation("person", "add", object, "");
    }

    @Override
    public Tip editStaff(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff) {
        Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        String userId = ShiroKit.getUser().getId();
        sysOrgan.setLastEditor(userId);
        sysOrgan.setLastTime(date);
        sysStru.setLastEditor(userId);
        sysStru.setLastTime(date);
        if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isOrganAudit()) {
            this.auditAdd(sysOrgan, sysStru, sysStaff, "2");
            return new MessageTip("\u4fee\u6539\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
        }
        this.sysOrganMapper.updateById((Object)sysOrgan);
        sysStru.setOrganAlias(sysOrgan.getOrganName());
        this.sysUsersService.update((Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"employee_id", (Object)sysStru.getStruId())).set((Object)"user_name", (Object)sysOrgan.getOrganName()));
        this.sysStruMapper.updateById((Object)sysStru);
        if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
            sysStaff.setName(sysOrgan.getOrganName());
            this.sysStaffService.saveOrUpdate((Object)sysStaff);
        }
        JSONObject object = new JSONObject();
        object.put("sysOrgan", (Object)sysOrgan);
        object.put("sysStru", (Object)sysStru);
        if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
            object.put("sysStaff", (Object)sysStaff);
        }
        this.abstractPushMsgMatcher.insertOperation("person", "update", object, "");
        return new MessageTip("\u4fee\u6539\u6210\u529f\uff01");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Tip editStaffVue(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, String ids) {
        Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        String userId = ShiroKit.getUser().getId();
        sysOrgan.setLastEditor(userId);
        sysOrgan.setLastTime(date);
        sysStru.setLastEditor(userId);
        sysStru.setLastTime(date);
        if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isOrganAudit()) {
            this.auditAdd(sysOrgan, sysStru, sysStaff, "2");
            this.sysStruAssistOrganAuditService.saveAssistOrganAudit(ids, sysStru.getStruId());
            return new MessageTip("\u4fee\u6539\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
        }
        this.sysOrganMapper.updateById((Object)sysOrgan);
        sysStru.setOrganAlias(sysOrgan.getOrganName());
        this.sysUsersService.update((Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"employee_id", (Object)sysStru.getStruId())).set((Object)"user_name", (Object)sysOrgan.getOrganName()));
        this.sysStruMapper.updateById((Object)sysStru);
        if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
            sysStaff.setName(sysOrgan.getOrganName());
            this.sysStaffService.saveOrUpdate((Object)sysStaff);
        }
        String sysStruId = sysStru.getStruId();
        this.iSysStruAssistOrganService.saveAssistOrgan(ids, sysStruId);
        JSONObject object = new JSONObject();
        object.put("sysOrgan", (Object)sysOrgan);
        object.put("sysStru", (Object)sysStru);
        if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
            object.put("sysStaff", (Object)sysStaff);
        }
        this.abstractPushMsgMatcher.insertOperation("person", "update", object, "");
        return new MessageTip("\u4fee\u6539\u6210\u529f\uff01");
    }

    private void auditAdd(SysOrgan sysOrgan, SysStru sysStru, SysStaff sysStaff, String flag) {
        SysOrganAudit sysOrganAudit = new SysOrganAudit();
        CopyPropertieUtils.copyProperties((Object)((Object)sysOrganAudit), (Object)((Object)sysOrgan));
        sysOrganAudit.setInUse(flag);
        if ("2".equals(flag)) {
            sysOrganAudit.setRealOrganId(sysOrgan.getOrganId());
            sysOrganAudit.setOrganId(null);
        }
        this.iSysOrganAuditService.save((Object)sysOrganAudit);
        SysStruAudit sysStruAudit = new SysStruAudit();
        CopyPropertieUtils.copyProperties((Object)((Object)sysStruAudit), (Object)((Object)sysStru));
        sysStruAudit.setOrganId(sysOrganAudit.getOrganId());
        if ("2".equals(flag)) {
            sysStruAudit.setRealStruId(sysStru.getStruId());
            sysStruAudit.setStruId(null);
        }
        sysStruAudit.setState("0");
        sysStruAudit.setInUse(flag);
        this.iSysStruAuditService.save((Object)sysStruAudit);
        if (ToolUtil.isNotEmpty((Object)((Object)sysStaff))) {
            SysStaffAudit sysStaffAudit = new SysStaffAudit();
            CopyPropertieUtils.copyProperties((Object)((Object)sysStaffAudit), (Object)((Object)sysStaff));
            sysStaffAudit.setStruId(sysStruAudit.getStruId());
            if ("2".equals(flag)) {
                sysStaffAudit.setRealStaffId(sysStaff.getStaffId());
                sysStaffAudit.setStaffId(null);
            }
            this.iSysStaffAuditService.save((Object)sysStaffAudit);
        }
    }

    @Override
    public void exportData(List<String> idList, HttpServletResponse response) {
        List strus = this.sysStruMapper.selectBatchIds(idList);
        List staffs = this.sysStaffMapper.selectList((Wrapper)new QueryWrapper().in((Object)"STRU_ID", idList));
        List users = this.sysUsersMapper.selectList((Wrapper)new QueryWrapper().in((Object)"EMPLOYEE_ID", idList));
        ArrayList<String> organIdList = new ArrayList<String>();
        for (SysStru sysStru : strus) {
            String organId = sysStru.getOrganId();
            organIdList.add(organId);
        }
        List organs = this.sysOrganMapper.selectBatchIds(organIdList);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("strus", strus);
        data.put("organs", organs);
        data.put("staffs", staffs);
        data.put("users", users);
        data.put("export_type", "employee");
        byte[] serializeData = SerializeUtils.serialize(data);
        String fileName = "employee_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile(serializeData, fileName, response);
    }

    @Override
    public void exportDataVue(List<String> idList, HttpServletResponse response) {
        List strus = this.sysStruMapper.selectBatchIds(idList);
        List staffs = this.sysStaffMapper.selectList((Wrapper)new QueryWrapper().in((Object)"STRU_ID", idList));
        List users = this.sysUsersMapper.selectList((Wrapper)new QueryWrapper().in((Object)"EMPLOYEE_ID", idList));
        List sysStruAssistOrgan = this.sysStruAssistOrganMapper.selectList((Wrapper)new QueryWrapper().in((Object)"STRU_ID", idList));
        ArrayList<String> organIdList = new ArrayList<String>();
        for (SysStru sysStru : strus) {
            String organId = sysStru.getOrganId();
            organIdList.add(organId);
        }
        List organs = this.sysOrganMapper.selectBatchIds(organIdList);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("strus", strus);
        data.put("organs", organs);
        data.put("staffs", staffs);
        data.put("users", users);
        data.put("sysStruAssistOrgan", sysStruAssistOrgan);
        data.put("export_type", "employee");
        byte[] serializeData = SerializeUtils.serialize(data);
        String fileName = "employee_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile(serializeData, fileName, response);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Tip importData(byte[] content) {
        Map data = (Map)SerializeUtils.deserialize((byte[])content);
        String export_type = (String)data.get("export_type");
        if (!"employee".equals(export_type)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u60a8\u5bfc\u5165\u7684\u662f" + (String)Constants.EXPORT_MAP.get(export_type) + ",\u8bf7\u5bfc\u5165" + (String)Constants.EXPORT_MAP.get("employee"));
        }
        List strus = (List)data.get("strus");
        List organs = (List)data.get("organs");
        List staffs = (List)data.get("staffs");
        List users = (List)data.get("users");
        Map<String, Integer> struCount = this.insertOrUpdateList(strus);
        Map<String, Integer> organCount = this.insertOrUpdateList(organs);
        Map<String, Integer> staffsCount = this.insertOrUpdateList(staffs);
        Map<String, Integer> usersCount = this.insertOrUpdateList(users);
        SuccessTip success = new SuccessTip();
        success.setMessage("\u5bfc\u5165\u6210\u529f\u3002\u4eba\u5458\u65b0\u589e\u6570\u636e" + struCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + struCount.get("update") + "\u6761\uff1b\u4eba\u5458\u8be6\u60c5\u65b0\u589e\u6570\u636e" + staffsCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + staffsCount.get("update") + "\u6761\u3002");
        return success;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Tip importDataVue(byte[] content) {
        Map data = (Map)SerializeUtils.deserialize((byte[])content);
        String export_type = (String)data.get("export_type");
        if (!"employee".equals(export_type)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u60a8\u5bfc\u5165\u7684\u662f" + (String)Constants.EXPORT_MAP.get(export_type) + ",\u8bf7\u5bfc\u5165" + (String)Constants.EXPORT_MAP.get("employee"));
        }
        List strus = (List)data.get("strus");
        List organs = (List)data.get("organs");
        List staffs = (List)data.get("staffs");
        List users = (List)data.get("users");
        List sysStruAssistOrgan = (List)data.get("sysStruAssistOrgan");
        Map<String, Integer> struCount = this.insertOrUpdateList(strus);
        Map<String, Integer> organCount = this.insertOrUpdateList(organs);
        Map<String, Integer> staffsCount = this.insertOrUpdateList(staffs);
        Map<String, Integer> usersCount = this.insertOrUpdateList(users);
        Map<String, Integer> sysStruAssistOrganCount = this.insertOrUpdateList(sysStruAssistOrgan);
        SuccessTip success = new SuccessTip();
        success.setMessage("\u5bfc\u5165\u6210\u529f\u3002\u4eba\u5458\u65b0\u589e\u6570\u636e" + struCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + struCount.get("update") + "\u6761\uff1b\u4eba\u5458\u8be6\u60c5\u65b0\u589e\u6570\u636e" + staffsCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + staffsCount.get("update") + "\u6761\u3002");
        return success;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Map<String, String> importVueStaff(byte[] content) {
        Map data;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            data = (Map)SerializeUtils.deserialize((byte[])content);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.FILE_READING_ERROR);
        }
        if (ToolUtil.isEmpty((Object)data)) {
            map.put("success", "fileError");
            map.put("message", "\u5bfc\u5165\u6570\u636e\u6709\u8bef");
            map.put("import", "employee");
            return map;
        }
        String export_type = (String)data.get("export_type");
        if (!"employee".equals(export_type)) {
            map.put("success", "false");
            map.put("errorImport", export_type);
            map.put("import", "employee");
            return map;
        }
        List strus = (List)data.get("strus");
        List organs = (List)data.get("organs");
        List staffs = (List)data.get("staffs");
        List users = (List)data.get("users");
        List sysStruAssistOrgan = (List)data.get("sysStruAssistOrgan");
        Map<String, Integer> struCount = this.insertOrUpdateList(strus);
        Map<String, Integer> organCount = this.insertOrUpdateList(organs);
        Map<String, Integer> staffsCount = this.insertOrUpdateList(staffs);
        Map<String, Integer> usersCount = this.insertOrUpdateList(users);
        Map<String, Integer> sysStruAssistOrganCount = this.insertOrUpdateList(sysStruAssistOrgan);
        map.put("success", "true");
        map.put("staffInsert", "" + struCount.get("insert"));
        map.put("staffUpdate", "" + struCount.get("update"));
        map.put("staffsInsert", "" + staffsCount.get("insert"));
        map.put("staffsUpdate", "" + staffsCount.get("update"));
        return map;
    }

    @Override
    public List<JSTreeModel> getEmployeeTree(String isEmployee, String parentId, String isExport) {
        List<JSTreeModel> list1;
        String newParentId = parentId;
        ShiroUser shiroUser = ShiroKit.getUser();
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            String empolyeeId = shiroUser.getEmployeeId();
            String struLevel = this.selectStruLevel(empolyeeId);
            level = Integer.parseInt(struLevel);
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId("11");
        root.setCode("11");
        root.setText("\u4eba\u5458\u7ec4\u7ec7\u673a\u6784");
        root.setIsLeaf("0");
        root.setParent("#");
        root.setStruLevel("0");
        root.setType("isRoot");
        if (isGradeAdmin) {
            root.getState().put("gradeDisabled", true);
        }
        if (this.globalProperties.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)newParentId)) {
            if (ToolUtil.equals((Object)"#", (Object)newParentId)) {
                newParentId = "11";
                result.add(root);
            }
            list1 = this.getEmployeeTree(isEmployee, newParentId);
        } else {
            result.add(root);
            list1 = this.getEmployeeTree(isEmployee);
        }
        List<JSTreeModel> list = isGradeAdmin ? this.orgMaintenanceService.getGradeStruTree(list1, level) : list1;
        result.addAll(list);
        if (Boolean.parseBoolean(isExport)) {
            for (JSTreeModel jsTreeModel : result) {
                if (jsTreeModel.getIsEmployee() == null) {
                    jsTreeModel.setState(false, false, true);
                    continue;
                }
                jsTreeModel.setState(false, false, false);
            }
        }
        return result;
    }

    @Override
    public List<JSTreeModel> getEmployeeTreeVue(String isEmployee, String parentId, String isExport) {
        List<JSTreeModel> list1;
        String newParentId = parentId;
        ShiroUser shiroUser = ShiroKit.getUser();
        Map<String, Object> map = ShiroFactroy.me().getDataScopeInfo(shiroUser);
        String dataScopeType = map.get("data_scope_type").toString();
        Set orgList = (Set)map.get("data_scope_list");
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            String empolyeeId = shiroUser.getEmployeeId();
            String struLevel = this.selectStruLevel(empolyeeId);
            level = Integer.parseInt(struLevel);
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId("11");
        root.setCode("11");
        root.setText("\u4eba\u5458\u7ec4\u7ec7\u673a\u6784");
        root.setIsLeaf("0");
        root.setParent("#");
        root.setStruLevel("0");
        root.setType("isRoot");
        if (isGradeAdmin) {
            root.getState().put("gradeDisabled", true);
        }
        if (!"1".equals(dataScopeType)) {
            root.getState().put("dataScopeDisabled", true);
        }
        if (this.globalProperties.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)newParentId)) {
            if (ToolUtil.equals((Object)"#", (Object)newParentId)) {
                newParentId = "11";
                result.add(root);
            }
            list1 = this.getEmployeeTreeVue(isEmployee, newParentId);
        } else {
            result.add(root);
            list1 = this.getEmployeeTree(isEmployee);
        }
        List<JSTreeModel> list = isGradeAdmin ? this.orgMaintenanceService.getGradeStruTree(list1, level) : ("1".equals(dataScopeType) ? list1 : this.orgMaintenanceService.getDataScopeTree(list1, dataScopeType, orgList));
        result.addAll(list);
        if (Boolean.parseBoolean(isExport)) {
            for (JSTreeModel jsTreeModel : result) {
                if (jsTreeModel.getIsEmployee() == null) {
                    jsTreeModel.setState(false, false, true);
                    continue;
                }
                jsTreeModel.setState(false, false, false);
            }
        }
        return result;
    }

    @Override
    public List<JSTreeModel> getEmployeeDepTreeVue(String struId) {
        ShiroUser shiroUser = ShiroKit.getUser();
        Map<String, Object> map = ShiroFactroy.me().getDataScopeInfo(shiroUser);
        String dataScopeType = map.get("data_scope_type").toString();
        Set orgList = (Set)map.get("data_scope_list");
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        int level = 0;
        if (isGradeAdmin) {
            String empolyeeId = shiroUser.getEmployeeId();
            String struLevel = this.selectStruLevel(empolyeeId);
            level = Integer.parseInt(struLevel);
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId("11");
        root.setCode("11");
        root.setText("\u4eba\u5458\u7ec4\u7ec7\u673a\u6784");
        root.setIsLeaf("0");
        root.setParent("#");
        root.setStruLevel("0");
        root.setType("isRoot");
        if (isGradeAdmin) {
            root.getState().put("gradeDisabled", true);
        }
        if (!"1".equals(dataScopeType)) {
            root.getState().put("dataScopeDisabled", true);
        }
        List<Object> list1 = Lists.newArrayList();
        if (this.globalProperties.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)struId)) {
            if (ToolUtil.equals((Object)"#", (Object)struId)) {
                struId = "11";
                result.add(root);
            }
            list1 = this.getEmployeeTreeVue(null, struId);
        }
        List<Object> list = isGradeAdmin ? this.orgMaintenanceService.getGradeStruTree(list1, level) : ("1".equals(dataScopeType) ? list1 : this.orgMaintenanceService.getDataScopeTree(list1, dataScopeType, orgList));
        result.addAll(list);
        return result;
    }

    @Override
    public Map<String, Object> getStaffInfoByParentStruId(Map<String, String> reqParamMap, String parentStruId) {
        String userCode;
        SysStru sysStru;
        HashMap<String, Object> staffPageMap = new HashMap<String, Object>(4);
        staffPageMap.put("code", 0);
        SysStru currentNodeStru = (SysStru)((Object)this.sysStruMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"STRU_ID", (Object)parentStruId)));
        HashMap queryStaffMap = Maps.newHashMap();
        queryStaffMap.put("parentStruId", parentStruId);
        int pageNo = reqParamMap.get("page") == null ? 1 : Integer.parseInt(reqParamMap.get("page"));
        int limit = reqParamMap.get("limit") == null ? 20 : Integer.parseInt(reqParamMap.get("limit"));
        Page page = new Page((long)pageNo, (long)limit);
        ShiroUser currentUser = ShiroKit.getUser();
        if (currentUser.isGradeadmin() && ((sysStru = (SysStru)((Object)this.sysStruMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"STRU_ID", (Object)currentUser.getDeptId())))) == null || currentNodeStru == null || currentNodeStru.getStruLevel().intValue() < sysStru.getStruLevel().intValue() || currentNodeStru.getStruLevel().intValue() == sysStru.getStruLevel().intValue() && !currentNodeStru.getStruId().equals(sysStru.getStruId()))) {
            staffPageMap.put("count", 0L);
            staffPageMap.put("data", null);
            return staffPageMap;
        }
        Map<String, Object> dataScopeMap = ShiroFactroy.me().getDataScopeInfo(currentUser);
        Set optStruNodeIdList = (Set)dataScopeMap.get("data_scope_list");
        String dataScopeType = dataScopeMap.get("data_scope_type").toString();
        if (!"1".equals(dataScopeType)) {
            if ("4".equals(dataScopeType) && currentUser.getDeptId().equals(parentStruId)) {
                queryStaffMap.put("userName", currentUser.getName());
                List<SysStaffVO> sysStaffVOList = this.sysStaffMapper.selectStaffPageByStruId(page, queryStaffMap);
                staffPageMap.put("count", page.getTotal());
                staffPageMap.put("data", sysStaffVOList);
                return staffPageMap;
            }
            if (!optStruNodeIdList.contains(parentStruId)) {
                staffPageMap.put("count", 0);
                staffPageMap.put("data", null);
                return staffPageMap;
            }
        }
        String userName = reqParamMap.get("userName") == null ? "" : reqParamMap.get("userName").trim();
        String string = userCode = reqParamMap.get("userCode") == null ? "" : reqParamMap.get("userCode").trim();
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            queryStaffMap.put("userName", userName);
        }
        if (StringUtils.isNotBlank((CharSequence)userCode)) {
            queryStaffMap.put("userCode", userCode);
        }
        List<SysStaffVO> sysStaffVOList = this.sysStaffMapper.selectStaffPageByStruId(page, queryStaffMap);
        staffPageMap.put("count", page.getTotal());
        staffPageMap.put("data", sysStaffVOList);
        return staffPageMap;
    }

    private Map<String, Integer> insertOrUpdateList(List<?> objects) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer update = 0;
        Integer insert = 0;
        if (CollectionUtils.isEmpty(objects)) {
            result.put("update", update);
            result.put("insert", insert);
            return result;
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = objects.size();
            for (int i = 0; i < size; ++i) {
                Integer n;
                Integer n2;
                Object object = objects.get(i);
                if (object instanceof SysStru) {
                    SysStru stru = (SysStru)((Object)object);
                    if (this.updateById((Object)stru)) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.save((Object)stru);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (object instanceof SysOrgan) {
                    SysOrgan organ = (SysOrgan)((Object)object);
                    if (SqlHelper.retBool((Integer)this.sysOrganMapper.updateById((Object)organ))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysOrganMapper.insert((Object)organ);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (object instanceof SysStaff) {
                    SysStaff sysStaff = (SysStaff)((Object)object);
                    if (SqlHelper.retBool((Integer)this.sysStaffMapper.updateById((Object)sysStaff))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysStaffMapper.insert((Object)sysStaff);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (object instanceof SysUsers) {
                    SysUsers sysUsers = (SysUsers)((Object)object);
                    if (SqlHelper.retBool((Integer)this.sysUsersMapper.updateById((Object)sysUsers))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysUsersMapper.insert((Object)sysUsers);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (object instanceof SysStruAssistOrgan) {
                    SysStruAssistOrgan sysStruAssistOrgan = (SysStruAssistOrgan)((Object)object);
                    if (SqlHelper.retBool((Integer)this.sysStruAssistOrganMapper.updateById((Object)sysStruAssistOrgan))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysStruAssistOrganMapper.insert((Object)sysStruAssistOrgan);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
        }
        result.put("update", update);
        result.put("insert", insert);
        return result;
    }
}

