/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.organ.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.bsp.organ.model.SysOrgan;
import com.jxdinfo.hussar.bsp.organ.model.SysStru;
import com.jxdinfo.hussar.bsp.organ.service.ISysStruService;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ISysStruServiceImpl
extends ServiceImpl<SysStruMapper, SysStru>
implements ISysStruService {
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private ISysStruAssistOrganService sysStruAssistOrganService;

    @Override
    public SysOrgan getOrganInfoByDeparmentId(String deparmentId) {
        return this.sysStruMapper.getOrganInfoByDeparmentId(deparmentId);
    }

    @Override
    public void getDataScopeOrgList(Set<String> orgList, String type, SysUsers sysUsers, ShiroUser shiroUser) {
        List<String> codeList;
        List<Map<String, Object>> allAssistOrgan = this.sysStruAssistOrganService.getAllAssistOrgan(shiroUser.getEmployeeId());
        ArrayList<String> deptList = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(allAssistOrgan)) {
            for (Map<String, Object> map : allAssistOrgan) {
                if (!ToolUtil.isNotEmpty((Object)map.get("ASSISTDEPTNAME"))) continue;
                deptList.add(map.get("ASSISTDEPIDS").toString());
            }
        }
        deptList.add(sysUsers.getDepartmentId());
        if ("3".equals(type)) {
            orgList.addAll(deptList);
        }
        if ("2".equals(type) && ToolUtil.isNotEmpty(codeList = this.sysStruMapper.getOrgCodeListByIdList(deptList))) {
            for (int i = 0; i < codeList.size(); ++i) {
                String code = codeList.get(i) + "%";
                codeList.set(i, code);
            }
            List<String> orgIds = this.sysStruMapper.getStruListByOrganCode(codeList);
            orgList.addAll(orgIds);
        }
    }
}

