/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.organ.service.impl;

import com.jxdinfo.hussar.bsp.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.bsp.organ.model.SysStru;
import com.jxdinfo.hussar.bsp.organ.service.ISysEmployeeService;
import com.jxdinfo.hussar.bsp.organ.service.ISysOrgService;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.permit.service.ISysStruResourcesService;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.factory.ShiroFactroy;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ISysOrgServiceImpl
implements ISysOrgService {
    @Resource
    private ISysEmployeeService sysEmployeeService;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private ISysStruResourcesService sysStruResourcesService;

    @Override
    public List<JSTreeModel> getOrgTree(String isEmployee, String isExport, String resourceId, String type, String handle, String parentId) {
        String newType = type;
        String newParentId = parentId;
        String newResourceId = resourceId;
        ShiroUser shiroUser = ShiroKit.getUser();
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            String empolyeeId = shiroUser.getEmployeeId();
            String struLevel = this.sysEmployeeService.selectStruLevel(empolyeeId);
            level = Integer.parseInt(struLevel);
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId("11");
        root.setCode("11");
        root.setText("\u7ec4\u7ec7\u673a\u6784");
        root.setIsLeaf("0");
        root.setParent("#");
        root.setStruLevel("0");
        root.setType("isRoot");
        if (isGradeAdmin) {
            root.getState().put("gradeDisabled", true);
        }
        if (Boolean.parseBoolean(isExport)) {
            root.setState(false, false, true);
        }
        List<Object> list = new ArrayList();
        ArrayList<JSTreeModel> list1 = new ArrayList();
        if (this.globalProperties.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)newParentId)) {
            if (ToolUtil.equals((Object)"#", (Object)newParentId)) {
                newParentId = "11";
                result.add(root);
            }
            list1 = this.orgMaintenanceService.getOrgTree(isEmployee, newParentId);
        } else {
            result.add(root);
            list1 = this.orgMaintenanceService.getOrgTree(isEmployee);
        }
        list = isGradeAdmin ? this.orgMaintenanceService.getGradeStruTree(list1, level) : list1;
        if (newResourceId != null && newType != null) {
            String treeId;
            newResourceId = newResourceId.trim();
            newType = newType.trim();
            List<String> resourceIdList = this.sysStruResourcesService.getResourceIdList(newResourceId, newType);
            List<String> struResourceCount = this.sysStruResourcesService.getStruResourceCountMap(list, resourceIdList);
            if ("delegate".equals(handle)) {
                for (JSTreeModel jsTreeModel : list) {
                    treeId = jsTreeModel.getId();
                    if (!struResourceCount.contains(treeId)) continue;
                    jsTreeModel.setState(true, true, true);
                }
            }
            if ("retrieve".equals(handle)) {
                for (JSTreeModel jsTreeModel : list) {
                    treeId = jsTreeModel.getId();
                    if (struResourceCount.contains(treeId)) {
                        jsTreeModel.setState(true, true, false);
                        continue;
                    }
                    jsTreeModel.setState(false, false, true);
                }
            }
        }
        result.addAll(list);
        return result;
    }

    @Override
    public List<String> getResourceStruId(String resourceId, String type) {
        String newType = type;
        String newResourceId = resourceId;
        ShiroUser shiroUser = ShiroKit.getUser();
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            String empolyeeId = shiroUser.getEmployeeId();
            String struLevel = this.sysEmployeeService.selectStruLevel(empolyeeId);
            level = Integer.parseInt(struLevel);
        }
        List<Object> list = new ArrayList();
        ArrayList<JSTreeModel> baseTreeList = new ArrayList();
        List<String> struIdResource = new ArrayList<String>();
        baseTreeList = this.orgMaintenanceService.getOrgTree(null);
        list = isGradeAdmin ? this.orgMaintenanceService.getGradeStruTree(baseTreeList, level) : baseTreeList;
        if (newResourceId != null && newType != null) {
            newResourceId = newResourceId.trim();
            newType = newType.trim();
            List<String> resourceIdList = this.sysStruResourcesService.getResourceIdList(newResourceId, newType);
            struIdResource = this.sysStruResourcesService.getStruResourceCountMap(list, resourceIdList);
        }
        return struIdResource;
    }

    @Override
    public List<String> getAllParentId() {
        ShiroUser shiroUser = ShiroKit.getUser();
        String struId = shiroUser.getEmployeeId();
        List<String> idList = new ArrayList<String>();
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin && ToolUtil.isNotEmpty((Object)struId)) {
            idList = this.getInfo(struId, idList);
            return idList;
        }
        return idList;
    }

    @Override
    public List<JSTreeModel> getOrgTreeVue(String isEmployee, String isExport, String resourceId, String type, String handle, String parentId) {
        String newType = type;
        String newParentId = parentId;
        String newResourceId = resourceId;
        ShiroUser shiroUser = ShiroKit.getUser();
        Map<String, Object> map = ShiroFactroy.me().getDataScopeInfo(shiroUser);
        String dataScopeType = map.get("data_scope_type").toString();
        Set orgList = (Set)map.get("data_scope_list");
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            String empolyeeId = shiroUser.getEmployeeId();
            String struLevel = this.sysEmployeeService.selectStruLevel(empolyeeId);
            level = Integer.parseInt(struLevel);
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId("11");
        root.setCode("11");
        root.setText("\u7ec4\u7ec7\u673a\u6784");
        root.setIsLeaf("0");
        root.setParent("#");
        root.setStruLevel("0");
        root.setType("isRoot");
        if (isGradeAdmin) {
            root.getState().put("gradeDisabled", true);
        }
        if (!"1".equals(dataScopeType)) {
            root.getState().put("dataScopeDisabled", true);
        }
        if (Boolean.parseBoolean(isExport)) {
            root.setState(false, false, true);
        }
        List<Object> list = new ArrayList();
        ArrayList<JSTreeModel> list1 = new ArrayList();
        if (this.globalProperties.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)newParentId)) {
            if (ToolUtil.equals((Object)"#", (Object)newParentId)) {
                newParentId = "11";
                result.add(root);
            }
            list1 = this.orgMaintenanceService.getOrgTree(isEmployee, newParentId);
        } else {
            result.add(root);
            list1 = this.orgMaintenanceService.getOrgTree(isEmployee);
        }
        list = isGradeAdmin ? this.orgMaintenanceService.getGradeStruTree(list1, level) : ("1".equals(dataScopeType) ? list1 : this.orgMaintenanceService.getDataScopeTree(list1, dataScopeType, orgList));
        if (newResourceId != null && newType != null) {
            String treeId;
            newResourceId = newResourceId.trim();
            newType = newType.trim();
            List<String> resourceIdList = this.sysStruResourcesService.getResourceIdList(newResourceId, newType);
            List<String> struResourceCount = this.sysStruResourcesService.getStruResourceCountMap(list, resourceIdList);
            if ("delegate".equals(handle)) {
                for (JSTreeModel jsTreeModel : list) {
                    treeId = jsTreeModel.getId();
                    if (!struResourceCount.contains(treeId)) continue;
                    jsTreeModel.setState(true, true, true);
                }
            }
            if ("retrieve".equals(handle)) {
                for (JSTreeModel jsTreeModel : list) {
                    treeId = jsTreeModel.getId();
                    if (struResourceCount.contains(treeId)) {
                        jsTreeModel.setState(true, true, false);
                        continue;
                    }
                    jsTreeModel.setState(false, false, true);
                }
            }
        }
        result.addAll(list);
        return result;
    }

    @Override
    public List<JSTreeModel> getOrgDepTreeVue(String struParentId) {
        ShiroUser shiroUser = ShiroKit.getUser();
        Map<String, Object> map = ShiroFactroy.me().getDataScopeInfo(shiroUser);
        String dataScopeType = map.get("data_scope_type").toString();
        Set orgList = (Set)map.get("data_scope_list");
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            String empolyeeId = shiroUser.getEmployeeId();
            String struLevel = this.sysEmployeeService.selectStruLevel(empolyeeId);
            level = Integer.parseInt(struLevel);
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId("11");
        root.setCode("11");
        root.setText("\u7ec4\u7ec7\u673a\u6784");
        root.setIsLeaf("0");
        root.setParent("#");
        root.setStruLevel("0");
        root.setType("isRoot");
        if (isGradeAdmin) {
            root.getState().put("gradeDisabled", true);
        }
        if (!"1".equals(dataScopeType)) {
            root.getState().put("dataScopeDisabled", true);
        }
        List<JSTreeModel> list1 = new ArrayList<JSTreeModel>();
        if (this.globalProperties.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)struParentId)) {
            if (ToolUtil.equals((Object)"#", (Object)struParentId)) {
                struParentId = "11";
                result.add(root);
            }
            list1 = this.orgMaintenanceService.getOrgTree(null, struParentId);
        }
        List<JSTreeModel> list = isGradeAdmin ? this.orgMaintenanceService.getGradeStruTree(list1, level) : ("1".equals(dataScopeType) ? list1 : this.orgMaintenanceService.getDataScopeTree(list1, dataScopeType, orgList));
        result.addAll(list);
        return result;
    }

    private List<String> getInfo(String struId, List<String> idList) {
        idList.add(struId);
        SysStru sysStru = (SysStru)((Object)this.sysStruMapper.selectById((Serializable)((Object)struId)));
        if (ToolUtil.isNotEmpty((Object)((Object)sysStru))) {
            this.getInfo(sysStru.getParentId(), idList);
        }
        return idList;
    }
}

