/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.organ.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bsp.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.bsp.organ.dao.SysOrganTypeMapper;
import com.jxdinfo.hussar.bsp.organ.dictmap.StruDict;
import com.jxdinfo.hussar.bsp.organ.model.SysOffice;
import com.jxdinfo.hussar.bsp.organ.model.SysOrgan;
import com.jxdinfo.hussar.bsp.organ.model.SysStru;
import com.jxdinfo.hussar.bsp.organ.service.ISysEmployeeService;
import com.jxdinfo.hussar.bsp.organ.service.ISysOrgService;
import com.jxdinfo.hussar.bsp.organ.service.ISysOrganService;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.bsp.permit.service.ISysIdtableService;
import com.jxdinfo.hussar.bsp.permit.service.ISysStruResourcesService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/orgMain"})
public class SysOrgManageController
extends BaseController {
    @Resource
    private ISysStruResourcesService sysStruResourcesService;
    @Resource
    private ISysEmployeeService sysEmployeeService;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private SysOrganTypeMapper sysOrganTypeMapper;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private ISysOrganService iSysOrganService;
    @Autowired
    ISysStruAuditService iSysStruAuditService;
    @Resource
    private ISysOrgService iSysOrgService;

    @BussinessLog(key="/orgMain/orgList", type="04", value="\u7ec4\u7ec7\u673a\u6784\u9875\u9762")
    @RequiresPermissions(value={"orgMain:orgList"})
    @RequestMapping(value={"/orgList"})
    public String orgMaintenance(Model model, HttpServletRequest request) {
        JSONObject json = this.orgMaintenanceService.getImgUrl(request);
        model.addAttribute("imgUrl", (Object)json);
        return "/bsp/organ/orgMaintenance.html";
    }

    @RequiresPermissions(value={"orgMain:orgTree"})
    @RequestMapping(value={"/orgTree"})
    @BussinessLog(key="/orgMain/orgTree", type="04", value="\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u6811")
    @ResponseBody
    public List<JSTreeModel> orgTree(HttpServletRequest request) {
        String isEmployee = request.getParameter("isEmployee");
        String isExport = request.getParameter("isExport");
        String resourceId = super.getPara("resourceId");
        String type = super.getPara("type");
        String handle = super.getPara("handle");
        String parentId = super.getPara("parentId");
        return this.iSysOrgService.getOrgTree(isEmployee, isExport, resourceId, type, handle, parentId);
    }

    @RequiresPermissions(value={"orgMain:orgTreeById"})
    @RequestMapping(value={"/orgTreeById"})
    @BussinessLog(key="/orgMain/orgTreeById", type="04", value="\u6839\u636e\u8282\u70b9\u7ec4\u7ec7\u673a\u6784ID\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u6811")
    @ResponseBody
    public List<JSTreeModel> orgTreeById(HttpServletRequest request) {
        String orgId = request.getParameter("orgId");
        String isEmployee = request.getParameter("isEmployee");
        String isHead = request.getParameter("isRoot");
        Boolean isRoot = Boolean.valueOf(isHead);
        List<JSTreeModel> result = this.orgMaintenanceService.getOrgTreeById(orgId, isEmployee);
        if (isRoot.booleanValue()) {
            JSTreeModel root = new JSTreeModel();
            root.setId("11");
            root.setCode("");
            root.setText("\u7ec4\u7ec7\u673a\u6784");
            root.setStruLevel("0");
            root.setParent("#");
            root.setIsLeaf("0");
            root.setType("isRoot");
            result.add(root);
        }
        return result;
    }

    @RequestMapping(value={"/orgInfo"})
    @RequiresPermissions(value={"orgMain:orgInfo"})
    @BussinessLog(key="/orgMain/orgInfo", type="04", value="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u67e5\u770b")
    public String orgInfo(Model model) {
        String struId = super.getPara("struId");
        SysOrganVo orgInfo = this.orgMaintenanceService.getOrgInfoById(struId);
        model.addAttribute("orgInfo", (Object)orgInfo);
        return "/bsp/organ/orgInfoView.html";
    }

    @RequestMapping(value={"/orgInfoAdd"})
    @RequiresPermissions(value={"orgMain:add"})
    @BussinessLog(key="/orgMain/orgInfoAdd", type="01", value="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u65b0\u589e")
    public String orgInfoAdd(Model model) {
        String orgParentId = super.getPara("orgParentId");
        String orgType = super.getPara("orgType");
        String orgTypeName = super.getPara("orgTypeName");
        String childNum = super.getPara("childNum");
        SysOrganVo orgInfo = this.orgMaintenanceService.getOrgInfoById(orgParentId);
        String orgParentCode = "";
        String orgParentName = "";
        String parentTypeCode = "";
        if (ToolUtil.isNotEmpty((Object)orgInfo)) {
            orgParentCode = orgInfo.getOrganCode();
            if (ToolUtil.isEmpty((Object)orgParentCode)) {
                orgParentCode = "";
            }
            orgParentName = orgInfo.getOrganName();
            parentTypeCode = orgInfo.getParentTypeCode();
            if (ToolUtil.isEmpty((Object)parentTypeCode)) {
                parentTypeCode = "";
            }
        }
        String businessName = "STRU_CODE";
        String tableName = "sys_stru";
        String currentCode = this.sysIdtableService.getCurrentCode(businessName, tableName, orgParentCode);
        model.addAttribute("currentCode", (Object)currentCode);
        model.addAttribute("orgInfo", null);
        model.addAttribute("orgType", (Object)orgType);
        model.addAttribute("orgParentId", (Object)orgParentId);
        model.addAttribute("orgParentCode", (Object)orgParentCode);
        model.addAttribute("orgParentName", (Object)orgParentName);
        if (ToolUtil.isNotEmpty((Object)orgInfo)) {
            model.addAttribute("struLevel", (Object)orgInfo.getStruLevel());
        } else {
            model.addAttribute("struLevel", (Object)"0");
        }
        model.addAttribute("childNum", (Object)childNum);
        model.addAttribute("orgTypeName", (Object)orgTypeName);
        model.addAttribute("parentTypeCode", (Object)parentTypeCode);
        return "/bsp/organ/orgInfoAdd.html";
    }

    @RequiresPermissions(value={"orgMain:edit"})
    @RequestMapping(value={"/orgInfoEdit"})
    @BussinessLog(key="/orgMain/orgInfoEdit", type="03", pk="orgId", value="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u4fee\u6539")
    public String orgInfoEdit(Model model) {
        String orgId = super.getPara("orgId");
        SysOrganVo orgInfo = this.orgMaintenanceService.getOrgInfoById(orgId);
        model.addAttribute("orgInfo", (Object)orgInfo);
        return "/bsp/organ/orgInfoEdit.html";
    }

    @RequiresPermissions(value={"orgMain:getOrgRoleByCode"})
    @RequestMapping(value={"/getOrgRoleByCode"})
    @BussinessLog(key="/orgMain/getOrgRoleByCode", type="04", value="\u6839\u636e\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u83b7\u53d6\u4e0b\u5c5e\u5355\u4f4d\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b")
    @ResponseBody
    public Object getOrgRoleByCode() {
        String orgType = super.getPara("orgType");
        String isRoot = super.getPara("isRoot");
        return this.orgMaintenanceService.getOrgRoleByCode(orgType, isRoot);
    }

    @RequestMapping(value={"/orgInfoSave"})
    @RequiresPermissions(value={"orgMain:orgInfoSave"})
    @BussinessLog(key="/orgMain/orgInfoSave", type="01", value="\u7ec4\u7ec7\u673a\u6784\u65b0\u589e")
    @ResponseBody
    public JSONObject orgInfoSave(SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        sysStru.setStruId(null);
        if (ToolUtil.isEmpty((Object)sysStru.getOrganAlias())) {
            sysStru.setOrganAlias(sysOrgan.getOrganName());
        }
        sysStru.setOrganId(null);
        sysStru.setIsLeaf("0");
        sysStru.setInUse("1");
        sysStru.setStruPath("");
        sysOrgan.setOrganId(null);
        sysOrgan.setInUse("1");
        sysStru.setStruLevel(sysStru.getStruLevel().add(new BigDecimal(1)));
        Long orderTree = 1L;
        Long maxOrder = this.orgMaintenanceService.getMaxOrderById(sysStru.getParentId());
        orderTree = ToolUtil.isNotEmpty((Object)maxOrder) ? Long.valueOf(maxOrder + 1L) : Long.valueOf(1L);
        BigDecimal struOrder = BigDecimal.valueOf(orderTree);
        sysStru.setStruOrder(struOrder);
        return this.orgMaintenanceService.orgInfoSave(sysStru, sysOrgan, null, sysOffice, true);
    }

    @RequestMapping(value={"/orgInfoEditSave"})
    @RequiresPermissions(value={"orgMain:orgInfoEditSave"})
    @BussinessLog(key="/orgMain/orgInfoEditSave", type="03", value="\u7ec4\u7ec7\u673a\u6784\u4fee\u6539", pk="struId,organId", dict=StruDict.class)
    @ResponseBody
    public JSONObject orgInfoEditSave(SysOrgan sysOrgan, SysStru sysStru, SysOffice sysOffice) {
        if (!this.iSysStruAuditService.checkCanOperate(sysStru.getStruId())) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("code", (Object)HttpCode.INTERNAL_SERVER_ERROR.value());
            jsonObject.put("message", (Object)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u4fee\u6539\uff01");
            return jsonObject;
        }
        SysOrgan sysOrgan1 = (SysOrgan)((Object)this.iSysOrganService.getById((Serializable)((Object)sysOrgan.getOrganId())));
        LogObjectHolder.me().set((Object)sysOrgan1);
        return this.orgMaintenanceService.orgInfoSave(sysStru, sysOrgan, null, sysOffice, false);
    }

    @RequestMapping(value={"/orgTreeOrder"})
    @ResponseBody
    @BussinessLog(key="/orgMain/orgTreeOrder", type="03", value="\u7ec4\u7ec7\u673a\u6784\u6392\u5e8f")
    @RequiresPermissions(value={"orgMain:orgTreeOrder"})
    public void orgTreeOrder() {
        String treeInfo = super.getPara("treeInfo");
        JSONArray treeArr = JSON.parseArray((String)treeInfo);
        this.orgMaintenanceService.saveOrgTreeOrder(treeArr);
    }

    @RequiresPermissions(value={"orgMain:del"})
    @RequestMapping(value={"/delOrgById"})
    @BussinessLog(key="/orgMain/delOrgById", type="02", value="\u7ec4\u7ec7\u673a\u6784\u5220\u9664", dict=StruDict.class)
    @ResponseBody
    public JSONObject delOrgById() {
        String orgId = super.getPara("struId");
        return this.orgMaintenanceService.delOrgById(orgId);
    }

    @RequestMapping(value={"principalSelect"})
    @BussinessLog(key="/orgMain/principalSelect", type="04", value="\u83b7\u53d6\u8d1f\u8d23\u4eba\u5217\u8868")
    @ResponseBody
    public JSONObject principalSelect() {
        ShiroUser shiroUser = ShiroKit.getUser();
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        String userName = super.getPara("userName");
        String departmentName = super.getPara("departmentName");
        String pageName = super.getPara("curr");
        String limitName = super.getPara("nums");
        if (ToolUtil.isNotEmpty((Object)pageName) && ToolUtil.isNotEmpty((Object)limitName)) {
            Page page = new Page((long)Integer.valueOf(pageName).intValue(), (long)Integer.valueOf(limitName).intValue());
            page = isGradeAdmin ? this.orgMaintenanceService.getPrincipalSelectList(page, userName, departmentName, shiroUser.getDeptId()) : this.orgMaintenanceService.getPrincipalSelectList(page, userName, departmentName);
            JSONObject json = new JSONObject();
            json.put("data", (Object)page.getRecords());
            json.put("code", (Object)"0");
            json.put("msg", (Object)"");
            json.put("count", (Object)page.getTotal());
            return json;
        }
        JSONObject json = new JSONObject();
        json.put("data", null);
        json.put("code", (Object)"500");
        json.put("msg", (Object)"\u53c2\u6570\u4e0d\u7b26\uff01");
        json.put("count", null);
        return json;
    }

    @RequiresPermissions(value={"orgMain:orgChangeById"})
    @RequestMapping(value={"/orgChangeById"})
    @BussinessLog(key="/orgMain/orgChangeById", type="04", value="\u6839\u636eID\u83b7\u53d6\u8f6c\u79fb\u7ec4\u7ec7\u673a\u6784\u6811")
    @ResponseBody
    public List<JSTreeModel> orgChangeById(HttpServletRequest request) {
        List<Object> result = new ArrayList();
        result = this.orgTree(request);
        for (JSTreeModel jSTreeModel : result) {
            jSTreeModel.setChildren("false");
        }
        return result;
    }

    @RequestMapping(value={"/orgTreeChange"})
    @ResponseBody
    @BussinessLog(key="/orgMain/orgTreeChange", type="03", value="\u7ec4\u7ec7\u673a\u6784\u8f6c\u79fb")
    @RequiresPermissions(value={"orgMain:orgTreeChange"})
    public JSONObject orgTreeChange() {
        String orgId = super.getPara("orgId");
        String parentId = super.getPara("parentId");
        String orgType = super.getPara("orgType");
        String isRoot = super.getPara("isRoot");
        String changeLevel = super.getPara("changeLevel");
        return this.orgMaintenanceService.orgTreeChange(orgId, parentId, orgType, isRoot, changeLevel);
    }

    @RequestMapping(value={"/singleMove"})
    @ResponseBody
    @BussinessLog(key="/orgMain/singleMove", type="03", value="\u7ec4\u7ec7\u673a\u6784\u4e0a\u79fb/\u4e0b\u79fb")
    @RequiresPermissions(value={"orgMain:singleMove"})
    public Tip updateMoveNode(String orgId, boolean isUp) {
        if (ToolUtil.isEmpty((Object)orgId)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        this.orgMaintenanceService.updateMoveNode(orgId, isUp);
        return BaseController.SUCCESS_TIP;
    }

    @RequestMapping(value={"/exportData"})
    @RequiresPermissions(value={"orgMain:exportData"})
    @BussinessLog(key="/orgMain/exportData", type="04", value="\u7ec4\u7ec7\u673a\u6784\u6570\u636e\u5bfc\u51fa")
    public void exportData(HttpServletResponse response) {
        String ids = super.getPara("ids");
        List<String> idList = Arrays.asList(ids.split(","));
        this.orgMaintenanceService.exportData(idList, response);
    }
}

