/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.menu.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bsp.menu.dao.SysMenuMapper;
import com.jxdinfo.hussar.bsp.menu.model.SysMenu;
import com.jxdinfo.hussar.bsp.menu.service.ISysMenuManageService;
import com.jxdinfo.hussar.bsp.permit.dao.SysFunctionsMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysModulesMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysFunctions;
import com.jxdinfo.hussar.bsp.permit.model.SysModules;
import com.jxdinfo.hussar.bsp.permit.model.SysResources;
import com.jxdinfo.hussar.bsp.permit.model.SysRoleResource;
import com.jxdinfo.hussar.bsp.permit.service.ISysIdtableService;
import com.jxdinfo.hussar.bsp.permit.service.ISysResManageService;
import com.jxdinfo.hussar.bsp.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.common.annotion.DynamicDS;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.speedcode.MenuNode;
import com.jxdinfo.speedcode.MenuService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@DynamicDS
public class SysCreateVueMenuServiceImpl
implements MenuService {
    private final ISysResManageService sysResManageService;
    private final ISysIdtableService sysIdtableService;
    private final ISysRoleResourceService sysRoleResourceService;
    private final ISysMenuManageService sysMenuManageService;
    private final SysUserRoleMapper sysUserRoleMapper;
    private final SysModulesMapper sysModulesMapper;
    private final SysFunctionsMapper sysFunctionsMapper;
    private final SysResourcesMapper sysResourcesMapper;
    private final SysMenuMapper sysMenuMapper;
    private static Logger logger = LoggerFactory.getLogger(SysCreateVueMenuServiceImpl.class);
    private static final String OPERATOR = "godaxe";
    private String RES_BTN = "res_btn";
    private String RES_MENU = "res_menu";
    private String[][] res = new String[][]{{"view", "add", "delete", "update", "list", "detail"}, {"\u9875\u9762", "\u589e\u52a0", "\u5220\u9664", "\u4fee\u6539", "\u67e5\u8be2", "\u8be6\u60c5"}, {this.RES_MENU, this.RES_BTN, this.RES_BTN, this.RES_BTN, this.RES_BTN, this.RES_BTN}};
    @Value(value="${hussar-formdesign.menu-role:\u8d85\u7ea7\u7ba1\u7406\u5458}")
    private String menuRole;
    @Value(value="${hussar-formdesign.menu-role-group:}")
    private String menuRoleGroup;

    @Autowired
    public SysCreateVueMenuServiceImpl(ISysResManageService sysResManageService, ISysIdtableService sysIdtableService, ISysRoleResourceService sysRoleResourceService, ISysMenuManageService sysMenuManageService, SysUserRoleMapper sysUserRoleMapper, SysModulesMapper sysModulesMapper, SysFunctionsMapper sysFunctionsMapper, SysResourcesMapper sysResourcesMapper, SysMenuMapper sysMenuMapper) {
        this.sysResManageService = sysResManageService;
        this.sysIdtableService = sysIdtableService;
        this.sysRoleResourceService = sysRoleResourceService;
        this.sysMenuManageService = sysMenuManageService;
        this.sysUserRoleMapper = sysUserRoleMapper;
        this.sysModulesMapper = sysModulesMapper;
        this.sysFunctionsMapper = sysFunctionsMapper;
        this.sysResourcesMapper = sysResourcesMapper;
        this.sysMenuMapper = sysMenuMapper;
    }

    public void createVueMenuRes(MenuNode menuNode) {
        this.create("@/views", "", menuNode, true, null, null);
    }

    public void deleteVueMenuRes(MenuNode menuNode) {
        this.delete("", menuNode);
    }

    public void showMenuRes(MenuNode menuNode) {
        this.show("", menuNode);
    }

    public void hideMenuRes(MenuNode menuNode) {
        this.hidden("", menuNode);
    }

    private void create(String parentComponent, String parentPath, MenuNode menuNode, boolean isFirst, String moduleId, String menuParentId) {
        String id = menuNode.enName + "";
        String name = menuNode.cnName;
        if (menuParentId == null) {
            parentComponent = parentComponent.replace("views", "pages/index/views");
        }
        String component = parentComponent + "/" + id;
        String path = parentPath + "/" + id;
        if (isFirst && ToolUtil.isEmpty((Object)menuNode.child)) {
            SysModules sysModules = this.createModule(name, null, "1");
            SysFunctions sysFunctions = this.createFunction(name, sysModules);
            SysResources sysResources = this.createResource(name, id, sysFunctions);
            if (ToolUtil.isNotEmpty((Object)((Object)sysResources))) {
                this.createMenu(component, name, path, sysResources, "1", null);
            }
        } else if (isFirst && ToolUtil.isNotEmpty((Object)menuNode.child)) {
            SysModules sysModules = this.createModule(name, null, "0");
            if (ToolUtil.isNotEmpty((Object)((Object)sysModules))) {
                SysMenu sysMenu = this.createMenu("@/views/layout/layout", name, path, null, "0", null);
                this.create(component, path, menuNode.child, false, sysModules.getModuleId(), sysMenu.getMenuId());
            }
        } else if (!isFirst && ToolUtil.isEmpty((Object)menuNode.child)) {
            SysModules sysModules = this.createModule(name, moduleId, "1");
            SysFunctions sysFunctions = this.createFunction(name, sysModules);
            SysResources sysResources = this.createResource(name, id, sysFunctions);
            if (ToolUtil.isNotEmpty((Object)((Object)sysResources))) {
                this.createMenu(component, name, path, sysResources, "1", menuParentId);
            }
        } else {
            SysModules sysModules = this.createModule(name, moduleId, "0");
            if (ToolUtil.isNotEmpty((Object)((Object)sysModules))) {
                SysMenu sysMenu = this.createMenu(component, name, path, null, "0", menuParentId);
                this.create(component, path, menuNode.child, false, sysModules.getModuleId(), sysMenu.getMenuId());
            }
        }
    }

    private SysMenu createMenu(String component, String name, String path, SysResources sysResources, String isLeaf, String menuParentId) {
        String fail;
        String newMenuParentId = menuParentId;
        String newComponent = component;
        if (ToolUtil.isEmpty((Object)newMenuParentId)) {
            newMenuParentId = "1";
        } else if (ToolUtil.equals((Object)isLeaf, (Object)"0")) {
            newComponent = newComponent + "/index";
        }
        SysMenu sysMenu = new SysMenu();
        List menuList = this.sysMenuMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"path", (Object)path));
        if (menuList.size() != 0 && isLeaf.equals(((SysMenu)((Object)menuList.get(0))).getIsLeaf())) {
            sysMenu = (SysMenu)((Object)menuList.get(0));
            fail = "\u66f4\u65b0\u83dc\u5355\u5931\u8d25\uff01";
        } else {
            fail = "\u65b0\u589e\u83dc\u5355\u5931\u8d25\uff01";
            sysMenu.setIcons(null);
            sysMenu.setParentId(newMenuParentId);
            if (ToolUtil.isNotEmpty((Object)((Object)sysResources))) {
                sysMenu.setResourceId(sysResources.getResourceId());
            }
            Long seq = this.sysMenuMapper.getMaxOrderByParentId(newMenuParentId) == null ? 1L : this.sysMenuMapper.getMaxOrderByParentId(newMenuParentId) + 1L;
            sysMenu.setSeq(new BigDecimal(seq));
            sysMenu.setOpenType(null);
            sysMenu.setPath(path);
            sysMenu.setIsLeaf(isLeaf);
            sysMenu.setHidden("1");
            sysMenu.setMenuType("2");
        }
        sysMenu.setComponent(newComponent);
        sysMenu.setText(name);
        sysMenu.setMenuAlias(name);
        sysMenu.setTitle(name);
        boolean result = this.sysMenuManageService.saveOrUpdate((Object)sysMenu);
        if (!result) {
            logger.error(fail);
        }
        return sysMenu;
    }

    private SysModules createModule(String name, String moduleId, String isLeaf) {
        String fail;
        String parentModuleId = null;
        parentModuleId = ToolUtil.isEmpty((Object)moduleId) ? "1" : moduleId;
        SysModules sysModules = new SysModules();
        List modulesList = this.sysModulesMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"module_name", (Object)name)).eq((Object)"parent_module_id", (Object)parentModuleId)).eq((Object)"is_leaf", (Object)isLeaf));
        if (modulesList.size() != 0) {
            sysModules = (SysModules)((Object)modulesList.get(0));
            fail = "\u6a21\u5757\u66f4\u65b0\u5931\u8d25\uff01";
        } else {
            fail = "\u65b0\u589e\u6a21\u5757\u5931\u8d25\uff01";
            String moduleCode = this.sysIdtableService.getCurrentCode("MODULE_CODE", "SYS_MODULES");
            sysModules.setModuleCode(moduleCode);
            sysModules.setIsLeaf(isLeaf);
            sysModules.setParentModuleId(parentModuleId);
            sysModules.setCreator(OPERATOR);
        }
        sysModules.setCreator(OPERATOR);
        sysModules.setModuleName(name);
        int moduleResult = this.sysResManageService.moduleSave(sysModules);
        if (moduleResult == 1) {
            return sysModules;
        }
        logger.error(fail);
        return null;
    }

    private SysFunctions createFunction(String name, SysModules sysModules) {
        String fail;
        if (ToolUtil.isEmpty((Object)((Object)sysModules))) {
            return null;
        }
        SysFunctions sysFunctions = new SysFunctions();
        List functionsList = this.sysFunctionsMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"module_id", (Object)sysModules.getModuleId())).eq((Object)"function_name", (Object)name));
        if (functionsList.size() != 0) {
            sysFunctions = (SysFunctions)((Object)functionsList.get(0));
            fail = "\u529f\u80fd\u66f4\u65b0\u5931\u8d25\uff01";
        } else {
            String functionCode = sysModules.getModuleCode() + this.sysIdtableService.getCurrentCode("FUNCTION_CODE", "SYS_FUNCTIONS");
            sysFunctions.setModuleId(sysModules.getModuleId());
            sysFunctions.setFunctionCode(functionCode);
            sysFunctions.setIsSys("1");
            sysFunctions.setCreator(OPERATOR);
            fail = "\u65b0\u589e\u529f\u80fd\u5931\u8d25\uff01";
        }
        sysFunctions.setCreator(OPERATOR);
        sysFunctions.setFunctionName(name);
        int functionResult = this.sysResManageService.functionSave(sysFunctions);
        if (functionResult == 1) {
            return sysFunctions;
        }
        logger.error(fail);
        return null;
    }

    private SysResources createResource(String name, String id, SysFunctions sysFunctions) {
        if (ToolUtil.isEmpty((Object)((Object)sysFunctions))) {
            return null;
        }
        SysResources returnResources = null;
        for (int i = 0; i < this.res[0].length; ++i) {
            String prefix = "res_menu".equals(this.res[2][i]) ? name : "";
            SysResources sysResources = new SysResources();
            List resourcesList = this.sysResourcesMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"url_names", (Object)("/" + id + "/" + this.res[0][i]))).eq((Object)"function_id", (Object)sysFunctions.getFunctionId()));
            if (resourcesList.size() != 0) {
                sysResources = (SysResources)((Object)resourcesList.get(0));
            } else {
                String currentCode = this.sysIdtableService.getCurrentCode("RESOURCE_CODE", "SYS_RESOURCES");
                sysResources.setResourceCode(sysFunctions.getFunctionCode() + currentCode);
                sysResources.setUrlNames("/" + id + "/" + this.res[0][i]);
                sysResources.setPermissions(id + ":" + this.res[0][i]);
                sysResources.setIsDefault("0");
                sysResources.setIsAudit("0");
                sysResources.setFunctionId(sysFunctions.getFunctionId());
                sysResources.setResTypeId(this.res[2][i]);
                sysResources.setIsRepeatAuthenticate("0");
                sysResources.setCreator(OPERATOR);
            }
            sysResources.setCreator(OPERATOR);
            sysResources.setResourceName(prefix + this.res[1][i]);
            sysResources.setResourceAlias(prefix + this.res[1][i]);
            String resourceResult = this.sysResManageService.resourceSave(sysResources);
            if (resourcesList.size() != 0) {
                if (ToolUtil.isEmpty((Object)resourceResult)) {
                    logger.error(this.res[0][i] + "\u8d44\u6e90\u66f4\u65b0\u5931\u8d25\uff01");
                }
            } else {
                SysResources getResources = this.sysResourcesMapper.getResourceByCode(sysResources.getResourceCode());
                sysResources.setResourceId(getResources.getResourceId());
                sysResources.setCreator(getResources.getCreator());
                sysResources.setCreateTime(getResources.getCreateTime());
                sysResources.setSeq(getResources.getSeq());
                boolean associationResult = this.associationRole(sysResources);
                if (ToolUtil.isEmpty((Object)resourceResult) || !associationResult) {
                    logger.error("\u65b0\u589e'" + this.res[0][i] + "'\u8d44\u6e90\u5931\u8d25\uff01");
                }
            }
            if (i != 0) continue;
            returnResources = sysResources;
        }
        return returnResources;
    }

    private Boolean associationRole(SysResources sysResources) {
        ArrayList<SysRoleResource> roleResourceList = new ArrayList<SysRoleResource>();
        String[] roleName = ToolUtil.isNotEmpty((Object)this.menuRole) ? this.menuRole.split(",") : new String[]{};
        String[] groupId = ToolUtil.isNotEmpty((Object)this.menuRoleGroup) ? this.menuRoleGroup.split(",") : new String[]{};
        List<String> roleList = this.sysUserRoleMapper.getRoleIdByRoleName(roleName);
        if (ToolUtil.isNotEmpty((Object)groupId)) {
            List<String> groupList = this.sysUserRoleMapper.getRoleIdByGroupId(groupId);
            for (String g : groupList) {
                boolean flag = false;
                for (String r : roleList) {
                    if (!g.equals(r)) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                roleList.add(g);
            }
        }
        for (String roleId : roleList) {
            SysRoleResource sysRoleResource = new SysRoleResource();
            sysRoleResource.setRoleId(roleId);
            sysRoleResource.setResourceId(sysResources.getResourceId());
            sysRoleResource.setCreator(sysResources.getCreator());
            sysRoleResource.setCreateTime(sysResources.getCreateTime());
            sysRoleResource.setLastEditor(sysResources.getCreator());
            sysRoleResource.setLastTime(sysResources.getCreateTime());
            roleResourceList.add(sysRoleResource);
        }
        return this.sysRoleResourceService.saveBatch(roleResourceList, roleResourceList.size());
    }

    private void delete(String parentPath, MenuNode menuNode) {
        String path = parentPath + "/" + menuNode.enName;
        if (ToolUtil.isEmpty((Object)menuNode.child)) {
            String resourceId = this.deleteMenu(path);
            if (ToolUtil.isNotEmpty((Object)resourceId)) {
                this.deleteRes(resourceId);
            }
        } else {
            this.delete(path, menuNode.child);
        }
    }

    private String deleteMenu(String path) {
        SysMenu sysMenu = (SysMenu)((Object)this.sysMenuMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"path", (Object)path)));
        this.sysMenuMapper.deleteById((Serializable)((Object)sysMenu));
        return sysMenu.getResourceId();
    }

    private void deleteRes(String resourceId) {
        String functionId = ((SysResources)((Object)this.sysResourcesMapper.selectById((Serializable)((Object)resourceId)))).getFunctionId();
        String moduleId = ((SysFunctions)((Object)this.sysFunctionsMapper.selectById((Serializable)((Object)functionId)))).getModuleId();
        this.sysResourcesMapper.delete((Wrapper)new QueryWrapper().eq((Object)"function_id", (Object)functionId));
        this.sysFunctionsMapper.deleteById((Serializable)((Object)functionId));
        this.sysModulesMapper.deleteById((Serializable)((Object)moduleId));
    }

    private void show(String parentPath, MenuNode menuNode) {
        SysMenu sysMenu;
        String path = parentPath + "/" + menuNode.enName;
        String isLeaf = "0";
        if (ToolUtil.isEmpty((Object)menuNode.child)) {
            isLeaf = "1";
        }
        if (ToolUtil.isEmpty((Object)((Object)(sysMenu = (SysMenu)((Object)this.sysMenuMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"path", (Object)path)).eq((Object)"is_leaf", (Object)isLeaf))))))) {
            logger.error("\u5f53\u524d\u9875\u9762\u5c1a\u672a\u53d1\u5e03\uff01");
            return;
        }
        sysMenu.setHidden("0");
        int result = this.sysMenuMapper.updateById((Object)sysMenu);
        if (ToolUtil.isNotEmpty((Object)menuNode.child)) {
            this.show(path, menuNode.child);
        } else if (result != 1) {
            logger.error("\u83dc\u5355\u663e\u793a\u5931\u8d25\uff01");
        }
    }

    private void hidden(String parentPath, MenuNode menuNode) {
        String path = parentPath + "/" + menuNode.enName;
        if (ToolUtil.isEmpty((Object)menuNode.child)) {
            SysMenu sysMenu = (SysMenu)((Object)this.sysMenuMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"path", (Object)path)).eq((Object)"is_leaf", (Object)"1")));
            if (ToolUtil.isEmpty((Object)((Object)sysMenu))) {
                logger.error("\u5f53\u524d\u9875\u9762\u5c1a\u672a\u53d1\u5e03\uff01");
                return;
            }
            sysMenu.setHidden("1");
            int result = this.sysMenuMapper.updateById((Object)sysMenu);
            if (result != 1) {
                logger.error("\u83dc\u5355\u9690\u85cf\u5931\u8d25\uff01");
            }
        } else {
            this.hidden(path, menuNode.child);
        }
    }
}

