/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.menu.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bsp.menu.model.SysMenu;
import com.jxdinfo.hussar.bsp.menu.service.ISysMenuManageService;
import com.jxdinfo.hussar.bsp.organ.service.ISysEmployeeService;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.permit.service.ISysStruResourcesService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.sys.service.ISysDicRefService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/menu"})
public class SysMenuManageController
extends BaseController {
    @Resource
    ISysMenuManageService sysMenuManageService;
    @Resource
    private ISysDicRefService iSysDicRefService;
    @Resource
    private ISysEmployeeService sysEmployeeService;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private ISysStruResourcesService sysStruResourcesService;

    @RequestMapping(value={"/menuList"})
    @RequiresPermissions(value={"menu:menuList"})
    @BussinessLog(key="/menu/menuList", type="04", value="\u83dc\u5355\u7ef4\u62a4\u9875\u9762")
    public String menuList() {
        return "/bsp/menu/menuManage.html";
    }

    @RequiresPermissions(value={"menu:menuTree"})
    @RequestMapping(value={"/menuTree"})
    @BussinessLog(key="/menu/menuTree", type="04", value="\u52a0\u8f7d\u83dc\u5355\u6811")
    @ResponseBody
    public List<JSTreeModel> menuTree() {
        List<JSTreeModel> result = this.sysMenuManageService.getMenuTree();
        JSTreeModel root = new JSTreeModel();
        root.setId("1");
        root.setText("\u83dc\u5355\u5217\u8868");
        root.setParent("#");
        root.setIsLeaf("0");
        root.setType("isRoot");
        result.add(root);
        return result;
    }

    @RequestMapping(value={"/menuAdd"})
    @RequiresPermissions(value={"menu:menuAdd"})
    @BussinessLog(key="/menu/menuAdd", type="04", value="\u65b0\u589e\u83dc\u5355\u9875\u9762\u8df3\u8f6c")
    public String menuAdd(Model model) {
        String menuId = super.getPara("menuId");
        SysMenu sysMenu = this.sysMenuManageService.getMenuInfo(menuId);
        String menuName = "";
        if (ToolUtil.isNotEmpty((Object)((Object)sysMenu))) {
            menuName = sysMenu.getText();
        }
        String length = super.getPara("length");
        model.addAttribute("length", (Object)length);
        model.addAttribute("menuId", (Object)menuId);
        model.addAttribute("menuName", (Object)menuName);
        return "/bsp/menu/menuAdd.html";
    }

    @BussinessLog(key="/menu/menuInfoSave", type="01", value="\u65b0\u589e\u83dc\u5355", pk="menuId")
    @RequiresPermissions(value={"menu:menuInfoSave"})
    @CacheEvict(value={"menu_info"}, allEntries=true)
    @RequestMapping(value={"/menuInfoSave"})
    @ResponseBody
    public void menuInfoSave(SysMenu sysMenu) {
        this.sysMenuManageService.menuInfoSave(sysMenu);
    }

    @BussinessLog(key="/menu/menuInfoEditSave", type="03", value="\u4fee\u6539\u83dc\u5355", pk="menuId")
    @RequiresPermissions(value={"menu:menuInfoEditSave"})
    @CacheEvict(value={"menu_info"}, allEntries=true)
    @RequestMapping(value={"/menuInfoEditSave"})
    @ResponseBody
    public void menuInfoEditSave(SysMenu sysMenu) {
        SysMenu result = this.sysMenuManageService.getMenuInfo(sysMenu.getMenuId());
        LogObjectHolder.me().set((Object)result);
        this.sysMenuManageService.menuInfoSave(sysMenu);
    }

    @RequiresPermissions(value={"menu:menuInfo"})
    @RequestMapping(value={"/menuInfo"})
    @BussinessLog(key="/menu/menuInfo", type="04", value="\u83dc\u5355\u4fe1\u606f\u9875\u9762\u8df3\u8f6c")
    public String menuInfo(Model model) {
        String menuId = super.getPara("menuId");
        String length = super.getPara("length");
        SysMenu result = this.sysMenuManageService.getMenuInfo(menuId);
        model.addAttribute("menuInfo", (Object)result);
        model.addAttribute("length", (Object)length);
        model.addAttribute("openType", (Object)this.iSysDicRefService.getDictLabel("menu_type", result.getOpenType()));
        return "/bsp/menu/menuView.html";
    }

    @BussinessLog(key="/menu/delMenuById", type="02", value="\u5220\u9664\u83dc\u5355", pk="menuId")
    @CacheEvict(value={"menu_info"}, allEntries=true)
    @RequestMapping(value={"/delMenuById"})
    @RequiresPermissions(value={"menu:delMenuById"})
    @ResponseBody
    public Tip delMenuById() {
        String ids = super.getPara("menuIds");
        List<String> menuIds = Arrays.asList(ids.split(","));
        if (this.sysMenuManageService.removeByIds(menuIds)) {
            SuccessTip tip = new SuccessTip();
            tip.setMessage("\u5220\u9664\u6210\u529f\uff01");
            return tip;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5220\u9664\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/menuInfoEdit"})
    @RequiresPermissions(value={"menu:menuInfoEdit"})
    @BussinessLog(key="/menu/menuInfoEdit", type="04", value="\u83dc\u5355\u7f16\u8f91")
    public String menuInfoEdit(Model model) {
        String menuId = super.getPara("menuId");
        String length = super.getPara("length");
        SysMenu result = this.sysMenuManageService.getMenuInfo(menuId);
        model.addAttribute("menuInfo", (Object)result);
        model.addAttribute("length", (Object)length);
        return "/bsp/menu/menuEdit.html";
    }

    @RequiresPermissions(value={"menu:menuTreeById"})
    @RequestMapping(value={"/menuTreeById"})
    @BussinessLog(key="/menu/menuTreeById", type="04", value="\u6839\u636e\u7236ID\u83b7\u53d6\u4e0b\u7ea7\u83dc\u5355\u6811")
    @ResponseBody
    public List<JSTreeModel> menuTreeById() {
        String menuId = super.getPara("menuId");
        String isHead = super.getPara("isRoot");
        Boolean isRoot = Boolean.valueOf(isHead);
        List<JSTreeModel> result = this.sysMenuManageService.menuTreeById(menuId);
        if (isRoot.booleanValue()) {
            JSTreeModel root = new JSTreeModel();
            root.setId("1");
            root.setText("\u83dc\u5355\u5217\u8868");
            root.setParent("#");
            root.setIsLeaf("0");
            root.setType("isRoot");
            result.add(root);
        }
        return result;
    }

    @RequestMapping(value={"/menuTreeOrder"})
    @CacheEvict(value={"menu_info"}, allEntries=true)
    @RequiresPermissions(value={"menu:menuTreeOrder"})
    @ResponseBody
    @BussinessLog(key="/menu/menuTreeOrder", type="03", value="\u83dc\u5355\u6811\u4e0b\u7ea7\u6392\u5e8f")
    public void menuTreeOrder() {
        String treeInfo = super.getPara("treeInfo");
        JSONArray treeArr = JSON.parseArray((String)treeInfo);
        JSONObject json = new JSONObject();
        ArrayList<SysMenu> list = new ArrayList<SysMenu>();
        for (int i = 0; i < treeArr.size(); ++i) {
            json = treeArr.getJSONObject(i);
            String id = json.getString("id");
            String order = json.getString("seq");
            SysMenu sm = new SysMenu();
            sm.setMenuId(id);
            sm.setSeq(new BigDecimal(order));
            list.add(sm);
        }
        if (ToolUtil.isNotEmpty(list)) {
            this.sysMenuManageService.updateBatchById(list, list.size());
        }
    }

    @RequestMapping(value={"/menuTreeChange"})
    @CacheEvict(value={"menu_info"}, allEntries=true)
    @RequiresPermissions(value={"menu:menuTreeChange"})
    @ResponseBody
    @BussinessLog(key="/menu/menuTreeChange", type="03", value="\u83dc\u5355\u6811\u8f6c\u79fb")
    public void menuTreeChange() {
        String menuId = super.getPara("menuId");
        String parentId = super.getPara("parentId");
        this.sysMenuManageService.menuTreeChange(menuId, parentId);
    }

    @RequestMapping(value={"/allIcons"})
    public String allIcons() {
        return "/bsp/menu/allIcons.json";
    }

    @RequestMapping(value={"/singleMove"})
    @CacheEvict(value={"menu_info"}, allEntries=true)
    @ResponseBody
    @RequiresPermissions(value={"menu:singleMove"})
    @BussinessLog(key="/menu/singleMove", type="03", value="\u83dc\u5355\u6811\u4e0a\u79fb/\u4e0b\u79fb")
    public Object updateMoveNode(String menuId, boolean isUp) {
        if (ToolUtil.isEmpty((Object)menuId)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        this.sysMenuManageService.updateMoveNode(menuId, isUp);
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/exportMenu"})
    @RequiresPermissions(value={"menu:exportMenu"})
    @BussinessLog(key="/menu/exportMenu", type="03", value="\u83dc\u5355\u5bfc\u51fa")
    public void exportData(HttpServletResponse response) {
        String menuIds = super.getPara("menuIds");
        List<String> menuIdList = Arrays.asList(menuIds.split(","));
        this.sysMenuManageService.exportMenu(menuIdList, response);
    }
}

