/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.loginuser.service.impl;

import com.baomidou.dynamic.datasource.annotation.Master;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.loginuser.dao.SysLoginUserMapper;
import com.jxdinfo.hussar.bsp.loginuser.model.SysLoginUser;
import com.jxdinfo.hussar.bsp.loginuser.model.SysUserTenant;
import com.jxdinfo.hussar.bsp.loginuser.service.SysLoginUserService;
import com.jxdinfo.hussar.bsp.loginuser.service.SysUserTenantService;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Master
public class SysLoginUserServiceImpl
extends ServiceImpl<SysLoginUserMapper, SysLoginUser>
implements SysLoginUserService {
    @Resource
    private SysLoginUserMapper sysLoginUserMapper;
    @Resource
    private SysUserTenantService sysUserTenantService;

    @Override
    public String getTenantCodeByAccount(String account) {
        List userTenantList;
        String tenantCode = "";
        SysLoginUser loginUser = (SysLoginUser)((Object)this.sysLoginUserMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"account", (Object)account)));
        if (ToolUtil.isNotEmpty((Object)((Object)loginUser)) && ToolUtil.isNotEmpty((Object)(userTenantList = this.sysUserTenantService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)loginUser.getUserId())).orderByAsc((Object)"tenant_code"))))) {
            tenantCode = ((SysUserTenant)((Object)userTenantList.get(0))).getTenantCode();
        }
        return tenantCode;
    }

    @Override
    public Boolean validateAccount(String account) {
        int count = this.sysLoginUserMapper.selectCount((Wrapper)new QueryWrapper().eq((Object)"account", (Object)account));
        return count > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncAddUser(SysUsers user) {
        String tenantCode;
        SysLoginUser loginUser = new SysLoginUser();
        SysUserTenant userTenant = new SysUserTenant();
        ShiroUser shiroUser = ShiroKit.getUser();
        String string = tenantCode = ToolUtil.isEmpty((Object)shiroUser) ? "" : shiroUser.getTenantCode();
        if (ToolUtil.isNotEmpty((Object)((Object)user))) {
            loginUser.setUserId(user.getUserId());
            loginUser.setAccount(user.getUserAccount());
            loginUser.setPassword(user.getPassword());
            userTenant.setUserId(user.getUserId());
            userTenant.setTenantCode(tenantCode);
        }
        this.sysLoginUserMapper.insert((Object)loginUser);
        this.sysUserTenantService.save((Object)userTenant);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<?> syncTenantUser(List<SysUsers> userList, String tenantCode) {
        ArrayList<SysUserTenant> userTenantList = new ArrayList<SysUserTenant>();
        for (SysUsers user : userList) {
            SysUserTenant userTenant = new SysUserTenant();
            userTenant.setUserId(user.getUserId());
            userTenant.setTenantCode(tenantCode);
            userTenantList.add(userTenant);
        }
        return ApiResponse.status((boolean)this.sysUserTenantService.saveBatch(userTenantList));
    }
}

