/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.datasource.service.impl;

import com.baomidou.dynamic.datasource.annotation.Master;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.datasource.dao.SysDataSourceMapper;
import com.jxdinfo.hussar.bsp.datasource.model.SysDataSource;
import com.jxdinfo.hussar.bsp.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.bsp.tenant.dao.SysTenantMapper;
import com.jxdinfo.hussar.bsp.tenant.model.SysTenant;
import com.jxdinfo.hussar.common.exception.DataSourceException;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.config.front.common.response.ResultCode;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.datasource.DataSourceProperties;
import com.jxdinfo.hussar.core.datasource.DruidProperties;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.tenant.TenantService;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Master
public class SysDataSourceServiceImpl
extends ServiceImpl<SysDataSourceMapper, SysDataSource>
implements SysDataSourceService {
    @Resource
    private SysDataSourceMapper sysDataSourceMapper;
    @Resource
    private SysTenantMapper sysTenantMapper;
    @Resource
    private DruidProperties druidProperties;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private ServerProperties serverProperties;

    @Override
    public ApiResponse<SysDataSource> getDetail(String dbId) {
        SysDataSource sysDatasource = (SysDataSource)((Object)this.sysDataSourceMapper.selectById((Serializable)((Object)dbId)));
        return ApiResponse.data((Object)((Object)sysDatasource));
    }

    @Override
    public Map<String, Object> queryList(String dbName, String driverClass, String page, String limit) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        if (ToolUtil.isNotEmpty((Object)page) && ToolUtil.isNotEmpty((Object)limit)) {
            Page pages = new Page((long)Integer.parseInt(page), (long)Integer.parseInt(limit));
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.like(!StringUtils.isEmpty((CharSequence)dbName), (Object)"DB_NAME", (Object)dbName)).like(!StringUtils.isEmpty((CharSequence)driverClass), (Object)"DRIVER_CLASS", (Object)driverClass)).eq((Object)"is_deleted", (Object)"0")).orderByDesc((Object)"CREATE_TIME");
            pages = (Page)this.sysDataSourceMapper.selectPage((IPage)pages, (Wrapper)queryWrapper);
            map.put("count", pages.getTotal());
            map.put("data", pages);
            map.put("code", 0);
            return map;
        }
        map.put("data", null);
        map.put("code", "500");
        map.put("msg", "\u53c2\u6570\u4e0d\u7b26");
        map.put("count", null);
        return map;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<SysDataSource> add(SysDataSource sysDataSource) {
        String validate = this.validateAddDataSource(sysDataSource);
        if (ToolUtil.isNotEmpty((Object)validate)) {
            return ApiResponse.fail((String)validate);
        }
        try {
            String className = DriverManager.getDriver(sysDataSource.getJdbcUrl()).getClass().getName();
            sysDataSource.setDriverClass(className);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        sysDataSource.setCreateTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        sysDataSource.setCreateUser(ToolUtil.isNotEmpty((Object)ShiroKit.getUser()) ? ShiroKit.getUser().getId() : null);
        sysDataSource.setIsDeleted("0");
        if (!super.save((Object)sysDataSource)) {
            return ApiResponse.fail((String)"\u6570\u636e\u6e90\u65b0\u589e\u5931\u8d25\uff01");
        }
        Connection conn = null;
        try {
            ApiResponse<?> result;
            conn = DataSourceUtil.getConnection((String)sysDataSource.getPermitUrl(), (String)sysDataSource.getPermitUserName(), (String)sysDataSource.getPermitPassword());
            String driverName = conn.getMetaData().getDriverName();
            if (driverName.toUpperCase().contains("MYSQL")) {
                result = this.isMysql(conn, sysDataSource);
            } else if (driverName.toUpperCase().contains("OSCAR")) {
                result = this.isOscar(conn, sysDataSource);
            } else if (driverName.toUpperCase().contains("ORACLE")) {
                result = this.isOracle(conn, sysDataSource);
            } else if (driverName.toUpperCase().contains("DM")) {
                result = this.isDm(conn, sysDataSource);
            } else if (driverName.toUpperCase().contains("POSTGRESQL")) {
                result = this.isPostgresql(conn, sysDataSource);
            } else {
                throw new DataSourceException("\u6570\u636e\u5e93\u7c7b\u578b\u6682\u4e0d\u652f\u6301\uff01");
            }
            if (ResultCode.SUCCESS.getCode() == result.getCode()) {
                ApiResponse apiResponse = ApiResponse.data((Object)((Object)sysDataSource));
                return apiResponse;
            }
            try {
                throw new DataSourceException(result.getMsg());
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new DataSourceException("\u6570\u636e\u5e93\u5f02\u5e38!");
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public ApiResponse<SysDataSource> checkDataSource(SysDataSource sysDataSource) {
        sysDataSource.setJdbcUrl(sysDataSource.getJdbcUrl().replaceAll("\n", ""));
        ApiResponse<SysDataSource> dbNameResult = this.valDbName(sysDataSource.getDbName());
        if (ResultCode.SUCCESS.getCode() != dbNameResult.getCode()) {
            return ApiResponse.fail((String)dbNameResult.getMsg());
        }
        ApiResponse<Boolean> connNameResult = this.checkConnName(sysDataSource.getConnName());
        if (((Boolean)connNameResult.getData()).booleanValue()) {
            return ApiResponse.fail((String)"\u8fde\u63a5\u6807\u8bc6\u5df2\u5b58\u5728\uff01");
        }
        ApiResponse<String> connResult = this.tryConnection(sysDataSource.getJdbcUrl(), sysDataSource.getUserName(), sysDataSource.getPassword(), true);
        if (ResultCode.FAILURE.getCode() == connResult.getCode()) {
            return ApiResponse.fail((String)"\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff01");
        }
        try {
            String className = DriverManager.getDriver(sysDataSource.getJdbcUrl()).getClass().getName();
            sysDataSource.setDriverClass(className);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        sysDataSource.setCreateTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        sysDataSource.setCreateUser(ToolUtil.isNotEmpty((Object)ShiroKit.getUser()) ? ShiroKit.getUser().getId() : null);
        sysDataSource.setIsDeleted("0");
        boolean exist = this.checkTableExist(sysDataSource);
        if (!super.save((Object)sysDataSource)) {
            return ApiResponse.fail((String)"\u6570\u636e\u6e90\u65b0\u589e\u5931\u8d25\uff01");
        }
        return ApiResponse.data((Object)((Object)sysDataSource), (String)String.valueOf(exist));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean checkTableExist(SysDataSource sysDataSource) {
        String url = sysDataSource.getJdbcUrl();
        String userName = sysDataSource.getUserName();
        try {
            this.addDataSource(sysDataSource);
            DataSourceUtil.changeTempDs((String)sysDataSource.getConnName());
            if (url.startsWith("jdbc:mysql")) {
                String dsName = url.substring(url.indexOf("/") + 2, url.indexOf("?"));
                String dbName = dsName.substring(dsName.indexOf("/") + 1);
                if (this.sysDataSourceMapper.mysqlTableNum(dbName) > 0) {
                    Boolean bl = false;
                    return bl;
                }
            } else if (url.startsWith("jdbc:oracle")) {
                if (this.sysDataSourceMapper.oracleTableNum(userName) > 0) {
                    Boolean bl = false;
                    return bl;
                }
            } else if (url.startsWith("jdbc:oscar")) {
                if (this.sysDataSourceMapper.oracleTableNum(userName) > 0) {
                    Boolean bl = false;
                    return bl;
                }
            } else if (url.startsWith("jdbc:dm")) {
                if (this.sysDataSourceMapper.oracleTableNum(userName) > 0) {
                    Boolean bl = false;
                    return bl;
                }
            } else if (this.sysDataSourceMapper.pgSqlTableNum() > 0) {
                Boolean bl = false;
                return bl;
            }
        }
        finally {
            DataSourceUtil.poll();
        }
        return true;
    }

    private String validateAddDataSource(SysDataSource sysDataSource) {
        ApiResponse<SysDataSource> dbNameResult = this.valDbName(sysDataSource.getDbName());
        if (ResultCode.SUCCESS.getCode() != dbNameResult.getCode()) {
            return dbNameResult.getMsg();
        }
        ApiResponse<Boolean> connNameResult = this.checkConnName(sysDataSource.getConnName());
        if (((Boolean)connNameResult.getData()).booleanValue()) {
            return "\u8fde\u63a5\u6807\u8bc6\u5df2\u5b58\u5728\uff01";
        }
        ApiResponse<String> connResult = this.tryConnection(sysDataSource.getJdbcUrl(), sysDataSource.getUserName(), sysDataSource.getPassword(), false);
        if (ResultCode.SUCCESS.getCode() == connResult.getCode()) {
            return "\u6570\u636e\u5e93\u5df2\u5b58\u5728\uff01";
        }
        if (sysDataSource.getJdbcUrl().toUpperCase().contains("POSTGRESQL") && !connResult.isSuccess()) {
            return "\u6570\u636e\u5e93\u6216\u89d2\u8272\u5df2\u5b58\u5728\uff01";
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<SysDataSource> edit(SysDataSource sysDataSource) {
        SysDataSource dataSource = (SysDataSource)((Object)super.getById((Serializable)((Object)sysDataSource.getDbId())));
        if (!super.updateById((Object)sysDataSource)) {
            return ApiResponse.fail((String)"\u6570\u636e\u6e90\u4fee\u6539\u5931\u8d25\uff01");
        }
        if (ToolUtil.isNotEmpty((Object)sysDataSource.getPassword()) && sysDataSource.getPassword().equals(dataSource.getPassword())) {
            return ApiResponse.status((boolean)true);
        }
        Connection conn = null;
        try {
            conn = DataSourceUtil.getConnection((String)dataSource.getJdbcUrl(), (String)dataSource.getUserName(), (String)dataSource.getPassword());
            DataSourceProperties properties = this.getPropertiesLikeOracle(sysDataSource.getDriverClass(), sysDataSource.getJdbcUrl(), sysDataSource);
            if (DataSourceUtil.updateDbPassword((Connection)conn, (DataSourceProperties)properties)) {
                ApiResponse apiResponse = ApiResponse.status((boolean)true);
                return apiResponse;
            }
            try {
                throw new DataSourceException("\u4fee\u6539\u6570\u636e\u5e93\u5bc6\u7801\u5931\u8d25\uff01");
            }
            catch (SQLException e) {
                throw new DataSourceException("\u6570\u636e\u5e93\u5f02\u5e38!");
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public ApiResponse<SysDataSource> delete(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.in((Object)"db_id", idList)).eq((Object)"is_deleted", (Object)"0");
        Integer count = this.sysTenantMapper.selectCount((Wrapper)queryWrapper);
        if (count > 0) {
            return ApiResponse.fail((String)"\u5b58\u5728\u5df2\u88ab\u79df\u6237\u5173\u8054\u7684\u6570\u636e\u6e90\uff01");
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.in((Object)"db_id", idList)).set((Object)"is_deleted", (Object)"1");
        return ApiResponse.status((boolean)super.update((Wrapper)updateWrapper));
    }

    @Override
    public ApiResponse<SysDataSource> valDbName(String dbName) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"DB_NAME", (Object)dbName)).eq((Object)"is_deleted", (Object)"0");
        Integer count = this.sysDataSourceMapper.selectCount((Wrapper)queryWrapper);
        if (count > 0) {
            return ApiResponse.fail((String)"\u6570\u636e\u6e90\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        return ApiResponse.status((boolean)true);
    }

    @Override
    public SysDataSource getByTenantCode(String tenantCode) {
        return this.sysDataSourceMapper.getByTenantCode(tenantCode);
    }

    @Override
    public ApiResponse<Boolean> checkConnName(String connName) {
        int count = this.sysDataSourceMapper.selectCountByConnName(connName);
        return ApiResponse.data((Object)(count > 0 ? 1 : 0));
    }

    @Override
    public SysDataSource selectByConnName(String connName) {
        return (SysDataSource)((Object)this.sysDataSourceMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"conn_name", (Object)connName)).eq((Object)"is_deleted", (Object)"0")));
    }

    @Override
    public void addDataSourceByConnName(String connName) {
        boolean flag = true;
        try {
            if (ToolUtil.isEmpty((Object)DataSourceUtil.getDataSource((String)connName))) {
                flag = false;
            }
        }
        catch (RuntimeException e) {
            flag = false;
        }
        if (!flag) {
            SysDataSource dataSource = this.selectByConnName(connName);
            DataSourceProperty property = new DataSourceProperty();
            property.setDruid(this.druidProperties.getDruid());
            property.setPoolName(connName);
            property.setDriverClassName(dataSource.getDriverClass());
            property.setUrl(dataSource.getJdbcUrl());
            property.setUsername(dataSource.getUserName());
            property.setPassword(dataSource.getPassword());
            DataSourceUtil.addDataSource((DataSourceProperty)property);
        }
    }

    private void addDataSource(SysDataSource sysDataSource) {
        boolean flag = true;
        try {
            if (ToolUtil.isEmpty((Object)DataSourceUtil.getDataSource((String)sysDataSource.getConnName()))) {
                flag = false;
            }
        }
        catch (RuntimeException e) {
            flag = false;
        }
        if (!flag) {
            DataSourceProperty property = new DataSourceProperty();
            property.setDruid(this.druidProperties.getDruid());
            property.setPoolName(sysDataSource.getConnName());
            property.setDriverClassName(sysDataSource.getDriverClass());
            property.setUrl(sysDataSource.getJdbcUrl());
            property.setUsername(sysDataSource.getUserName());
            property.setPassword(sysDataSource.getPassword());
            DataSourceUtil.addDataSource((DataSourceProperty)property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResponse<String> tryConnection(String url, String userName, String password, boolean printFlag) {
        Connection conn = null;
        try {
            conn = DataSourceUtil.getConnection((String)url, (String)userName, (String)password);
            String driverName = conn.getMetaData().getDriverName();
            ApiResponse apiResponse = ApiResponse.data((Object)driverName.toUpperCase());
            return apiResponse;
        }
        catch (SQLException e) {
            if (printFlag) {
                e.printStackTrace();
            }
            ApiResponse apiResponse = ApiResponse.fail((String)"\u6570\u636e\u5e93\u8fde\u63a5\u9519\u8bef\uff01");
            return apiResponse;
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public ApiResponse<?> isMysql(String username, String password, String driverClassName, String url, String code) {
        String str = url.substring(url.indexOf("/") + 2, url.indexOf("?"));
        String dsName = str.substring(str.indexOf("/") + 1);
        String newUrl = url.replace(dsName, code);
        SysDataSource sysDataSource = new SysDataSource();
        sysDataSource.setDbName(code);
        sysDataSource.setConnName("tenant" + code);
        sysDataSource.setDriverClass(driverClassName);
        sysDataSource.setJdbcUrl(newUrl);
        sysDataSource.setUserName(username);
        sysDataSource.setPassword(password);
        sysDataSource.setCreateTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        sysDataSource.setCreateUser(ToolUtil.isNotEmpty((Object)ShiroKit.getUser()) ? ShiroKit.getUser().getId() : null);
        sysDataSource.setIsDeleted("0");
        if (!super.save((Object)sysDataSource)) {
            throw new DataSourceException("\u6570\u636e\u6e90\u65b0\u589e\u5931\u8d25\uff01");
        }
        DataSourceProperties dataSourceProperties = new DataSourceProperties();
        dataSourceProperties.setUrl(newUrl);
        dataSourceProperties.setUsername(username);
        dataSourceProperties.setPassword(password);
        dataSourceProperties.setDriverClassName(driverClassName);
        dataSourceProperties.setDbName(code);
        dataSourceProperties.setPoolName(sysDataSource.getConnName());
        return this.createDataSource(null, dataSourceProperties);
    }

    private ApiResponse<?> isMysql(Connection conn, SysDataSource dataSource) {
        String url = dataSource.getJdbcUrl();
        String dsName = url.substring(url.indexOf("/") + 2, url.indexOf("?"));
        dsName = dsName.substring(dsName.indexOf("/") + 1);
        DataSourceProperties dataSourceProperties = new DataSourceProperties();
        dataSourceProperties.setUrl(url);
        dataSourceProperties.setUsername(dataSource.getUserName());
        dataSourceProperties.setPassword(dataSource.getPassword());
        dataSourceProperties.setDriverClassName(dataSource.getDriverClass());
        dataSourceProperties.setDbName(dsName);
        dataSourceProperties.setPoolName(dataSource.getConnName());
        return this.createDataSource(conn, dataSourceProperties);
    }

    @Override
    public ApiResponse<?> isOscar(String driverClassName, String url, String code) {
        SysDataSource sysDataSource = this.getDataSourceLikeOracle(driverClassName, url, code);
        if (!super.save((Object)sysDataSource)) {
            throw new DataSourceException("\u6570\u636e\u6e90\u65b0\u589e\u5931\u8d25\uff01");
        }
        DataSourceProperties dataSourceProperties = this.getPropertiesLikeOracle(driverClassName, url, sysDataSource);
        return this.createDataSource(null, dataSourceProperties);
    }

    private ApiResponse<?> isOscar(Connection conn, SysDataSource dataSource) {
        DataSourceProperties dataSourceProperties = this.getPropertiesByDataSource(dataSource);
        return this.createDataSource(conn, dataSourceProperties);
    }

    @Override
    public ApiResponse<?> isOracle(String driverClassName, String url, String code) {
        SysDataSource sysDataSource = this.getDataSourceLikeOracle(driverClassName, url, code);
        if (!super.save((Object)sysDataSource)) {
            throw new DataSourceException("\u6570\u636e\u6e90\u65b0\u589e\u5931\u8d25\uff01");
        }
        DataSourceProperties dataSourceProperties = this.getPropertiesLikeOracle(driverClassName, url, sysDataSource);
        return this.createDataSource(null, dataSourceProperties);
    }

    private ApiResponse<?> isOracle(Connection conn, SysDataSource dataSource) {
        DataSourceProperties dataSourceProperties = this.getPropertiesByDataSource(dataSource);
        return this.createDataSource(conn, dataSourceProperties);
    }

    private ApiResponse<?> createDataSource(Connection conn, DataSourceProperties dataSourceProperties) {
        boolean isCreate = "2".equals(this.globalProperties.getTenantLevel()) ? DataSourceUtil.createDatabase((DataSourceProperties)dataSourceProperties) : ("3".equals(this.globalProperties.getTenantLevel()) ? DataSourceUtil.createDatabase((Connection)conn, (DataSourceProperties)dataSourceProperties) : false);
        if (isCreate) {
            return ApiResponse.status((boolean)true);
        }
        return ApiResponse.fail((String)"\u6570\u636e\u5e93\u521b\u5efa\u5931\u8d25\uff01");
    }

    private SysDataSource getDataSourceLikeOracle(String driverClassName, String url, String code) {
        String userName = "USER" + code;
        String password = "PWD" + code;
        if (url.contains("jdbc:postgresql")) {
            String str = url.substring(url.indexOf("/") + 2, url.indexOf("?"));
            String dsName = str.substring(str.indexOf("/") + 1);
            url = url.replace(dsName, userName);
        }
        SysDataSource sysDataSource = new SysDataSource();
        sysDataSource.setDbName(code);
        sysDataSource.setConnName("tenant" + code);
        sysDataSource.setDriverClass(driverClassName);
        sysDataSource.setJdbcUrl(url);
        sysDataSource.setUserName(userName);
        sysDataSource.setPassword(password);
        sysDataSource.setCreateTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        sysDataSource.setCreateUser(ToolUtil.isNotEmpty((Object)ShiroKit.getUser()) ? ShiroKit.getUser().getId() : null);
        sysDataSource.setIsDeleted("0");
        return sysDataSource;
    }

    private DataSourceProperties getPropertiesLikeOracle(String driverClassName, String url, SysDataSource dataSource) {
        DataSourceProperties dataSourceProperties = new DataSourceProperties();
        dataSourceProperties.setUrl(url);
        dataSourceProperties.setUsername(dataSource.getUserName());
        dataSourceProperties.setPassword(dataSource.getPassword());
        dataSourceProperties.setDriverClassName(driverClassName);
        dataSourceProperties.setPoolName(dataSource.getConnName());
        return dataSourceProperties;
    }

    private DataSourceProperties getPropertiesByDataSource(SysDataSource dataSource) {
        DataSourceProperties dataSourceProperties = new DataSourceProperties();
        dataSourceProperties.setUrl(dataSource.getJdbcUrl());
        dataSourceProperties.setUsername(dataSource.getUserName());
        dataSourceProperties.setPassword(dataSource.getPassword());
        dataSourceProperties.setDriverClassName(dataSource.getDriverClass());
        dataSourceProperties.setPoolName(dataSource.getConnName());
        return dataSourceProperties;
    }

    @Override
    public ApiResponse<?> isDm(String driverClassName, String url, String code) {
        SysDataSource sysDataSource = this.getDataSourceLikeOracle(driverClassName, url, code);
        if (!super.save((Object)sysDataSource)) {
            throw new DataSourceException("\u6570\u636e\u6e90\u65b0\u589e\u5931\u8d25\uff01");
        }
        DataSourceProperties dataSourceProperties = this.getPropertiesLikeOracle(driverClassName, url, sysDataSource);
        return this.createDataSource(null, dataSourceProperties);
    }

    private ApiResponse<?> isDm(Connection conn, SysDataSource dataSource) {
        DataSourceProperties dataSourceProperties = this.getPropertiesByDataSource(dataSource);
        return this.createDataSource(conn, dataSourceProperties);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<?> isPostgresql(String username, String password, String driverClassName, String url, String code) {
        SysDataSource sysDataSource = this.getDataSourceLikeOracle(driverClassName, url, code);
        if (!super.save((Object)sysDataSource)) {
            throw new DataSourceException("\u6570\u636e\u6e90\u65b0\u589e\u5931\u8d25\uff01");
        }
        DataSourceProperties dataSourceProperties = this.getPropertiesLikeOracle(driverClassName, url, sysDataSource);
        return this.createDataSource(null, dataSourceProperties);
    }

    private ApiResponse<?> isPostgresql(Connection conn, SysDataSource dataSource) {
        DataSourceProperties dataSourceProperties = this.getPropertiesByDataSource(dataSource);
        return this.createDataSource(conn, dataSourceProperties);
    }

    @Override
    public ApiResponse<?> execSqlFile(String dbId, String isBpmType, String tenantId) {
        SysDataSource dataSource = (SysDataSource)((Object)this.sysDataSourceMapper.selectById((Serializable)((Object)dbId)));
        String url = dataSource.getJdbcUrl();
        String userName = dataSource.getUserName();
        String password = dataSource.getPassword();
        try {
            Connection conn = DataSourceUtil.getConnection((String)url, (String)userName, (String)password);
            String driverName = conn.getMetaData().getDriverName();
            DataSourceProperties dataSourceProperties = new DataSourceProperties();
            dataSourceProperties.setUrl(url);
            dataSourceProperties.setUsername(userName);
            dataSourceProperties.setPassword(password);
            if ("1".equals(isBpmType)) {
                if ("2".equals(this.globalProperties.getTenantLevel())) {
                    if (driverName.toUpperCase().contains("MYSQL")) {
                        return this.execSqlFile(dataSourceProperties, "tenantsql/mysql/HUSSAR_V8_MYSQL.sql", "tenantsql/mysql/HUSSAR_V8_MYSQL_UPDATE.sql", "tenantsql/mysql/BPM_MYSQL.sql", dbId);
                    }
                    if (driverName.toUpperCase().contains("OSCAR")) {
                        return this.execSqlFile(dataSourceProperties, "tenantsql/oscar/HUSSAR_V8_OSCAR.sql", "tenantsql/oscar/HUSSAR_V8_OSCAR_UPDATE.sql", "tenantsql/oscar/BPM_OSCAR.sql", dbId);
                    }
                    if (driverName.toUpperCase().contains("ORACLE")) {
                        return this.execSqlFile(dataSourceProperties, "tenantsql/oracle/HUSSAR_V8_ORACLE.sql", "tenantsql/oracle/HUSSAR_V8_ORACLE_UPDATE.sql", "tenantsql/oracle/BPM_ORACLE.sql", dbId);
                    }
                    if (driverName.toUpperCase().contains("DM")) {
                        return this.execSqlFile(dataSourceProperties, "tenantsql/dm/HUSSAR_V8_DM.sql", "tenantsql/dm/HUSSAR_V8_DM_UPDATE.sql", "tenantsql/dm/BPM_DM.sql", dbId);
                    }
                    return ApiResponse.fail((String)"\u6570\u636e\u5e93\u7c7b\u578b\u6682\u4e0d\u652f\u6301\uff01");
                }
                if (driverName.toUpperCase().contains("MYSQL")) {
                    return this.execSqlFile1(dataSourceProperties, "tenantsql/mysql/HUSSAR_V8_MYSQL.sql", "tenantsql/mysql/HUSSAR_V8_MYSQL_UPDATE.sql", "tenantsql/mysql/BPM_MYSQL.sql", dbId);
                }
                if (driverName.toUpperCase().contains("OSCAR")) {
                    return this.execSqlFile1(dataSourceProperties, "tenantsql/oscar/HUSSAR_V8_OSCAR.sql", "tenantsql/oscar/HUSSAR_V8_OSCAR_UPDATE.sql", "tenantsql/oscar/BPM_OSCAR.sql", dbId);
                }
                if (driverName.toUpperCase().contains("ORACLE")) {
                    return this.execSqlFile1(dataSourceProperties, "tenantsql/oracle/HUSSAR_V8_ORACLE.sql", "tenantsql/oracle/HUSSAR_V8_ORACLE_UPDATE.sql", "tenantsql/oracle/BPM_ORACLE.sql", dbId);
                }
                if (driverName.toUpperCase().contains("DM")) {
                    return this.execSqlFile1(dataSourceProperties, "tenantsql/dm/HUSSAR_V8_DM.sql", "tenantsql/dm/HUSSAR_V8_DM_UPDATE.sql", "tenantsql/dm/BPM_DM.sql", dbId);
                }
                if (driverName.toUpperCase().contains("POSTGRESQL")) {
                    return this.execSqlFile(dataSourceProperties, "tenantsql/postgresql/HUSSAR_V8_PGSQL.sql", "tenantsql/postgresql/HUSSAR_V8_PGSQL_UPDATE.sql");
                }
                return ApiResponse.fail((String)"\u6570\u636e\u5e93\u7c7b\u578b\u6682\u4e0d\u652f\u6301\uff01");
            }
            if (driverName.toUpperCase().contains("MYSQL")) {
                return this.execSqlFile(dataSourceProperties, "tenantsql/mysql/HUSSAR_V8_MYSQL.sql", "tenantsql/mysql/HUSSAR_V8_MYSQL_UPDATE.sql");
            }
            if (driverName.toUpperCase().contains("OSCAR")) {
                return this.execSqlFile(dataSourceProperties, "tenantsql/oscar/HUSSAR_V8_OSCAR.sql", "tenantsql/oscar/HUSSAR_V8_OSCAR_UPDATE.sql");
            }
            if (driverName.toUpperCase().contains("ORACLE")) {
                return this.execSqlFile(dataSourceProperties, "tenantsql/oracle/HUSSAR_V8_ORACLE.sql", "tenantsql/oracle/HUSSAR_V8_ORACLE_UPDATE.sql");
            }
            if (driverName.toUpperCase().contains("DM")) {
                return this.execSqlFile(dataSourceProperties, "tenantsql/dm/HUSSAR_V8_DM.sql", "tenantsql/dm/HUSSAR_V8_DM_UPDATE.sql");
            }
            if (driverName.toUpperCase().contains("POSTGRESQL")) {
                return this.execSqlFile(dataSourceProperties, "tenantsql/postgresql/HUSSAR_V8_PGSQL.sql", "tenantsql/postgresql/HUSSAR_V8_PGSQL_UPDATE.sql");
            }
            return ApiResponse.fail((String)"\u6570\u636e\u5e93\u7c7b\u578b\u6682\u4e0d\u652f\u6301\uff01");
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DataSourceException("\u6570\u636e\u5e93\u8fde\u63a5\u9519\u8bef\uff01");
        }
    }

    private ApiResponse<?> execSqlFile(DataSourceProperties dataSourceProperties, String initPath, String updatePath) {
        if (DataSourceUtil.execSqlFile((DataSourceProperty)dataSourceProperties, (String)initPath)) {
            if (DataSourceUtil.execSqlFile((DataSourceProperty)dataSourceProperties, (String)updatePath)) {
                return ApiResponse.status((boolean)true);
            }
            return ApiResponse.fail((String)"\u589e\u91cfSQL\u5bfc\u5165\u5931\u8d25\uff01");
        }
        return ApiResponse.fail((String)"\u521d\u59cb\u5316SQL\u5bfc\u5165\u5931\u8d25\uff01");
    }

    private ApiResponse<?> execSqlFile(DataSourceProperties dataSourceProperties, String initPath, String updatePath, String bpmPath, String dbId) {
        if (DataSourceUtil.execSqlFile((DataSourceProperty)dataSourceProperties, (String)initPath)) {
            if (DataSourceUtil.execSqlFile((DataSourceProperty)dataSourceProperties, (String)updatePath)) {
                if (DataSourceUtil.execSqlFile((DataSourceProperty)dataSourceProperties, (String)bpmPath)) {
                    return this.bpm(dbId);
                }
                return ApiResponse.fail((String)"\u5de5\u4f5c\u6d41SQL\u5bfc\u5165\u5931\u8d25\uff01");
            }
            return ApiResponse.fail((String)"\u589e\u91cfSQL\u5bfc\u5165\u5931\u8d25\uff01");
        }
        return ApiResponse.fail((String)"\u521d\u59cb\u5316SQL\u5bfc\u5165\u5931\u8d25\uff01");
    }

    private ApiResponse<?> execSqlFile1(DataSourceProperties dataSourceProperties, String initPath, String updatePath, String bpmPath, String dbId) {
        if (DataSourceUtil.execSqlFile((DataSourceProperty)dataSourceProperties, (String)initPath)) {
            if (DataSourceUtil.execSqlFile((DataSourceProperty)dataSourceProperties, (String)updatePath)) {
                if (DataSourceUtil.execSqlFile((DataSourceProperty)dataSourceProperties, (String)bpmPath)) {
                    return ApiResponse.status((boolean)true);
                }
                return ApiResponse.fail((String)"\u5de5\u4f5c\u6d41SQL\u5bfc\u5165\u5931\u8d25\uff01");
            }
            return ApiResponse.fail((String)"\u589e\u91cfSQL\u5bfc\u5165\u5931\u8d25\uff01");
        }
        return ApiResponse.fail((String)"\u521d\u59cb\u5316SQL\u5bfc\u5165\u5931\u8d25\uff01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiResponse<?> bpm(String dbId) {
        int id;
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"DB_ID", (Object)dbId)).eq((Object)"IS_DELETED", (Object)"0");
        String address = "http://" + this.getIP() + ":" + this.serverProperties.getPort();
        String bpmTenantId = ((SysTenant)((Object)this.sysTenantMapper.selectOne((Wrapper)queryWrapper))).getBpmTenantId();
        String connName = ((SysDataSource)((Object)this.sysDataSourceMapper.selectById((Serializable)((Object)dbId)))).getConnName();
        try {
            this.addDataSourceByConnName(connName);
            DataSourceUtil.changeTempDs((String)connName);
            id = TenantService.insertSysActConfig((String)bpmTenantId, (String)address);
        }
        finally {
            DataSourceUtil.poll();
        }
        return ApiResponse.status((id == 1 ? 1 : 0) != 0);
    }

    @Override
    public String getIP() {
        String localip = null;
        String netip = null;
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            boolean finded = false;
            block2: while (netInterfaces.hasMoreElements() && !finded) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> address = ni.getInetAddresses();
                while (address.hasMoreElements()) {
                    ip = address.nextElement();
                    if (!ip.isSiteLocalAddress() && !ip.isLoopbackAddress() && ip.getHostAddress().indexOf(":") == -1) {
                        netip = ip.getHostAddress();
                        finded = true;
                        continue block2;
                    }
                    if (!ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().indexOf(":") != -1) continue;
                    localip = ip.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        if (netip != null && !"".equals(netip)) {
            return netip;
        }
        return localip;
    }
}

