/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.baseconfig.service.impl;

import com.baomidou.dynamic.datasource.annotation.Master;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.baseconfig.dao.SysBaseConfigMapper;
import com.jxdinfo.hussar.bsp.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.bsp.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
@Master
public class SysBaseConfigServiceImpl
extends ServiceImpl<SysBaseConfigMapper, SysBaseConfig>
implements ISysBaseConfigService {
    @Resource
    private HussarCacheManager hussarCacheManager;
    @Resource
    private GlobalProperties globalProperties;

    @Override
    @Master
    public SysBaseConfig getSysBaseConfig(String configKey) {
        return this.getSysBaseConfigWithUser(configKey, null);
    }

    @Override
    public void setSysBaseConfigCache(String configKey, SysBaseConfig baseConfig) {
        String key = "base_config:" + configKey;
        if (this.globalProperties.isTenantOpen()) {
            key = "base_config:" + DataSourceUtil.currentDsName() + ":" + configKey;
        }
        this.hussarCacheManager.setObject("base_config", key, (Object)baseConfig);
    }

    @Override
    @Master
    public SysBaseConfig getSysBaseConfigWithUser(String configKey, ShiroUser shiroUser) {
        SysBaseConfig sysBaseConfig;
        Object obj;
        String key = "base_config:" + configKey;
        if (this.globalProperties.isTenantOpen()) {
            key = "base_config:" + DataSourceUtil.currentDsName() + ":" + configKey;
        }
        if (ToolUtil.isEmpty((Object)(obj = this.hussarCacheManager.getObject("base_config", key)))) {
            SysBaseConfig baseConfig = (SysBaseConfig)((Object)super.getOne((Wrapper)new QueryWrapper().eq((Object)"config_key", (Object)configKey), false));
            this.hussarCacheManager.setObject("base_config", key, (Object)baseConfig);
            sysBaseConfig = baseConfig;
        } else {
            sysBaseConfig = (SysBaseConfig)((Object)obj);
        }
        return sysBaseConfig;
    }
}

