/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.audit.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bpm.messagepush.AbstractBpmPushMsgMatcher;
import com.jxdinfo.hussar.bsp.audit.model.SysUserIpAudit;
import com.jxdinfo.hussar.bsp.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.bsp.audit.service.ISysUserIpAuditService;
import com.jxdinfo.hussar.bsp.audit.service.ISysUsersAuditService;
import com.jxdinfo.hussar.bsp.audit.util.CopyPropertieUtils;
import com.jxdinfo.hussar.bsp.organ.model.SysOrgan;
import com.jxdinfo.hussar.bsp.organ.service.ISysStruService;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.bsp.sysuserip.service.ISysUserIpService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.sys.model.DicSingle;
import com.jxdinfo.hussar.core.sys.service.ISysDicRefService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/user"})
public class SysUsersAuditController
extends BaseController {
    @Autowired
    private ISysUsersAuditService iSysUsersAuditService;
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private ISysUserIpService iSysUserIpService;
    @Resource
    private ISysUserIpAuditService iSysUserIpAuditService;
    @Resource
    private ISysDicRefService iSysDicRefService;
    @Resource
    private ISysStruService iSysStruService;
    @Resource
    private AbstractBpmPushMsgMatcher bpmAbstractPushMsgMatcher;

    @RequestMapping(value={"/audit"})
    @RequiresPermissions(value={"user:audit"})
    @BussinessLog(key="/user/audit", type="04", value="\u7528\u6237\u5ba1\u6838\u9875\u9762")
    public String audit(Model model) {
        List<DicSingle> a = this.iSysDicRefService.getDictByType("user_role_review");
        model.addAttribute("status", a);
        return "/bsp/permit/useraudit/sysUsersAudit.html";
    }

    @RequestMapping(value={"/detail"})
    @RequiresPermissions(value={"user:detail"})
    @BussinessLog(key="/user/detail", type="04", value="\u7528\u6237\u5ba1\u6838\u8be6\u60c5")
    public String view(String id, Model model) {
        SysUsersAudit sysUsersAudit = (SysUsersAudit)((Object)this.iSysUsersAuditService.getById((Serializable)((Object)id)));
        sysUsersAudit.setAccessLoginIp(this.iSysUsersAuditService.queryIp(sysUsersAudit.getUserId()));
        model.addAttribute("sysUsersAudit", (Object)sysUsersAudit);
        return "/bsp/permit/useraudit/sysUsersAuditView.html";
    }

    @RequestMapping(value={"/editDetail"})
    @RequiresPermissions(value={"user:editDetail"})
    @BussinessLog(key="/user/editDetail", type="04", value="\u7528\u6237\u5ba1\u6838\u4fee\u6539\u8be6\u60c5")
    public String editDetail(String id, Model model) {
        SysUsersAudit sysUsersAudit = (SysUsersAudit)((Object)this.iSysUsersAuditService.getById((Serializable)((Object)id)));
        SysUsers sysUsers = (SysUsers)((Object)this.iSysUsersService.getById((Serializable)((Object)sysUsersAudit.getUserId())));
        sysUsers.setAccessLoginIp(this.iSysUsersAuditService.queryIp(sysUsersAudit.getUserId()));
        sysUsersAudit.setAccessLoginIp(this.iSysUsersAuditService.queryAuditIp(sysUsersAudit.getUserId(), "1"));
        model.addAttribute("sysUsersAudit", (Object)sysUsersAudit);
        model.addAttribute("sysUsers", (Object)sysUsers);
        return "/bsp/permit/useraudit/sysUsersAuditEditView.html";
    }

    @RequestMapping(value={"/editPassDetail"})
    @BussinessLog(key="/user/editPassDetail", type="04", value="\u7528\u6237\u5ba1\u6838\u8df3\u8f6c\u4fee\u6539(\u5df2\u901a\u8fc7)\u8be6\u60c5\u9875\u9762")
    public String editPassDetail(String id, Model model) {
        SysUsersAudit sysUsersAudit = (SysUsersAudit)((Object)this.iSysUsersAuditService.getById((Serializable)((Object)id)));
        SysUsers sysUsers = (SysUsers)((Object)this.iSysUsersService.getById((Serializable)((Object)sysUsersAudit.getUserId())));
        CopyPropertieUtils.copyProperties((Object)((Object)sysUsersAudit), (Object)((Object)sysUsers));
        sysUsersAudit.setAccessLoginIp(this.iSysUsersAuditService.queryIp(sysUsersAudit.getUserId()));
        model.addAttribute("sysUsersAudit", (Object)sysUsersAudit);
        return "/bsp/permit/useraudit/sysUsersAuditView.html";
    }

    @RequestMapping(value={"/transDetail"})
    @BussinessLog(key="/user/transDetail", type="04", value="\u8f6c\u79fb\u8be6\u60c5")
    public String transDetail(String id, Model model) {
        SysUsersAudit sysUsersAudit = (SysUsersAudit)((Object)this.iSysUsersAuditService.getById((Serializable)((Object)id)));
        SysUsers sysUsers = (SysUsers)((Object)this.iSysUsersService.getById((Serializable)((Object)sysUsersAudit.getUserId())));
        SysOrgan sysOrganPre = this.iSysStruService.getOrganInfoByDeparmentId(sysUsers.getDepartmentId());
        SysOrgan sysOrganAft = this.iSysStruService.getOrganInfoByDeparmentId(sysUsersAudit.getDepartmentId());
        model.addAttribute("pre", (Object)(ToolUtil.isEmpty((Object)((Object)sysOrganPre)) ? null : sysOrganPre));
        model.addAttribute("aft", (Object)(ToolUtil.isEmpty((Object)((Object)sysOrganAft)) ? null : sysOrganAft));
        return "/bsp/permit/useraudit/sysUsersAuditTransView.html";
    }

    @RequestMapping(value={"/listAudit"})
    @ResponseBody
    @RequiresPermissions(value={"user:listAudit"})
    @BussinessLog(key="/user/listAudit", type="04", value="\u7528\u6237\u5ba1\u6838\u5217\u8868")
    public Object listAudit() {
        String currentPage = super.getPara("page");
        String limit = super.getPara("limit");
        String type = super.getPara("type");
        String account = super.getPara("account");
        String status = super.getPara("status");
        Page page = new Page((long)Integer.valueOf(currentPage).intValue(), (long)Integer.valueOf(limit).intValue());
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq(ToolUtil.isNotEmpty((Object)type), (Object)"CURRENT_STATUS", (Object)type)).like(ToolUtil.isNotEmpty((Object)account), (Object)"USER_ACCOUNT", (Object)account)).eq(ToolUtil.isNotEmpty((Object)status), (Object)"IS_AUDIT", (Object)status)).orderByDesc((Object)"CREATE_TIME");
        page = (Page)this.iSysUsersAuditService.page((IPage)page, (Wrapper)wrapper);
        JSONObject json = new JSONObject();
        json.put("data", (Object)page.getRecords());
        json.put("code", (Object)"0");
        json.put("msg", (Object)"");
        json.put("count", (Object)page.getTotal());
        return json;
    }

    @RequestMapping(value={"/passAdd"})
    @ResponseBody
    @RequiresPermissions(value={"user:passAdd"})
    @BussinessLog(key="/user/passAdd", type="03", value="\u7528\u6237\u5ba1\u6838\u65b0\u589e\u901a\u8fc7")
    public Tip passAdd(String id) {
        SysUsersAudit sysUsersAudit = (SysUsersAudit)((Object)this.iSysUsersAuditService.getById((Serializable)((Object)id)));
        if (this.iSysUsersService.isExistAccount(sysUsersAudit.getUserAccount())) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u7528\u6237\u540d\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09");
        }
        if (this.iSysUsersAuditService.passAdd(sysUsersAudit)) {
            return SUCCESS_TIP;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/passEdit"})
    @ResponseBody
    @RequiresPermissions(value={"user:passEdit"})
    @BussinessLog(key="/user/passEdit", type="03", value="\u7528\u6237\u5ba1\u6838\u4fee\u6539\u901a\u8fc7")
    public Tip passEdit(String id) {
        if (this.iSysUsersAuditService.passEdit(id)) {
            return SUCCESS_TIP;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/passDel"})
    @ResponseBody
    @RequiresPermissions(value={"user:passDel"})
    @BussinessLog(key="/user/passDel", type="03", value="\u7528\u6237\u5ba1\u6838\u5220\u9664\u901a\u8fc7")
    public Tip passDel(String id) {
        if (this.iSysUsersAuditService.passDel(id)) {
            return SUCCESS_TIP;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/passCalcel"})
    @ResponseBody
    @RequiresPermissions(value={"user:passCalcel"})
    @BussinessLog(key="/user/passCalcel", type="03", value="\u7528\u6237\u5ba1\u6838\u6ce8\u9500\u901a\u8fc7")
    public Tip passCalcel(String id) {
        if (this.iSysUsersAuditService.passCalcel(id)) {
            return SUCCESS_TIP;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/passTrans"})
    @ResponseBody
    @RequiresPermissions(value={"user:passTrans"})
    @BussinessLog(key="/user/passTrans", type="03", value="\u7528\u6237\u5ba1\u6838\u8f6c\u79fb\u901a\u8fc7")
    public Tip passTrans(String id) {
        SysUsersAudit sysUsersAudit = (SysUsersAudit)((Object)this.iSysUsersAuditService.getById((Serializable)((Object)id)));
        sysUsersAudit.setIsAudit("1");
        SysUsers sysUsers = new SysUsers();
        CopyPropertieUtils.copyProperties((Object)((Object)sysUsers), (Object)((Object)sysUsersAudit));
        if (this.iSysUsersService.updateById((Object)sysUsers) && this.iSysUsersAuditService.updateById((Object)sysUsersAudit)) {
            this.bpmAbstractPushMsgMatcher.pushUser(sysUsers, "update", null);
            return SUCCESS_TIP;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/reject"})
    @ResponseBody
    @RequiresPermissions(value={"user:reject"})
    @BussinessLog(key="/user/reject", type="03", value="\u7528\u6237\u5ba1\u6838\u9a73\u56de")
    public Tip rejectAdd(String id) {
        SysUsersAudit sysUsersAudit = new SysUsersAudit();
        sysUsersAudit.setId(id);
        sysUsersAudit.setIsAudit("2");
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"IS_AUDIT", (Object)"0")).eq((Object)"CURRENT_STATUS", (Object)"1");
        SysUserIpAudit sysUserIpAudit = new SysUserIpAudit();
        sysUserIpAudit.setCurrentStatus("2");
        this.iSysUserIpAuditService.update((Object)sysUserIpAudit, (Wrapper)wrapper);
        if (this.iSysUsersAuditService.updateById((Object)sysUsersAudit)) {
            return SUCCESS_TIP;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5931\u8d25\uff01");
    }
}

