/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.audit.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bsp.audit.model.SysStaffAudit;
import com.jxdinfo.hussar.bsp.audit.service.ISysStaffAuditService;
import com.jxdinfo.hussar.bsp.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.bsp.audit.vo.SysStruAuditVo;
import com.jxdinfo.hussar.bsp.organ.model.SysStaff;
import com.jxdinfo.hussar.bsp.organ.service.ISysStaffService;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.organ.vo.OrganInfoVo;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sysStaffAudit"})
public class SysStaffAuditController
extends BaseController {
    private String PREFIX = "/bsp/audit/";
    @Autowired
    private ISysStaffAuditService sysStaffAuditService;
    @Autowired
    private ISysStruAuditService iSysStruAuditService;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private ISysStaffService sysStaffService;

    @RequestMapping(value={"/view"})
    @BussinessLog(key="/sysStaffAudit/view", type="04", value="\u4eba\u5458\u5ba1\u6838\u9875\u9762")
    @RequiresPermissions(value={"sysStaffAudit:view"})
    public String index() {
        return this.PREFIX + "sysStaffAudit.html";
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    @RequiresPermissions(value={"sysStaffAudit:list"})
    @BussinessLog(key="/sysStaffAudit/list", type="04", value="\u4eba\u5458\u5ba1\u6838\u5217\u8868")
    public Object list(String userName, @RequestParam(defaultValue="0") String type) {
        int page = Integer.parseInt(super.getPara("page"));
        int limit = Integer.parseInt(super.getPara("limit"));
        Page pages = new Page((long)page, (long)limit);
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        List<SysStruAuditVo> list = this.sysStaffAuditService.queryStaffAudit(pages, userName, type);
        result.put("count", pages.getTotal());
        result.put("data", list);
        result.put("code", 0);
        result.put("msg", "success");
        return result;
    }

    @RequestMapping(value={"/detail"})
    @BussinessLog(key="/sysStaffAudit/view", type="04", value="\u4eba\u5458\u5ba1\u6838\u8be6\u60c5")
    @RequiresPermissions(value={"sysStaffAudit:view"})
    public String detail(Model model) {
        String htmlPath = "/";
        String struId = super.getPara("struId");
        String type = super.getPara("type");
        if ("1".equals(type)) {
            OrganInfoVo orgInfo = this.iSysStruAuditService.getOrgInfoById(struId);
            SysStaffAudit staff = (SysStaffAudit)((Object)this.sysStaffAuditService.getOne((Wrapper)new QueryWrapper().eq((Object)"STRU_ID", (Object)struId), false));
            if (ToolUtil.isEmpty((Object)((Object)staff))) {
                staff = new SysStaffAudit();
            }
            model.addAttribute("orgInfo", (Object)orgInfo);
            model.addAttribute("staff", (Object)staff);
            htmlPath = this.PREFIX + "addStaffView.html";
        } else if ("2".equals(type)) {
            String odlSex;
            String realStruId = super.getPara("realStruId");
            OrganInfoVo orgInfo = this.iSysStruAuditService.getEditOrgInfoById(struId);
            SysStaffAudit staff = (SysStaffAudit)((Object)this.sysStaffAuditService.getOne((Wrapper)new QueryWrapper().eq((Object)"STRU_ID", (Object)struId), false));
            if (ToolUtil.isEmpty((Object)((Object)staff))) {
                staff = new SysStaffAudit();
            }
            OrganInfoVo oldOrgInfo = this.orgMaintenanceService.getOldOrgInfoById(realStruId);
            SysStaff oldStaff = (SysStaff)((Object)this.sysStaffService.getOne((Wrapper)new QueryWrapper().eq((Object)"STRU_ID", (Object)realStruId), false));
            String sex = staff.getSex();
            if (sex != null) {
                switch (sex) {
                    case "1": {
                        sex = "\u7537";
                        break;
                    }
                    case "2": {
                        sex = "\u5973";
                        break;
                    }
                }
                staff.setSex(sex);
            }
            if ((odlSex = oldStaff.getSex()) != null) {
                switch (odlSex) {
                    case "1": {
                        odlSex = "\u7537";
                        break;
                    }
                    case "2": {
                        odlSex = "\u5973";
                        break;
                    }
                }
                oldStaff.setSex(odlSex);
            }
            model.addAttribute("orgInfo", (Object)orgInfo);
            model.addAttribute("staff", (Object)staff);
            model.addAttribute("oldOrgInfo", (Object)oldOrgInfo);
            model.addAttribute("oldStaff", (Object)oldStaff);
            htmlPath = this.PREFIX + "editStaffView.html";
        } else if ("3".equals(type)) {
            String realStruId = super.getPara("realStruId");
            OrganInfoVo orgInfo = this.orgMaintenanceService.getOldOrgInfoById(realStruId);
            SysStaff staff = (SysStaff)((Object)this.sysStaffService.getOne((Wrapper)new QueryWrapper().eq((Object)"STRU_ID", (Object)realStruId), false));
            if (ToolUtil.isEmpty((Object)((Object)staff))) {
                staff = new SysStaff();
            }
            model.addAttribute("orgInfo", (Object)orgInfo);
            model.addAttribute("staff", (Object)staff);
            htmlPath = this.PREFIX + "addStaffView.html";
        } else {
            String sex;
            String realStruId = super.getPara("realStruId");
            OrganInfoVo oldOrgInfo = this.orgMaintenanceService.getOldOrgInfoById(realStruId);
            String newParentName = this.iSysStruAuditService.getNewParentName(struId);
            SysStaffAudit staff = (SysStaffAudit)((Object)this.sysStaffAuditService.getOne((Wrapper)new QueryWrapper().eq((Object)"STRU_ID", (Object)realStruId), false));
            SysStaff oldStaff = (SysStaff)((Object)this.sysStaffService.getOne((Wrapper)new QueryWrapper().eq((Object)"STRU_ID", (Object)realStruId), false));
            if (ToolUtil.isEmpty((Object)((Object)staff))) {
                staff = new SysStaffAudit();
            }
            if ((sex = oldStaff.getSex()) != null) {
                switch (sex) {
                    case "1": {
                        sex = "\u7537";
                        break;
                    }
                    case "2": {
                        sex = "\u5973";
                        break;
                    }
                }
                staff.setSex(sex);
                oldStaff.setSex(sex);
            }
            staff.setAddress(oldStaff.getAddress());
            staff.setBirthday(oldStaff.getBirthday());
            staff.setGraduateDate(oldStaff.getGraduateDate());
            staff.setGraduateSchool(oldStaff.getGraduateSchool());
            staff.setIdcard(oldStaff.getIdcard());
            staff.setName(oldStaff.getName());
            staff.setWorkDate(oldStaff.getWorkDate());
            staff.setWorkId(oldStaff.getWorkId());
            OrganInfoVo orgInfo = new OrganInfoVo();
            BeanUtils.copyProperties((Object)oldOrgInfo, (Object)orgInfo);
            orgInfo.setParentName(newParentName);
            model.addAttribute("orgInfo", (Object)orgInfo);
            model.addAttribute("oldOrgInfo", (Object)oldOrgInfo);
            model.addAttribute("staff", (Object)staff);
            model.addAttribute("oldStaff", (Object)oldStaff);
            htmlPath = this.PREFIX + "editStaffView.html";
        }
        return htmlPath;
    }

    @RequestMapping(value={"/delete"})
    @BussinessLog(key="/sysStaffAudit/delete", type="02", value="\u5220\u9664\u4eba\u5458\u673a\u6784\u64cd\u4f5c\u5ba1\u6838")
    @ResponseBody
    public Tip delete(@RequestParam String sysStaffAuditId) {
        this.sysStaffAuditService.removeById((Serializable)((Object)sysStaffAuditId));
        return SUCCESS_TIP;
    }
}

