/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.messagepush.util;

import com.jxdinfo.hussar.common.exception.HussarUndeclaredThrowableException;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.util.BpmConfigReadService;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="global", name={"tenant-open"}, havingValue="true", matchIfMissing=false)
public class TenantBpmConfigRead
implements BpmConfigReadService {
    private static String url;
    private static String tenantId;
    private static String tenantCipher;
    @Value(value="${hussar-bpm.url:}")
    private String tempUrl;
    @Value(value="${hussar-bpm.tenant-id:}")
    private String tempTenantId;
    @Value(value="${hussar-bpm.tenant-cipher:}")
    private String tempTenantCipher;

    @PostConstruct
    public void init() {
        url = this.tempUrl;
        tenantId = null;
        tenantCipher = null;
    }

    public void setTempUrl(String tempUrl) {
        this.tempUrl = tempUrl;
    }

    public void setTempTenantId(String tempTenantId) {
        this.tempTenantId = tempTenantId;
    }

    public void setTempTenantCipher(String tempTenantCipher) {
        this.tempTenantCipher = tempTenantCipher;
    }

    public String getUrl() {
        return url;
    }

    public String getTempTenantId() {
        return this.tempTenantId;
    }

    public String getTenantId() throws HussarUndeclaredThrowableException {
        ShiroUser shiroUser = ShiroKit.getUser();
        if (shiroUser != null && shiroUser.getTenantId() != null && shiroUser.getTenantCipher() != null) {
            tenantId = shiroUser.getTenantId();
            tenantCipher = shiroUser.getTenantCipher();
        } else {
            tenantId = null;
            tenantCipher = null;
        }
        return tenantId;
    }

    public String getTenantCipher() {
        return tenantCipher;
    }

    public String getTempTenantCipher() {
        return this.tempTenantCipher;
    }
}

