/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ueditor.upload;

import com.jxdinfo.hussar.ueditor.PathFormat;
import com.jxdinfo.hussar.ueditor.define.BaseState;
import com.jxdinfo.hussar.ueditor.define.FileType;
import com.jxdinfo.hussar.ueditor.define.State;
import com.jxdinfo.hussar.ueditor.upload.StorageManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class BinaryUploader {
    public static final State save(HttpServletRequest request, Map<String, Object> conf) {
        boolean isAjaxUpload;
        FileItemStream fileStream = null;
        boolean bl = isAjaxUpload = request.getHeader("X_Requested_With") != null;
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            return new BaseState(false, 5);
        }
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        if (isAjaxUpload) {
            upload.setHeaderEncoding("UTF-8");
        }
        try {
            FileItemIterator iterator = upload.getItemIterator(request);
            while (iterator.hasNext() && (fileStream = iterator.next()).isFormField()) {
                fileStream = null;
            }
            if (fileStream == null) {
                return new BaseState(false, 7);
            }
            String savePath = (String)conf.get("savePath");
            String originFileName = fileStream.getName();
            String suffix = FileType.getSuffixByFilename(originFileName);
            originFileName = originFileName.substring(0, originFileName.length() - suffix.length());
            savePath = savePath + suffix;
            long maxSize = (Long)conf.get("maxSize");
            if (!BinaryUploader.validType(suffix, (String[])conf.get("allowFiles"))) {
                return new BaseState(false, 8);
            }
            savePath = PathFormat.parse(savePath, originFileName);
            String physicalPath = (String)conf.get("rootPath") + savePath;
            InputStream is = fileStream.openStream();
            State storageState = StorageManager.saveFileByInputStream(is, physicalPath, maxSize);
            is.close();
            if (storageState.isSuccess()) {
                storageState.putInfo("url", PathFormat.format(savePath));
                storageState.putInfo("type", suffix);
                storageState.putInfo("original", originFileName + suffix);
            }
            return storageState;
        }
        catch (FileUploadException e) {
            return new BaseState(false, 6);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new BaseState(false, 4);
        }
    }

    private static boolean validType(String type, String[] allowTypes) {
        List<String> list = Arrays.asList(allowTypes);
        return list.contains(type);
    }
}

