/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.system.controller.util;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;

public class GeneratePassword {
    private static int[] index = new int[]{5, 10, 26, 26};
    private static char[] specialCharacters = new char[]{'@', '#', '.', '!', '$'};
    private static char[] numbers = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static char[] upperLetters = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static char[] lowerLetters = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final String LOW_PASS = "1";
    private static final String MIDDLE_PASS = "2";
    private static final String HIGH_PASS = "3";
    private static Object[] all = new Object[]{specialCharacters, numbers, upperLetters, lowerLetters};

    public static String generate(String pwdRule) {
        String pass = "";
        List<String> list = Arrays.asList(pwdRule.split(","));
        int minLength = Integer.parseInt(list.get(0));
        int maxLength = Integer.parseInt(list.get(1));
        String rule = list.get(2);
        int length = minLength + new SecureRandom().nextInt(maxLength - minLength);
        pass = LOW_PASS.equals(rule) ? GeneratePassword.generateLowPass(length) : (MIDDLE_PASS.equals(rule) ? GeneratePassword.generateMiddlePass(length) : GeneratePassword.generateHighPass(length));
        return pass;
    }

    private static String generateLowPass(int length) {
        StringBuilder password = new StringBuilder();
        int type = new SecureRandom().nextInt(4);
        char[] t = (char[])all[type];
        for (int i = 0; i < length; ++i) {
            int eindex = new SecureRandom().nextInt(index[type]);
            password.append(t[eindex]);
        }
        return password.toString();
    }

    private static String generateMiddlePass(int length) {
        int eindex;
        int i;
        StringBuilder password = new StringBuilder();
        int type1 = new SecureRandom().nextInt(4);
        int type2 = new SecureRandom().nextInt(4);
        while (type1 == type2) {
            type2 = new SecureRandom().nextInt(4);
        }
        char[] t1 = (char[])all[type1];
        char[] t2 = (char[])all[type2];
        int num1 = length / 2;
        int num2 = length / 2 + length % 2;
        for (i = 0; i < num1; ++i) {
            eindex = new SecureRandom().nextInt(index[type1]);
            password.append(t1[eindex]);
        }
        for (i = 0; i < num2; ++i) {
            eindex = new SecureRandom().nextInt(index[type2]);
            password.append(t2[eindex]);
        }
        return password.toString();
    }

    private static String generateHighPass(int length) {
        int eindex;
        int i;
        StringBuilder password = new StringBuilder();
        int type1 = new SecureRandom().nextInt(4);
        int type2 = new SecureRandom().nextInt(4);
        int type3 = new SecureRandom().nextInt(4);
        while (type1 == type2) {
            type2 = new SecureRandom().nextInt(4);
        }
        while (type3 == type2 || type3 == type1) {
            type3 = new SecureRandom().nextInt(4);
        }
        char[] t1 = (char[])all[type1];
        char[] t2 = (char[])all[type2];
        char[] t3 = (char[])all[type3];
        int num1 = length / 3;
        int num2 = length / 3;
        int num3 = length / 3 + length % 3;
        for (i = 0; i < num1; ++i) {
            eindex = new SecureRandom().nextInt(index[type1]);
            password.append(t1[eindex]);
        }
        for (i = 0; i < num2; ++i) {
            eindex = new SecureRandom().nextInt(index[type2]);
            password.append(t2[eindex]);
        }
        for (i = 0; i < num3; ++i) {
            eindex = new SecureRandom().nextInt(index[type3]);
            password.append(t3[eindex]);
        }
        return password.toString();
    }
}

