/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.system.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bpm.messagepush.util.ShiroBpmConfiguration;
import com.jxdinfo.hussar.bsp.menu.model.MenuInfo;
import com.jxdinfo.hussar.bsp.menu.service.ISysMenuManageService;
import com.jxdinfo.hussar.bsp.permit.model.SysOnline;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysOnlineHistService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.bsp.theme.service.IThemeService;
import com.jxdinfo.hussar.bsp.welcome.service.ISysWelcomeService;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.InvalidKaptchaException;
import com.jxdinfo.hussar.common.exception.LoginGetParamException;
import com.jxdinfo.hussar.common.exception.TotpKeyException;
import com.jxdinfo.hussar.config.cas.ShiroCasConfiguration;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.config.properties.HussarProperties;
import com.jxdinfo.hussar.core.aop.NoRepeatMethod;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.encrypt.CryptoUtil;
import com.jxdinfo.hussar.core.log.HussarLogManager;
import com.jxdinfo.hussar.core.log.factory.LogTaskFactory;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.support.StrKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.isc.conf.ShiroIscConfiguration;
import com.jxdinfo.hussar.isc.util.ISCTools;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class LoginController
extends BaseController {
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private IThemeService themeService;
    @Resource
    private ISysOnlineHistService iSysOnlineHistService;
    @Resource
    private ISysMenuManageService iSysMenuManageService;
    @Resource
    private ISysWelcomeService iSysWelcomeService;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private HussarProperties hussarProperties;
    @Resource
    private ShiroIscConfiguration iscConf;
    @Autowired
    private AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Autowired
    private ShiroCasConfiguration casConf;
    @Autowired
    private ShiroBpmConfiguration bpmConf;
    @Value(value="${server.port}")
    private String port;
    @Value(value="${spring.profiles.active}")
    private String profiles;

    @RequestMapping(value={"${hussar.welcome-page}"}, method={RequestMethod.GET})
    public String index(Model model) {
        ShiroUser shiroUser = ShiroKit.getUser();
        if (this.iscConf.isActive()) {
            List<MenuInfo> iscMenus = ISCTools.getMenuListByUserId(shiroUser.getId());
            String userName = shiroUser.getName();
            String userId = shiroUser.getId();
            model.addAttribute("userId", (Object)userId);
            model.addAttribute("userName", (Object)userName);
            model.addAttribute("menus", iscMenus);
            model.addAttribute("changeTheme", (Object)this.globalProperties.isChangeTheme());
            model.addAttribute("firstLogin", (Object)"NO");
            model.addAttribute("changePwd", (Object)"NO");
            return this.iscConf.getWelcomePage();
        }
        if (ToolUtil.isEmpty((Object)shiroUser)) {
            if (this.casConf.isActive()) {
                return BaseController.REDIRECT + this.casConf.getServerLogoutUrl() + "?service=" + this.casConf.getLocalUrl();
            }
            return BaseController.REDIRECT + "/login";
        }
        if (this.hussarProperties.getUseSeparation().booleanValue() && this.casConf.isActive()) {
            return BaseController.REDIRECT + this.casConf.getFrontUrl() + "/#/casLogin";
        }
        List<String> rolesList = shiroUser.getRolesList();
        if (rolesList == null || rolesList.size() == 0) {
            ShiroKit.getSubject().logout();
            if (this.casConf.isActive()) {
                return BaseController.REDIRECT + this.casConf.getServerLogoutUrl() + "?service=" + this.casConf.getLocalUrl();
            }
            return BaseController.REDIRECT + "/login";
        }
        List<MenuInfo> menus = this.iSysMenuManageService.getMenuByRoles(shiroUser.getId(), rolesList, this.profiles);
        if (!this.casConf.getActiveType().equals("CASServer")) {
            for (MenuInfo menuInfo : menus) {
                if (!menuInfo.getMenuId().equals("bc1636807d12490f9fe32f57d2999aa1")) continue;
                menus.remove((Object)menuInfo);
                break;
            }
        }
        if (!this.bpmConf.getSendMessage().equals("true")) {
            for (MenuInfo menuInfo : menus) {
                if (!menuInfo.getMenuId().equals("e3296a07c84bda0135bb32a008c186b1")) continue;
                menus.remove((Object)menuInfo);
                break;
            }
        }
        String userName = shiroUser.getName();
        String userId = shiroUser.getId();
        ArrayList<String> roleList = new ArrayList<String>(rolesList);
        roleList.add(userId);
        model.addAttribute("userId", (Object)userId);
        model.addAttribute("userName", (Object)userName);
        model.addAttribute("menus", menus);
        model.addAttribute("changeTheme", (Object)this.globalProperties.isChangeTheme());
        model.addAttribute("welcomePage", (Object)this.iSysWelcomeService.getUserIndex(roleList));
        String address = HttpKit.getLocalHost();
        model.addAttribute("opentype", (Object)this.casConf.getActiveType());
        model.addAttribute("port", (Object)(address + ":" + this.port));
        model.addAttribute("htmlpath", (Object)super.getPara("htmlpath"));
        model.addAttribute("businessId", (Object)super.getPara("businessId"));
        if (this.globalProperties.isForceChangePwd()) {
            SysUsers sysUser = this.iSysUsersService.getUser(shiroUser.getId());
            if (Whether.YES.getValue().equals(sysUser.getIsSys())) {
                model.addAttribute("firstLogin", (Object)"NO");
                model.addAttribute("changePwd", (Object)"NO");
                return "/index.html";
            }
            if (this.iSysUsersService.isFirstLogin(shiroUser.getId())) {
                model.addAttribute("firstLogin", (Object)"YES");
            } else {
                model.addAttribute("firstLogin", (Object)"NO");
            }
            if (this.iSysUsersService.isPwdOverdue(shiroUser.getId())) {
                model.addAttribute("changePwd", (Object)"YES");
            } else {
                model.addAttribute("changePwd", (Object)"NO");
            }
        } else {
            model.addAttribute("firstLogin", (Object)"NO");
            model.addAttribute("changePwd", (Object)"NO");
        }
        return "/index.html";
    }

    @RequestMapping(value={"/login"}, method={RequestMethod.GET})
    public String login() {
        if (this.hussarProperties.getUseSeparation().booleanValue()) {
            return "redirect:static/ui/index.html";
        }
        String welcomePage = this.hussarProperties.getWelcomePage();
        String loginHtml = this.hussarProperties.getLoginHtml();
        HttpServletRequest request = this.getHttpServletRequest();
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (!"username".equalsIgnoreCase(paramName) && !"password".equalsIgnoreCase(paramName) && !"cipher".equalsIgnoreCase(paramName) && !"encrypted".equalsIgnoreCase(paramName)) continue;
            throw new LoginGetParamException();
        }
        String paramTips = request.getParameter("tips");
        Object tips = request.getAttribute("tips");
        if (ToolUtil.isEmpty((Object)tips)) {
            if (ToolUtil.isNotEmpty((Object)paramTips)) {
                request.setAttribute("tips", (Object)paramTips);
            } else {
                request.setAttribute("tips", (Object)"");
            }
        }
        if (tips == null) {
            request.setAttribute("tips", (Object)"");
        }
        if (ToolUtil.isEmpty((Object)loginHtml)) {
            loginHtml = "/login.html";
        }
        if (StrKit.isNotEmpty((String)welcomePage)) {
            ShiroKit.getSession().setAttribute((Object)"welcome_page", (Object)welcomePage);
            ShiroKit.getSession().setAttribute((Object)"tips", tips);
        }
        if (ShiroKit.isAuthenticated() || ShiroKit.getUser() != null) {
            return REDIRECT + "/";
        }
        return loginHtml;
    }

    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    @ResponseBody
    @NoRepeatMethod(timeout=500L)
    public Tip loginVali(@RequestBody Map<String, String> body) {
        String username = body.get("username");
        String password = body.get("cipher");
        String encrypted = body.get("encrypted");
        String remember = body.get("remember");
        if (StringUtils.isEmpty((CharSequence)password)) {
            password = encrypted;
        }
        password = CryptoUtil.decode(password);
        SysUsers sysUsers = (SysUsers)((Object)this.iSysUsersService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_account", (Object)username)).eq((Object)"account_status", (Object)UserStatus.OK.getCode()), false));
        if (this.hussarProperties.getKaptchaOpen().booleanValue()) {
            String kaptcha = body.get("kaptcha");
            String code = (String)super.getSession().getAttribute("KAPTCHA_SESSION_KEY");
            if (ToolUtil.isEmpty((Object)kaptcha) || !kaptcha.equalsIgnoreCase(code)) {
                throw new InvalidKaptchaException(username, "\u9a8c\u8bc1\u7801\u9519\u8bef");
            }
        }
        if (this.hussarProperties.getTotpOpen().booleanValue()) {
            String totp = body.get("totp");
            if (sysUsers != null && !this.abstractOTPCredentialsMatcher.verify(sysUsers.getTotpKey(), totp, this.hussarProperties.getTotpOffsetMin())) {
                throw new TotpKeyException(username, "\u52a8\u6001\u5bc6\u7801\u9519\u8bef");
            }
        }
        Subject currentUser = ShiroKit.getSubject();
        Session session = currentUser.getSession();
        LinkedHashMap attributes = new LinkedHashMap();
        Collection keys = session.getAttributeKeys();
        for (Object key : keys) {
            Object value = session.getAttribute(key);
            if (value == null) continue;
            attributes.put(key, value);
        }
        currentUser.logout();
        UsernamePasswordToken token = new UsernamePasswordToken(username, password.toCharArray());
        if ("on".equals(remember)) {
            token.setRememberMe(true);
        } else {
            token.setRememberMe(false);
        }
        currentUser.login((AuthenticationToken)token);
        session = currentUser.getSession();
        for (Object key : attributes.keySet()) {
            session.setAttribute(key, attributes.get(key));
        }
        ShiroUser shiroUser = ShiroKit.getUser();
        session.setAttribute((Object)"sessionFlag", (Object)true);
        session.setAttribute((Object)"shiroUser", (Object)shiroUser);
        session.setAttribute((Object)"userId", (Object)shiroUser.getId());
        session.setAttribute((Object)"theme", (Object)this.themeService.getUserTheme());
        if (sysUsers != null && "1".equals(sysUsers.getLoginTimeLimit())) {
            session.setAttribute((Object)"startTime", (Object)sysUsers.getAccessLoginStartTime());
            session.setAttribute((Object)"endTime", (Object)sysUsers.getAccessLoginEndTime());
        }
        SysOnline online = this.iSysOnlineHistService.addRecord();
        session.setAttribute((Object)"online", (Object)online);
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("sessionId", (String)((Object)ShiroKit.getSession().getId()));
        info.put("ip", HttpKit.getIp());
        info.put("port", HttpKit.getPort());
        info.put("host", HttpKit.getHost());
        info.put("localIp", HttpKit.getLocalIp());
        info.put("localPort", HttpKit.getLocalPort());
        info.put("localHost", HttpKit.getLocalHost());
        HussarLogManager.me().executeLog(LogTaskFactory.loginLog(shiroUser, "05", info));
        SysUsers user = new SysUsers();
        user.setUserId(shiroUser.getId());
        user.setLastLoginTime(new Date());
        this.iSysUsersService.updateById((Object)user);
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/logout"}, method={RequestMethod.GET})
    public String logOut() {
        ShiroKit.getSubject().logout();
        if (this.casConf.isActive()) {
            return BaseController.REDIRECT + this.casConf.getServerLogoutUrl() + "?service=" + this.casConf.getLocalUrl();
        }
        return BaseController.REDIRECT + "/login";
    }
}

