/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.system.controller;

import com.google.code.kaptcha.Producer;
import com.jxdinfo.hussar.config.properties.HussarProperties;
import com.jxdinfo.hussar.core.util.FileUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/kaptcha"})
public class KaptchaController {
    @Resource
    private HussarProperties hussarProperties;
    @Autowired
    Producer producer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={""})
    public void index(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        response.setDateHeader("Expires", 0L);
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
        response.setContentType("image/jpeg");
        String capText = this.producer.createText();
        session.setAttribute("KAPTCHA_SESSION_KEY", (Object)capText);
        BufferedImage bi = this.producer.createImage(capText);
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            ImageIO.write((RenderedImage)bi, "jpg", (OutputStream)out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            try {
                out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @RequestMapping(value={"/{pictureId}"})
    public void renderPicture(@PathVariable(value="pictureId") String pictureId, HttpServletResponse response) {
        String path = this.hussarProperties.getFileUploadPath() + pictureId + ".jpg";
        try {
            byte[] bytes = FileUtil.toByteArray((String)path);
            response.getOutputStream().write(bytes);
            return;
        }
        catch (IOException e) {
            try {
                response.sendRedirect("/static/img/default.png");
                return;
            }
            catch (IOException e1) {
                e1.printStackTrace();
                return;
            }
        }
    }
}

