/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.system.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bsp.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.bsp.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.bsp.permit.model.SysGetBackPassword;
import com.jxdinfo.hussar.bsp.permit.model.SysPasswordHist;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysGetBackPasswordService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.encrypt.CryptoUtil;
import com.jxdinfo.hussar.core.shiro.encrypt.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.core.shiro.lock.LoginLock;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/getBackPwd"})
public class GetBackPasswordController
extends BaseController {
    @Resource
    private ISysGetBackPasswordService iSysGetBackPasswordService;
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;

    @RequestMapping(value={"/view"})
    public String index() {
        return "/getPwd.html";
    }

    @RequestMapping(value={"/getQues"})
    @ResponseBody
    public Tip getUserQues() {
        String userAccount = super.getPara("userAccount").trim();
        String kaptcha = super.getPara("kaptcha").trim();
        String code = (String)super.getSession().getAttribute("KAPTCHA_SESSION_KEY");
        super.getSession().setAttribute("KAPTCHA_SESSION_KEY", null);
        if (ToolUtil.isEmpty((Object)kaptcha) || !kaptcha.equalsIgnoreCase(code)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u9a8c\u8bc1\u7801\u8f93\u5165\u9519\u8bef\uff01");
        }
        if (!this.iSysUsersService.isExistAccount(userAccount)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u8be5\u7528\u6237\u540d\u4e0d\u5b58\u5728\uff01");
        }
        SysUsers user = (SysUsers)((Object)this.iSysUsersService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ACCOUNT", (Object)userAccount)).ne((Object)"ACCOUNT_STATUS", (Object)"2"), false));
        SysGetBackPassword sysGetBackPassword = (SysGetBackPassword)((Object)this.iSysGetBackPasswordService.getById((Serializable)((Object)user.getUserId())));
        if (ToolUtil.isEmpty((Object)((Object)sysGetBackPassword))) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u60a8\u6ca1\u6709\u8bbe\u7f6e\u5bc6\u4fdd\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u627e\u56de\u60a8\u7684\u5bc6\u7801\uff01");
        }
        return new ErrorTip(HttpCode.OK.value().intValue(), sysGetBackPassword.getpQues());
    }

    @RequestMapping(value={"/validateKey"})
    @ResponseBody
    public Tip validateKey() {
        String userName;
        String userAccount = super.getPara("userAccount").trim();
        String pQues = super.getPara("pQues").trim();
        String pKey = super.getPara("pKey").trim();
        String kaptcha = super.getPara("kaptcha").trim();
        userAccount = CryptoUtil.decode(userAccount);
        pQues = CryptoUtil.decode(pQues);
        pKey = CryptoUtil.decode(pKey);
        kaptcha = CryptoUtil.decode(kaptcha);
        String code = (String)super.getSession().getAttribute("KAPTCHA_SESSION_KEY");
        super.getSession().setAttribute("KAPTCHA_SESSION_KEY", null);
        if (ToolUtil.isEmpty((Object)kaptcha) || !kaptcha.equalsIgnoreCase(code)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u9a8c\u8bc1\u7801\u8f93\u5165\u9519\u8bef\uff01");
        }
        SysUsers user = (SysUsers)((Object)this.iSysUsersService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ACCOUNT", (Object)userAccount)).ne((Object)"ACCOUNT_STATUS", (Object)"2"), false));
        SysGetBackPassword sysGetBackPassword = (SysGetBackPassword)((Object)this.iSysGetBackPasswordService.getById((Serializable)((Object)user.getUserId())));
        ISysBaseConfigService iSysBaseConfigService = (ISysBaseConfigService)SpringContextHolder.getBean(ISysBaseConfigService.class);
        LoginLock loginLock = (LoginLock)SpringContextHolder.getBean(LoginLock.class);
        if (loginLock.userIsLock(userName = user.getUserName())) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5f53\u524d\u5e10\u53f7\u5df2\u88ab\u9501\u5b9a\uff01");
        }
        if (ToolUtil.isNotEmpty((Object)((Object)sysGetBackPassword))) {
            int loginChanceTime;
            if (pQues.equals(sysGetBackPassword.getpQues()) && pKey.equals(sysGetBackPassword.getpKey())) {
                loginLock.removeUserCache(userName);
                return new ErrorTip(HttpCode.OK.value().intValue(), "\u9a8c\u8bc1\u901a\u8fc7\uff0c\u8bf7\u8bbe\u7f6e\u60a8\u7684\u65b0\u5bc6\u7801\uff01");
            }
            SysBaseConfig sysBaseConfig = iSysBaseConfigService.getSysBaseConfig("fail_number");
            String tryLoginTime = sysBaseConfig.getConfigValue();
            loginLock.addUserCache(userName, Integer.parseInt(tryLoginTime));
            int loginChance = Integer.parseInt(tryLoginTime) - loginLock.userLockNum(userName);
            int n = loginChanceTime = loginChance < 0 ? 0 : loginChance;
            if (loginChanceTime == 0) {
                return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5f53\u524d\u5e10\u53f7\u5df2\u88ab\u9501\u5b9a\uff01");
            }
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u60a8\u8f93\u5165\u7684\u7b54\u6848\u4e0d\u6b63\u786e\uff01\uff0c\u8fd8\u6709" + loginChanceTime + "\u6b21\u673a\u4f1a");
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u60a8\u6ca1\u6709\u8bbe\u7f6e\u5bc6\u4fdd\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u627e\u56de\u60a8\u7684\u5bc6\u7801\uff01");
    }

    @RequestMapping(value={"/setNewPwd"})
    @ResponseBody
    @BussinessLog(key="/getBackPwd/setNewPwd", type="11", value="\u4fee\u6539\u5bc6\u7801")
    public Tip setNewPwd() {
        String data = super.getPara("data").trim();
        String pQues = super.getPara("pQues").trim();
        String pKey = super.getPara("pKey").trim();
        data = CryptoUtil.decode(data);
        pQues = CryptoUtil.decode(pQues);
        pKey = CryptoUtil.decode(pKey);
        String[] params = data.split("&");
        String userAccount = "";
        String newPwd = "";
        String cPwd = "";
        for (String param : params) {
            String[] p = param.split("=");
            if ("userAccount".equals(p[0])) {
                userAccount = p[1];
            }
            if ("new_pwd".equals(p[0])) {
                newPwd = p[1];
            }
            if (!"c_pwd".equals(p[0])) continue;
            cPwd = p[1];
        }
        SysUsers user = (SysUsers)((Object)this.iSysUsersService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ACCOUNT", (Object)userAccount)).ne((Object)"ACCOUNT_STATUS", (Object)"2"), false));
        String userId = user.getUserId();
        String regular = this.globalProperties.getPwdComplexityRegular().replaceAll("/", "");
        String hint = this.globalProperties.getUnmatchedHint();
        if (!newPwd.matches(regular)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), hint);
        }
        if (newPwd.toLowerCase().contains(userAccount.toLowerCase())) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u4fee\u6539\u5931\u8d25\uff01\uff08\u5bc6\u7801\u5305\u542b\u7528\u6237\u540d\uff09");
        }
        SysGetBackPassword info = (SysGetBackPassword)((Object)this.iSysGetBackPasswordService.getById((Serializable)((Object)userId)));
        if (ToolUtil.isEmpty((Object)((Object)info)) || !pQues.equals(info.getpQues()) || !pKey.equals(info.getpKey())) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u60a8\u672a\u8bbe\u7f6e\u5bc6\u4fdd\u6216\u4fe1\u606f\u6709\u8bef\uff01");
        }
        if (!newPwd.equals(cPwd)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u4e24\u6b21\u8f93\u5165\u7684\u5bc6\u7801\u4e0d\u4e00\u81f4\uff01");
        }
        String nPwd = this.credentialsMatcher.passwordEncode(newPwd.getBytes());
        List<SysPasswordHist> list = this.iSysUsersService.getPwdHist(userId);
        for (SysPasswordHist sysPasswordHist : list) {
            if (!nPwd.equals(sysPasswordHist.getPassword())) continue;
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u65b0\u5bc6\u7801\u4e0d\u80fd\u548c\u524d" + this.globalProperties.getPwdRepeatTime() + "\u6b21\u7684\u5bc6\u7801\u4e00\u6837\uff01");
        }
        user.setPassword(nPwd);
        this.iSysUsersService.updatePwd(user);
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/regular"})
    @ResponseBody
    public Map<String, String> getPwdRegular() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("regular", this.globalProperties.getPwdComplexityRegular());
        result.put("hint", this.globalProperties.getUnmatchedHint());
        return result;
    }
}

